// Code generated by smithy-go-codegen DO NOT EDIT.

package codeguruprofiler

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/codeguruprofiler/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Adds permissions to a profiling group's resource-based policy that are
//
// provided using an action group. If a profiling group doesn't have a
// resource-based policy, one is created for it using the permissions in the action
// group and the roles and users in the principals parameter.
//
// The one supported action group that can be added is agentPermission which
// grants ConfigureAgent and PostAgent permissions. For more information, see [Resource-based policies in CodeGuru Profiler] in
// the Amazon CodeGuru Profiler User Guide, [ConfigureAgent]ConfigureAgent , and [PostAgentProfile]PostAgentProfile .
//
// The first time you call PutPermission on a profiling group, do not specify a
// revisionId because it doesn't have a resource-based policy. Subsequent calls
// must provide a revisionId to specify which revision of the resource-based
// policy to add the permissions to.
//
// The response contains the profiling group's JSON-formatted resource policy.
//
// [ConfigureAgent]: https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html
// [Resource-based policies in CodeGuru Profiler]: https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html
// [PostAgentProfile]: https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html
func (c *Client) PutPermission(ctx context.Context, params *PutPermissionInput, optFns ...func(*Options)) (*PutPermissionOutput, error) {
	if params == nil {
		params = &PutPermissionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutPermission", params, optFns, c.addOperationPutPermissionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutPermissionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The structure representing the putPermissionRequest .
type PutPermissionInput struct {

	//  Specifies an action group that contains permissions to add to a profiling
	// group resource. One action group is supported, agentPermissions , which grants
	// permission to perform actions required by the profiling agent, ConfigureAgent
	// and PostAgentProfile permissions.
	//
	// This member is required.
	ActionGroup types.ActionGroup

	//  A list ARNs for the roles and users you want to grant access to the profiling
	// group. Wildcards are not are supported in the ARNs.
	//
	// This member is required.
	Principals []string

	// The name of the profiling group to grant access to.
	//
	// This member is required.
	ProfilingGroupName *string

	//  A universally unique identifier (UUID) for the revision of the policy you are
	// adding to the profiling group. Do not specify this when you add permissions to a
	// profiling group for the first time. If a policy already exists on the profiling
	// group, you must specify the revisionId .
	RevisionId *string

	noSmithyDocumentSerde
}

// The structure representing the putPermissionResponse .
type PutPermissionOutput struct {

	//  The JSON-formatted resource-based policy on the profiling group that includes
	// the added permissions.
	//
	// This member is required.
	Policy *string

	//  A universally unique identifier (UUID) for the revision of the resource-based
	// policy that includes the added permissions. The JSON-formatted policy is in the
	// policy element of the response.
	//
	// This member is required.
	RevisionId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutPermissionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpPutPermission{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpPutPermission{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutPermission"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpPutPermissionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutPermission(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutPermission(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutPermission",
	}
}
