// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanroomsml

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cleanroomsml/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of trained model versions for a specified trained model. This
// operation allows you to view all versions of a trained model, including
// information about their status and creation details. You can use this to track
// the evolution of your trained models and select specific versions for inference
// or further training.
func (c *Client) ListTrainedModelVersions(ctx context.Context, params *ListTrainedModelVersionsInput, optFns ...func(*Options)) (*ListTrainedModelVersionsOutput, error) {
	if params == nil {
		params = &ListTrainedModelVersionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTrainedModelVersions", params, optFns, c.addOperationListTrainedModelVersionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTrainedModelVersionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTrainedModelVersionsInput struct {

	// The membership identifier for the collaboration that contains the trained model.
	//
	// This member is required.
	MembershipIdentifier *string

	// The Amazon Resource Name (ARN) of the trained model for which to list versions.
	//
	// This member is required.
	TrainedModelArn *string

	// The maximum number of trained model versions to return in a single page. The
	// default value is 10, and the maximum value is 100.
	MaxResults *int32

	// The pagination token from a previous ListTrainedModelVersions request. Use this
	// token to retrieve the next page of results.
	NextToken *string

	// Filter the results to only include trained model versions with the specified
	// status. Valid values include CREATE_PENDING , CREATE_IN_PROGRESS , ACTIVE ,
	// CREATE_FAILED , and others.
	Status types.TrainedModelStatus

	noSmithyDocumentSerde
}

type ListTrainedModelVersionsOutput struct {

	// A list of trained model versions that match the specified criteria. Each entry
	// contains summary information about a trained model version, including its
	// version identifier, status, and creation details.
	//
	// This member is required.
	TrainedModels []types.TrainedModelSummary

	// The pagination token to use in a subsequent ListTrainedModelVersions request to
	// retrieve the next page of results. This value is null when there are no more
	// results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTrainedModelVersionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListTrainedModelVersions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListTrainedModelVersions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTrainedModelVersions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListTrainedModelVersionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTrainedModelVersions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListTrainedModelVersionsPaginatorOptions is the paginator options for
// ListTrainedModelVersions
type ListTrainedModelVersionsPaginatorOptions struct {
	// The maximum number of trained model versions to return in a single page. The
	// default value is 10, and the maximum value is 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTrainedModelVersionsPaginator is a paginator for ListTrainedModelVersions
type ListTrainedModelVersionsPaginator struct {
	options   ListTrainedModelVersionsPaginatorOptions
	client    ListTrainedModelVersionsAPIClient
	params    *ListTrainedModelVersionsInput
	nextToken *string
	firstPage bool
}

// NewListTrainedModelVersionsPaginator returns a new
// ListTrainedModelVersionsPaginator
func NewListTrainedModelVersionsPaginator(client ListTrainedModelVersionsAPIClient, params *ListTrainedModelVersionsInput, optFns ...func(*ListTrainedModelVersionsPaginatorOptions)) *ListTrainedModelVersionsPaginator {
	if params == nil {
		params = &ListTrainedModelVersionsInput{}
	}

	options := ListTrainedModelVersionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTrainedModelVersionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTrainedModelVersionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTrainedModelVersions page.
func (p *ListTrainedModelVersionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTrainedModelVersionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListTrainedModelVersions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListTrainedModelVersionsAPIClient is a client that implements the
// ListTrainedModelVersions operation.
type ListTrainedModelVersionsAPIClient interface {
	ListTrainedModelVersions(context.Context, *ListTrainedModelVersionsInput, ...func(*Options)) (*ListTrainedModelVersionsOutput, error)
}

var _ ListTrainedModelVersionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListTrainedModelVersions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTrainedModelVersions",
	}
}
