// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanroomsml

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cleanroomsml/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of trained model inference jobs in a specified collaboration.
func (c *Client) ListCollaborationTrainedModelInferenceJobs(ctx context.Context, params *ListCollaborationTrainedModelInferenceJobsInput, optFns ...func(*Options)) (*ListCollaborationTrainedModelInferenceJobsOutput, error) {
	if params == nil {
		params = &ListCollaborationTrainedModelInferenceJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCollaborationTrainedModelInferenceJobs", params, optFns, c.addOperationListCollaborationTrainedModelInferenceJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCollaborationTrainedModelInferenceJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCollaborationTrainedModelInferenceJobsInput struct {

	// The collaboration ID of the collaboration that contains the trained model
	// inference jobs that you are interested in.
	//
	// This member is required.
	CollaborationIdentifier *string

	// The maximum size of the results that is returned per call.
	MaxResults *int32

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string

	// The Amazon Resource Name (ARN) of the trained model that was used to create the
	// trained model inference jobs that you are interested in.
	TrainedModelArn *string

	// The version identifier of the trained model to filter inference jobs by. When
	// specified, only inference jobs that used this specific version of the trained
	// model are returned.
	TrainedModelVersionIdentifier *string

	noSmithyDocumentSerde
}

type ListCollaborationTrainedModelInferenceJobsOutput struct {

	// The trained model inference jobs that you are interested in.
	//
	// This member is required.
	CollaborationTrainedModelInferenceJobs []types.CollaborationTrainedModelInferenceJobSummary

	// The token value used to access the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCollaborationTrainedModelInferenceJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListCollaborationTrainedModelInferenceJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListCollaborationTrainedModelInferenceJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCollaborationTrainedModelInferenceJobs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListCollaborationTrainedModelInferenceJobsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCollaborationTrainedModelInferenceJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListCollaborationTrainedModelInferenceJobsPaginatorOptions is the paginator
// options for ListCollaborationTrainedModelInferenceJobs
type ListCollaborationTrainedModelInferenceJobsPaginatorOptions struct {
	// The maximum size of the results that is returned per call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCollaborationTrainedModelInferenceJobsPaginator is a paginator for
// ListCollaborationTrainedModelInferenceJobs
type ListCollaborationTrainedModelInferenceJobsPaginator struct {
	options   ListCollaborationTrainedModelInferenceJobsPaginatorOptions
	client    ListCollaborationTrainedModelInferenceJobsAPIClient
	params    *ListCollaborationTrainedModelInferenceJobsInput
	nextToken *string
	firstPage bool
}

// NewListCollaborationTrainedModelInferenceJobsPaginator returns a new
// ListCollaborationTrainedModelInferenceJobsPaginator
func NewListCollaborationTrainedModelInferenceJobsPaginator(client ListCollaborationTrainedModelInferenceJobsAPIClient, params *ListCollaborationTrainedModelInferenceJobsInput, optFns ...func(*ListCollaborationTrainedModelInferenceJobsPaginatorOptions)) *ListCollaborationTrainedModelInferenceJobsPaginator {
	if params == nil {
		params = &ListCollaborationTrainedModelInferenceJobsInput{}
	}

	options := ListCollaborationTrainedModelInferenceJobsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCollaborationTrainedModelInferenceJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCollaborationTrainedModelInferenceJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCollaborationTrainedModelInferenceJobs page.
func (p *ListCollaborationTrainedModelInferenceJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCollaborationTrainedModelInferenceJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCollaborationTrainedModelInferenceJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCollaborationTrainedModelInferenceJobsAPIClient is a client that implements
// the ListCollaborationTrainedModelInferenceJobs operation.
type ListCollaborationTrainedModelInferenceJobsAPIClient interface {
	ListCollaborationTrainedModelInferenceJobs(context.Context, *ListCollaborationTrainedModelInferenceJobsInput, ...func(*Options)) (*ListCollaborationTrainedModelInferenceJobsOutput, error)
}

var _ ListCollaborationTrainedModelInferenceJobsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCollaborationTrainedModelInferenceJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCollaborationTrainedModelInferenceJobs",
	}
}
