// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The Amazon Chime account details. An AWS account can have multiple Amazon Chime
// accounts.
type Account struct {

	// The Amazon Chime account ID.
	//
	// This member is required.
	AccountId *string

	// The AWS account ID.
	//
	// This member is required.
	AwsAccountId *string

	// The Amazon Chime account name.
	//
	// This member is required.
	Name *string

	// The status of the account.
	AccountStatus AccountStatus

	// The Amazon Chime account type. For more information about different account
	// types, see [Managing Your Amazon Chime Accounts]in the Amazon Chime Administration Guide.
	//
	// [Managing Your Amazon Chime Accounts]: https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html
	AccountType AccountType

	// The Amazon Chime account creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time

	// The default license for the Amazon Chime account.
	DefaultLicense License

	// The sign-in delegate groups associated with the account.
	SigninDelegateGroups []SigninDelegateGroup

	// Supported licenses for the Amazon Chime account.
	SupportedLicenses []License

	noSmithyDocumentSerde
}

// Settings related to the Amazon Chime account. This includes settings that start
// or stop remote control of shared screens, or start or stop the dial-out option
// in the Amazon Chime web application. For more information about these settings,
// see [Use the Policies Page]in the Amazon Chime Administration Guide.
//
// [Use the Policies Page]: https://docs.aws.amazon.com/chime/latest/ag/policies.html
type AccountSettings struct {

	// Setting that stops or starts remote control of shared screens during meetings.
	DisableRemoteControl *bool

	// Setting that allows meeting participants to choose the Call me at a phone
	// number option. For more information, see [Join a Meeting without the Amazon Chime App].
	//
	// [Join a Meeting without the Amazon Chime App]: https://docs.aws.amazon.com/chime/latest/ug/chime-join-meeting.html
	EnableDialOut *bool

	noSmithyDocumentSerde
}

// The Alexa for Business metadata associated with an Amazon Chime user, used to
// integrate Alexa for Business with a device.
type AlexaForBusinessMetadata struct {

	// The ARN of the room resource.
	AlexaForBusinessRoomArn *string

	// Starts or stops Alexa for Business.
	IsAlexaForBusinessEnabled *bool

	noSmithyDocumentSerde
}

// A resource that allows Enterprise account administrators to configure an
// interface to receive events from Amazon Chime.
type Bot struct {

	// The bot email address.
	BotEmail *string

	// The bot ID.
	BotId *string

	// The bot type.
	BotType BotType

	// The bot creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time

	// When true, the bot is stopped from running in your account.
	Disabled *bool

	// The bot display name.
	DisplayName *string

	// The security token used to authenticate Amazon Chime with the outgoing event
	// endpoint.
	SecurityToken *string

	// The updated bot timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time

	// The unique ID for the bot user.
	UserId *string

	noSmithyDocumentSerde
}

// The Amazon Chime Business Calling settings for the administrator's AWS account.
// Includes any Amazon S3 buckets designated for storing call detail records.
type BusinessCallingSettings struct {

	// The Amazon S3 bucket designated for call detail record storage.
	CdrBucket *string

	noSmithyDocumentSerde
}

// The retention settings that determine how long to retain conversation messages
// for an Amazon Chime Enterprise account.
type ConversationRetentionSettings struct {

	// The number of days for which to retain conversation messages.
	RetentionDays *int32

	noSmithyDocumentSerde
}

// The configuration that allows a bot to receive outgoing events. Can be either
// an HTTPS endpoint or a Lambda function ARN.
type EventsConfiguration struct {

	// The bot ID.
	BotId *string

	// Lambda function ARN that allows a bot to receive outgoing events.
	LambdaFunctionArn *string

	// HTTPS endpoint that allows a bot to receive outgoing events.
	OutboundEventsHTTPSEndpoint *string

	noSmithyDocumentSerde
}

// Invitation object returned after emailing users to invite them to join the
// Amazon Chime Team account.
type Invite struct {

	// The email address to which the invite is sent.
	EmailAddress *string

	// The status of the invite email.
	EmailStatus EmailStatus

	// The invite ID.
	InviteId *string

	// The status of the invite.
	Status InviteStatus

	noSmithyDocumentSerde
}

// The member details, such as email address, name, member ID, and member type.
type Member struct {

	// The Amazon Chime account ID.
	AccountId *string

	// The member email address.
	Email *string

	// The member name.
	FullName *string

	// The member ID (user ID or bot ID).
	MemberId *string

	// The member type.
	MemberType MemberType

	noSmithyDocumentSerde
}

// The list of errors returned when a member action results in an error.
type MemberError struct {

	// The error code.
	ErrorCode ErrorCode

	// The error message.
	ErrorMessage *string

	// The member ID.
	MemberId *string

	noSmithyDocumentSerde
}

// Membership details, such as member ID and member role.
type MembershipItem struct {

	// The member ID.
	MemberId *string

	// The member role.
	Role RoomMembershipRole

	noSmithyDocumentSerde
}

// A phone number for which an order has been placed.
type OrderedPhoneNumber struct {

	// The phone number, in E.164 format.
	E164PhoneNumber *string

	// The phone number status.
	Status OrderedPhoneNumberStatus

	noSmithyDocumentSerde
}

// A phone number used for Amazon Chime Business Calling or an Amazon Chime Voice
// Connector.
type PhoneNumber struct {

	// The phone number associations.
	Associations []PhoneNumberAssociation

	// The outbound calling name associated with the phone number.
	CallingName *string

	// The outbound calling name status.
	CallingNameStatus CallingNameStatus

	// The phone number capabilities.
	Capabilities *PhoneNumberCapabilities

	// The phone number country. Format: ISO 3166-1 alpha-2.
	Country *string

	// The phone number creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time

	// The deleted phone number timestamp, in ISO 8601 format.
	DeletionTimestamp *time.Time

	// The phone number, in E.164 format.
	E164PhoneNumber *string

	// The phone number ID.
	PhoneNumberId *string

	// The phone number product type.
	ProductType PhoneNumberProductType

	// The phone number status.
	Status PhoneNumberStatus

	// The phone number type.
	Type PhoneNumberType

	// The updated phone number timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time

	noSmithyDocumentSerde
}

// The phone number associations, such as Amazon Chime account ID, Amazon Chime
// user ID, Amazon Chime Voice Connector ID, or Amazon Chime Voice Connector group
// ID.
type PhoneNumberAssociation struct {

	// The timestamp of the phone number association, in ISO 8601 format.
	AssociatedTimestamp *time.Time

	// Defines the association with an Amazon Chime account ID, user ID, Amazon Chime
	// Voice Connector ID, or Amazon Chime Voice Connector group ID.
	Name PhoneNumberAssociationName

	// Contains the ID for the entity specified in Name.
	Value *string

	noSmithyDocumentSerde
}

// The phone number capabilities for Amazon Chime Business Calling phone numbers,
// such as enabled inbound and outbound calling and text messaging.
type PhoneNumberCapabilities struct {

	// Allows or denies inbound calling for the specified phone number.
	InboundCall *bool

	// Allows or denies inbound MMS messaging for the specified phone number.
	InboundMMS *bool

	// Allows or denies inbound SMS messaging for the specified phone number.
	InboundSMS *bool

	// Allows or denies outbound calling for the specified phone number.
	OutboundCall *bool

	// Allows or denies outbound MMS messaging for the specified phone number.
	OutboundMMS *bool

	// Allows or denies outbound SMS messaging for the specified phone number.
	OutboundSMS *bool

	noSmithyDocumentSerde
}

// The phone number country.
type PhoneNumberCountry struct {

	// The phone number country code. Format: ISO 3166-1 alpha-2.
	CountryCode *string

	// The supported phone number types.
	SupportedPhoneNumberTypes []PhoneNumberType

	noSmithyDocumentSerde
}

// If the phone number action fails for one or more of the phone numbers in the
// request, a list of the phone numbers is returned, along with error codes and
// error messages.
type PhoneNumberError struct {

	// The error code.
	ErrorCode ErrorCode

	// The error message.
	ErrorMessage *string

	// The phone number ID for which the action failed.
	PhoneNumberId *string

	noSmithyDocumentSerde
}

// The details of a phone number order created for Amazon Chime.
type PhoneNumberOrder struct {

	// The phone number order creation time stamp, in ISO 8601 format.
	CreatedTimestamp *time.Time

	// The ordered phone number details, such as the phone number in E.164 format and
	// the phone number status.
	OrderedPhoneNumbers []OrderedPhoneNumber

	// The phone number order ID.
	PhoneNumberOrderId *string

	// The phone number order product type.
	ProductType PhoneNumberProductType

	// The status of the phone number order.
	Status PhoneNumberOrderStatus

	// The updated phone number order time stamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time

	noSmithyDocumentSerde
}

// The retention settings for an Amazon Chime Enterprise account that determine
// how long to retain items such as chat-room messages and chat-conversation
// messages.
type RetentionSettings struct {

	// The chat conversation retention settings.
	ConversationRetentionSettings *ConversationRetentionSettings

	// The chat room retention settings.
	RoomRetentionSettings *RoomRetentionSettings

	noSmithyDocumentSerde
}

// The Amazon Chime chat room details.
type Room struct {

	// The Amazon Chime account ID.
	AccountId *string

	// The identifier of the room creator.
	CreatedBy *string

	// The room creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time

	// The room name.
	Name *string

	// The room ID.
	RoomId *string

	// The room update timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time

	noSmithyDocumentSerde
}

// The room membership details.
type RoomMembership struct {

	// The identifier of the user that invited the room member.
	InvitedBy *string

	// The member details, such as email address, name, member ID, and member type.
	Member *Member

	// The membership role.
	Role RoomMembershipRole

	// The room ID.
	RoomId *string

	// The room membership update timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time

	noSmithyDocumentSerde
}

// The retention settings that determine how long to retain chat-room messages for
// an Amazon Chime Enterprise account.
type RoomRetentionSettings struct {

	// The number of days for which to retain chat-room messages.
	RetentionDays *int32

	noSmithyDocumentSerde
}

// An Active Directory (AD) group whose members are granted permission to act as
// delegates.
type SigninDelegateGroup struct {

	// The group name.
	GroupName *string

	noSmithyDocumentSerde
}

// Settings that allow management of telephony permissions for an Amazon Chime
// user, such as inbound and outbound calling and text messaging.
type TelephonySettings struct {

	// Allows or denies inbound calling.
	//
	// This member is required.
	InboundCalling *bool

	// Allows or denies outbound calling.
	//
	// This member is required.
	OutboundCalling *bool

	// Allows or denies SMS messaging.
	//
	// This member is required.
	SMS *bool

	noSmithyDocumentSerde
}

// The phone number ID, product type, or calling name fields to update, used with
// the BatchUpdatePhoneNumberand UpdatePhoneNumber actions.
type UpdatePhoneNumberRequestItem struct {

	// The phone number ID to update.
	//
	// This member is required.
	PhoneNumberId *string

	// The outbound calling name to update.
	CallingName *string

	// The product type to update.
	ProductType PhoneNumberProductType

	noSmithyDocumentSerde
}

// The user ID and user fields to update, used with the BatchUpdateUser action.
type UpdateUserRequestItem struct {

	// The user ID.
	//
	// This member is required.
	UserId *string

	// The Alexa for Business metadata.
	AlexaForBusinessMetadata *AlexaForBusinessMetadata

	// The user license type.
	LicenseType License

	// The user type.
	UserType UserType

	noSmithyDocumentSerde
}

// The user on the Amazon Chime account.
type User struct {

	// The user ID.
	//
	// This member is required.
	UserId *string

	// The Amazon Chime account ID.
	AccountId *string

	// The Alexa for Business metadata.
	AlexaForBusinessMetadata *AlexaForBusinessMetadata

	// The display name of the user.
	DisplayName *string

	// Date and time when the user is invited to the Amazon Chime account, in ISO 8601
	// format.
	InvitedOn *time.Time

	// The license type for the user.
	LicenseType License

	// The user's personal meeting PIN.
	PersonalPIN *string

	// The primary email address of the user.
	PrimaryEmail *string

	// The primary phone number associated with the user.
	PrimaryProvisionedNumber *string

	// Date and time when the user is registered, in ISO 8601 format.
	RegisteredOn *time.Time

	// The user invite status.
	UserInvitationStatus InviteStatus

	// The user registration status.
	UserRegistrationStatus RegistrationStatus

	// The user type.
	UserType UserType

	noSmithyDocumentSerde
}

// The list of errors returned when errors are encountered during the BatchSuspendUser, BatchUnsuspendUser, or BatchUpdateUser
// actions. This includes user IDs, error codes, and error messages.
type UserError struct {

	// The error code.
	ErrorCode ErrorCode

	// The error message.
	ErrorMessage *string

	// The user ID for which the action failed.
	UserId *string

	noSmithyDocumentSerde
}

// Settings associated with an Amazon Chime user, including inbound and outbound
// calling and text messaging.
type UserSettings struct {

	// The telephony settings associated with the user.
	//
	// This member is required.
	Telephony *TelephonySettings

	noSmithyDocumentSerde
}

// The Amazon Chime Voice Connector settings. Includes any Amazon S3 buckets
// designated for storing call detail records.
type VoiceConnectorSettings struct {

	// The Amazon S3 bucket designated for call detail record storage.
	CdrBucket *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
