// Code generated by smithy-go-codegen DO NOT EDIT.

package braket

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/braket/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Searches and lists spending limits based on specified filters. This operation
// supports pagination and allows filtering by various criteria to find specific
// spending limits. We recommend using pagination to ensure that the operation
// returns quickly and successfully.
func (c *Client) SearchSpendingLimits(ctx context.Context, params *SearchSpendingLimitsInput, optFns ...func(*Options)) (*SearchSpendingLimitsOutput, error) {
	if params == nil {
		params = &SearchSpendingLimitsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SearchSpendingLimits", params, optFns, c.addOperationSearchSpendingLimitsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SearchSpendingLimitsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SearchSpendingLimitsInput struct {

	// The filters to apply when searching for spending limits. Use filters to narrow
	// down the results based on specific criteria.
	Filters []types.SearchSpendingLimitsFilter

	// The maximum number of results to return in a single call. Minimum value of 1,
	// maximum value of 100. Default is 20.
	MaxResults *int32

	// The token to retrieve the next page of results. This value is returned from a
	// previous call to SearchSpendingLimits when there are more results available.
	NextToken *string

	noSmithyDocumentSerde
}

type SearchSpendingLimitsOutput struct {

	// An array of spending limit summaries that match the specified filters.
	//
	// This member is required.
	SpendingLimits []types.SpendingLimitSummary

	// The token to retrieve the next page of results. This value is null when there
	// are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSearchSpendingLimitsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSearchSpendingLimits{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSearchSpendingLimits{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SearchSpendingLimits"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpSearchSpendingLimitsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSearchSpendingLimits(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// SearchSpendingLimitsPaginatorOptions is the paginator options for
// SearchSpendingLimits
type SearchSpendingLimitsPaginatorOptions struct {
	// The maximum number of results to return in a single call. Minimum value of 1,
	// maximum value of 100. Default is 20.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// SearchSpendingLimitsPaginator is a paginator for SearchSpendingLimits
type SearchSpendingLimitsPaginator struct {
	options   SearchSpendingLimitsPaginatorOptions
	client    SearchSpendingLimitsAPIClient
	params    *SearchSpendingLimitsInput
	nextToken *string
	firstPage bool
}

// NewSearchSpendingLimitsPaginator returns a new SearchSpendingLimitsPaginator
func NewSearchSpendingLimitsPaginator(client SearchSpendingLimitsAPIClient, params *SearchSpendingLimitsInput, optFns ...func(*SearchSpendingLimitsPaginatorOptions)) *SearchSpendingLimitsPaginator {
	if params == nil {
		params = &SearchSpendingLimitsInput{}
	}

	options := SearchSpendingLimitsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &SearchSpendingLimitsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *SearchSpendingLimitsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next SearchSpendingLimits page.
func (p *SearchSpendingLimitsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*SearchSpendingLimitsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.SearchSpendingLimits(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// SearchSpendingLimitsAPIClient is a client that implements the
// SearchSpendingLimits operation.
type SearchSpendingLimitsAPIClient interface {
	SearchSpendingLimits(context.Context, *SearchSpendingLimitsInput, ...func(*Options)) (*SearchSpendingLimitsOutput, error)
}

var _ SearchSpendingLimitsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opSearchSpendingLimits(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SearchSpendingLimits",
	}
}
