// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"github.com/aws/aws-sdk-go-v2/service/bedrockruntime/document"
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The model must request at least one tool (no text is generated). For example,
// {"any" : {}} . For more information, see [Call a tool with the Converse API] in the Amazon Bedrock User Guide.
//
// [Call a tool with the Converse API]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type AnyToolChoice struct {
	noSmithyDocumentSerde
}

// Details about the specific guardrail that was applied during this assessment,
// including its identifier, version, ARN, origin, and ownership information.
type AppliedGuardrailDetails struct {

	// The ARN of the guardrail that was applied.
	GuardrailArn *string

	// The unique ID of the guardrail that was applied.
	GuardrailId *string

	// The origin of how the guardrail was applied. This can be either requested at
	// the API level or enforced at the account or organization level as a default
	// guardrail.
	GuardrailOrigin []GuardrailOrigin

	// The ownership type of the guardrail, indicating whether it is owned by the
	// requesting account or is a cross-account guardrail shared from another AWS
	// account.
	GuardrailOwnership GuardrailOwnership

	// The version of the guardrail that was applied.
	GuardrailVersion *string

	noSmithyDocumentSerde
}

// Asynchronous invocation output data settings.
//
// The following types satisfy this interface:
//
//	AsyncInvokeOutputDataConfigMemberS3OutputDataConfig
type AsyncInvokeOutputDataConfig interface {
	isAsyncInvokeOutputDataConfig()
}

// A storage location for the output data in an S3 bucket
type AsyncInvokeOutputDataConfigMemberS3OutputDataConfig struct {
	Value AsyncInvokeS3OutputDataConfig

	noSmithyDocumentSerde
}

func (*AsyncInvokeOutputDataConfigMemberS3OutputDataConfig) isAsyncInvokeOutputDataConfig() {}

// Asynchronous invocation output data settings.
type AsyncInvokeS3OutputDataConfig struct {

	// An object URI starting with s3:// .
	//
	// This member is required.
	S3Uri *string

	// If the bucket belongs to another AWS account, specify that account's ID.
	BucketOwner *string

	// A KMS encryption key ID.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// A summary of an asynchronous invocation.
type AsyncInvokeSummary struct {

	// The invocation's ARN.
	//
	// This member is required.
	InvocationArn *string

	// The invoked model's ARN.
	//
	// This member is required.
	ModelArn *string

	// The invocation's output data settings.
	//
	// This member is required.
	OutputDataConfig AsyncInvokeOutputDataConfig

	// When the invocation was submitted.
	//
	// This member is required.
	SubmitTime *time.Time

	// The invocation's idempotency token.
	ClientRequestToken *string

	// When the invocation ended.
	EndTime *time.Time

	// An error message.
	FailureMessage *string

	// When the invocation was last modified.
	LastModifiedTime *time.Time

	// The invocation's status.
	Status AsyncInvokeStatus

	noSmithyDocumentSerde
}

// An audio content block that contains audio data in various supported formats.
type AudioBlock struct {

	// The format of the audio data, such as MP3, WAV, FLAC, or other supported audio
	// formats.
	//
	// This member is required.
	Format AudioFormat

	// The source of the audio data, which can be provided as raw bytes or an S3
	// location.
	//
	// This member is required.
	Source AudioSource

	// Error information if the audio block could not be processed or contains invalid
	// data.
	Error *ErrorBlock

	noSmithyDocumentSerde
}

// The source of audio data, which can be provided either as raw bytes or a
// reference to an S3 location.
//
// The following types satisfy this interface:
//
//	AudioSourceMemberBytes
//	AudioSourceMemberS3Location
type AudioSource interface {
	isAudioSource()
}

// Audio data encoded in base64.
type AudioSourceMemberBytes struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*AudioSourceMemberBytes) isAudioSource() {}

// A reference to audio data stored in an Amazon S3 bucket. To see which models
// support S3 uploads, see [Supported models and features for Converse].
//
// [Supported models and features for Converse]: https://docs.aws.amazon.com/bedrock/latest/userguide/conversation-inference-supported-models-features.html
type AudioSourceMemberS3Location struct {
	Value S3Location

	noSmithyDocumentSerde
}

func (*AudioSourceMemberS3Location) isAudioSource() {}

// The Model automatically decides if a tool should be called or whether to
// generate text instead. For example, {"auto" : {}} . For more information, see [Call a tool with the Converse API]
// in the Amazon Bedrock User Guide
//
// [Call a tool with the Converse API]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type AutoToolChoice struct {
	noSmithyDocumentSerde
}

// Defines a section of content to be cached for reuse in subsequent API calls.
type CachePointBlock struct {

	// Specifies the type of cache point within the CachePointBlock.
	//
	// This member is required.
	Type CachePointType

	noSmithyDocumentSerde
}

// Contains information about a citation that references a specific source
// document. Citations provide traceability between the model's generated response
// and the source documents that informed that response.
type Citation struct {

	// The precise location within the source document where the cited content can be
	// found, including character positions, page numbers, or chunk identifiers.
	Location CitationLocation

	// The source from the original search result that provided the cited content.
	Source *string

	// The specific content from the source document that was referenced or cited in
	// the generated response.
	SourceContent []CitationSourceContent

	// The title or identifier of the source document being cited.
	Title *string

	noSmithyDocumentSerde
}

// Contains the generated text content that corresponds to or is supported by a
// citation from a source document.
//
// The following types satisfy this interface:
//
//	CitationGeneratedContentMemberText
type CitationGeneratedContent interface {
	isCitationGeneratedContent()
}

// The text content that was generated by the model and is supported by the
// associated citation.
type CitationGeneratedContentMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*CitationGeneratedContentMemberText) isCitationGeneratedContent() {}

// Specifies the precise location within a source document where cited content can
// be found. This can include character-level positions, page numbers, or document
// chunks depending on the document type and indexing method.
//
// The following types satisfy this interface:
//
//	CitationLocationMemberDocumentChar
//	CitationLocationMemberDocumentChunk
//	CitationLocationMemberDocumentPage
//	CitationLocationMemberSearchResultLocation
//	CitationLocationMemberWeb
type CitationLocation interface {
	isCitationLocation()
}

// The character-level location within the document where the cited content is
// found.
type CitationLocationMemberDocumentChar struct {
	Value DocumentCharLocation

	noSmithyDocumentSerde
}

func (*CitationLocationMemberDocumentChar) isCitationLocation() {}

// The chunk-level location within the document where the cited content is found,
// typically used for documents that have been segmented into logical chunks.
type CitationLocationMemberDocumentChunk struct {
	Value DocumentChunkLocation

	noSmithyDocumentSerde
}

func (*CitationLocationMemberDocumentChunk) isCitationLocation() {}

// The page-level location within the document where the cited content is found.
type CitationLocationMemberDocumentPage struct {
	Value DocumentPageLocation

	noSmithyDocumentSerde
}

func (*CitationLocationMemberDocumentPage) isCitationLocation() {}

// The search result location where the cited content is found, including the
// search result index and block positions within the content array.
type CitationLocationMemberSearchResultLocation struct {
	Value SearchResultLocation

	noSmithyDocumentSerde
}

func (*CitationLocationMemberSearchResultLocation) isCitationLocation() {}

// The web URL that was cited for this reference.
type CitationLocationMemberWeb struct {
	Value WebLocation

	noSmithyDocumentSerde
}

func (*CitationLocationMemberWeb) isCitationLocation() {}

// Configuration settings for enabling and controlling document citations in
// Converse API responses. When enabled, the model can include citation information
// that links generated content back to specific source documents.
type CitationsConfig struct {

	// Specifies whether citations from the selected document should be used in the
	// model's response. When set to true, the model can generate citations that
	// reference the source documents used to inform the response.
	//
	// This member is required.
	Enabled *bool

	noSmithyDocumentSerde
}

// A content block that contains both generated text and associated citation
// information. This block type is returned when document citations are enabled,
// providing traceability between the generated content and the source documents
// that informed the response.
type CitationsContentBlock struct {

	// An array of citations that reference the source documents used to generate the
	// associated content.
	Citations []Citation

	// The generated content that is supported by the associated citations.
	Content []CitationGeneratedContent

	noSmithyDocumentSerde
}

// Contains incremental updates to citation information during streaming
// responses. This allows clients to build up citation data progressively as the
// response is generated.
type CitationsDelta struct {

	// Specifies the precise location within a source document where cited content can
	// be found. This can include character-level positions, page numbers, or document
	// chunks depending on the document type and indexing method.
	Location CitationLocation

	// The source from the original search result that provided the cited content.
	Source *string

	// The specific content from the source document that was referenced or cited in
	// the generated response.
	SourceContent []CitationSourceContentDelta

	// The title or identifier of the source document being cited.
	Title *string

	noSmithyDocumentSerde
}

// Contains the actual text content from a source document that is being cited or
// referenced in the model's response.
//
// The following types satisfy this interface:
//
//	CitationSourceContentMemberText
type CitationSourceContent interface {
	isCitationSourceContent()
}

// The text content from the source document that is being cited.
type CitationSourceContentMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*CitationSourceContentMemberText) isCitationSourceContent() {}

// Contains incremental updates to the source content text during streaming
// responses, allowing clients to build up the cited content progressively.
type CitationSourceContentDelta struct {

	// An incremental update to the text content from the source document that is
	// being cited.
	Text *string

	noSmithyDocumentSerde
}

// A block of content for a message that you pass to, or receive from, a model
// with the [Converse]or [ConverseStream] API operations.
//
// The following types satisfy this interface:
//
//	ContentBlockMemberAudio
//	ContentBlockMemberCachePoint
//	ContentBlockMemberCitationsContent
//	ContentBlockMemberDocument
//	ContentBlockMemberGuardContent
//	ContentBlockMemberImage
//	ContentBlockMemberReasoningContent
//	ContentBlockMemberSearchResult
//	ContentBlockMemberText
//	ContentBlockMemberToolResult
//	ContentBlockMemberToolUse
//	ContentBlockMemberVideo
//
// [Converse]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html
// [ConverseStream]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html
type ContentBlock interface {
	isContentBlock()
}

// An audio content block containing audio data in the conversation.
type ContentBlockMemberAudio struct {
	Value AudioBlock

	noSmithyDocumentSerde
}

func (*ContentBlockMemberAudio) isContentBlock() {}

// CachePoint to include in the message.
type ContentBlockMemberCachePoint struct {
	Value CachePointBlock

	noSmithyDocumentSerde
}

func (*ContentBlockMemberCachePoint) isContentBlock() {}

// A content block that contains both generated text and associated citation
// information, providing traceability between the response and source documents.
type ContentBlockMemberCitationsContent struct {
	Value CitationsContentBlock

	noSmithyDocumentSerde
}

func (*ContentBlockMemberCitationsContent) isContentBlock() {}

// A document to include in the message.
type ContentBlockMemberDocument struct {
	Value DocumentBlock

	noSmithyDocumentSerde
}

func (*ContentBlockMemberDocument) isContentBlock() {}

// Contains the content to assess with the guardrail. If you don't specify
// guardContent in a call to the Converse API, the guardrail (if passed in the
// Converse API) assesses the entire message.
//
// For more information, see Use a guardrail with the Converse API in the Amazon
// Bedrock User Guide.
type ContentBlockMemberGuardContent struct {
	Value GuardrailConverseContentBlock

	noSmithyDocumentSerde
}

func (*ContentBlockMemberGuardContent) isContentBlock() {}

// Image to include in the message.
//
// This field is only supported by Anthropic Claude 3 models.
type ContentBlockMemberImage struct {
	Value ImageBlock

	noSmithyDocumentSerde
}

func (*ContentBlockMemberImage) isContentBlock() {}

// Contains content regarding the reasoning that is carried out by the model.
// Reasoning refers to a Chain of Thought (CoT) that the model generates to enhance
// the accuracy of its final response.
type ContentBlockMemberReasoningContent struct {
	Value ReasoningContentBlock

	noSmithyDocumentSerde
}

func (*ContentBlockMemberReasoningContent) isContentBlock() {}

// Search result to include in the message.
type ContentBlockMemberSearchResult struct {
	Value SearchResultBlock

	noSmithyDocumentSerde
}

func (*ContentBlockMemberSearchResult) isContentBlock() {}

// Text to include in the message.
type ContentBlockMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*ContentBlockMemberText) isContentBlock() {}

// The result for a tool request that a model makes.
type ContentBlockMemberToolResult struct {
	Value ToolResultBlock

	noSmithyDocumentSerde
}

func (*ContentBlockMemberToolResult) isContentBlock() {}

// Information about a tool use request from a model.
type ContentBlockMemberToolUse struct {
	Value ToolUseBlock

	noSmithyDocumentSerde
}

func (*ContentBlockMemberToolUse) isContentBlock() {}

// Video to include in the message.
type ContentBlockMemberVideo struct {
	Value VideoBlock

	noSmithyDocumentSerde
}

func (*ContentBlockMemberVideo) isContentBlock() {}

// A block of content in a streaming response.
//
// The following types satisfy this interface:
//
//	ContentBlockDeltaMemberCitation
//	ContentBlockDeltaMemberImage
//	ContentBlockDeltaMemberReasoningContent
//	ContentBlockDeltaMemberText
//	ContentBlockDeltaMemberToolResult
//	ContentBlockDeltaMemberToolUse
type ContentBlockDelta interface {
	isContentBlockDelta()
}

// Incremental citation information that is streamed as part of the response
// generation process.
type ContentBlockDeltaMemberCitation struct {
	Value CitationsDelta

	noSmithyDocumentSerde
}

func (*ContentBlockDeltaMemberCitation) isContentBlockDelta() {}

// A streaming delta event containing incremental image data.
type ContentBlockDeltaMemberImage struct {
	Value ImageBlockDelta

	noSmithyDocumentSerde
}

func (*ContentBlockDeltaMemberImage) isContentBlockDelta() {}

// Contains content regarding the reasoning that is carried out by the model.
// Reasoning refers to a Chain of Thought (CoT) that the model generates to enhance
// the accuracy of its final response.
type ContentBlockDeltaMemberReasoningContent struct {
	Value ReasoningContentBlockDelta

	noSmithyDocumentSerde
}

func (*ContentBlockDeltaMemberReasoningContent) isContentBlockDelta() {}

// The content text.
type ContentBlockDeltaMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*ContentBlockDeltaMemberText) isContentBlockDelta() {}

// An incremental update that contains the results from a tool call.
type ContentBlockDeltaMemberToolResult struct {
	Value []ToolResultBlockDelta

	noSmithyDocumentSerde
}

func (*ContentBlockDeltaMemberToolResult) isContentBlockDelta() {}

// Information about a tool that the model is requesting to use.
type ContentBlockDeltaMemberToolUse struct {
	Value ToolUseBlockDelta

	noSmithyDocumentSerde
}

func (*ContentBlockDeltaMemberToolUse) isContentBlockDelta() {}

// The content block delta event.
type ContentBlockDeltaEvent struct {

	// The block index for a content block delta event.
	//
	// This member is required.
	ContentBlockIndex *int32

	// The delta for a content block delta event.
	//
	// This member is required.
	Delta ContentBlockDelta

	noSmithyDocumentSerde
}

// Content block start information.
//
// The following types satisfy this interface:
//
//	ContentBlockStartMemberImage
//	ContentBlockStartMemberToolResult
//	ContentBlockStartMemberToolUse
type ContentBlockStart interface {
	isContentBlockStart()
}

// The initial event indicating the start of a streaming image block.
type ContentBlockStartMemberImage struct {
	Value ImageBlockStart

	noSmithyDocumentSerde
}

func (*ContentBlockStartMemberImage) isContentBlockStart() {}

// The
type ContentBlockStartMemberToolResult struct {
	Value ToolResultBlockStart

	noSmithyDocumentSerde
}

func (*ContentBlockStartMemberToolResult) isContentBlockStart() {}

// Information about a tool that the model is requesting to use.
type ContentBlockStartMemberToolUse struct {
	Value ToolUseBlockStart

	noSmithyDocumentSerde
}

func (*ContentBlockStartMemberToolUse) isContentBlockStart() {}

// Content block start event.
type ContentBlockStartEvent struct {

	// The index for a content block start event.
	//
	// This member is required.
	ContentBlockIndex *int32

	// Start information about a content block start event.
	//
	// This member is required.
	Start ContentBlockStart

	noSmithyDocumentSerde
}

// A content block stop event.
type ContentBlockStopEvent struct {

	// The index for a content block.
	//
	// This member is required.
	ContentBlockIndex *int32

	noSmithyDocumentSerde
}

// Metrics for a call to [Converse].
//
// [Converse]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html
type ConverseMetrics struct {

	// The latency of the call to Converse , in milliseconds.
	//
	// This member is required.
	LatencyMs *int64

	noSmithyDocumentSerde
}

// The output from a call to [Converse].
//
// The following types satisfy this interface:
//
//	ConverseOutputMemberMessage
//
// [Converse]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html
type ConverseOutput interface {
	isConverseOutput()
}

// The message that the model generates.
type ConverseOutputMemberMessage struct {
	Value Message

	noSmithyDocumentSerde
}

func (*ConverseOutputMemberMessage) isConverseOutput() {}

// A conversation stream metadata event.
type ConverseStreamMetadataEvent struct {

	// The metrics for the conversation stream metadata event.
	//
	// This member is required.
	Metrics *ConverseStreamMetrics

	// Usage information for the conversation stream event.
	//
	// This member is required.
	Usage *TokenUsage

	// Model performance configuration metadata for the conversation stream event.
	PerformanceConfig *PerformanceConfiguration

	// Specifies the processing tier configuration used for serving the request.
	ServiceTier *ServiceTier

	// The trace object in the response from [ConverseStream] that contains information about the
	// guardrail behavior.
	//
	// [ConverseStream]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html
	Trace *ConverseStreamTrace

	noSmithyDocumentSerde
}

// Metrics for the stream.
type ConverseStreamMetrics struct {

	// The latency for the streaming request, in milliseconds.
	//
	// This member is required.
	LatencyMs *int64

	noSmithyDocumentSerde
}

// The messages output stream
//
// The following types satisfy this interface:
//
//	ConverseStreamOutputMemberContentBlockDelta
//	ConverseStreamOutputMemberContentBlockStart
//	ConverseStreamOutputMemberContentBlockStop
//	ConverseStreamOutputMemberMessageStart
//	ConverseStreamOutputMemberMessageStop
//	ConverseStreamOutputMemberMetadata
type ConverseStreamOutput interface {
	isConverseStreamOutput()
}

// The messages output content block delta.
type ConverseStreamOutputMemberContentBlockDelta struct {
	Value ContentBlockDeltaEvent

	noSmithyDocumentSerde
}

func (*ConverseStreamOutputMemberContentBlockDelta) isConverseStreamOutput() {}

// Start information for a content block.
type ConverseStreamOutputMemberContentBlockStart struct {
	Value ContentBlockStartEvent

	noSmithyDocumentSerde
}

func (*ConverseStreamOutputMemberContentBlockStart) isConverseStreamOutput() {}

// Stop information for a content block.
type ConverseStreamOutputMemberContentBlockStop struct {
	Value ContentBlockStopEvent

	noSmithyDocumentSerde
}

func (*ConverseStreamOutputMemberContentBlockStop) isConverseStreamOutput() {}

// Message start information.
type ConverseStreamOutputMemberMessageStart struct {
	Value MessageStartEvent

	noSmithyDocumentSerde
}

func (*ConverseStreamOutputMemberMessageStart) isConverseStreamOutput() {}

// Message stop information.
type ConverseStreamOutputMemberMessageStop struct {
	Value MessageStopEvent

	noSmithyDocumentSerde
}

func (*ConverseStreamOutputMemberMessageStop) isConverseStreamOutput() {}

// Metadata for the converse output stream.
type ConverseStreamOutputMemberMetadata struct {
	Value ConverseStreamMetadataEvent

	noSmithyDocumentSerde
}

func (*ConverseStreamOutputMemberMetadata) isConverseStreamOutput() {}

// The trace object in a response from [ConverseStream].
//
// [ConverseStream]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html
type ConverseStreamTrace struct {

	// The guardrail trace object.
	Guardrail *GuardrailTraceAssessment

	// The request's prompt router.
	PromptRouter *PromptRouterTrace

	noSmithyDocumentSerde
}

// The inputs from a Converse API request for token counting.
//
// This structure mirrors the input format for the Converse operation, allowing
// you to count tokens for conversation-based inference requests.
type ConverseTokensRequest struct {

	// The additionalModelRequestFields of Converse input request to count tokens for.
	// Use this field when you want to pass additional parameters that the model
	// supports.
	AdditionalModelRequestFields document.Interface

	// An array of messages to count tokens for.
	Messages []Message

	// The system content blocks to count tokens for. System content provides
	// instructions or context to the model about how it should behave or respond. The
	// token count will include any system content provided.
	System []SystemContentBlock

	// The toolConfig of Converse input request to count tokens for. Configuration
	// information for the tools that the model can use when generating a response.
	ToolConfig *ToolConfiguration

	noSmithyDocumentSerde
}

// The trace object in a response from [Converse].
//
// [Converse]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html
type ConverseTrace struct {

	// The guardrail trace object.
	Guardrail *GuardrailTraceAssessment

	// The request's prompt router.
	PromptRouter *PromptRouterTrace

	noSmithyDocumentSerde
}

// The input value for token counting. The value should be either an InvokeModel
// or Converse request body.
//
// The following types satisfy this interface:
//
//	CountTokensInputMemberConverse
//	CountTokensInputMemberInvokeModel
type CountTokensInput interface {
	isCountTokensInput()
}

// A Converse request for which to count tokens. Use this field when you want to
// count tokens for a conversation-based input that would be sent to the Converse
// operation.
type CountTokensInputMemberConverse struct {
	Value ConverseTokensRequest

	noSmithyDocumentSerde
}

func (*CountTokensInputMemberConverse) isCountTokensInput() {}

// An InvokeModel request for which to count tokens. Use this field when you want
// to count tokens for a raw text input that would be sent to the InvokeModel
// operation.
type CountTokensInputMemberInvokeModel struct {
	Value InvokeModelTokensRequest

	noSmithyDocumentSerde
}

func (*CountTokensInputMemberInvokeModel) isCountTokensInput() {}

// A document to include in a message.
type DocumentBlock struct {

	// A name for the document. The name can only contain the following characters:
	//
	//   - Alphanumeric characters
	//
	//   - Whitespace characters (no more than one in a row)
	//
	//   - Hyphens
	//
	//   - Parentheses
	//
	//   - Square brackets
	//
	// This field is vulnerable to prompt injections, because the model might
	// inadvertently interpret it as instructions. Therefore, we recommend that you
	// specify a neutral name.
	//
	// This member is required.
	Name *string

	// Contains the content of the document.
	//
	// This member is required.
	Source DocumentSource

	// Configuration settings that control how citations should be generated for this
	// specific document.
	Citations *CitationsConfig

	// Contextual information about how the document should be processed or
	// interpreted by the model when generating citations.
	Context *string

	// The format of a document, or its extension.
	Format DocumentFormat

	noSmithyDocumentSerde
}

// Specifies a character-level location within a document, providing precise
// positioning information for cited content using start and end character indices.
type DocumentCharLocation struct {

	// The index of the document within the array of documents provided in the request.
	DocumentIndex *int32

	// The ending character position of the cited content within the document.
	End *int32

	// The starting character position of the cited content within the document.
	Start *int32

	noSmithyDocumentSerde
}

// Specifies a chunk-level location within a document, providing positioning
// information for cited content using logical document segments or chunks.
type DocumentChunkLocation struct {

	// The index of the document within the array of documents provided in the request.
	DocumentIndex *int32

	// The ending chunk identifier or index of the cited content within the document.
	End *int32

	// The starting chunk identifier or index of the cited content within the document.
	Start *int32

	noSmithyDocumentSerde
}

// Contains the actual content of a document that can be processed by the model
// and potentially cited in the response.
//
// The following types satisfy this interface:
//
//	DocumentContentBlockMemberText
type DocumentContentBlock interface {
	isDocumentContentBlock()
}

// The text content of the document.
type DocumentContentBlockMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*DocumentContentBlockMemberText) isDocumentContentBlock() {}

// Specifies a page-level location within a document, providing positioning
// information for cited content using page numbers.
type DocumentPageLocation struct {

	// The index of the document within the array of documents provided in the request.
	DocumentIndex *int32

	// The ending page number of the cited content within the document.
	End *int32

	// The starting page number of the cited content within the document.
	Start *int32

	noSmithyDocumentSerde
}

// Contains the content of a document.
//
// The following types satisfy this interface:
//
//	DocumentSourceMemberBytes
//	DocumentSourceMemberContent
//	DocumentSourceMemberS3Location
//	DocumentSourceMemberText
type DocumentSource interface {
	isDocumentSource()
}

// The raw bytes for the document. If you use an Amazon Web Services SDK, you
// don't need to encode the bytes in base64.
type DocumentSourceMemberBytes struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*DocumentSourceMemberBytes) isDocumentSource() {}

// The structured content of the document source, which may include various
// content blocks such as text, images, or other document elements.
type DocumentSourceMemberContent struct {
	Value []DocumentContentBlock

	noSmithyDocumentSerde
}

func (*DocumentSourceMemberContent) isDocumentSource() {}

// The location of a document object in an Amazon S3 bucket. To see which models
// support S3 uploads, see [Supported models and features for Converse].
//
// [Supported models and features for Converse]: https://docs.aws.amazon.com/bedrock/latest/userguide/conversation-inference-supported-models-features.html
type DocumentSourceMemberS3Location struct {
	Value S3Location

	noSmithyDocumentSerde
}

func (*DocumentSourceMemberS3Location) isDocumentSource() {}

// The text content of the document source.
type DocumentSourceMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*DocumentSourceMemberText) isDocumentSource() {}

// A block containing error information when content processing fails.
type ErrorBlock struct {

	// A human-readable error message describing what went wrong during content
	// processing.
	Message *string

	noSmithyDocumentSerde
}

// A behavior assessment of the guardrail policies used in a call to the Converse
// API.
type GuardrailAssessment struct {

	// Details about the specific guardrail that was applied during this assessment,
	// including its identifier, version, ARN, origin, and ownership information.
	AppliedGuardrailDetails *AppliedGuardrailDetails

	// The automated reasoning policy assessment results, including logical validation
	// findings for the input content.
	AutomatedReasoningPolicy *GuardrailAutomatedReasoningPolicyAssessment

	// The content policy.
	ContentPolicy *GuardrailContentPolicyAssessment

	// The contextual grounding policy used for the guardrail assessment.
	ContextualGroundingPolicy *GuardrailContextualGroundingPolicyAssessment

	// The invocation metrics for the guardrail assessment.
	InvocationMetrics *GuardrailInvocationMetrics

	// The sensitive information policy.
	SensitiveInformationPolicy *GuardrailSensitiveInformationPolicyAssessment

	// The topic policy.
	TopicPolicy *GuardrailTopicPolicyAssessment

	// The word policy.
	WordPolicy *GuardrailWordPolicyAssessment

	noSmithyDocumentSerde
}

// Represents a logical validation result from automated reasoning policy
// evaluation. The finding indicates whether claims in the input are logically
// valid, invalid, satisfiable, impossible, or have other logical issues.
//
// The following types satisfy this interface:
//
//	GuardrailAutomatedReasoningFindingMemberImpossible
//	GuardrailAutomatedReasoningFindingMemberInvalid
//	GuardrailAutomatedReasoningFindingMemberNoTranslations
//	GuardrailAutomatedReasoningFindingMemberSatisfiable
//	GuardrailAutomatedReasoningFindingMemberTooComplex
//	GuardrailAutomatedReasoningFindingMemberTranslationAmbiguous
//	GuardrailAutomatedReasoningFindingMemberValid
type GuardrailAutomatedReasoningFinding interface {
	isGuardrailAutomatedReasoningFinding()
}

// Contains the result when the automated reasoning evaluation determines that no
// valid logical conclusions can be drawn due to contradictions in the premises or
// policy rules themselves.
type GuardrailAutomatedReasoningFindingMemberImpossible struct {
	Value GuardrailAutomatedReasoningImpossibleFinding

	noSmithyDocumentSerde
}

func (*GuardrailAutomatedReasoningFindingMemberImpossible) isGuardrailAutomatedReasoningFinding() {}

// Contains the result when the automated reasoning evaluation determines that the
// claims in the input are logically invalid and contradict the established
// premises or policy rules.
type GuardrailAutomatedReasoningFindingMemberInvalid struct {
	Value GuardrailAutomatedReasoningInvalidFinding

	noSmithyDocumentSerde
}

func (*GuardrailAutomatedReasoningFindingMemberInvalid) isGuardrailAutomatedReasoningFinding() {}

// Contains the result when the automated reasoning evaluation cannot extract any
// relevant logical information from the input that can be validated against the
// policy rules.
type GuardrailAutomatedReasoningFindingMemberNoTranslations struct {
	Value GuardrailAutomatedReasoningNoTranslationsFinding

	noSmithyDocumentSerde
}

func (*GuardrailAutomatedReasoningFindingMemberNoTranslations) isGuardrailAutomatedReasoningFinding() {
}

// Contains the result when the automated reasoning evaluation determines that the
// claims in the input could be either true or false depending on additional
// assumptions not provided in the input context.
type GuardrailAutomatedReasoningFindingMemberSatisfiable struct {
	Value GuardrailAutomatedReasoningSatisfiableFinding

	noSmithyDocumentSerde
}

func (*GuardrailAutomatedReasoningFindingMemberSatisfiable) isGuardrailAutomatedReasoningFinding() {}

// Contains the result when the automated reasoning evaluation cannot process the
// input due to its complexity or volume exceeding the system's processing capacity
// for logical analysis.
type GuardrailAutomatedReasoningFindingMemberTooComplex struct {
	Value GuardrailAutomatedReasoningTooComplexFinding

	noSmithyDocumentSerde
}

func (*GuardrailAutomatedReasoningFindingMemberTooComplex) isGuardrailAutomatedReasoningFinding() {}

// Contains the result when the automated reasoning evaluation detects that the
// input has multiple valid logical interpretations, requiring additional context
// or clarification to proceed with validation.
type GuardrailAutomatedReasoningFindingMemberTranslationAmbiguous struct {
	Value GuardrailAutomatedReasoningTranslationAmbiguousFinding

	noSmithyDocumentSerde
}

func (*GuardrailAutomatedReasoningFindingMemberTranslationAmbiguous) isGuardrailAutomatedReasoningFinding() {
}

// Contains the result when the automated reasoning evaluation determines that the
// claims in the input are logically valid and definitively true based on the
// provided premises and policy rules.
type GuardrailAutomatedReasoningFindingMemberValid struct {
	Value GuardrailAutomatedReasoningValidFinding

	noSmithyDocumentSerde
}

func (*GuardrailAutomatedReasoningFindingMemberValid) isGuardrailAutomatedReasoningFinding() {}

// Indicates that no valid claims can be made due to logical contradictions in the
// premises or rules.
type GuardrailAutomatedReasoningImpossibleFinding struct {

	// The automated reasoning policy rules that contradict the claims and/or premises
	// in the input.
	ContradictingRules []GuardrailAutomatedReasoningRule

	// Indication of a logic issue with the translation without needing to consider
	// the automated reasoning policy rules.
	LogicWarning *GuardrailAutomatedReasoningLogicWarning

	// The logical translation of the input that this finding evaluates.
	Translation *GuardrailAutomatedReasoningTranslation

	noSmithyDocumentSerde
}

// References a portion of the original input text that corresponds to logical
// elements.
type GuardrailAutomatedReasoningInputTextReference struct {

	// The specific text from the original input that this reference points to.
	Text *string

	noSmithyDocumentSerde
}

// Indicates that the claims are logically false and contradictory to the
// established rules or premises.
type GuardrailAutomatedReasoningInvalidFinding struct {

	// The automated reasoning policy rules that contradict the claims in the input.
	ContradictingRules []GuardrailAutomatedReasoningRule

	// Indication of a logic issue with the translation without needing to consider
	// the automated reasoning policy rules.
	LogicWarning *GuardrailAutomatedReasoningLogicWarning

	// The logical translation of the input that this finding invalidates.
	Translation *GuardrailAutomatedReasoningTranslation

	noSmithyDocumentSerde
}

// Identifies logical issues in the translated statements that exist independent
// of any policy rules, such as statements that are always true or always false.
type GuardrailAutomatedReasoningLogicWarning struct {

	// The logical statements that are validated while assuming the policy and
	// premises.
	Claims []GuardrailAutomatedReasoningStatement

	// The logical statements that serve as premises under which the claims are
	// validated.
	Premises []GuardrailAutomatedReasoningStatement

	// The category of the detected logical issue, such as statements that are always
	// true or always false.
	Type GuardrailAutomatedReasoningLogicWarningType

	noSmithyDocumentSerde
}

// Indicates that no relevant logical information could be extracted from the
// input for validation.
type GuardrailAutomatedReasoningNoTranslationsFinding struct {
	noSmithyDocumentSerde
}

// Contains the results of automated reasoning policy evaluation, including
// logical findings about the validity of claims made in the input content.
type GuardrailAutomatedReasoningPolicyAssessment struct {

	// List of logical validation results produced by evaluating the input content
	// against automated reasoning policies.
	Findings []GuardrailAutomatedReasoningFinding

	noSmithyDocumentSerde
}

// References a specific automated reasoning policy rule that was applied during
// evaluation.
type GuardrailAutomatedReasoningRule struct {

	// The unique identifier of the automated reasoning rule.
	Identifier *string

	// The ARN of the automated reasoning policy version that contains this rule.
	PolicyVersionArn *string

	noSmithyDocumentSerde
}

// Indicates that the claims could be either true or false depending on additional
// assumptions not provided in the input.
type GuardrailAutomatedReasoningSatisfiableFinding struct {

	// An example scenario demonstrating how the claims could be logically false.
	ClaimsFalseScenario *GuardrailAutomatedReasoningScenario

	// An example scenario demonstrating how the claims could be logically true.
	ClaimsTrueScenario *GuardrailAutomatedReasoningScenario

	// Indication of a logic issue with the translation without needing to consider
	// the automated reasoning policy rules.
	LogicWarning *GuardrailAutomatedReasoningLogicWarning

	// The logical translation of the input that this finding evaluates.
	Translation *GuardrailAutomatedReasoningTranslation

	noSmithyDocumentSerde
}

// Represents a logical scenario where claims can be evaluated as true or false,
// containing specific logical assignments.
type GuardrailAutomatedReasoningScenario struct {

	// List of logical assignments and statements that define this scenario.
	Statements []GuardrailAutomatedReasoningStatement

	noSmithyDocumentSerde
}

// A logical statement that includes both formal logic representation and natural
// language explanation.
type GuardrailAutomatedReasoningStatement struct {

	// The formal logical representation of the statement.
	Logic *string

	// The natural language explanation of the logical statement.
	NaturalLanguage *string

	noSmithyDocumentSerde
}

// Indicates that the input exceeds the processing capacity due to the volume or
// complexity of the logical information.
type GuardrailAutomatedReasoningTooComplexFinding struct {
	noSmithyDocumentSerde
}

// Contains the logical translation of natural language input into formal logical
// statements, including premises, claims, and confidence scores.
type GuardrailAutomatedReasoningTranslation struct {

	// The logical statements that are being validated against the premises and policy
	// rules.
	Claims []GuardrailAutomatedReasoningStatement

	// A confidence score between 0 and 1 indicating how certain the system is about
	// the logical translation.
	Confidence *float64

	// The logical statements that serve as the foundation or assumptions for the
	// claims.
	Premises []GuardrailAutomatedReasoningStatement

	// References to portions of the original input text that correspond to the claims
	// but could not be fully translated.
	UntranslatedClaims []GuardrailAutomatedReasoningInputTextReference

	// References to portions of the original input text that correspond to the
	// premises but could not be fully translated.
	UntranslatedPremises []GuardrailAutomatedReasoningInputTextReference

	noSmithyDocumentSerde
}

// Indicates that the input has multiple valid logical interpretations, requiring
// additional context or clarification.
type GuardrailAutomatedReasoningTranslationAmbiguousFinding struct {

	// Scenarios showing how the different translation options differ in meaning.
	DifferenceScenarios []GuardrailAutomatedReasoningScenario

	// Different logical interpretations that were detected during translation of the
	// input.
	Options []GuardrailAutomatedReasoningTranslationOption

	noSmithyDocumentSerde
}

// Represents one possible logical interpretation of ambiguous input content.
type GuardrailAutomatedReasoningTranslationOption struct {

	// Example translations that provide this possible interpretation of the input.
	Translations []GuardrailAutomatedReasoningTranslation

	noSmithyDocumentSerde
}

// Indicates that the claims are definitively true and logically implied by the
// premises, with no possible alternative interpretations.
type GuardrailAutomatedReasoningValidFinding struct {

	// An example scenario demonstrating how the claims are logically true.
	ClaimsTrueScenario *GuardrailAutomatedReasoningScenario

	// Indication of a logic issue with the translation without needing to consider
	// the automated reasoning policy rules.
	LogicWarning *GuardrailAutomatedReasoningLogicWarning

	// The automated reasoning policy rules that support why this result is considered
	// valid.
	SupportingRules []GuardrailAutomatedReasoningRule

	// The logical translation of the input that this finding validates.
	Translation *GuardrailAutomatedReasoningTranslation

	noSmithyDocumentSerde
}

// Configuration information for a guardrail that you use with the [Converse] operation.
//
// [Converse]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html
type GuardrailConfiguration struct {

	// The identifier for the guardrail.
	GuardrailIdentifier *string

	// The version of the guardrail.
	GuardrailVersion *string

	// The trace behavior for the guardrail.
	Trace GuardrailTrace

	noSmithyDocumentSerde
}

// The content block to be evaluated by the guardrail.
//
// The following types satisfy this interface:
//
//	GuardrailContentBlockMemberImage
//	GuardrailContentBlockMemberText
type GuardrailContentBlock interface {
	isGuardrailContentBlock()
}

// Image within guardrail content block to be evaluated by the guardrail.
type GuardrailContentBlockMemberImage struct {
	Value GuardrailImageBlock

	noSmithyDocumentSerde
}

func (*GuardrailContentBlockMemberImage) isGuardrailContentBlock() {}

// Text within content block to be evaluated by the guardrail.
type GuardrailContentBlockMemberText struct {
	Value GuardrailTextBlock

	noSmithyDocumentSerde
}

func (*GuardrailContentBlockMemberText) isGuardrailContentBlock() {}

// The content filter for a guardrail.
type GuardrailContentFilter struct {

	// The guardrail action.
	//
	// This member is required.
	Action GuardrailContentPolicyAction

	// The guardrail confidence.
	//
	// This member is required.
	Confidence GuardrailContentFilterConfidence

	// The guardrail type.
	//
	// This member is required.
	Type GuardrailContentFilterType

	// Indicates whether content that breaches the guardrail configuration is detected.
	Detected *bool

	// The filter strength setting for the guardrail content filter.
	FilterStrength GuardrailContentFilterStrength

	noSmithyDocumentSerde
}

// An assessment of a content policy for a guardrail.
type GuardrailContentPolicyAssessment struct {

	// The content policy filters.
	//
	// This member is required.
	Filters []GuardrailContentFilter

	noSmithyDocumentSerde
}

// The details for the guardrails contextual grounding filter.
type GuardrailContextualGroundingFilter struct {

	// The action performed by the guardrails contextual grounding filter.
	//
	// This member is required.
	Action GuardrailContextualGroundingPolicyAction

	// The score generated by contextual grounding filter.
	//
	// This member is required.
	Score *float64

	// The threshold used by contextual grounding filter to determine whether the
	// content is grounded or not.
	//
	// This member is required.
	Threshold *float64

	// The contextual grounding filter type.
	//
	// This member is required.
	Type GuardrailContextualGroundingFilterType

	// Indicates whether content that fails the contextual grounding evaluation
	// (grounding or relevance score less than the corresponding threshold) was
	// detected.
	Detected *bool

	noSmithyDocumentSerde
}

// The policy assessment details for the guardrails contextual grounding filter.
type GuardrailContextualGroundingPolicyAssessment struct {

	// The filter details for the guardrails contextual grounding filter.
	Filters []GuardrailContextualGroundingFilter

	noSmithyDocumentSerde
}

// A content block for selective guarding with the [Converse] or [ConverseStream] API operations.
//
// The following types satisfy this interface:
//
//	GuardrailConverseContentBlockMemberImage
//	GuardrailConverseContentBlockMemberText
//
// [Converse]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html
// [ConverseStream]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html
type GuardrailConverseContentBlock interface {
	isGuardrailConverseContentBlock()
}

// Image within converse content block to be evaluated by the guardrail.
type GuardrailConverseContentBlockMemberImage struct {
	Value GuardrailConverseImageBlock

	noSmithyDocumentSerde
}

func (*GuardrailConverseContentBlockMemberImage) isGuardrailConverseContentBlock() {}

// The text to guard.
type GuardrailConverseContentBlockMemberText struct {
	Value GuardrailConverseTextBlock

	noSmithyDocumentSerde
}

func (*GuardrailConverseContentBlockMemberText) isGuardrailConverseContentBlock() {}

// An image block that contains images that you want to assess with a guardrail.
type GuardrailConverseImageBlock struct {

	// The format details for the image type of the guardrail converse image block.
	//
	// This member is required.
	Format GuardrailConverseImageFormat

	// The image source (image bytes) of the guardrail converse image block.
	//
	// This member is required.
	Source GuardrailConverseImageSource

	noSmithyDocumentSerde
}

// The image source (image bytes) of the guardrail converse image source.
//
// The following types satisfy this interface:
//
//	GuardrailConverseImageSourceMemberBytes
type GuardrailConverseImageSource interface {
	isGuardrailConverseImageSource()
}

// The raw image bytes for the image.
type GuardrailConverseImageSourceMemberBytes struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*GuardrailConverseImageSourceMemberBytes) isGuardrailConverseImageSource() {}

// A text block that contains text that you want to assess with a guardrail. For
// more information, see [GuardrailConverseContentBlock].
//
// [GuardrailConverseContentBlock]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_GuardrailConverseContentBlock.html
type GuardrailConverseTextBlock struct {

	// The text that you want to guard.
	//
	// This member is required.
	Text *string

	// The qualifier details for the guardrails contextual grounding filter.
	Qualifiers []GuardrailConverseContentQualifier

	noSmithyDocumentSerde
}

// The action of the guardrail coverage details.
type GuardrailCoverage struct {

	// The guardrail coverage for images (the number of images that guardrails
	// guarded).
	Images *GuardrailImageCoverage

	// The text characters of the guardrail coverage details.
	TextCharacters *GuardrailTextCharactersCoverage

	noSmithyDocumentSerde
}

// A custom word configured in a guardrail.
type GuardrailCustomWord struct {

	// The action for the custom word.
	//
	// This member is required.
	Action GuardrailWordPolicyAction

	// The match for the custom word.
	//
	// This member is required.
	Match *string

	// Indicates whether custom word content that breaches the guardrail configuration
	// is detected.
	Detected *bool

	noSmithyDocumentSerde
}

// Contain an image which user wants guarded. This block is accepted by the
// guardrails independent API.
type GuardrailImageBlock struct {

	// The format details for the file type of the image blocked by the guardrail.
	//
	// This member is required.
	Format GuardrailImageFormat

	// The image source (image bytes) details of the image blocked by the guardrail.
	//
	// This member is required.
	Source GuardrailImageSource

	noSmithyDocumentSerde
}

// The details of the guardrail image coverage.
type GuardrailImageCoverage struct {

	// The count (integer) of images guardrails guarded.
	Guarded *int32

	// Represents the total number of images (integer) that were in the request
	// (guarded and unguarded).
	Total *int32

	noSmithyDocumentSerde
}

// The image source (image bytes) of the guardrail image source. Object used in
// independent api.
//
// The following types satisfy this interface:
//
//	GuardrailImageSourceMemberBytes
type GuardrailImageSource interface {
	isGuardrailImageSource()
}

// The bytes details of the guardrail image source. Object used in independent api.
type GuardrailImageSourceMemberBytes struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*GuardrailImageSourceMemberBytes) isGuardrailImageSource() {}

// The invocation metrics for the guardrail.
type GuardrailInvocationMetrics struct {

	// The coverage details for the guardrail invocation metrics.
	GuardrailCoverage *GuardrailCoverage

	// The processing latency details for the guardrail invocation metrics.
	GuardrailProcessingLatency *int64

	// The usage details for the guardrail invocation metrics.
	Usage *GuardrailUsage

	noSmithyDocumentSerde
}

// A managed word configured in a guardrail.
type GuardrailManagedWord struct {

	// The action for the managed word.
	//
	// This member is required.
	Action GuardrailWordPolicyAction

	// The match for the managed word.
	//
	// This member is required.
	Match *string

	// The type for the managed word.
	//
	// This member is required.
	Type GuardrailManagedWordType

	// Indicates whether managed word content that breaches the guardrail
	// configuration is detected.
	Detected *bool

	noSmithyDocumentSerde
}

// The output content produced by the guardrail.
type GuardrailOutputContent struct {

	// The specific text for the output content produced by the guardrail.
	Text *string

	noSmithyDocumentSerde
}

// A Personally Identifiable Information (PII) entity configured in a guardrail.
type GuardrailPiiEntityFilter struct {

	// The PII entity filter action.
	//
	// This member is required.
	Action GuardrailSensitiveInformationPolicyAction

	// The PII entity filter match.
	//
	// This member is required.
	Match *string

	// The PII entity filter type.
	//
	// This member is required.
	Type GuardrailPiiEntityType

	// Indicates whether personally identifiable information (PII) that breaches the
	// guardrail configuration is detected.
	Detected *bool

	noSmithyDocumentSerde
}

// A Regex filter configured in a guardrail.
type GuardrailRegexFilter struct {

	// The region filter action.
	//
	// This member is required.
	Action GuardrailSensitiveInformationPolicyAction

	// Indicates whether custom regex entities that breach the guardrail configuration
	// are detected.
	Detected *bool

	// The regesx filter match.
	Match *string

	// The regex filter name.
	Name *string

	// The regex query.
	Regex *string

	noSmithyDocumentSerde
}

// The assessment for a Personally Identifiable Information (PII) policy.
type GuardrailSensitiveInformationPolicyAssessment struct {

	// The PII entities in the assessment.
	//
	// This member is required.
	PiiEntities []GuardrailPiiEntityFilter

	// The regex queries in the assessment.
	//
	// This member is required.
	Regexes []GuardrailRegexFilter

	noSmithyDocumentSerde
}

// Configuration information for a guardrail that you use with the [ConverseStream] action.
//
// [ConverseStream]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html
type GuardrailStreamConfiguration struct {

	// The identifier for the guardrail.
	GuardrailIdentifier *string

	// The version of the guardrail.
	GuardrailVersion *string

	// The processing mode.
	//
	// The processing mode. For more information, see Configure streaming response
	// behavior in the Amazon Bedrock User Guide.
	StreamProcessingMode GuardrailStreamProcessingMode

	// The trace behavior for the guardrail.
	Trace GuardrailTrace

	noSmithyDocumentSerde
}

// The text block to be evaluated by the guardrail.
type GuardrailTextBlock struct {

	// The input text details to be evaluated by the guardrail.
	//
	// This member is required.
	Text *string

	// The qualifiers describing the text block.
	Qualifiers []GuardrailContentQualifier

	noSmithyDocumentSerde
}

// The guardrail coverage for the text characters.
type GuardrailTextCharactersCoverage struct {

	// The text characters that were guarded by the guardrail coverage.
	Guarded *int32

	// The total text characters by the guardrail coverage.
	Total *int32

	noSmithyDocumentSerde
}

// Information about a topic guardrail.
type GuardrailTopic struct {

	// The action the guardrail should take when it intervenes on a topic.
	//
	// This member is required.
	Action GuardrailTopicPolicyAction

	// The name for the guardrail.
	//
	// This member is required.
	Name *string

	// The type behavior that the guardrail should perform when the model detects the
	// topic.
	//
	// This member is required.
	Type GuardrailTopicType

	// Indicates whether topic content that breaches the guardrail configuration is
	// detected.
	Detected *bool

	noSmithyDocumentSerde
}

// A behavior assessment of a topic policy.
type GuardrailTopicPolicyAssessment struct {

	// The topics in the assessment.
	//
	// This member is required.
	Topics []GuardrailTopic

	noSmithyDocumentSerde
}

// A Top level guardrail trace object. For more information, see [ConverseTrace].
//
// [ConverseTrace]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseTrace.html
type GuardrailTraceAssessment struct {

	// Provides the reason for the action taken when harmful content is detected.
	ActionReason *string

	// The input assessment.
	InputAssessment map[string]GuardrailAssessment

	// The output from the model.
	ModelOutput []string

	// the output assessments.
	OutputAssessments map[string][]GuardrailAssessment

	noSmithyDocumentSerde
}

// The details on the use of the guardrail.
type GuardrailUsage struct {

	// The content policy units processed by the guardrail.
	//
	// This member is required.
	ContentPolicyUnits *int32

	// The contextual grounding policy units processed by the guardrail.
	//
	// This member is required.
	ContextualGroundingPolicyUnits *int32

	// The sensitive information policy free units processed by the guardrail.
	//
	// This member is required.
	SensitiveInformationPolicyFreeUnits *int32

	// The sensitive information policy units processed by the guardrail.
	//
	// This member is required.
	SensitiveInformationPolicyUnits *int32

	// The topic policy units processed by the guardrail.
	//
	// This member is required.
	TopicPolicyUnits *int32

	// The word policy units processed by the guardrail.
	//
	// This member is required.
	WordPolicyUnits *int32

	// The number of automated reasoning policies that were processed during the
	// guardrail evaluation.
	AutomatedReasoningPolicies *int32

	// The number of text units processed by the automated reasoning policy.
	AutomatedReasoningPolicyUnits *int32

	// The content policy image units processed by the guardrail.
	ContentPolicyImageUnits *int32

	noSmithyDocumentSerde
}

// The word policy assessment.
type GuardrailWordPolicyAssessment struct {

	// Custom words in the assessment.
	//
	// This member is required.
	CustomWords []GuardrailCustomWord

	// Managed word lists in the assessment.
	//
	// This member is required.
	ManagedWordLists []GuardrailManagedWord

	noSmithyDocumentSerde
}

// Image content for a message.
type ImageBlock struct {

	// The format of the image.
	//
	// This member is required.
	Format ImageFormat

	// The source for the image.
	//
	// This member is required.
	Source ImageSource

	// Error information if the image block could not be processed or contains invalid
	// data.
	Error *ErrorBlock

	noSmithyDocumentSerde
}

// A streaming delta event that contains incremental image data during streaming
// responses.
type ImageBlockDelta struct {

	// Error information if this image delta could not be processed.
	Error *ErrorBlock

	// The incremental image source data for this delta event.
	Source ImageSource

	noSmithyDocumentSerde
}

// The initial event in a streaming image block that indicates the start of image
// content.
type ImageBlockStart struct {

	// The format of the image data that will be streamed in subsequent delta events.
	//
	// This member is required.
	Format ImageFormat

	noSmithyDocumentSerde
}

// The source for an image.
//
// The following types satisfy this interface:
//
//	ImageSourceMemberBytes
//	ImageSourceMemberS3Location
type ImageSource interface {
	isImageSource()
}

// The raw image bytes for the image. If you use an AWS SDK, you don't need to
// encode the image bytes in base64.
type ImageSourceMemberBytes struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*ImageSourceMemberBytes) isImageSource() {}

// The location of an image object in an Amazon S3 bucket. To see which models
// support S3 uploads, see [Supported models and features for Converse].
//
// [Supported models and features for Converse]: https://docs.aws.amazon.com/bedrock/latest/userguide/conversation-inference-supported-models-features.html
type ImageSourceMemberS3Location struct {
	Value S3Location

	noSmithyDocumentSerde
}

func (*ImageSourceMemberS3Location) isImageSource() {}

// Base inference parameters to pass to a model in a call to [Converse] or [ConverseStream]. For more
// information, see [Inference parameters for foundation models].
//
// If you need to pass additional parameters that the model supports, use the
// additionalModelRequestFields request field in the call to Converse or
// ConverseStream . For more information, see [Model parameters].
//
// [Inference parameters for foundation models]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html
// [Converse]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html
// [ConverseStream]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html
// [Model parameters]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html
type InferenceConfiguration struct {

	// The maximum number of tokens to allow in the generated response. The default
	// value is the maximum allowed value for the model that you are using. For more
	// information, see [Inference parameters for foundation models].
	//
	// [Inference parameters for foundation models]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html
	MaxTokens *int32

	// A list of stop sequences. A stop sequence is a sequence of characters that
	// causes the model to stop generating the response.
	StopSequences []string

	// The likelihood of the model selecting higher-probability options while
	// generating a response. A lower value makes the model more likely to choose
	// higher-probability options, while a higher value makes the model more likely to
	// choose lower-probability options.
	//
	// The default value is the default value for the model that you are using. For
	// more information, see [Inference parameters for foundation models].
	//
	// [Inference parameters for foundation models]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html
	Temperature *float32

	// The percentage of most-likely candidates that the model considers for the next
	// token. For example, if you choose a value of 0.8 for topP , the model selects
	// from the top 80% of the probability distribution of tokens that could be next in
	// the sequence.
	//
	// The default value is the default value for the model that you are using. For
	// more information, see [Inference parameters for foundation models].
	//
	// [Inference parameters for foundation models]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html
	TopP *float32

	noSmithyDocumentSerde
}

// The body of an InvokeModel API request for token counting. This structure
// mirrors the input format for the InvokeModel operation, allowing you to count
// tokens for raw text inference requests.
type InvokeModelTokensRequest struct {

	// The request body to count tokens for, formatted according to the model's
	// expected input format. To learn about the input format for different models, see
	// [Model inference parameters and responses].
	//
	// [Model inference parameters and responses]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html
	//
	// This member is required.
	Body []byte

	noSmithyDocumentSerde
}

// A message input, or returned from, a call to [Converse] or [ConverseStream].
//
// [Converse]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html
// [ConverseStream]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html
type Message struct {

	// The message content. Note the following restrictions:
	//
	//   - You can include up to 20 images. Each image's size, height, and width must
	//   be no more than 3.75 MB, 8000 px, and 8000 px, respectively.
	//
	//   - You can include up to five documents. Each document's size must be no more
	//   than 4.5 MB.
	//
	//   - If you include a ContentBlock with a document field in the array, you must
	//   also include a ContentBlock with a text field.
	//
	//   - You can only include images and documents if the role is user .
	//
	// This member is required.
	Content []ContentBlock

	// The role that the message plays in the message.
	//
	// This member is required.
	Role ConversationRole

	noSmithyDocumentSerde
}

// The start of a message.
type MessageStartEvent struct {

	// The role for the message.
	//
	// This member is required.
	Role ConversationRole

	noSmithyDocumentSerde
}

// The stop event for a message.
type MessageStopEvent struct {

	// The reason why the model stopped generating output.
	//
	// This member is required.
	StopReason StopReason

	// The additional model response fields.
	AdditionalModelResponseFields document.Interface

	noSmithyDocumentSerde
}

// Payload content included in the response.
type PayloadPart struct {

	// Base64-encoded bytes of payload data.
	Bytes []byte

	noSmithyDocumentSerde
}

// Performance settings for a model.
type PerformanceConfiguration struct {

	// To use a latency-optimized version of the model, set to optimized .
	Latency PerformanceConfigLatency

	noSmithyDocumentSerde
}

// A prompt router trace.
type PromptRouterTrace struct {

	// The ID of the invoked model.
	InvokedModelId *string

	noSmithyDocumentSerde
}

// Contains a map of variables in a prompt from Prompt management to an object
// containing the values to fill in for them when running model invocation. For
// more information, see [How Prompt management works].
//
// The following types satisfy this interface:
//
//	PromptVariableValuesMemberText
//
// [How Prompt management works]: https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-how.html
type PromptVariableValues interface {
	isPromptVariableValues()
}

// The text value that the variable maps to.
type PromptVariableValuesMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*PromptVariableValuesMemberText) isPromptVariableValues() {}

// Contains content regarding the reasoning that is carried out by the model with
// respect to the content in the content block. Reasoning refers to a Chain of
// Thought (CoT) that the model generates to enhance the accuracy of its final
// response.
//
// The following types satisfy this interface:
//
//	ReasoningContentBlockMemberReasoningText
//	ReasoningContentBlockMemberRedactedContent
type ReasoningContentBlock interface {
	isReasoningContentBlock()
}

// The reasoning that the model used to return the output.
type ReasoningContentBlockMemberReasoningText struct {
	Value ReasoningTextBlock

	noSmithyDocumentSerde
}

func (*ReasoningContentBlockMemberReasoningText) isReasoningContentBlock() {}

// The content in the reasoning that was encrypted by the model provider for
// safety reasons. The encryption doesn't affect the quality of responses.
type ReasoningContentBlockMemberRedactedContent struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*ReasoningContentBlockMemberRedactedContent) isReasoningContentBlock() {}

// Contains content regarding the reasoning that is carried out by the model with
// respect to the content in the content block. Reasoning refers to a Chain of
// Thought (CoT) that the model generates to enhance the accuracy of its final
// response.
//
// The following types satisfy this interface:
//
//	ReasoningContentBlockDeltaMemberRedactedContent
//	ReasoningContentBlockDeltaMemberSignature
//	ReasoningContentBlockDeltaMemberText
type ReasoningContentBlockDelta interface {
	isReasoningContentBlockDelta()
}

// The content in the reasoning that was encrypted by the model provider for
// safety reasons. The encryption doesn't affect the quality of responses.
type ReasoningContentBlockDeltaMemberRedactedContent struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*ReasoningContentBlockDeltaMemberRedactedContent) isReasoningContentBlockDelta() {}

// A token that verifies that the reasoning text was generated by the model. If
// you pass a reasoning block back to the API in a multi-turn conversation, include
// the text and its signature unmodified.
type ReasoningContentBlockDeltaMemberSignature struct {
	Value string

	noSmithyDocumentSerde
}

func (*ReasoningContentBlockDeltaMemberSignature) isReasoningContentBlockDelta() {}

// The reasoning that the model used to return the output.
type ReasoningContentBlockDeltaMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*ReasoningContentBlockDeltaMemberText) isReasoningContentBlockDelta() {}

// Contains the reasoning that the model used to return the output.
type ReasoningTextBlock struct {

	// The reasoning that the model used to return the output.
	//
	// This member is required.
	Text *string

	// A token that verifies that the reasoning text was generated by the model. If
	// you pass a reasoning block back to the API in a multi-turn conversation, include
	// the text and its signature unmodified.
	Signature *string

	noSmithyDocumentSerde
}

// Definition of content in the response stream.
//
// The following types satisfy this interface:
//
//	ResponseStreamMemberChunk
type ResponseStream interface {
	isResponseStream()
}

// Content included in the response.
type ResponseStreamMemberChunk struct {
	Value PayloadPart

	noSmithyDocumentSerde
}

func (*ResponseStreamMemberChunk) isResponseStream() {}

// A storage location in an Amazon S3 bucket.
type S3Location struct {

	// An object URI starting with s3:// .
	//
	// This member is required.
	Uri *string

	// If the bucket belongs to another AWS account, specify that account's ID.
	BucketOwner *string

	noSmithyDocumentSerde
}

// A search result block that enables natural citations with proper source
// attribution for retrieved content.
//
// This field is only supported by Anthropic Claude Opus 4.1, Opus 4, Sonnet 4.5,
// Sonnet 4, Sonnet 3.7, and 3.5 Haiku models.
type SearchResultBlock struct {

	// An array of search result content block.
	//
	// This member is required.
	Content []SearchResultContentBlock

	// The source URL or identifier for the content.
	//
	// This member is required.
	Source *string

	// A descriptive title for the search result.
	//
	// This member is required.
	Title *string

	// Configuration setting for citations
	Citations *CitationsConfig

	noSmithyDocumentSerde
}

// A block within a search result that contains the content.
type SearchResultContentBlock struct {

	// The actual text content
	//
	// This member is required.
	Text *string

	noSmithyDocumentSerde
}

// Specifies a search result location within the content array, providing
// positioning information for cited content using search result index and block
// positions.
type SearchResultLocation struct {

	// The ending position in the content array where the cited content ends.
	End *int32

	// The index of the search result content block where the cited content is found.
	SearchResultIndex *int32

	// The starting position in the content array where the cited content begins.
	Start *int32

	noSmithyDocumentSerde
}

// Specifies the processing tier configuration used for serving the request.
type ServiceTier struct {

	// Specifies the processing tier type used for serving the request.
	//
	// This member is required.
	Type ServiceTierType

	noSmithyDocumentSerde
}

// The model must request a specific tool. For example, {"tool" : {"name" : "Your
// tool name"}} . For more information, see [Call a tool with the Converse API] in the Amazon Bedrock User Guide
//
// This field is only supported by Anthropic Claude 3 models.
//
// [Call a tool with the Converse API]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type SpecificToolChoice struct {

	// The name of the tool that the model must request.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Contains configurations for instructions to provide the model for how to handle
// input. To learn more, see [Using the Converse API].
//
// The following types satisfy this interface:
//
//	SystemContentBlockMemberCachePoint
//	SystemContentBlockMemberGuardContent
//	SystemContentBlockMemberText
//
// [Using the Converse API]: https://docs.aws.amazon.com/bedrock/latest/userguide/conversation-inference-call.html
type SystemContentBlock interface {
	isSystemContentBlock()
}

// CachePoint to include in the system prompt.
type SystemContentBlockMemberCachePoint struct {
	Value CachePointBlock

	noSmithyDocumentSerde
}

func (*SystemContentBlockMemberCachePoint) isSystemContentBlock() {}

// A content block to assess with the guardrail. Use with the [Converse] or [ConverseStream] API operations.
//
// For more information, see Use a guardrail with the Converse API in the Amazon
// Bedrock User Guide.
//
// [Converse]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html
// [ConverseStream]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html
type SystemContentBlockMemberGuardContent struct {
	Value GuardrailConverseContentBlock

	noSmithyDocumentSerde
}

func (*SystemContentBlockMemberGuardContent) isSystemContentBlock() {}

// A system prompt for the model.
type SystemContentBlockMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*SystemContentBlockMemberText) isSystemContentBlock() {}

// Specifies a system-defined tool for the model to use. System-defined tools are
// tools that are created and provided by the model provider.
type SystemTool struct {

	// The name of the system-defined tool that you want to call.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// A tag.
type Tag struct {

	// The tag's key.
	//
	// This member is required.
	Key *string

	// The tag's value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The tokens used in a message API inference call.
type TokenUsage struct {

	// The number of tokens sent in the request to the model.
	//
	// This member is required.
	InputTokens *int32

	// The number of tokens that the model generated for the request.
	//
	// This member is required.
	OutputTokens *int32

	// The total of input tokens and tokens generated by the model.
	//
	// This member is required.
	TotalTokens *int32

	// The number of input tokens read from the cache for the request.
	CacheReadInputTokens *int32

	// The number of input tokens written to the cache for the request.
	CacheWriteInputTokens *int32

	noSmithyDocumentSerde
}

// Information about a tool that you can use with the Converse API. For more
// information, see [Call a tool with the Converse API]in the Amazon Bedrock User Guide.
//
// The following types satisfy this interface:
//
//	ToolMemberCachePoint
//	ToolMemberSystemTool
//	ToolMemberToolSpec
//
// [Call a tool with the Converse API]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type Tool interface {
	isTool()
}

// CachePoint to include in the tool configuration.
type ToolMemberCachePoint struct {
	Value CachePointBlock

	noSmithyDocumentSerde
}

func (*ToolMemberCachePoint) isTool() {}

// Specifies the system-defined tool that you want use.
type ToolMemberSystemTool struct {
	Value SystemTool

	noSmithyDocumentSerde
}

func (*ToolMemberSystemTool) isTool() {}

// The specfication for the tool.
type ToolMemberToolSpec struct {
	Value ToolSpecification

	noSmithyDocumentSerde
}

func (*ToolMemberToolSpec) isTool() {}

// Determines which tools the model should request in a call to Converse or
// ConverseStream . For more information, see [Call a tool with the Converse API] in the Amazon Bedrock User Guide.
//
// The following types satisfy this interface:
//
//	ToolChoiceMemberAny
//	ToolChoiceMemberAuto
//	ToolChoiceMemberTool
//
// [Call a tool with the Converse API]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type ToolChoice interface {
	isToolChoice()
}

// The model must request at least one tool (no text is generated).
type ToolChoiceMemberAny struct {
	Value AnyToolChoice

	noSmithyDocumentSerde
}

func (*ToolChoiceMemberAny) isToolChoice() {}

// (Default). The Model automatically decides if a tool should be called or
// whether to generate text instead.
type ToolChoiceMemberAuto struct {
	Value AutoToolChoice

	noSmithyDocumentSerde
}

func (*ToolChoiceMemberAuto) isToolChoice() {}

// The Model must request the specified tool. Only supported by Anthropic Claude 3
// and Amazon Nova models.
type ToolChoiceMemberTool struct {
	Value SpecificToolChoice

	noSmithyDocumentSerde
}

func (*ToolChoiceMemberTool) isToolChoice() {}

// Configuration information for the tools that you pass to a model. For more
// information, see [Tool use (function calling)]in the Amazon Bedrock User Guide.
//
// [Tool use (function calling)]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type ToolConfiguration struct {

	// An array of tools that you want to pass to a model.
	//
	// This member is required.
	Tools []Tool

	// If supported by model, forces the model to request a tool.
	ToolChoice ToolChoice

	noSmithyDocumentSerde
}

// The schema for the tool. The top level schema type must be object . For more
// information, see [Call a tool with the Converse API]in the Amazon Bedrock User Guide.
//
// The following types satisfy this interface:
//
//	ToolInputSchemaMemberJson
//
// [Call a tool with the Converse API]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type ToolInputSchema interface {
	isToolInputSchema()
}

// The JSON schema for the tool. For more information, see [JSON Schema Reference].
//
// [JSON Schema Reference]: https://json-schema.org/understanding-json-schema/reference
type ToolInputSchemaMemberJson struct {
	Value document.Interface

	noSmithyDocumentSerde
}

func (*ToolInputSchemaMemberJson) isToolInputSchema() {}

// A tool result block that contains the results for a tool request that the model
// previously made. For more information, see [Call a tool with the Converse API]in the Amazon Bedrock User Guide.
//
// [Call a tool with the Converse API]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type ToolResultBlock struct {

	// The content for tool result content block.
	//
	// This member is required.
	Content []ToolResultContentBlock

	// The ID of the tool request that this is the result for.
	//
	// This member is required.
	ToolUseId *string

	// The status for the tool result content block.
	//
	// This field is only supported by Amazon Nova and Anthropic Claude 3 and 4 models.
	Status ToolResultStatus

	// The type for the tool result content block.
	Type *string

	noSmithyDocumentSerde
}

// Contains incremental updates to tool results information during streaming
// responses. This allows clients to build up tool results data progressively as
// the response is generated.
//
// The following types satisfy this interface:
//
//	ToolResultBlockDeltaMemberJson
//	ToolResultBlockDeltaMemberText
type ToolResultBlockDelta interface {
	isToolResultBlockDelta()
}

// The JSON schema for the tool result content block. see [JSON Schema Reference].
//
// [JSON Schema Reference]: https://json-schema.org/understanding-json-schema/reference
type ToolResultBlockDeltaMemberJson struct {
	Value document.Interface

	noSmithyDocumentSerde
}

func (*ToolResultBlockDeltaMemberJson) isToolResultBlockDelta() {}

// The reasoning the model used to return the output.
type ToolResultBlockDeltaMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*ToolResultBlockDeltaMemberText) isToolResultBlockDelta() {}

// The start of a tool result block. For more information, see [Call a tool with the Converse API] in the Amazon
// Bedrock User Guide.
//
// [Call a tool with the Converse API]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type ToolResultBlockStart struct {

	// The ID of the tool that was used to generate this tool result block.
	//
	// This member is required.
	ToolUseId *string

	// The status of the tool result block.
	Status ToolResultStatus

	// The type for the tool that was used to generate this tool result block.
	Type *string

	noSmithyDocumentSerde
}

// The tool result content block. For more information, see [Call a tool with the Converse API] in the Amazon Bedrock
// User Guide.
//
// The following types satisfy this interface:
//
//	ToolResultContentBlockMemberDocument
//	ToolResultContentBlockMemberImage
//	ToolResultContentBlockMemberJson
//	ToolResultContentBlockMemberSearchResult
//	ToolResultContentBlockMemberText
//	ToolResultContentBlockMemberVideo
//
// [Call a tool with the Converse API]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type ToolResultContentBlock interface {
	isToolResultContentBlock()
}

// A tool result that is a document.
type ToolResultContentBlockMemberDocument struct {
	Value DocumentBlock

	noSmithyDocumentSerde
}

func (*ToolResultContentBlockMemberDocument) isToolResultContentBlock() {}

// A tool result that is an image.
//
// This field is only supported by Amazon Nova and Anthropic Claude 3 and 4 models.
type ToolResultContentBlockMemberImage struct {
	Value ImageBlock

	noSmithyDocumentSerde
}

func (*ToolResultContentBlockMemberImage) isToolResultContentBlock() {}

// A tool result that is JSON format data.
type ToolResultContentBlockMemberJson struct {
	Value document.Interface

	noSmithyDocumentSerde
}

func (*ToolResultContentBlockMemberJson) isToolResultContentBlock() {}

// A tool result that is a search result.
type ToolResultContentBlockMemberSearchResult struct {
	Value SearchResultBlock

	noSmithyDocumentSerde
}

func (*ToolResultContentBlockMemberSearchResult) isToolResultContentBlock() {}

// A tool result that is text.
type ToolResultContentBlockMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*ToolResultContentBlockMemberText) isToolResultContentBlock() {}

// A tool result that is video.
type ToolResultContentBlockMemberVideo struct {
	Value VideoBlock

	noSmithyDocumentSerde
}

func (*ToolResultContentBlockMemberVideo) isToolResultContentBlock() {}

// The specification for the tool. For more information, see [Call a tool with the Converse API] in the Amazon
// Bedrock User Guide.
//
// [Call a tool with the Converse API]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type ToolSpecification struct {

	// The input schema for the tool in JSON format.
	//
	// This member is required.
	InputSchema ToolInputSchema

	// The name for the tool.
	//
	// This member is required.
	Name *string

	// The description for the tool.
	Description *string

	noSmithyDocumentSerde
}

// A tool use content block. Contains information about a tool that the model is
// requesting be run., The model uses the result from the tool to generate a
// response. For more information, see [Call a tool with the Converse API]in the Amazon Bedrock User Guide.
//
// [Call a tool with the Converse API]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type ToolUseBlock struct {

	// The input to pass to the tool.
	//
	// This member is required.
	Input document.Interface

	// The name of the tool that the model wants to use.
	//
	// This member is required.
	Name *string

	// The ID for the tool request.
	//
	// This member is required.
	ToolUseId *string

	// The type for the tool request.
	Type ToolUseType

	noSmithyDocumentSerde
}

// The delta for a tool use block.
type ToolUseBlockDelta struct {

	// The input for a requested tool.
	//
	// This member is required.
	Input *string

	noSmithyDocumentSerde
}

// The start of a tool use block. For more information, see [Call a tool with the Converse API] in the Amazon Bedrock
// User Guide.
//
// [Call a tool with the Converse API]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type ToolUseBlockStart struct {

	// The name of the tool that the model is requesting to use.
	//
	// This member is required.
	Name *string

	// The ID for the tool request.
	//
	// This member is required.
	ToolUseId *string

	// The type for the tool request.
	Type ToolUseType

	noSmithyDocumentSerde
}

// A video block.
type VideoBlock struct {

	// The block's format.
	//
	// This member is required.
	Format VideoFormat

	// The block's source.
	//
	// This member is required.
	Source VideoSource

	noSmithyDocumentSerde
}

// A video source. You can upload a smaller video as a base64-encoded string as
// long as the encoded file is less than 25MB. You can also transfer videos up to
// 1GB in size from an S3 bucket.
//
// The following types satisfy this interface:
//
//	VideoSourceMemberBytes
//	VideoSourceMemberS3Location
type VideoSource interface {
	isVideoSource()
}

// Video content encoded in base64.
type VideoSourceMemberBytes struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*VideoSourceMemberBytes) isVideoSource() {}

// The location of a video object in an Amazon S3 bucket. To see which models
// support S3 uploads, see [Supported models and features for Converse].
//
// [Supported models and features for Converse]: https://docs.aws.amazon.com/bedrock/latest/userguide/conversation-inference-supported-models-features.html
type VideoSourceMemberS3Location struct {
	Value S3Location

	noSmithyDocumentSerde
}

func (*VideoSourceMemberS3Location) isVideoSource() {}

// Provides the URL and domain information for the website that was cited when
// performing a web search.
type WebLocation struct {

	// The domain that was cited when performing a web search.
	Domain *string

	// The URL that was cited when performing a web search.
	Url *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAsyncInvokeOutputDataConfig()        {}
func (*UnknownUnionMember) isAudioSource()                        {}
func (*UnknownUnionMember) isCitationGeneratedContent()           {}
func (*UnknownUnionMember) isCitationLocation()                   {}
func (*UnknownUnionMember) isCitationSourceContent()              {}
func (*UnknownUnionMember) isContentBlock()                       {}
func (*UnknownUnionMember) isContentBlockDelta()                  {}
func (*UnknownUnionMember) isContentBlockStart()                  {}
func (*UnknownUnionMember) isConverseOutput()                     {}
func (*UnknownUnionMember) isConverseStreamOutput()               {}
func (*UnknownUnionMember) isCountTokensInput()                   {}
func (*UnknownUnionMember) isDocumentContentBlock()               {}
func (*UnknownUnionMember) isDocumentSource()                     {}
func (*UnknownUnionMember) isGuardrailAutomatedReasoningFinding() {}
func (*UnknownUnionMember) isGuardrailContentBlock()              {}
func (*UnknownUnionMember) isGuardrailConverseContentBlock()      {}
func (*UnknownUnionMember) isGuardrailConverseImageSource()       {}
func (*UnknownUnionMember) isGuardrailImageSource()               {}
func (*UnknownUnionMember) isImageSource()                        {}
func (*UnknownUnionMember) isPromptVariableValues()               {}
func (*UnknownUnionMember) isReasoningContentBlock()              {}
func (*UnknownUnionMember) isReasoningContentBlockDelta()         {}
func (*UnknownUnionMember) isResponseStream()                     {}
func (*UnknownUnionMember) isSystemContentBlock()                 {}
func (*UnknownUnionMember) isTool()                               {}
func (*UnknownUnionMember) isToolChoice()                         {}
func (*UnknownUnionMember) isToolInputSchema()                    {}
func (*UnknownUnionMember) isToolResultBlockDelta()               {}
func (*UnknownUnionMember) isToolResultContentBlock()             {}
func (*UnknownUnionMember) isVideoSource()                        {}
