// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockruntime

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockruntime/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns the token count for a given inference request. This operation helps you
// estimate token usage before sending requests to foundation models by returning
// the token count that would be used if the same input were sent to the model in
// an inference request.
//
// Token counting is model-specific because different models use different
// tokenization strategies. The token count returned by this operation will match
// the token count that would be charged if the same input were sent to the model
// in an InvokeModel or Converse request.
//
// You can use this operation to:
//
//   - Estimate costs before sending inference requests.
//
//   - Optimize prompts to fit within token limits.
//
//   - Plan for token usage in your applications.
//
// This operation accepts the same input formats as InvokeModel and Converse ,
// allowing you to count tokens for both raw text inputs and structured
// conversation formats.
//
// The following operations are related to CountTokens :
//
// [InvokeModel]
//   - - Sends inference requests to foundation models
//
// [Converse]
//   - - Sends conversation-based inference requests to foundation models
//
// [Converse]: https://docs.aws.amazon.com/bedrock/latest/API/API_runtime_Converse.html
// [InvokeModel]: https://docs.aws.amazon.com/bedrock/latest/API/API_runtime_InvokeModel.html
func (c *Client) CountTokens(ctx context.Context, params *CountTokensInput, optFns ...func(*Options)) (*CountTokensOutput, error) {
	if params == nil {
		params = &CountTokensInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CountTokens", params, optFns, c.addOperationCountTokensMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CountTokensOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CountTokensInput struct {

	// The input for which to count tokens. The structure of this parameter depends on
	// whether you're counting tokens for an InvokeModel or Converse request:
	//
	//   - For InvokeModel requests, provide the request body in the invokeModel field
	//
	//   - For Converse requests, provide the messages and system content in the
	//   converse field
	//
	// The input format must be compatible with the model specified in the modelId
	// parameter.
	//
	// This member is required.
	Input types.CountTokensInput

	// The unique identifier or ARN of the foundation model to use for token counting.
	// Each model processes tokens differently, so the token count is specific to the
	// model you specify.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

type CountTokensOutput struct {

	// The number of tokens in the provided input according to the specified model's
	// tokenization rules. This count represents the number of input tokens that would
	// be processed if the same input were sent to the model in an inference request.
	// Use this value to estimate costs and ensure your inputs stay within model token
	// limits.
	//
	// This member is required.
	InputTokens *int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCountTokensMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCountTokens{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCountTokens{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CountTokens"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCountTokensValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCountTokens(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCountTokens(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CountTokens",
	}
}
