// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockdataautomationruntime

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockdataautomationruntime/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Async API: Invoke data automation.
func (c *Client) InvokeDataAutomationAsync(ctx context.Context, params *InvokeDataAutomationAsyncInput, optFns ...func(*Options)) (*InvokeDataAutomationAsyncOutput, error) {
	if params == nil {
		params = &InvokeDataAutomationAsyncInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "InvokeDataAutomationAsync", params, optFns, c.addOperationInvokeDataAutomationAsyncMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*InvokeDataAutomationAsyncOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Invoke Data Automation Async Request
type InvokeDataAutomationAsyncInput struct {

	// Data automation profile ARN
	//
	// This member is required.
	DataAutomationProfileArn *string

	// Input configuration.
	//
	// This member is required.
	InputConfiguration *types.InputConfiguration

	// Output configuration.
	//
	// This member is required.
	OutputConfiguration *types.OutputConfiguration

	// Blueprint list.
	Blueprints []types.Blueprint

	// Idempotency token.
	ClientToken *string

	// Data automation configuration.
	DataAutomationConfiguration *types.DataAutomationConfiguration

	// Encryption configuration.
	EncryptionConfiguration *types.EncryptionConfiguration

	// Notification configuration.
	NotificationConfiguration *types.NotificationConfiguration

	// List of tags.
	Tags []types.Tag

	noSmithyDocumentSerde
}

// Invoke Data Automation Async Response
type InvokeDataAutomationAsyncOutput struct {

	// ARN of the automation job
	//
	// This member is required.
	InvocationArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationInvokeDataAutomationAsyncMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpInvokeDataAutomationAsync{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpInvokeDataAutomationAsync{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "InvokeDataAutomationAsync"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opInvokeDataAutomationAsyncMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpInvokeDataAutomationAsyncValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opInvokeDataAutomationAsync(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpInvokeDataAutomationAsync struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpInvokeDataAutomationAsync) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpInvokeDataAutomationAsync) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*InvokeDataAutomationAsyncInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *InvokeDataAutomationAsyncInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opInvokeDataAutomationAsyncMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpInvokeDataAutomationAsync{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opInvokeDataAutomationAsync(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "InvokeDataAutomationAsync",
	}
}
