// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockdataautomation

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/bedrockdataautomation/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpCreateBlueprint struct {
}

func (*awsRestjson1_serializeOpCreateBlueprint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateBlueprint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBlueprintInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/blueprints/")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateBlueprintInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateBlueprintInput(v *CreateBlueprintInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateBlueprintInput(v *CreateBlueprintInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlueprintName != nil {
		ok := object.Key("blueprintName")
		ok.String(*v.BlueprintName)
	}

	if len(v.BlueprintStage) > 0 {
		ok := object.Key("blueprintStage")
		ok.String(string(v.BlueprintStage))
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.EncryptionConfiguration != nil {
		ok := object.Key("encryptionConfiguration")
		if err := awsRestjson1_serializeDocumentEncryptionConfiguration(v.EncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Schema != nil {
		ok := object.Key("schema")
		ok.String(*v.Schema)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpCreateBlueprintVersion struct {
}

func (*awsRestjson1_serializeOpCreateBlueprintVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateBlueprintVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBlueprintVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/blueprints/{blueprintArn}/versions/")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateBlueprintVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateBlueprintVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateBlueprintVersionInput(v *CreateBlueprintVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BlueprintArn == nil || len(*v.BlueprintArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member blueprintArn must not be empty")}
	}
	if v.BlueprintArn != nil {
		if err := encoder.SetURI("blueprintArn").String(*v.BlueprintArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateBlueprintVersionInput(v *CreateBlueprintVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	return nil
}

type awsRestjson1_serializeOpCreateDataAutomationProject struct {
}

func (*awsRestjson1_serializeOpCreateDataAutomationProject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDataAutomationProject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDataAutomationProjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/data-automation-projects/")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDataAutomationProjectInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDataAutomationProjectInput(v *CreateDataAutomationProjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDataAutomationProjectInput(v *CreateDataAutomationProjectInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.CustomOutputConfiguration != nil {
		ok := object.Key("customOutputConfiguration")
		if err := awsRestjson1_serializeDocumentCustomOutputConfiguration(v.CustomOutputConfiguration, ok); err != nil {
			return err
		}
	}

	if v.EncryptionConfiguration != nil {
		ok := object.Key("encryptionConfiguration")
		if err := awsRestjson1_serializeDocumentEncryptionConfiguration(v.EncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.OverrideConfiguration != nil {
		ok := object.Key("overrideConfiguration")
		if err := awsRestjson1_serializeDocumentOverrideConfiguration(v.OverrideConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ProjectDescription != nil {
		ok := object.Key("projectDescription")
		ok.String(*v.ProjectDescription)
	}

	if v.ProjectName != nil {
		ok := object.Key("projectName")
		ok.String(*v.ProjectName)
	}

	if len(v.ProjectStage) > 0 {
		ok := object.Key("projectStage")
		ok.String(string(v.ProjectStage))
	}

	if len(v.ProjectType) > 0 {
		ok := object.Key("projectType")
		ok.String(string(v.ProjectType))
	}

	if v.StandardOutputConfiguration != nil {
		ok := object.Key("standardOutputConfiguration")
		if err := awsRestjson1_serializeDocumentStandardOutputConfiguration(v.StandardOutputConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBlueprint struct {
}

func (*awsRestjson1_serializeOpDeleteBlueprint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBlueprint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBlueprintInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/blueprints/{blueprintArn}/")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBlueprintInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBlueprintInput(v *DeleteBlueprintInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BlueprintArn == nil || len(*v.BlueprintArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member blueprintArn must not be empty")}
	}
	if v.BlueprintArn != nil {
		if err := encoder.SetURI("blueprintArn").String(*v.BlueprintArn); err != nil {
			return err
		}
	}

	if v.BlueprintVersion != nil {
		encoder.SetQuery("blueprintVersion").String(*v.BlueprintVersion)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDataAutomationProject struct {
}

func (*awsRestjson1_serializeOpDeleteDataAutomationProject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDataAutomationProject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDataAutomationProjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/data-automation-projects/{projectArn}/")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDataAutomationProjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDataAutomationProjectInput(v *DeleteDataAutomationProjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ProjectArn == nil || len(*v.ProjectArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member projectArn must not be empty")}
	}
	if v.ProjectArn != nil {
		if err := encoder.SetURI("projectArn").String(*v.ProjectArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetBlueprint struct {
}

func (*awsRestjson1_serializeOpGetBlueprint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetBlueprint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBlueprintInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/blueprints/{blueprintArn}/")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetBlueprintInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetBlueprintInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetBlueprintInput(v *GetBlueprintInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BlueprintArn == nil || len(*v.BlueprintArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member blueprintArn must not be empty")}
	}
	if v.BlueprintArn != nil {
		if err := encoder.SetURI("blueprintArn").String(*v.BlueprintArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetBlueprintInput(v *GetBlueprintInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.BlueprintStage) > 0 {
		ok := object.Key("blueprintStage")
		ok.String(string(v.BlueprintStage))
	}

	if v.BlueprintVersion != nil {
		ok := object.Key("blueprintVersion")
		ok.String(*v.BlueprintVersion)
	}

	return nil
}

type awsRestjson1_serializeOpGetDataAutomationProject struct {
}

func (*awsRestjson1_serializeOpGetDataAutomationProject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDataAutomationProject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDataAutomationProjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/data-automation-projects/{projectArn}/")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDataAutomationProjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetDataAutomationProjectInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDataAutomationProjectInput(v *GetDataAutomationProjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ProjectArn == nil || len(*v.ProjectArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member projectArn must not be empty")}
	}
	if v.ProjectArn != nil {
		if err := encoder.SetURI("projectArn").String(*v.ProjectArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetDataAutomationProjectInput(v *GetDataAutomationProjectInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ProjectStage) > 0 {
		ok := object.Key("projectStage")
		ok.String(string(v.ProjectStage))
	}

	return nil
}

type awsRestjson1_serializeOpListBlueprints struct {
}

func (*awsRestjson1_serializeOpListBlueprints) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBlueprints) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBlueprintsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/blueprints/")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListBlueprintsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBlueprintsInput(v *ListBlueprintsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListBlueprintsInput(v *ListBlueprintsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlueprintArn != nil {
		ok := object.Key("blueprintArn")
		ok.String(*v.BlueprintArn)
	}

	if len(v.BlueprintStageFilter) > 0 {
		ok := object.Key("blueprintStageFilter")
		ok.String(string(v.BlueprintStageFilter))
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.ProjectFilter != nil {
		ok := object.Key("projectFilter")
		if err := awsRestjson1_serializeDocumentDataAutomationProjectFilter(v.ProjectFilter, ok); err != nil {
			return err
		}
	}

	if len(v.ResourceOwner) > 0 {
		ok := object.Key("resourceOwner")
		ok.String(string(v.ResourceOwner))
	}

	return nil
}

type awsRestjson1_serializeOpListDataAutomationProjects struct {
}

func (*awsRestjson1_serializeOpListDataAutomationProjects) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDataAutomationProjects) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDataAutomationProjectsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/data-automation-projects/")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListDataAutomationProjectsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDataAutomationProjectsInput(v *ListDataAutomationProjectsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListDataAutomationProjectsInput(v *ListDataAutomationProjectsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlueprintFilter != nil {
		ok := object.Key("blueprintFilter")
		if err := awsRestjson1_serializeDocumentBlueprintFilter(v.BlueprintFilter, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if len(v.ProjectStageFilter) > 0 {
		ok := object.Key("projectStageFilter")
		ok.String(string(v.ProjectStageFilter))
	}

	if len(v.ResourceOwner) > 0 {
		ok := object.Key("resourceOwner")
		ok.String(string(v.ResourceOwner))
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/listTagsForResource")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListTagsForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("resourceARN")
		ok.String(*v.ResourceARN)
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tagResource")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("resourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/untagResource")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("resourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.TagKeys != nil {
		ok := object.Key("tagKeys")
		if err := awsRestjson1_serializeDocumentTagKeyList(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBlueprint struct {
}

func (*awsRestjson1_serializeOpUpdateBlueprint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBlueprint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBlueprintInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/blueprints/{blueprintArn}/")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBlueprintInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBlueprintInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBlueprintInput(v *UpdateBlueprintInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BlueprintArn == nil || len(*v.BlueprintArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member blueprintArn must not be empty")}
	}
	if v.BlueprintArn != nil {
		if err := encoder.SetURI("blueprintArn").String(*v.BlueprintArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBlueprintInput(v *UpdateBlueprintInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.BlueprintStage) > 0 {
		ok := object.Key("blueprintStage")
		ok.String(string(v.BlueprintStage))
	}

	if v.EncryptionConfiguration != nil {
		ok := object.Key("encryptionConfiguration")
		if err := awsRestjson1_serializeDocumentEncryptionConfiguration(v.EncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Schema != nil {
		ok := object.Key("schema")
		ok.String(*v.Schema)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDataAutomationProject struct {
}

func (*awsRestjson1_serializeOpUpdateDataAutomationProject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDataAutomationProject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDataAutomationProjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/data-automation-projects/{projectArn}/")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDataAutomationProjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDataAutomationProjectInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDataAutomationProjectInput(v *UpdateDataAutomationProjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ProjectArn == nil || len(*v.ProjectArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member projectArn must not be empty")}
	}
	if v.ProjectArn != nil {
		if err := encoder.SetURI("projectArn").String(*v.ProjectArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDataAutomationProjectInput(v *UpdateDataAutomationProjectInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomOutputConfiguration != nil {
		ok := object.Key("customOutputConfiguration")
		if err := awsRestjson1_serializeDocumentCustomOutputConfiguration(v.CustomOutputConfiguration, ok); err != nil {
			return err
		}
	}

	if v.EncryptionConfiguration != nil {
		ok := object.Key("encryptionConfiguration")
		if err := awsRestjson1_serializeDocumentEncryptionConfiguration(v.EncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.OverrideConfiguration != nil {
		ok := object.Key("overrideConfiguration")
		if err := awsRestjson1_serializeDocumentOverrideConfiguration(v.OverrideConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ProjectDescription != nil {
		ok := object.Key("projectDescription")
		ok.String(*v.ProjectDescription)
	}

	if len(v.ProjectStage) > 0 {
		ok := object.Key("projectStage")
		ok.String(string(v.ProjectStage))
	}

	if v.StandardOutputConfiguration != nil {
		ok := object.Key("standardOutputConfiguration")
		if err := awsRestjson1_serializeDocumentStandardOutputConfiguration(v.StandardOutputConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioExtractionCategory(v *types.AudioExtractionCategory, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	if v.TypeConfiguration != nil {
		ok := object.Key("typeConfiguration")
		if err := awsRestjson1_serializeDocumentAudioExtractionCategoryTypeConfiguration(v.TypeConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Types != nil {
		ok := object.Key("types")
		if err := awsRestjson1_serializeDocumentAudioExtractionCategoryTypes(v.Types, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioExtractionCategoryTypeConfiguration(v *types.AudioExtractionCategoryTypeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Transcript != nil {
		ok := object.Key("transcript")
		if err := awsRestjson1_serializeDocumentTranscriptConfiguration(v.Transcript, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioExtractionCategoryTypes(v []types.AudioExtractionCategoryType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentAudioInputLanguages(v []types.Language, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentAudioLanguageConfiguration(v *types.AudioLanguageConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.GenerativeOutputLanguage) > 0 {
		ok := object.Key("generativeOutputLanguage")
		ok.String(string(v.GenerativeOutputLanguage))
	}

	if v.IdentifyMultipleLanguages != nil {
		ok := object.Key("identifyMultipleLanguages")
		ok.Boolean(*v.IdentifyMultipleLanguages)
	}

	if v.InputLanguages != nil {
		ok := object.Key("inputLanguages")
		if err := awsRestjson1_serializeDocumentAudioInputLanguages(v.InputLanguages, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioOverrideConfiguration(v *types.AudioOverrideConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LanguageConfiguration != nil {
		ok := object.Key("languageConfiguration")
		if err := awsRestjson1_serializeDocumentAudioLanguageConfiguration(v.LanguageConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ModalityProcessing != nil {
		ok := object.Key("modalityProcessing")
		if err := awsRestjson1_serializeDocumentModalityProcessingConfiguration(v.ModalityProcessing, ok); err != nil {
			return err
		}
	}

	if v.SensitiveDataConfiguration != nil {
		ok := object.Key("sensitiveDataConfiguration")
		if err := awsRestjson1_serializeDocumentSensitiveDataConfiguration(v.SensitiveDataConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioStandardExtraction(v *types.AudioStandardExtraction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Category != nil {
		ok := object.Key("category")
		if err := awsRestjson1_serializeDocumentAudioExtractionCategory(v.Category, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioStandardGenerativeField(v *types.AudioStandardGenerativeField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	if v.Types != nil {
		ok := object.Key("types")
		if err := awsRestjson1_serializeDocumentAudioStandardGenerativeFieldTypes(v.Types, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioStandardGenerativeFieldTypes(v []types.AudioStandardGenerativeFieldType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentAudioStandardOutputConfiguration(v *types.AudioStandardOutputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Extraction != nil {
		ok := object.Key("extraction")
		if err := awsRestjson1_serializeDocumentAudioStandardExtraction(v.Extraction, ok); err != nil {
			return err
		}
	}

	if v.GenerativeField != nil {
		ok := object.Key("generativeField")
		if err := awsRestjson1_serializeDocumentAudioStandardGenerativeField(v.GenerativeField, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBlueprintFilter(v *types.BlueprintFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlueprintArn != nil {
		ok := object.Key("blueprintArn")
		ok.String(*v.BlueprintArn)
	}

	if len(v.BlueprintStage) > 0 {
		ok := object.Key("blueprintStage")
		ok.String(string(v.BlueprintStage))
	}

	if v.BlueprintVersion != nil {
		ok := object.Key("blueprintVersion")
		ok.String(*v.BlueprintVersion)
	}

	return nil
}

func awsRestjson1_serializeDocumentBlueprintItem(v *types.BlueprintItem, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlueprintArn != nil {
		ok := object.Key("blueprintArn")
		ok.String(*v.BlueprintArn)
	}

	if len(v.BlueprintStage) > 0 {
		ok := object.Key("blueprintStage")
		ok.String(string(v.BlueprintStage))
	}

	if v.BlueprintVersion != nil {
		ok := object.Key("blueprintVersion")
		ok.String(*v.BlueprintVersion)
	}

	return nil
}

func awsRestjson1_serializeDocumentBlueprintItems(v []types.BlueprintItem, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentBlueprintItem(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentChannelLabelingConfiguration(v *types.ChannelLabelingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomOutputConfiguration(v *types.CustomOutputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Blueprints != nil {
		ok := object.Key("blueprints")
		if err := awsRestjson1_serializeDocumentBlueprintItems(v.Blueprints, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDataAutomationProjectFilter(v *types.DataAutomationProjectFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ProjectArn != nil {
		ok := object.Key("projectArn")
		ok.String(*v.ProjectArn)
	}

	if len(v.ProjectStage) > 0 {
		ok := object.Key("projectStage")
		ok.String(string(v.ProjectStage))
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentBoundingBox(v *types.DocumentBoundingBox, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentExtractionGranularity(v *types.DocumentExtractionGranularity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Types != nil {
		ok := object.Key("types")
		if err := awsRestjson1_serializeDocumentDocumentExtractionGranularityTypes(v.Types, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentExtractionGranularityTypes(v []types.DocumentExtractionGranularityType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentDocumentOutputAdditionalFileFormat(v *types.DocumentOutputAdditionalFileFormat, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentOutputFormat(v *types.DocumentOutputFormat, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalFileFormat != nil {
		ok := object.Key("additionalFileFormat")
		if err := awsRestjson1_serializeDocumentDocumentOutputAdditionalFileFormat(v.AdditionalFileFormat, ok); err != nil {
			return err
		}
	}

	if v.TextFormat != nil {
		ok := object.Key("textFormat")
		if err := awsRestjson1_serializeDocumentDocumentOutputTextFormat(v.TextFormat, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentOutputTextFormat(v *types.DocumentOutputTextFormat, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Types != nil {
		ok := object.Key("types")
		if err := awsRestjson1_serializeDocumentDocumentOutputTextFormatTypes(v.Types, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentOutputTextFormatTypes(v []types.DocumentOutputTextFormatType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentDocumentOverrideConfiguration(v *types.DocumentOverrideConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ModalityProcessing != nil {
		ok := object.Key("modalityProcessing")
		if err := awsRestjson1_serializeDocumentModalityProcessingConfiguration(v.ModalityProcessing, ok); err != nil {
			return err
		}
	}

	if v.SensitiveDataConfiguration != nil {
		ok := object.Key("sensitiveDataConfiguration")
		if err := awsRestjson1_serializeDocumentSensitiveDataConfiguration(v.SensitiveDataConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Splitter != nil {
		ok := object.Key("splitter")
		if err := awsRestjson1_serializeDocumentSplitterConfiguration(v.Splitter, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentStandardExtraction(v *types.DocumentStandardExtraction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BoundingBox != nil {
		ok := object.Key("boundingBox")
		if err := awsRestjson1_serializeDocumentDocumentBoundingBox(v.BoundingBox, ok); err != nil {
			return err
		}
	}

	if v.Granularity != nil {
		ok := object.Key("granularity")
		if err := awsRestjson1_serializeDocumentDocumentExtractionGranularity(v.Granularity, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentStandardGenerativeField(v *types.DocumentStandardGenerativeField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentStandardOutputConfiguration(v *types.DocumentStandardOutputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Extraction != nil {
		ok := object.Key("extraction")
		if err := awsRestjson1_serializeDocumentDocumentStandardExtraction(v.Extraction, ok); err != nil {
			return err
		}
	}

	if v.GenerativeField != nil {
		ok := object.Key("generativeField")
		if err := awsRestjson1_serializeDocumentDocumentStandardGenerativeField(v.GenerativeField, ok); err != nil {
			return err
		}
	}

	if v.OutputFormat != nil {
		ok := object.Key("outputFormat")
		if err := awsRestjson1_serializeDocumentDocumentOutputFormat(v.OutputFormat, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEncryptionConfiguration(v *types.EncryptionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KmsEncryptionContext != nil {
		ok := object.Key("kmsEncryptionContext")
		if err := awsRestjson1_serializeDocumentKmsEncryptionContext(v.KmsEncryptionContext, ok); err != nil {
			return err
		}
	}

	if v.KmsKeyId != nil {
		ok := object.Key("kmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	return nil
}

func awsRestjson1_serializeDocumentImageBoundingBox(v *types.ImageBoundingBox, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	return nil
}

func awsRestjson1_serializeDocumentImageExtractionCategory(v *types.ImageExtractionCategory, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	if v.Types != nil {
		ok := object.Key("types")
		if err := awsRestjson1_serializeDocumentImageExtractionCategoryTypes(v.Types, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentImageExtractionCategoryTypes(v []types.ImageExtractionCategoryType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentImageOverrideConfiguration(v *types.ImageOverrideConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ModalityProcessing != nil {
		ok := object.Key("modalityProcessing")
		if err := awsRestjson1_serializeDocumentModalityProcessingConfiguration(v.ModalityProcessing, ok); err != nil {
			return err
		}
	}

	if v.SensitiveDataConfiguration != nil {
		ok := object.Key("sensitiveDataConfiguration")
		if err := awsRestjson1_serializeDocumentSensitiveDataConfiguration(v.SensitiveDataConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentImageStandardExtraction(v *types.ImageStandardExtraction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BoundingBox != nil {
		ok := object.Key("boundingBox")
		if err := awsRestjson1_serializeDocumentImageBoundingBox(v.BoundingBox, ok); err != nil {
			return err
		}
	}

	if v.Category != nil {
		ok := object.Key("category")
		if err := awsRestjson1_serializeDocumentImageExtractionCategory(v.Category, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentImageStandardGenerativeField(v *types.ImageStandardGenerativeField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	if v.Types != nil {
		ok := object.Key("types")
		if err := awsRestjson1_serializeDocumentImageStandardGenerativeFieldTypes(v.Types, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentImageStandardGenerativeFieldTypes(v []types.ImageStandardGenerativeFieldType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentImageStandardOutputConfiguration(v *types.ImageStandardOutputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Extraction != nil {
		ok := object.Key("extraction")
		if err := awsRestjson1_serializeDocumentImageStandardExtraction(v.Extraction, ok); err != nil {
			return err
		}
	}

	if v.GenerativeField != nil {
		ok := object.Key("generativeField")
		if err := awsRestjson1_serializeDocumentImageStandardGenerativeField(v.GenerativeField, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentKmsEncryptionContext(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentModalityProcessingConfiguration(v *types.ModalityProcessingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	return nil
}

func awsRestjson1_serializeDocumentModalityRoutingConfiguration(v *types.ModalityRoutingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Jpeg) > 0 {
		ok := object.Key("jpeg")
		ok.String(string(v.Jpeg))
	}

	if len(v.Mov) > 0 {
		ok := object.Key("mov")
		ok.String(string(v.Mov))
	}

	if len(v.Mp4) > 0 {
		ok := object.Key("mp4")
		ok.String(string(v.Mp4))
	}

	if len(v.Png) > 0 {
		ok := object.Key("png")
		ok.String(string(v.Png))
	}

	return nil
}

func awsRestjson1_serializeDocumentOverrideConfiguration(v *types.OverrideConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Audio != nil {
		ok := object.Key("audio")
		if err := awsRestjson1_serializeDocumentAudioOverrideConfiguration(v.Audio, ok); err != nil {
			return err
		}
	}

	if v.Document != nil {
		ok := object.Key("document")
		if err := awsRestjson1_serializeDocumentDocumentOverrideConfiguration(v.Document, ok); err != nil {
			return err
		}
	}

	if v.Image != nil {
		ok := object.Key("image")
		if err := awsRestjson1_serializeDocumentImageOverrideConfiguration(v.Image, ok); err != nil {
			return err
		}
	}

	if v.ModalityRouting != nil {
		ok := object.Key("modalityRouting")
		if err := awsRestjson1_serializeDocumentModalityRoutingConfiguration(v.ModalityRouting, ok); err != nil {
			return err
		}
	}

	if v.Video != nil {
		ok := object.Key("video")
		if err := awsRestjson1_serializeDocumentVideoOverrideConfiguration(v.Video, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPIIEntitiesConfiguration(v *types.PIIEntitiesConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PiiEntityTypes != nil {
		ok := object.Key("piiEntityTypes")
		if err := awsRestjson1_serializeDocumentPIIEntityTypes(v.PiiEntityTypes, ok); err != nil {
			return err
		}
	}

	if len(v.RedactionMaskMode) > 0 {
		ok := object.Key("redactionMaskMode")
		ok.String(string(v.RedactionMaskMode))
	}

	return nil
}

func awsRestjson1_serializeDocumentPIIEntityTypes(v []types.PIIEntityType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentSensitiveDataConfiguration(v *types.SensitiveDataConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DetectionMode) > 0 {
		ok := object.Key("detectionMode")
		ok.String(string(v.DetectionMode))
	}

	if v.DetectionScope != nil {
		ok := object.Key("detectionScope")
		if err := awsRestjson1_serializeDocumentSensitiveDataDetectionScope(v.DetectionScope, ok); err != nil {
			return err
		}
	}

	if v.PiiEntitiesConfiguration != nil {
		ok := object.Key("piiEntitiesConfiguration")
		if err := awsRestjson1_serializeDocumentPIIEntitiesConfiguration(v.PiiEntitiesConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSensitiveDataDetectionScope(v []types.SensitiveDataDetectionScopeType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentSpeakerLabelingConfiguration(v *types.SpeakerLabelingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	return nil
}

func awsRestjson1_serializeDocumentSplitterConfiguration(v *types.SplitterConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	return nil
}

func awsRestjson1_serializeDocumentStandardOutputConfiguration(v *types.StandardOutputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Audio != nil {
		ok := object.Key("audio")
		if err := awsRestjson1_serializeDocumentAudioStandardOutputConfiguration(v.Audio, ok); err != nil {
			return err
		}
	}

	if v.Document != nil {
		ok := object.Key("document")
		if err := awsRestjson1_serializeDocumentDocumentStandardOutputConfiguration(v.Document, ok); err != nil {
			return err
		}
	}

	if v.Image != nil {
		ok := object.Key("image")
		if err := awsRestjson1_serializeDocumentImageStandardOutputConfiguration(v.Image, ok); err != nil {
			return err
		}
	}

	if v.Video != nil {
		ok := object.Key("video")
		if err := awsRestjson1_serializeDocumentVideoStandardOutputConfiguration(v.Video, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentTagKeyList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTranscriptConfiguration(v *types.TranscriptConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelLabeling != nil {
		ok := object.Key("channelLabeling")
		if err := awsRestjson1_serializeDocumentChannelLabelingConfiguration(v.ChannelLabeling, ok); err != nil {
			return err
		}
	}

	if v.SpeakerLabeling != nil {
		ok := object.Key("speakerLabeling")
		if err := awsRestjson1_serializeDocumentSpeakerLabelingConfiguration(v.SpeakerLabeling, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoBoundingBox(v *types.VideoBoundingBox, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoExtractionCategory(v *types.VideoExtractionCategory, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	if v.Types != nil {
		ok := object.Key("types")
		if err := awsRestjson1_serializeDocumentVideoExtractionCategoryTypes(v.Types, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoExtractionCategoryTypes(v []types.VideoExtractionCategoryType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentVideoOverrideConfiguration(v *types.VideoOverrideConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ModalityProcessing != nil {
		ok := object.Key("modalityProcessing")
		if err := awsRestjson1_serializeDocumentModalityProcessingConfiguration(v.ModalityProcessing, ok); err != nil {
			return err
		}
	}

	if v.SensitiveDataConfiguration != nil {
		ok := object.Key("sensitiveDataConfiguration")
		if err := awsRestjson1_serializeDocumentSensitiveDataConfiguration(v.SensitiveDataConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoStandardExtraction(v *types.VideoStandardExtraction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BoundingBox != nil {
		ok := object.Key("boundingBox")
		if err := awsRestjson1_serializeDocumentVideoBoundingBox(v.BoundingBox, ok); err != nil {
			return err
		}
	}

	if v.Category != nil {
		ok := object.Key("category")
		if err := awsRestjson1_serializeDocumentVideoExtractionCategory(v.Category, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoStandardGenerativeField(v *types.VideoStandardGenerativeField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	if v.Types != nil {
		ok := object.Key("types")
		if err := awsRestjson1_serializeDocumentVideoStandardGenerativeFieldTypes(v.Types, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoStandardGenerativeFieldTypes(v []types.VideoStandardGenerativeFieldType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentVideoStandardOutputConfiguration(v *types.VideoStandardOutputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Extraction != nil {
		ok := object.Key("extraction")
		if err := awsRestjson1_serializeDocumentVideoStandardExtraction(v.Extraction, ok); err != nil {
			return err
		}
	}

	if v.GenerativeField != nil {
		ok := object.Key("generativeField")
		if err := awsRestjson1_serializeDocumentVideoStandardGenerativeField(v.GenerativeField, ok); err != nil {
			return err
		}
	}

	return nil
}
