// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockdataautomation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockdataautomation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all existing Amazon Bedrock Data Automation Projects
func (c *Client) ListDataAutomationProjects(ctx context.Context, params *ListDataAutomationProjectsInput, optFns ...func(*Options)) (*ListDataAutomationProjectsOutput, error) {
	if params == nil {
		params = &ListDataAutomationProjectsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDataAutomationProjects", params, optFns, c.addOperationListDataAutomationProjectsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDataAutomationProjectsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// List DataAutomationProject Request
type ListDataAutomationProjectsInput struct {

	// Blueprint Filter
	BlueprintFilter *types.BlueprintFilter

	// Max Results
	MaxResults *int32

	// Pagination token
	NextToken *string

	// Project Stage filter
	ProjectStageFilter types.DataAutomationProjectStageFilter

	// Resource Owner
	ResourceOwner types.ResourceOwner

	noSmithyDocumentSerde
}

// List DataAutomationProject Response
type ListDataAutomationProjectsOutput struct {

	// List of DataAutomationProjectSummary
	//
	// This member is required.
	Projects []types.DataAutomationProjectSummary

	// Pagination token
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDataAutomationProjectsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDataAutomationProjects{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDataAutomationProjects{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDataAutomationProjects"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListDataAutomationProjectsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDataAutomationProjects(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDataAutomationProjectsPaginatorOptions is the paginator options for
// ListDataAutomationProjects
type ListDataAutomationProjectsPaginatorOptions struct {
	// Max Results
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDataAutomationProjectsPaginator is a paginator for
// ListDataAutomationProjects
type ListDataAutomationProjectsPaginator struct {
	options   ListDataAutomationProjectsPaginatorOptions
	client    ListDataAutomationProjectsAPIClient
	params    *ListDataAutomationProjectsInput
	nextToken *string
	firstPage bool
}

// NewListDataAutomationProjectsPaginator returns a new
// ListDataAutomationProjectsPaginator
func NewListDataAutomationProjectsPaginator(client ListDataAutomationProjectsAPIClient, params *ListDataAutomationProjectsInput, optFns ...func(*ListDataAutomationProjectsPaginatorOptions)) *ListDataAutomationProjectsPaginator {
	if params == nil {
		params = &ListDataAutomationProjectsInput{}
	}

	options := ListDataAutomationProjectsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDataAutomationProjectsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDataAutomationProjectsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDataAutomationProjects page.
func (p *ListDataAutomationProjectsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDataAutomationProjectsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDataAutomationProjects(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDataAutomationProjectsAPIClient is a client that implements the
// ListDataAutomationProjects operation.
type ListDataAutomationProjectsAPIClient interface {
	ListDataAutomationProjects(context.Context, *ListDataAutomationProjectsInput, ...func(*Options)) (*ListDataAutomationProjectsOutput, error)
}

var _ ListDataAutomationProjectsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDataAutomationProjects(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDataAutomationProjects",
	}
}
