// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime/document"
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

//	Contains details about the Lambda function containing the business logic that
//
// is carried out upon invoking the action or the custom control method for
// handling the information elicited from the user.
//
// The following types satisfy this interface:
//
//	ActionGroupExecutorMemberCustomControl
//	ActionGroupExecutorMemberLambda
type ActionGroupExecutor interface {
	isActionGroupExecutor()
}

//	To return the action group invocation results directly in the InvokeInlineAgent
//
// response, specify RETURN_CONTROL .
type ActionGroupExecutorMemberCustomControl struct {
	Value CustomControlMethod

	noSmithyDocumentSerde
}

func (*ActionGroupExecutorMemberCustomControl) isActionGroupExecutor() {}

//	The Amazon Resource Name (ARN) of the Lambda function containing the business
//
// logic that is carried out upon invoking the action.
type ActionGroupExecutorMemberLambda struct {
	Value string

	noSmithyDocumentSerde
}

func (*ActionGroupExecutorMemberLambda) isActionGroupExecutor() {}

// Contains information about the action group being invoked. For more information
// about the possible structures, see the InvocationInput tab in [OrchestrationTrace]in the [Amazon Bedrock User Guide].
//
// [OrchestrationTrace]: https://docs.aws.amazon.com/bedrock/latest/userguide/trace-orchestration.html
// [Amazon Bedrock User Guide]: https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html
type ActionGroupInvocationInput struct {

	// The name of the action group.
	ActionGroupName *string

	// The path to the API to call, based off the action group.
	ApiPath *string

	// How fulfillment of the action is handled. For more information, see [Handling fulfillment of the action].
	//
	// [Handling fulfillment of the action]: https://docs.aws.amazon.com/bedrock/latest/userguide/action-handle.html
	ExecutionType ExecutionType

	// The function in the action group to call.
	Function *string

	// The unique identifier of the invocation. Only returned if the executionType is
	// RETURN_CONTROL .
	InvocationId *string

	// The parameters in the Lambda input event.
	Parameters []Parameter

	// The parameters in the request body for the Lambda input event.
	RequestBody *RequestBody

	// The API method being used, based off the action group.
	Verb *string

	noSmithyDocumentSerde
}

// Contains the JSON-formatted string returned by the API invoked by the action
// group.
type ActionGroupInvocationOutput struct {

	// Contains information about the action group output.
	Metadata *Metadata

	// The JSON-formatted string returned by the API invoked by the action group.
	Text *string

	noSmithyDocumentSerde
}

// Contains details of the inline agent's action group.
type AgentActionGroup struct {

	//  The name of the action group.
	//
	// This member is required.
	ActionGroupName *string

	//  The Amazon Resource Name (ARN) of the Lambda function containing the business
	// logic that is carried out upon invoking the action or the custom control method
	// for handling the information elicited from the user.
	ActionGroupExecutor ActionGroupExecutor

	//  Contains either details about the S3 object containing the OpenAPI schema for
	// the action group or the JSON or YAML-formatted payload defining the schema. For
	// more information, see [Action group OpenAPI schemas].
	//
	// [Action group OpenAPI schemas]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html
	ApiSchema APISchema

	//  A description of the action group.
	Description *string

	//  Contains details about the function schema for the action group or the JSON or
	// YAML-formatted payload defining the schema.
	FunctionSchema FunctionSchema

	// Specify a built-in or computer use action for this action group. If you specify
	// a value, you must leave the description , apiSchema , and actionGroupExecutor
	// fields empty for this action group.
	//
	//   - To allow your agent to request the user for additional information when
	//   trying to complete a task, set this field to AMAZON.UserInput .
	//
	//   - To allow your agent to generate, run, and troubleshoot code when trying to
	//   complete a task, set this field to AMAZON.CodeInterpreter .
	//
	//   - To allow your agent to use an Anthropic computer use tool, specify one of
	//   the following values.
	//
	// Computer use is a new Anthropic Claude model capability (in beta) available
	//   with Anthropic Claude 3.7 Sonnet and Claude 3.5 Sonnet v2 only. When operating
	//   computer use functionality, we recommend taking additional security precautions,
	//   such as executing computer actions in virtual environments with restricted data
	//   access and limited internet connectivity. For more information, see [Configure an Amazon Bedrock Agent to complete tasks with computer use tools].
	//
	//   - ANTHROPIC.Computer - Gives the agent permission to use the mouse and
	//   keyboard and take screenshots.
	//
	//   - ANTHROPIC.TextEditor - Gives the agent permission to view, create and edit
	//   files.
	//
	//   - ANTHROPIC.Bash - Gives the agent permission to run commands in a bash shell.
	//
	// [Configure an Amazon Bedrock Agent to complete tasks with computer use tools]: https://docs.aws.amazon.com/bedrock/latest/userguide/agent-computer-use.html
	ParentActionGroupSignature ActionGroupSignature

	//  The configuration settings for a computer use action.
	//
	// Computer use is a new Anthropic Claude model capability (in beta) available
	// with Claude 3.7 Sonnet and Claude 3.5 Sonnet v2 only. For more information, see [Configure an Amazon Bedrock Agent to complete tasks with computer use tools]
	// .
	//
	// [Configure an Amazon Bedrock Agent to complete tasks with computer use tools]: https://docs.aws.amazon.com/bedrock/latest/userguide/agent-computer-use.html
	ParentActionGroupSignatureParams map[string]string

	noSmithyDocumentSerde
}

// Input for an agent collaborator. The input can be text or an action invocation
// result.
type AgentCollaboratorInputPayload struct {

	// An action invocation result.
	ReturnControlResults *ReturnControlResults

	// Input text.
	Text *string

	// The input type.
	Type PayloadType

	noSmithyDocumentSerde
}

// An agent collaborator invocation input.
type AgentCollaboratorInvocationInput struct {

	// The collaborator's alias ARN.
	AgentCollaboratorAliasArn *string

	// The collaborator's name.
	AgentCollaboratorName *string

	// Text or action invocation result input for the collaborator.
	Input *AgentCollaboratorInputPayload

	noSmithyDocumentSerde
}

// Output from an agent collaborator.
type AgentCollaboratorInvocationOutput struct {

	// The output's agent collaborator alias ARN.
	AgentCollaboratorAliasArn *string

	// The output's agent collaborator name.
	AgentCollaboratorName *string

	// Contains information about the output from the agent collaborator.
	Metadata *Metadata

	// The output's output.
	Output *AgentCollaboratorOutputPayload

	noSmithyDocumentSerde
}

// Output from an agent collaborator. The output can be text or an action
// invocation result.
type AgentCollaboratorOutputPayload struct {

	// An action invocation result.
	ReturnControlPayload *ReturnControlPayload

	// Text output.
	Text *string

	// The type of output.
	Type PayloadType

	noSmithyDocumentSerde
}

// An event in which the prompt was analyzed in preparation for optimization.
type AnalyzePromptEvent struct {

	// A message describing the analysis of the prompt.
	Message *string

	noSmithyDocumentSerde
}

// Contains information about the API operation that the agent predicts should be
// called.
//
// This data type is used in the following API operations:
//
//   - In the returnControl field of the [InvokeAgent response]
//
// [InvokeAgent response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax
type ApiInvocationInput struct {

	// The action group that the API operation belongs to.
	//
	// This member is required.
	ActionGroup *string

	// Contains information about the API operation to invoke.
	ActionInvocationType ActionInvocationType

	// The agent's ID.
	AgentId *string

	// The path to the API operation.
	ApiPath *string

	// The agent collaborator's name.
	CollaboratorName *string

	// The HTTP method of the API operation.
	HttpMethod *string

	// The parameters to provide for the API request, as the agent elicited from the
	// user.
	Parameters []ApiParameter

	// The request body to provide for the API request, as the agent elicited from the
	// user.
	RequestBody *ApiRequestBody

	noSmithyDocumentSerde
}

// Information about a parameter to provide to the API request.
//
// This data type is used in the following API operations:
//
// [InvokeAgent response]
//
// [InvokeAgent response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax
type ApiParameter struct {

	// The name of the parameter.
	Name *string

	// The data type for the parameter.
	Type *string

	// The value of the parameter.
	Value *string

	noSmithyDocumentSerde
}

// The request body to provide for the API request, as the agent elicited from the
// user.
//
// This data type is used in the following API operations:
//
// [InvokeAgent response]
//
// [InvokeAgent response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax
type ApiRequestBody struct {

	// The content of the request body. The key of the object in this field is a media
	// type defining the format of the request body.
	Content map[string]PropertyParameters

	noSmithyDocumentSerde
}

// Contains information about the API operation that was called from the action
// group and the response body that was returned.
//
// This data type is used in the following API operations:
//
//   - In the returnControlInvocationResults of the [InvokeAgent request]
//
// [InvokeAgent request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_RequestSyntax
type ApiResult struct {

	// The action group that the API operation belongs to.
	//
	// This member is required.
	ActionGroup *string

	// The agent's ID.
	AgentId *string

	// The path to the API operation.
	ApiPath *string

	// Controls the API operations or functions to invoke based on the user
	// confirmation.
	ConfirmationState ConfirmationState

	// The HTTP method for the API operation.
	HttpMethod *string

	// http status code from API execution response (for example: 200, 400, 500).
	HttpStatusCode *int32

	// The response body from the API operation. The key of the object is the content
	// type (currently, only TEXT is supported). The response may be returned directly
	// or from the Lambda function.
	ResponseBody map[string]ContentBody

	// Controls the final response state returned to end user when API/Function
	// execution failed. When this state is FAILURE, the request would fail with
	// dependency failure exception. When this state is REPROMPT, the API/function
	// response will be sent to model for re-prompt
	ResponseState ResponseState

	noSmithyDocumentSerde
}

//	Contains details about the OpenAPI schema for the action group. For more
//
// information, see [Action group OpenAPI schemas]. You can either include the schema directly in the payload
// field or you can upload it to an S3 bucket and specify the S3 bucket location in
// the s3 field.
//
// The following types satisfy this interface:
//
//	APISchemaMemberPayload
//	APISchemaMemberS3
//
// [Action group OpenAPI schemas]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html
type APISchema interface {
	isAPISchema()
}

//	The JSON or YAML-formatted payload defining the OpenAPI schema for the action
//
// group.
type APISchemaMemberPayload struct {
	Value string

	noSmithyDocumentSerde
}

func (*APISchemaMemberPayload) isAPISchema() {}

//	Contains details about the S3 object containing the OpenAPI schema for the
//
// action group.
type APISchemaMemberS3 struct {
	Value S3Identifier

	noSmithyDocumentSerde
}

func (*APISchemaMemberS3) isAPISchema() {}

// Contains citations for a part of an agent response.
type Attribution struct {

	// A list of citations and related information for a part of an agent response.
	Citations []Citation

	noSmithyDocumentSerde
}

// Contains information about an audio segment retrieved from a knowledge base,
// including its location and transcription.
//
// This data type is used in the following API operations:
//
// [Retrieve response]
//   - – in the audio field
//
// [Retrieve response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax
type AudioSegment struct {

	// The S3 URI where this specific audio segment is stored in the multimodal
	// storage destination.
	//
	// This member is required.
	S3Uri *string

	// The text transcription of the audio segment content.
	Transcription *string

	noSmithyDocumentSerde
}

// Settings for a model called with InvokeAgent.
type BedrockModelConfigurations struct {

	// The performance configuration for the model.
	PerformanceConfig *PerformanceConfiguration

	noSmithyDocumentSerde
}

// Contains configurations for an Amazon Bedrock reranker model.
type BedrockRerankingConfiguration struct {

	// Contains configurations for a reranker model.
	//
	// This member is required.
	ModelConfiguration *BedrockRerankingModelConfiguration

	// The number of results to return after reranking.
	NumberOfResults *int32

	noSmithyDocumentSerde
}

// Contains configurations for a reranker model.
type BedrockRerankingModelConfiguration struct {

	// The ARN of the reranker model.
	//
	// This member is required.
	ModelArn *string

	// A JSON object whose keys are request fields for the model and whose values are
	// values for those fields.
	AdditionalModelRequestFields map[string]document.Interface

	noSmithyDocumentSerde
}

// A block of content that you pass to, or receive from, a Amazon Bedrock session
// in an invocation step. You pass the content to a session in the payLoad of the [PutInvocationStep]
// API operation. You retrieve the content with the [GetInvocationStep]API operation.
//
// For more information about sessions, see [Store and retrieve conversation history and context with Amazon Bedrock sessions].
//
// The following types satisfy this interface:
//
//	BedrockSessionContentBlockMemberImage
//	BedrockSessionContentBlockMemberText
//
// [Store and retrieve conversation history and context with Amazon Bedrock sessions]: https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html
// [GetInvocationStep]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_GetInvocationStep.html
// [PutInvocationStep]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_PutInvocationStep.html
type BedrockSessionContentBlock interface {
	isBedrockSessionContentBlock()
}

// The image in the invocation step.
type BedrockSessionContentBlockMemberImage struct {
	Value ImageBlock

	noSmithyDocumentSerde
}

func (*BedrockSessionContentBlockMemberImage) isBedrockSessionContentBlock() {}

// The text in the invocation step.
type BedrockSessionContentBlockMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*BedrockSessionContentBlockMemberText) isBedrockSessionContentBlock() {}

// This property contains the document to chat with, along with its attributes.
type ByteContentDoc struct {

	// The MIME type of the document contained in the wrapper object.
	//
	// This member is required.
	ContentType *string

	// The byte value of the file to upload, encoded as a Base-64 string.
	//
	// This member is required.
	Data []byte

	// The file name of the document contained in the wrapper object.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

// The property contains the file to chat with, along with its attributes.
type ByteContentFile struct {

	// The raw bytes of the file to attach. The maximum size of all files that is
	// attached is 10MB. You can attach a maximum of 5 files.
	//
	// This member is required.
	Data []byte

	// The MIME type of data contained in the file used for chat.
	//
	// This member is required.
	MediaType *string

	noSmithyDocumentSerde
}

// Details about a caller.
//
// The following types satisfy this interface:
//
//	CallerMemberAgentAliasArn
type Caller interface {
	isCaller()
}

// The caller's agent alias ARN.
type CallerMemberAgentAliasArn struct {
	Value string

	noSmithyDocumentSerde
}

func (*CallerMemberAgentAliasArn) isCaller() {}

// An object containing a segment of the generated response that is based on a
// source in the knowledge base, alongside information about the source.
//
// This data type is used in the following API operations:
//
// [InvokeAgent response]
//   - – in the citations field
//
// [RetrieveAndGenerate response]
//   - – in the citations field
//
// [RetrieveAndGenerate response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax
// [InvokeAgent response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax
type Citation struct {

	// Contains the generated response and metadata
	GeneratedResponsePart *GeneratedResponsePart

	// Contains metadata about the sources cited for the generated response.
	RetrievedReferences []RetrievedReference

	noSmithyDocumentSerde
}

// A citation event.
type CitationEvent struct {

	// The citation.
	//
	// Deprecated: Citation is deprecated. Please use GeneratedResponsePart and
	// RetrievedReferences for citation event.
	Citation *Citation

	// The generated response to the citation event.
	GeneratedResponsePart *GeneratedResponsePart

	// The retrieved references of the citation event.
	RetrievedReferences []RetrievedReference

	noSmithyDocumentSerde
}

// Contains information about the code interpreter being invoked.
type CodeInterpreterInvocationInput struct {

	// The code for the code interpreter to use.
	Code *string

	// Files that are uploaded for code interpreter to use.
	Files []string

	noSmithyDocumentSerde
}

// Contains the JSON-formatted string returned by the API invoked by the code
// interpreter.
type CodeInterpreterInvocationOutput struct {

	// Contains the error returned from code execution.
	ExecutionError *string

	// Contains the successful output returned from code execution
	ExecutionOutput *string

	// Indicates if the execution of the code timed out.
	ExecutionTimeout *bool

	// Contains output files, if generated by code execution.
	Files []string

	// Contains information about the output from the code interpreter.
	Metadata *Metadata

	noSmithyDocumentSerde
}

// List of inline collaborators.
type Collaborator struct {

	//  The foundation model used by the inline collaborator agent.
	//
	// This member is required.
	FoundationModel *string

	//  Instruction that tell the inline collaborator agent what it should do and how
	// it should interact with users.
	//
	// This member is required.
	Instruction *string

	//  List of action groups with each action group defining tasks the inline
	// collaborator agent needs to carry out.
	ActionGroups []AgentActionGroup

	//  Defines how the inline supervisor agent handles information across multiple
	// collaborator agents to coordinate a final response.
	AgentCollaboration AgentCollaboration

	//  Name of the inline collaborator agent which must be the same name as specified
	// for collaboratorName .
	AgentName *string

	//  Settings of the collaborator agent.
	CollaboratorConfigurations []CollaboratorConfiguration

	//  The Amazon Resource Name (ARN) of the AWS KMS key that encrypts the inline
	// collaborator.
	CustomerEncryptionKeyArn *string

	//  Details of the guardwrail associated with the inline collaborator.
	GuardrailConfiguration *GuardrailConfigurationWithArn

	//  The number of seconds for which the Amazon Bedrock keeps information about the
	// user's conversation with the inline collaborator agent.
	//
	// A user interaction remains active for the amount of time specified. If no
	// conversation occurs during this time, the session expires and Amazon Bedrock
	// deletes any data provided before the timeout.
	IdleSessionTTLInSeconds *int32

	//  Knowledge base associated with the inline collaborator agent.
	KnowledgeBases []KnowledgeBase

	//  Contains configurations to override prompt templates in different parts of an
	// inline collaborator sequence. For more information, see [Advanced prompts].
	//
	// [Advanced prompts]: https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html
	PromptOverrideConfiguration *PromptOverrideConfiguration

	noSmithyDocumentSerde
}

// Settings of an inline collaborator agent.
type CollaboratorConfiguration struct {

	//  Instructions that tell the inline collaborator agent what it should do and how
	// it should interact with users.
	//
	// This member is required.
	CollaboratorInstruction *string

	//  Name of the inline collaborator agent which must be the same name as specified
	// for agentName .
	//
	// This member is required.
	CollaboratorName *string

	//  The Amazon Resource Name (ARN) of the inline collaborator agent.
	AgentAliasArn *string

	//  A relay conversation history for the inline collaborator agent.
	RelayConversationHistory RelayConversationHistory

	noSmithyDocumentSerde
}

// Contains information about a condition evaluation result during a flow
// execution. This event is generated when a condition node in the flow evaluates
// its conditions.
//
// Flow executions is in preview release for Amazon Bedrock and is subject to
// change.
type ConditionResultEvent struct {

	// The name of the condition node that evaluated the conditions.
	//
	// This member is required.
	NodeName *string

	// A list of conditions that were satisfied during the evaluation.
	//
	// This member is required.
	SatisfiedConditions []SatisfiedCondition

	// The timestamp when the condition evaluation occurred.
	//
	// This member is required.
	Timestamp *time.Time

	noSmithyDocumentSerde
}

// A content block.
//
// The following types satisfy this interface:
//
//	ContentBlockMemberText
type ContentBlock interface {
	isContentBlock()
}

// The block's text.
type ContentBlockMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*ContentBlockMemberText) isContentBlock() {}

// Contains the body of the API response.
//
// This data type is used in the following API operations:
//
//   - In the returnControlInvocationResults field of the [InvokeAgent request]
//
// [InvokeAgent request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_RequestSyntax
type ContentBody struct {

	// The body of the API response.
	Body *string

	// Lists details, including format and source, for the image in the response from
	// the function call. You can specify only one image and the function in the
	// returnControlInvocationResults must be a computer use action. For more
	// information, see [Configure an Amazon Bedrock Agent to complete tasks with computer use tools].
	//
	// [Configure an Amazon Bedrock Agent to complete tasks with computer use tools]: https://docs.aws.amazon.com/bedrock/latest/userguide/agent-computer-use.html
	Images []ImageInput

	noSmithyDocumentSerde
}

// A conversation history.
type ConversationHistory struct {

	// The conversation's messages.
	Messages []Message

	noSmithyDocumentSerde
}

// Contains details of the custom orchestration configured for the agent.
type CustomOrchestration struct {

	// The structure of the executor invoking the actions in custom orchestration.
	Executor OrchestrationExecutor

	noSmithyDocumentSerde
}

// The trace behavior for the custom orchestration.
type CustomOrchestrationTrace struct {

	//  The event details used with the custom orchestration.
	Event *CustomOrchestrationTraceEvent

	//  The unique identifier of the trace.
	TraceId *string

	noSmithyDocumentSerde
}

//	The event in the custom orchestration sequence. Events are the responses which
//
// the custom orchestration Lambda function sends as response to the agent.
type CustomOrchestrationTraceEvent struct {

	//  The text that prompted the event at this step.
	Text *string

	noSmithyDocumentSerde
}

// The unique external source of the content contained in the wrapper object.
type ExternalSource struct {

	// The source type of the external source wrapper object.
	//
	// This member is required.
	SourceType ExternalSourceType

	// The identifier, contentType, and data of the external source wrapper object.
	ByteContent *ByteContentDoc

	// The S3 location of the external source wrapper object.
	S3Location *S3ObjectDoc

	noSmithyDocumentSerde
}

// Contains the generation configuration of the external source wrapper object.
type ExternalSourcesGenerationConfiguration struct {

	//  Additional model parameters and their corresponding values not included in the
	// textInferenceConfig structure for an external source. Takes in custom model
	// parameters specific to the language model being used.
	AdditionalModelRequestFields map[string]document.Interface

	// The configuration details for the guardrail.
	GuardrailConfiguration *GuardrailConfiguration

	//  Configuration settings for inference when using RetrieveAndGenerate to
	// generate responses while using an external source.
	InferenceConfig *InferenceConfig

	// The latency configuration for the model.
	PerformanceConfig *PerformanceConfiguration

	// Contain the textPromptTemplate string for the external source wrapper object.
	PromptTemplate *PromptTemplate

	noSmithyDocumentSerde
}

// The configurations of the external source wrapper object in the
// retrieveAndGenerate function.
type ExternalSourcesRetrieveAndGenerateConfiguration struct {

	// The model Amazon Resource Name (ARN) for the external source wrapper object in
	// the retrieveAndGenerate function.
	//
	// This member is required.
	ModelArn *string

	// The document for the external source wrapper object in the retrieveAndGenerate
	// function.
	//
	// This member is required.
	Sources []ExternalSource

	// The prompt used with the external source wrapper object with the
	// retrieveAndGenerate function.
	GenerationConfiguration *ExternalSourcesGenerationConfiguration

	noSmithyDocumentSerde
}

// Contains information about the failure of the interaction.
type FailureTrace struct {

	// The failure code for the trace.
	FailureCode *int32

	// The reason the interaction failed.
	FailureReason *string

	// Information about the failure that occurred.
	Metadata *Metadata

	// The unique identifier of the trace.
	TraceId *string

	noSmithyDocumentSerde
}

// Contains information for a metadata field to include in or exclude from
// consideration when reranking.
type FieldForReranking struct {

	// The name of a metadata field to include in or exclude from consideration when
	// reranking.
	//
	// This member is required.
	FieldName *string

	noSmithyDocumentSerde
}

// Contains intermediate response for code interpreter if any files have been
// generated.
type FilePart struct {

	// Files containing intermediate response for the user.
	Files []OutputFile

	noSmithyDocumentSerde
}

// The source file of the content contained in the wrapper object.
type FileSource struct {

	// The source type of the files to attach.
	//
	// This member is required.
	SourceType FileSourceType

	// The data and the text of the attached files.
	ByteContent *ByteContentFile

	// The s3 location of the files to attach.
	S3Location *S3ObjectFile

	noSmithyDocumentSerde
}

// Specifies the name that the metadata attribute must match and the value to
// which to compare the value of the metadata attribute. For more information, see [Query configurations]
// .
//
// This data type is used in the following API operations:
//
// [RetrieveAndGenerate request]
//
// [RetrieveAndGenerate request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax
// [Query configurations]: https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html
type FilterAttribute struct {

	// The name that the metadata attribute must match.
	//
	// This member is required.
	Key *string

	// The value to whcih to compare the value of the metadata attribute.
	//
	// This member is required.
	Value document.Interface

	noSmithyDocumentSerde
}

// Contains details about the response to the user.
type FinalResponse struct {

	// Contains information about the invoke agent operation.
	Metadata *Metadata

	// The text in the response to the user.
	Text *string

	noSmithyDocumentSerde
}

// Contains information about why a flow completed.
type FlowCompletionEvent struct {

	// The reason that the flow completed.
	//
	// This member is required.
	CompletionReason FlowCompletionReason

	noSmithyDocumentSerde
}

// Contains the content of an flow execution input or output field.
//
// Flow executions is in preview release for Amazon Bedrock and is subject to
// change.
//
// The following types satisfy this interface:
//
//	FlowExecutionContentMemberDocument
type FlowExecutionContent interface {
	isFlowExecutionContent()
}

// The document content of the field, which can contain text or structured data.
type FlowExecutionContentMemberDocument struct {
	Value document.Interface

	noSmithyDocumentSerde
}

func (*FlowExecutionContentMemberDocument) isFlowExecutionContent() {}

// Contains information about an error that occurred during an flow execution.
//
// Flow executions is in preview release for Amazon Bedrock and is subject to
// change.
type FlowExecutionError struct {

	// The error code for the type of error that occurred.
	Error FlowExecutionErrorType

	// A descriptive message that provides details about the error.
	Message *string

	// The name of the node in the flow where the error occurred (if applicable).
	NodeName *string

	noSmithyDocumentSerde
}

// Represents an event that occurred during an flow execution. This is a union
// type that can contain one of several event types, such as node input and output
// events; flow input and output events; condition node result events, or failure
// events.
//
// Flow executions is in preview release for Amazon Bedrock and is subject to
// change.
//
// The following types satisfy this interface:
//
//	FlowExecutionEventMemberConditionResultEvent
//	FlowExecutionEventMemberFlowFailureEvent
//	FlowExecutionEventMemberFlowInputEvent
//	FlowExecutionEventMemberFlowOutputEvent
//	FlowExecutionEventMemberNodeActionEvent
//	FlowExecutionEventMemberNodeDependencyEvent
//	FlowExecutionEventMemberNodeFailureEvent
//	FlowExecutionEventMemberNodeInputEvent
//	FlowExecutionEventMemberNodeOutputEvent
type FlowExecutionEvent interface {
	isFlowExecutionEvent()
}

// Contains information about a condition evaluation result during the flow
// execution. This event is generated when a condition node in the flow evaluates
// its conditions.
type FlowExecutionEventMemberConditionResultEvent struct {
	Value ConditionResultEvent

	noSmithyDocumentSerde
}

func (*FlowExecutionEventMemberConditionResultEvent) isFlowExecutionEvent() {}

// Contains information about a failure that occurred at the flow level during
// execution.
type FlowExecutionEventMemberFlowFailureEvent struct {
	Value FlowFailureEvent

	noSmithyDocumentSerde
}

func (*FlowExecutionEventMemberFlowFailureEvent) isFlowExecutionEvent() {}

// Contains information about the inputs provided to the flow at the start of
// execution.
type FlowExecutionEventMemberFlowInputEvent struct {
	Value FlowExecutionInputEvent

	noSmithyDocumentSerde
}

func (*FlowExecutionEventMemberFlowInputEvent) isFlowExecutionEvent() {}

// Contains information about the outputs produced by the flow at the end of
// execution.
type FlowExecutionEventMemberFlowOutputEvent struct {
	Value FlowExecutionOutputEvent

	noSmithyDocumentSerde
}

func (*FlowExecutionEventMemberFlowOutputEvent) isFlowExecutionEvent() {}

// Contains information about an action (operation) called by a node during
// execution.
type FlowExecutionEventMemberNodeActionEvent struct {
	Value NodeActionEvent

	noSmithyDocumentSerde
}

func (*FlowExecutionEventMemberNodeActionEvent) isFlowExecutionEvent() {}

// Contains information about an internal trace of a specific node during
// execution.
type FlowExecutionEventMemberNodeDependencyEvent struct {
	Value NodeDependencyEvent

	noSmithyDocumentSerde
}

func (*FlowExecutionEventMemberNodeDependencyEvent) isFlowExecutionEvent() {}

// Contains information about a failure that occurred at a specific node during
// execution.
type FlowExecutionEventMemberNodeFailureEvent struct {
	Value NodeFailureEvent

	noSmithyDocumentSerde
}

func (*FlowExecutionEventMemberNodeFailureEvent) isFlowExecutionEvent() {}

// Contains information about the inputs provided to a specific node during
// execution.
type FlowExecutionEventMemberNodeInputEvent struct {
	Value NodeInputEvent

	noSmithyDocumentSerde
}

func (*FlowExecutionEventMemberNodeInputEvent) isFlowExecutionEvent() {}

// Contains information about the outputs produced by a specific node during
// execution.
type FlowExecutionEventMemberNodeOutputEvent struct {
	Value NodeOutputEvent

	noSmithyDocumentSerde
}

func (*FlowExecutionEventMemberNodeOutputEvent) isFlowExecutionEvent() {}

// Contains information about the inputs provided to the flow at the start of a
// flow execution.
//
// Flow executions is in preview release for Amazon Bedrock and is subject to
// change.
type FlowExecutionInputEvent struct {

	// A list of input fields provided to the flow.
	//
	// This member is required.
	Fields []FlowInputField

	// The name of the node that receives the inputs.
	//
	// This member is required.
	NodeName *string

	// The timestamp when the inputs are provided.
	//
	// This member is required.
	Timestamp *time.Time

	noSmithyDocumentSerde
}

// Contains information about the outputs produced by the flow during a flow
// execution.
//
// Flow executions is in preview release for Amazon Bedrock and is subject to
// change.
type FlowExecutionOutputEvent struct {

	// A list of output fields produced by the flow.
	//
	// This member is required.
	Fields []FlowOutputField

	// The name of the node that produces the outputs.
	//
	// This member is required.
	NodeName *string

	// The timestamp when the outputs are produced.
	//
	// This member is required.
	Timestamp *time.Time

	noSmithyDocumentSerde
}

// Contains summary information about a flow execution, including its status,
// timestamps, and identifiers.
//
// Flow executions is in preview release for Amazon Bedrock and is subject to
// change.
type FlowExecutionSummary struct {

	// The timestamp when the flow execution was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) that uniquely identifies the flow execution.
	//
	// This member is required.
	ExecutionArn *string

	// The unique identifier of the flow alias used for the execution.
	//
	// This member is required.
	FlowAliasIdentifier *string

	// The unique identifier of the flow.
	//
	// This member is required.
	FlowIdentifier *string

	// The version of the flow used for the execution.
	//
	// This member is required.
	FlowVersion *string

	// The current status of the flow execution.
	//
	// Flow executions time out after 24 hours.
	//
	// This member is required.
	Status FlowExecutionStatus

	// The timestamp when the flow execution ended. This field is only populated when
	// the execution has completed, failed, timed out, or been aborted.
	EndedAt *time.Time

	noSmithyDocumentSerde
}

// Contains information about a failure that occurred at the flow level during a
// flow execution.
//
// Flow executions is in preview release for Amazon Bedrock and is subject to
// change.
type FlowFailureEvent struct {

	// The error code that identifies the type of failure that occurred.
	//
	// This member is required.
	ErrorCode FlowErrorCode

	// A descriptive message that provides details about the failure.
	//
	// This member is required.
	ErrorMessage *string

	// The timestamp when the failure occurred.
	//
	// This member is required.
	Timestamp *time.Time

	noSmithyDocumentSerde
}

// Contains information about an input into the prompt flow and where to send it.
type FlowInput struct {

	// Contains information about an input into the prompt flow.
	//
	// This member is required.
	Content FlowInputContent

	// The name of the flow input node that begins the prompt flow.
	//
	// This member is required.
	NodeName *string

	// The name of the input from the flow input node.
	NodeInputName *string

	// The name of the output from the flow input node that begins the prompt flow.
	NodeOutputName *string

	noSmithyDocumentSerde
}

// Contains information about an input into the flow.
//
// The following types satisfy this interface:
//
//	FlowInputContentMemberDocument
type FlowInputContent interface {
	isFlowInputContent()
}

// The input to send to the prompt flow input node.
type FlowInputContentMemberDocument struct {
	Value document.Interface

	noSmithyDocumentSerde
}

func (*FlowInputContentMemberDocument) isFlowInputContent() {}

// Represents an input field provided to a flow during a flow execution.
//
// Flow executions is in preview release for Amazon Bedrock and is subject to
// change.
type FlowInputField struct {

	// The content of the input field, which can contain text or structured data.
	//
	// This member is required.
	Content FlowExecutionContent

	// The name of the input field as defined in the flow's input schema.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The content structure containing input information for multi-turn flow
// interactions.
//
// The following types satisfy this interface:
//
//	FlowMultiTurnInputContentMemberDocument
type FlowMultiTurnInputContent interface {
	isFlowMultiTurnInputContent()
}

// The requested additional input to send back to the multi-turn flow node.
type FlowMultiTurnInputContentMemberDocument struct {
	Value document.Interface

	noSmithyDocumentSerde
}

func (*FlowMultiTurnInputContentMemberDocument) isFlowMultiTurnInputContent() {}

// Response object from the flow multi-turn node requesting additional information.
type FlowMultiTurnInputRequestEvent struct {

	// The content payload containing the input request details for the multi-turn
	// interaction.
	//
	// This member is required.
	Content FlowMultiTurnInputContent

	// The name of the node in the flow that is requesting the input.
	//
	// This member is required.
	NodeName *string

	// The type of the node in the flow that is requesting the input.
	//
	// This member is required.
	NodeType NodeType

	noSmithyDocumentSerde
}

// Contains information about the content in an output from prompt flow invocation.
//
// The following types satisfy this interface:
//
//	FlowOutputContentMemberDocument
type FlowOutputContent interface {
	isFlowOutputContent()
}

// The content in the output.
type FlowOutputContentMemberDocument struct {
	Value document.Interface

	noSmithyDocumentSerde
}

func (*FlowOutputContentMemberDocument) isFlowOutputContent() {}

// Contains information about an output from prompt flow invoction.
type FlowOutputEvent struct {

	// The content in the output.
	//
	// This member is required.
	Content FlowOutputContent

	// The name of the flow output node that the output is from.
	//
	// This member is required.
	NodeName *string

	// The type of the node that the output is from.
	//
	// This member is required.
	NodeType NodeType

	noSmithyDocumentSerde
}

// Represents an output field produced by a flow during a flow execution.
//
// Flow executions is in preview release for Amazon Bedrock and is subject to
// change.
type FlowOutputField struct {

	// The content of the output field, which can contain text or structured data.
	//
	// This member is required.
	Content FlowExecutionContent

	// The name of the output field as defined in the flow's output schema.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The output of the flow.
//
// The following types satisfy this interface:
//
//	FlowResponseStreamMemberFlowCompletionEvent
//	FlowResponseStreamMemberFlowMultiTurnInputRequestEvent
//	FlowResponseStreamMemberFlowOutputEvent
//	FlowResponseStreamMemberFlowTraceEvent
type FlowResponseStream interface {
	isFlowResponseStream()
}

// Contains information about why the flow completed.
type FlowResponseStreamMemberFlowCompletionEvent struct {
	Value FlowCompletionEvent

	noSmithyDocumentSerde
}

func (*FlowResponseStreamMemberFlowCompletionEvent) isFlowResponseStream() {}

// The event stream containing the multi-turn input request information from the
// flow.
type FlowResponseStreamMemberFlowMultiTurnInputRequestEvent struct {
	Value FlowMultiTurnInputRequestEvent

	noSmithyDocumentSerde
}

func (*FlowResponseStreamMemberFlowMultiTurnInputRequestEvent) isFlowResponseStream() {}

// Contains information about an output from flow invocation.
type FlowResponseStreamMemberFlowOutputEvent struct {
	Value FlowOutputEvent

	noSmithyDocumentSerde
}

func (*FlowResponseStreamMemberFlowOutputEvent) isFlowResponseStream() {}

// Contains information about a trace, which tracks an input or output for a node
// in the flow.
type FlowResponseStreamMemberFlowTraceEvent struct {
	Value FlowTraceEvent

	noSmithyDocumentSerde
}

func (*FlowResponseStreamMemberFlowTraceEvent) isFlowResponseStream() {}

// Contains information about an input or output for a node in the flow. For more
// information, see [Track each step in your prompt flow by viewing its trace in Amazon Bedrock].
//
// The following types satisfy this interface:
//
//	FlowTraceMemberConditionNodeResultTrace
//	FlowTraceMemberNodeActionTrace
//	FlowTraceMemberNodeDependencyTrace
//	FlowTraceMemberNodeInputTrace
//	FlowTraceMemberNodeOutputTrace
//
// [Track each step in your prompt flow by viewing its trace in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html
type FlowTrace interface {
	isFlowTrace()
}

// Contains information about an output from a condition node.
type FlowTraceMemberConditionNodeResultTrace struct {
	Value FlowTraceConditionNodeResultEvent

	noSmithyDocumentSerde
}

func (*FlowTraceMemberConditionNodeResultTrace) isFlowTrace() {}

// Contains information about an action (operation) called by a node.
type FlowTraceMemberNodeActionTrace struct {
	Value FlowTraceNodeActionEvent

	noSmithyDocumentSerde
}

func (*FlowTraceMemberNodeActionTrace) isFlowTrace() {}

// Contains information about an internal trace of a node.
type FlowTraceMemberNodeDependencyTrace struct {
	Value FlowTraceDependencyEvent

	noSmithyDocumentSerde
}

func (*FlowTraceMemberNodeDependencyTrace) isFlowTrace() {}

// Contains information about the input into a node.
type FlowTraceMemberNodeInputTrace struct {
	Value FlowTraceNodeInputEvent

	noSmithyDocumentSerde
}

func (*FlowTraceMemberNodeInputTrace) isFlowTrace() {}

// Contains information about the output from a node.
type FlowTraceMemberNodeOutputTrace struct {
	Value FlowTraceNodeOutputEvent

	noSmithyDocumentSerde
}

func (*FlowTraceMemberNodeOutputTrace) isFlowTrace() {}

// Contains information about a condition that was satisfied. For more
// information, see [Track each step in your prompt flow by viewing its trace in Amazon Bedrock].
//
// [Track each step in your prompt flow by viewing its trace in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html
type FlowTraceCondition struct {

	// The name of the condition.
	//
	// This member is required.
	ConditionName *string

	noSmithyDocumentSerde
}

// Contains information about an output from a condition node. For more
// information, see [Track each step in your prompt flow by viewing its trace in Amazon Bedrock].
//
// [Track each step in your prompt flow by viewing its trace in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html
type FlowTraceConditionNodeResultEvent struct {

	// The name of the condition node.
	//
	// This member is required.
	NodeName *string

	// An array of objects containing information about the conditions that were
	// satisfied.
	//
	// This member is required.
	SatisfiedConditions []FlowTraceCondition

	// The date and time that the trace was returned.
	//
	// This member is required.
	Timestamp *time.Time

	noSmithyDocumentSerde
}

// Contains information about a dependency trace event in the flow.
type FlowTraceDependencyEvent struct {

	// The name of the node that generated the dependency trace.
	//
	// This member is required.
	NodeName *string

	// The date and time that the dependency trace was generated.
	//
	// This member is required.
	Timestamp *time.Time

	// The trace elements containing detailed information about the dependency.
	//
	// This member is required.
	TraceElements TraceElements

	noSmithyDocumentSerde
}

// Contains information about a trace, which tracks an input or output for a node
// in the flow. For more information, see [Track each step in your prompt flow by viewing its trace in Amazon Bedrock].
//
// [Track each step in your prompt flow by viewing its trace in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html
type FlowTraceEvent struct {

	// The trace object containing information about an input or output for a node in
	// the flow.
	//
	// This member is required.
	Trace FlowTrace

	noSmithyDocumentSerde
}

// Contains information about an action (operation) called by a node in an Amazon
// Bedrock flow. The service generates action events for calls made by prompt
// nodes, agent nodes, and Amazon Web Services Lambda nodes.
type FlowTraceNodeActionEvent struct {

	// The name of the node that called the operation.
	//
	// This member is required.
	NodeName *string

	// The name of the operation that the node called.
	//
	// This member is required.
	OperationName *string

	// The ID of the request that the node made to the operation.
	//
	// This member is required.
	RequestId *string

	// The name of the service that the node called.
	//
	// This member is required.
	ServiceName *string

	// The date and time that the operation was called.
	//
	// This member is required.
	Timestamp *time.Time

	// The request payload sent to the downstream service.
	OperationRequest document.Interface

	// The response payload received from the downstream service.
	OperationResponse document.Interface

	noSmithyDocumentSerde
}

// Contains the content of the node input. For more information, see [Track each step in your prompt flow by viewing its trace in Amazon Bedrock].
//
// The following types satisfy this interface:
//
//	FlowTraceNodeInputContentMemberDocument
//
// [Track each step in your prompt flow by viewing its trace in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html
type FlowTraceNodeInputContent interface {
	isFlowTraceNodeInputContent()
}

// The content of the node input.
type FlowTraceNodeInputContentMemberDocument struct {
	Value document.Interface

	noSmithyDocumentSerde
}

func (*FlowTraceNodeInputContentMemberDocument) isFlowTraceNodeInputContent() {}

// Contains information about the input into a node. For more information, see [Track each step in your prompt flow by viewing its trace in Amazon Bedrock].
//
// [Track each step in your prompt flow by viewing its trace in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html
type FlowTraceNodeInputEvent struct {

	// An array of objects containing information about each field in the input.
	//
	// This member is required.
	Fields []FlowTraceNodeInputField

	// The name of the node that received the input.
	//
	// This member is required.
	NodeName *string

	// The date and time that the trace was returned.
	//
	// This member is required.
	Timestamp *time.Time

	noSmithyDocumentSerde
}

// Represents an item in the execution chain for flow trace node input tracking.
type FlowTraceNodeInputExecutionChainItem struct {

	// The name of the node in the execution chain.
	//
	// This member is required.
	NodeName *string

	// The type of execution chain item. Supported values are Iterator and Loop.
	//
	// This member is required.
	Type FlowControlNodeType

	// The index position of this item in the execution chain.
	Index *int32

	noSmithyDocumentSerde
}

// Contains information about a field in the input into a node. For more
// information, see [Track each step in your prompt flow by viewing its trace in Amazon Bedrock].
//
// [Track each step in your prompt flow by viewing its trace in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html
type FlowTraceNodeInputField struct {

	// The content of the node input.
	//
	// This member is required.
	Content FlowTraceNodeInputContent

	// The name of the node input.
	//
	// This member is required.
	NodeInputName *string

	// The category of the input field.
	Category FlowNodeInputCategory

	// The execution path through nested nodes like iterators and loops.
	ExecutionChain []FlowTraceNodeInputExecutionChainItem

	// The source node that provides input data to this field.
	Source *FlowTraceNodeInputSource

	// The data type of the input field for compatibility validation.
	Type FlowNodeIODataType

	noSmithyDocumentSerde
}

// Represents the source of input data for a flow trace node field.
type FlowTraceNodeInputSource struct {

	// The expression used to extract data from the source.
	//
	// This member is required.
	Expression *string

	// The name of the source node that provides the input data.
	//
	// This member is required.
	NodeName *string

	// The name of the output field from the source node.
	//
	// This member is required.
	OutputFieldName *string

	noSmithyDocumentSerde
}

// Contains the content of the node output. For more information, see [Track each step in your prompt flow by viewing its trace in Amazon Bedrock].
//
// The following types satisfy this interface:
//
//	FlowTraceNodeOutputContentMemberDocument
//
// [Track each step in your prompt flow by viewing its trace in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html
type FlowTraceNodeOutputContent interface {
	isFlowTraceNodeOutputContent()
}

// The content of the node output.
type FlowTraceNodeOutputContentMemberDocument struct {
	Value document.Interface

	noSmithyDocumentSerde
}

func (*FlowTraceNodeOutputContentMemberDocument) isFlowTraceNodeOutputContent() {}

// Contains information about the output from a node. For more information, see [Track each step in your prompt flow by viewing its trace in Amazon Bedrock].
//
// [Track each step in your prompt flow by viewing its trace in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html
type FlowTraceNodeOutputEvent struct {

	// An array of objects containing information about each field in the output.
	//
	// This member is required.
	Fields []FlowTraceNodeOutputField

	// The name of the node that yielded the output.
	//
	// This member is required.
	NodeName *string

	// The date and time that the trace was returned.
	//
	// This member is required.
	Timestamp *time.Time

	noSmithyDocumentSerde
}

// Contains information about a field in the output from a node. For more
// information, see [Track each step in your prompt flow by viewing its trace in Amazon Bedrock].
//
// [Track each step in your prompt flow by viewing its trace in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html
type FlowTraceNodeOutputField struct {

	// The content of the node output.
	//
	// This member is required.
	Content FlowTraceNodeOutputContent

	// The name of the node output.
	//
	// This member is required.
	NodeOutputName *string

	// The next node that receives output data from this field.
	Next []FlowTraceNodeOutputNext

	// The data type of the output field for compatibility validation.
	Type FlowNodeIODataType

	noSmithyDocumentSerde
}

// Represents the next node that receives output data from a flow trace.
type FlowTraceNodeOutputNext struct {

	// The name of the input field in the next node that receives the data.
	//
	// This member is required.
	InputFieldName *string

	// The name of the next node that receives the output data.
	//
	// This member is required.
	NodeName *string

	noSmithyDocumentSerde
}

//	Defines parameters that the agent needs to invoke from the user to complete
//
// the function. Corresponds to an action in an action group.
type FunctionDefinition struct {

	//  A name for the function.
	//
	// This member is required.
	Name *string

	//  A description of the function and its purpose.
	Description *string

	//  The parameters that the agent elicits from the user to fulfill the function.
	Parameters map[string]ParameterDetail

	//  Contains information if user confirmation is required to invoke the function.
	RequireConfirmation RequireConfirmation

	noSmithyDocumentSerde
}

// Contains information about the function that the agent predicts should be
// called.
//
// This data type is used in the following API operations:
//
//   - In the returnControl field of the [InvokeAgent response]
//
// [InvokeAgent response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax
type FunctionInvocationInput struct {

	// The action group that the function belongs to.
	//
	// This member is required.
	ActionGroup *string

	// Contains information about the function to invoke,
	ActionInvocationType ActionInvocationType

	// The agent's ID.
	AgentId *string

	// The collaborator's name.
	CollaboratorName *string

	// The name of the function.
	Function *string

	// A list of parameters of the function.
	Parameters []FunctionParameter

	noSmithyDocumentSerde
}

// Contains information about a parameter of the function.
//
// This data type is used in the following API operations:
//
//   - In the returnControl field of the [InvokeAgent response]
//
// [InvokeAgent response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax
type FunctionParameter struct {

	// The name of the parameter.
	Name *string

	// The data type of the parameter.
	Type *string

	// The value of the parameter.
	Value *string

	noSmithyDocumentSerde
}

// Contains information about the function that was called from the action group
// and the response that was returned.
//
// This data type is used in the following API operations:
//
//   - In the returnControlInvocationResults of the [InvokeAgent request]
//
// [InvokeAgent request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_RequestSyntax
type FunctionResult struct {

	// The action group that the function belongs to.
	//
	// This member is required.
	ActionGroup *string

	// The agent's ID.
	AgentId *string

	// Contains the user confirmation information about the function that was called.
	ConfirmationState ConfirmationState

	// The name of the function that was called.
	Function *string

	// The response from the function call using the parameters. The response might be
	// returned directly or from the Lambda function. Specify TEXT or IMAGES . The key
	// of the object is the content type. You can only specify one type. If you specify
	// IMAGES , you can specify only one image. You can specify images only when the
	// function in the returnControlInvocationResults is a computer use action. For
	// more information, see [Configure an Amazon Bedrock Agent to complete tasks with computer use tools].
	//
	// [Configure an Amazon Bedrock Agent to complete tasks with computer use tools]: https://docs.aws.amazon.com/bedrock/latest/userguide/agent-computer-use.html
	ResponseBody map[string]ContentBody

	// Controls the final response state returned to end user when API/Function
	// execution failed. When this state is FAILURE, the request would fail with
	// dependency failure exception. When this state is REPROMPT, the API/function
	// response will be sent to model for re-prompt
	ResponseState ResponseState

	noSmithyDocumentSerde
}

//	Contains details about the function schema for the action group or the JSON or
//
// YAML-formatted payload defining the schema.
//
// The following types satisfy this interface:
//
//	FunctionSchemaMemberFunctions
type FunctionSchema interface {
	isFunctionSchema()
}

// A list of functions that each define an action in the action group.
type FunctionSchemaMemberFunctions struct {
	Value []FunctionDefinition

	noSmithyDocumentSerde
}

func (*FunctionSchemaMemberFunctions) isFunctionSchema() {}

// Contains information about a query generated for a natural language query.
type GeneratedQuery struct {

	// An SQL query that corresponds to the natural language query.
	Sql *string

	// The type of transformed query.
	Type GeneratedQueryType

	noSmithyDocumentSerde
}

// Contains metadata about a part of the generated response that is accompanied by
// a citation.
//
// This data type is used in the following API operations:
//
// [InvokeAgent response]
//   - – in the generatedResponsePart field
//
// [RetrieveAndGenerate response]
//   - – in the generatedResponsePart field
//
// [RetrieveAndGenerate response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax
// [InvokeAgent response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax
type GeneratedResponsePart struct {

	// Contains metadata about a textual part of the generated response that is
	// accompanied by a citation.
	TextResponsePart *TextResponsePart

	noSmithyDocumentSerde
}

// Contains configurations for response generation based on the knowledge base
// query results.
//
// This data type is used in the following API operations:
//
// [RetrieveAndGenerate request]
//
// [RetrieveAndGenerate request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax
type GenerationConfiguration struct {

	//  Additional model parameters and corresponding values not included in the
	// textInferenceConfig structure for a knowledge base. This allows users to provide
	// custom model parameters specific to the language model being used.
	AdditionalModelRequestFields map[string]document.Interface

	// The configuration details for the guardrail.
	GuardrailConfiguration *GuardrailConfiguration

	//  Configuration settings for inference when using RetrieveAndGenerate to
	// generate responses while using a knowledge base as a source.
	InferenceConfig *InferenceConfig

	// The latency configuration for the model.
	PerformanceConfig *PerformanceConfiguration

	// Contains the template for the prompt that's sent to the model for response
	// generation. Generation prompts must include the $search_results$ variable. For
	// more information, see [Use placeholder variables]in the user guide.
	//
	// [Use placeholder variables]: https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html
	PromptTemplate *PromptTemplate

	noSmithyDocumentSerde
}

// Assessment details of the content analyzed by Guardrails.
type GuardrailAssessment struct {

	// Content policy details of the Guardrail.
	ContentPolicy *GuardrailContentPolicyAssessment

	// Sensitive Information policy details of Guardrail.
	SensitiveInformationPolicy *GuardrailSensitiveInformationPolicyAssessment

	// Topic policy details of the Guardrail.
	TopicPolicy *GuardrailTopicPolicyAssessment

	// Word policy details of the Guardrail.
	WordPolicy *GuardrailWordPolicyAssessment

	noSmithyDocumentSerde
}

// The configuration details for the guardrail.
type GuardrailConfiguration struct {

	// The unique identifier for the guardrail.
	//
	// This member is required.
	GuardrailId *string

	// The version of the guardrail.
	//
	// This member is required.
	GuardrailVersion *string

	noSmithyDocumentSerde
}

// The configuration details for the guardrail.
type GuardrailConfigurationWithArn struct {

	//  The unique identifier for the guardrail.
	//
	// This member is required.
	GuardrailIdentifier *string

	//  The version of the guardrail.
	//
	// This member is required.
	GuardrailVersion *string

	noSmithyDocumentSerde
}

// Details of the content filter used in the Guardrail.
type GuardrailContentFilter struct {

	// The action placed on the content by the Guardrail filter.
	Action GuardrailContentPolicyAction

	// The confidence level regarding the content detected in the filter by the
	// Guardrail.
	Confidence GuardrailContentFilterConfidence

	// The type of content detected in the filter by the Guardrail.
	Type GuardrailContentFilterType

	noSmithyDocumentSerde
}

// The details of the policy assessment in the Guardrails filter.
type GuardrailContentPolicyAssessment struct {

	// The filter details of the policy assessment used in the Guardrails filter.
	Filters []GuardrailContentFilter

	noSmithyDocumentSerde
}

// The custom word details for the filter in the Guardrail.
type GuardrailCustomWord struct {

	// The action details for the custom word filter in the Guardrail.
	Action GuardrailWordPolicyAction

	// The match details for the custom word filter in the Guardrail.
	Match *string

	noSmithyDocumentSerde
}

// A guardrail event.
type GuardrailEvent struct {

	// The guardrail action.
	Action GuadrailAction

	noSmithyDocumentSerde
}

// The managed word details for the filter in the Guardrail.
type GuardrailManagedWord struct {

	// The action details for the managed word filter in the Guardrail.
	Action GuardrailWordPolicyAction

	// The match details for the managed word filter in the Guardrail.
	Match *string

	// The type details for the managed word filter in the Guardrail.
	Type GuardrailManagedWordType

	noSmithyDocumentSerde
}

// The Guardrail filter to identify and remove personally identifiable information
// (PII).
type GuardrailPiiEntityFilter struct {

	// The action of the Guardrail filter to identify and remove PII.
	Action GuardrailSensitiveInformationPolicyAction

	// The match to settings in the Guardrail filter to identify and remove PII.
	Match *string

	// The type of PII the Guardrail filter has identified and removed.
	Type GuardrailPiiEntityType

	noSmithyDocumentSerde
}

// The details for the regex filter used in the Guardrail.
type GuardrailRegexFilter struct {

	// The action details for the regex filter used in the Guardrail.
	Action GuardrailSensitiveInformationPolicyAction

	// The match details for the regex filter used in the Guardrail.
	Match *string

	// The name details for the regex filter used in the Guardrail.
	Name *string

	// The regex details for the regex filter used in the Guardrail.
	Regex *string

	noSmithyDocumentSerde
}

// The details of the sensitive policy assessment used in the Guardrail.
type GuardrailSensitiveInformationPolicyAssessment struct {

	// The details of the PII entities used in the sensitive policy assessment for the
	// Guardrail.
	PiiEntities []GuardrailPiiEntityFilter

	// The details of the regexes used in the sensitive policy assessment for the
	// Guardrail.
	Regexes []GuardrailRegexFilter

	noSmithyDocumentSerde
}

// The details for a specific topic defined in the Guardrail.
type GuardrailTopic struct {

	// The action details on a specific topic in the Guardrail.
	Action GuardrailTopicPolicyAction

	// The name details on a specific topic in the Guardrail.
	Name *string

	// The type details on a specific topic in the Guardrail.
	Type GuardrailTopicType

	noSmithyDocumentSerde
}

// The details of the policy assessment used in the Guardrail.
type GuardrailTopicPolicyAssessment struct {

	// The topic details of the policy assessment used in the Guardrail.
	Topics []GuardrailTopic

	noSmithyDocumentSerde
}

// The trace details used in the Guardrail.
type GuardrailTrace struct {

	// The trace action details used with the Guardrail.
	Action GuardrailAction

	// The details of the input assessments used in the Guardrail Trace.
	InputAssessments []GuardrailAssessment

	// Contains information about the Guardrail output.
	Metadata *Metadata

	// The details of the output assessments used in the Guardrail Trace.
	OutputAssessments []GuardrailAssessment

	// The details of the trace Id used in the Guardrail Trace.
	TraceId *string

	noSmithyDocumentSerde
}

// The assessment details for words defined in the Guardrail filter.
type GuardrailWordPolicyAssessment struct {

	// The custom word details for words defined in the Guardrail filter.
	CustomWords []GuardrailCustomWord

	// The managed word lists for words defined in the Guardrail filter.
	ManagedWordLists []GuardrailManagedWord

	noSmithyDocumentSerde
}

// Image content for an invocation step.
type ImageBlock struct {

	// The format of the image.
	//
	// This member is required.
	Format ImageFormat

	// The source for the image.
	//
	// This member is required.
	Source ImageSource

	noSmithyDocumentSerde
}

// Details about an image in the result from a function in the action group
// invocation. You can specify images only when the function is a computer use
// action. For more information, see [Configure an Amazon Bedrock Agent to complete tasks with computer use tools].
//
// [Configure an Amazon Bedrock Agent to complete tasks with computer use tools]: https://docs.aws.amazon.com/bedrock/latest/userguide/agent-computer-use.html
type ImageInput struct {

	// The type of image in the result.
	//
	// This member is required.
	Format ImageInputFormat

	// The source of the image in the result.
	//
	// This member is required.
	Source ImageInputSource

	noSmithyDocumentSerde
}

// Details about the source of an input image in the result from a function in the
// action group invocation.
//
// The following types satisfy this interface:
//
//	ImageInputSourceMemberBytes
type ImageInputSource interface {
	isImageInputSource()
}

//	The raw image bytes for the image. If you use an Amazon Web Services SDK, you
//
// don't need to encode the image bytes in base64.
type ImageInputSourceMemberBytes struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*ImageInputSourceMemberBytes) isImageInputSource() {}

// The source for an image.
//
// The following types satisfy this interface:
//
//	ImageSourceMemberBytes
//	ImageSourceMemberS3Location
type ImageSource interface {
	isImageSource()
}

//	The raw image bytes for the image. If you use an Amazon Web Services SDK, you
//
// don't need to encode the image bytes in base64.
type ImageSourceMemberBytes struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*ImageSourceMemberBytes) isImageSource() {}

// The path to the Amazon S3 bucket where the image is stored.
type ImageSourceMemberS3Location struct {
	Value S3Location

	noSmithyDocumentSerde
}

func (*ImageSourceMemberS3Location) isImageSource() {}

// Settings for implicit filtering, where a model generates a metadata filter
// based on the prompt.
type ImplicitFilterConfiguration struct {

	// Metadata that can be used in a filter.
	//
	// This member is required.
	MetadataAttributes []MetadataAttributeSchema

	// The model that generates the filter.
	//
	// This member is required.
	ModelArn *string

	noSmithyDocumentSerde
}

//	The configuration for inference settings when generating responses using
//
// RetrieveAndGenerate.
type InferenceConfig struct {

	//  Configuration settings specific to text generation while generating responses
	// using RetrieveAndGenerate.
	TextInferenceConfig *TextInferenceConfig

	noSmithyDocumentSerde
}

// Specifications about the inference parameters that were provided alongside the
// prompt. These are specified in the [PromptOverrideConfiguration]object that was set when the agent was
// created or updated. For more information, see [Inference parameters for foundation models].
//
// [Inference parameters for foundation models]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html
// [PromptOverrideConfiguration]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html
type InferenceConfiguration struct {

	// The maximum number of tokens allowed in the generated response.
	MaximumLength *int32

	// A list of stop sequences. A stop sequence is a sequence of characters that
	// causes the model to stop generating the response.
	StopSequences []string

	// The likelihood of the model selecting higher-probability options while
	// generating a response. A lower value makes the model more likely to choose
	// higher-probability options, while a higher value makes the model more likely to
	// choose lower-probability options.
	Temperature *float32

	// While generating a response, the model determines the probability of the
	// following token at each point of generation. The value that you set for topK is
	// the number of most-likely candidates from which the model chooses the next token
	// in the sequence. For example, if you set topK to 50, the model selects the next
	// token from among the top 50 most likely choices.
	TopK *int32

	// While generating a response, the model determines the probability of the
	// following token at each point of generation. The value that you set for Top P
	// determines the number of most-likely candidates from which the model chooses the
	// next token in the sequence. For example, if you set topP to 0.8, the model only
	// selects the next token from the top 80% of the probability distribution of next
	// tokens.
	TopP *float32

	noSmithyDocumentSerde
}

// Contains intermediate response for code interpreter if any files have been
// generated.
type InlineAgentFilePart struct {

	// Files containing intermediate response for the user.
	Files []OutputFile

	noSmithyDocumentSerde
}

// Contains a part of an agent response and citations for it.
type InlineAgentPayloadPart struct {

	// Contains citations for a part of an agent response.
	Attribution *Attribution

	// A part of the agent response in bytes.
	Bytes []byte

	noSmithyDocumentSerde
}

// The response from invoking the agent and associated citations and trace
// information.
//
// The following types satisfy this interface:
//
//	InlineAgentResponseStreamMemberChunk
//	InlineAgentResponseStreamMemberFiles
//	InlineAgentResponseStreamMemberReturnControl
//	InlineAgentResponseStreamMemberTrace
type InlineAgentResponseStream interface {
	isInlineAgentResponseStream()
}

// Contains a part of an agent response and citations for it.
type InlineAgentResponseStreamMemberChunk struct {
	Value InlineAgentPayloadPart

	noSmithyDocumentSerde
}

func (*InlineAgentResponseStreamMemberChunk) isInlineAgentResponseStream() {}

// Contains intermediate response for code interpreter if any files have been
// generated.
type InlineAgentResponseStreamMemberFiles struct {
	Value InlineAgentFilePart

	noSmithyDocumentSerde
}

func (*InlineAgentResponseStreamMemberFiles) isInlineAgentResponseStream() {}

// Contains the parameters and information that the agent elicited from the
// customer to carry out an action. This information is returned to the system and
// can be used in your own setup for fulfilling the action.
type InlineAgentResponseStreamMemberReturnControl struct {
	Value InlineAgentReturnControlPayload

	noSmithyDocumentSerde
}

func (*InlineAgentResponseStreamMemberReturnControl) isInlineAgentResponseStream() {}

// Contains information about the agent and session, alongside the agent's
// reasoning process and results from calling actions and querying knowledge bases
// and metadata about the trace. You can use the trace to understand how the agent
// arrived at the response it provided the customer. For more information, see [Trace events].
//
// [Trace events]: https://docs.aws.amazon.com/bedrock/latest/userguide/trace-events.html
type InlineAgentResponseStreamMemberTrace struct {
	Value InlineAgentTracePart

	noSmithyDocumentSerde
}

func (*InlineAgentResponseStreamMemberTrace) isInlineAgentResponseStream() {}

// Contains information to return from the action group that the agent has
// predicted to invoke.
//
// This data type is used in the [InvokeAgent response] API operation.
//
// [InvokeAgent response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax
type InlineAgentReturnControlPayload struct {

	// The identifier of the action group invocation.
	InvocationId *string

	// A list of objects that contain information about the parameters and inputs that
	// need to be sent into the API operation or function, based on what the agent
	// determines from its session with the user.
	InvocationInputs []InvocationInputMember

	noSmithyDocumentSerde
}

// Contains information about the agent and session, alongside the agent's
// reasoning process and results from calling API actions and querying knowledge
// bases and metadata about the trace. You can use the trace to understand how the
// agent arrived at the response it provided the customer. For more information,
// see [Trace enablement].
//
// [Trace enablement]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement
type InlineAgentTracePart struct {

	// The caller chain for the trace part.
	CallerChain []Caller

	// The collaborator name for the trace part.
	CollaboratorName *string

	// The time that trace occurred.
	EventTime *time.Time

	// The unique identifier of the session with the agent.
	SessionId *string

	// Contains one part of the agent's reasoning process and results from calling API
	// actions and querying knowledge bases. You can use the trace to understand how
	// the agent arrived at the response it provided the customer. For more
	// information, see [Trace enablement].
	//
	// [Trace enablement]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement
	Trace Trace

	noSmithyDocumentSerde
}

// Settings for a model called with InvokeInlineAgent.
type InlineBedrockModelConfigurations struct {

	// The latency configuration for the model.
	PerformanceConfig *PerformanceConfiguration

	noSmithyDocumentSerde
}

//	Contains parameters that specify various attributes that persist across a
//
// session or prompt. You can define session state attributes as key-value pairs
// when writing a [Lambda function]for an action group or pass them when making an InvokeInlineAgent
// request. Use session state attributes to control and provide conversational
// context for your inline agent and to help customize your agent's behavior. For
// more information, see [Control session context]
//
// [Control session context]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html
// [Lambda function]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-lambda.html
type InlineSessionState struct {

	//  Contains the conversation history that persist across sessions.
	ConversationHistory *ConversationHistory

	//  Contains information about the files used by code interpreter.
	Files []InputFile

	//  The identifier of the invocation of an action. This value must match the
	// invocationId returned in the InvokeInlineAgent response for the action whose
	// results are provided in the returnControlInvocationResults field. For more
	// information, see [Return control to the agent developer].
	//
	// [Return control to the agent developer]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html
	InvocationId *string

	//  Contains attributes that persist across a session and the values of those
	// attributes.
	PromptSessionAttributes map[string]string

	//  Contains information about the results from the action group invocation. For
	// more information, see [Return control to the agent developer].
	//
	// If you include this field in the sessionState field, the inputText field will
	// be ignored.
	//
	// [Return control to the agent developer]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html
	ReturnControlInvocationResults []InvocationResultMember

	//  Contains attributes that persist across a session and the values of those
	// attributes.
	SessionAttributes map[string]string

	noSmithyDocumentSerde
}

// Contains details of the source files.
type InputFile struct {

	// The name of the source file.
	//
	// This member is required.
	Name *string

	// Specifies where the files are located.
	//
	// This member is required.
	Source *FileSource

	// Specifies how the source files will be used by the code interpreter.
	//
	// This member is required.
	UseCase FileUseCase

	noSmithyDocumentSerde
}

// Contains the image data for multimodal knowledge base queries, including format
// and content.
//
// This data type is used in the following API operations:
//
// [Retrieve request]
//   - – in the image field
//
// [Retrieve request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax
type InputImage struct {

	// The format of the input image. Supported formats include png, gif, jpeg, and
	// webp.
	//
	// This member is required.
	Format InputImageFormat

	// The base64-encoded image data for inline image content. Maximum size is 5MB.
	//
	// This member is required.
	InlineContent []byte

	noSmithyDocumentSerde
}

// Contains information about the prompt to optimize.
//
// The following types satisfy this interface:
//
//	InputPromptMemberTextPrompt
type InputPrompt interface {
	isInputPrompt()
}

// Contains information about the text prompt to optimize.
type InputPromptMemberTextPrompt struct {
	Value TextPrompt

	noSmithyDocumentSerde
}

func (*InputPromptMemberTextPrompt) isInputPrompt() {}

// Contains information pertaining to the action group or knowledge base that is
// being invoked.
type InvocationInput struct {

	// Contains information about the action group to be invoked.
	ActionGroupInvocationInput *ActionGroupInvocationInput

	// The collaborator's invocation input.
	AgentCollaboratorInvocationInput *AgentCollaboratorInvocationInput

	// Contains information about the code interpreter to be invoked.
	CodeInterpreterInvocationInput *CodeInterpreterInvocationInput

	// Specifies whether the agent is invoking an action group or a knowledge base.
	InvocationType InvocationType

	// Contains details about the knowledge base to look up and the query to be made.
	KnowledgeBaseLookupInput *KnowledgeBaseLookupInput

	// The unique identifier of the trace.
	TraceId *string

	noSmithyDocumentSerde
}

// Contains details about the API operation or function that the agent predicts
// should be called.
//
// This data type is used in the following API operations:
//
//   - In the returnControl field of the [InvokeAgent response]
//
// The following types satisfy this interface:
//
//	InvocationInputMemberMemberApiInvocationInput
//	InvocationInputMemberMemberFunctionInvocationInput
//
// [InvokeAgent response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax
type InvocationInputMember interface {
	isInvocationInputMember()
}

// Contains information about the API operation that the agent predicts should be
// called.
type InvocationInputMemberMemberApiInvocationInput struct {
	Value ApiInvocationInput

	noSmithyDocumentSerde
}

func (*InvocationInputMemberMemberApiInvocationInput) isInvocationInputMember() {}

// Contains information about the function that the agent predicts should be
// called.
type InvocationInputMemberMemberFunctionInvocationInput struct {
	Value FunctionInvocationInput

	noSmithyDocumentSerde
}

func (*InvocationInputMemberMemberFunctionInvocationInput) isInvocationInputMember() {}

// A result from the invocation of an action. For more information, see [Return control to the agent developer] and [Control session context].
//
// This data type is used in the following API operations:
//
// [InvokeAgent request]
//
// The following types satisfy this interface:
//
//	InvocationResultMemberMemberApiResult
//	InvocationResultMemberMemberFunctionResult
//
// [InvokeAgent request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_RequestSyntax
// [Return control to the agent developer]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html
// [Control session context]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html
type InvocationResultMember interface {
	isInvocationResultMember()
}

// The result from the API response from the action group invocation.
type InvocationResultMemberMemberApiResult struct {
	Value ApiResult

	noSmithyDocumentSerde
}

func (*InvocationResultMemberMemberApiResult) isInvocationResultMember() {}

// The result from the function from the action group invocation.
type InvocationResultMemberMemberFunctionResult struct {
	Value FunctionResult

	noSmithyDocumentSerde
}

func (*InvocationResultMemberMemberFunctionResult) isInvocationResultMember() {}

// Stores fine-grained state checkpoints, including text and images, for each
// interaction in an invocation in a session. For more information about sessions,
// see [Store and retrieve conversation history and context with Amazon Bedrock sessions].
//
// [Store and retrieve conversation history and context with Amazon Bedrock sessions]: https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html
type InvocationStep struct {

	// The unique identifier (in UUID format) for the invocation that includes the
	// invocation step.
	//
	// This member is required.
	InvocationId *string

	// The unique identifier (in UUID format) for the invocation step.
	//
	// This member is required.
	InvocationStepId *string

	// The timestamp for when the invocation step was created.
	//
	// This member is required.
	InvocationStepTime *time.Time

	// Payload content, such as text and images, for the invocation step.
	//
	// This member is required.
	Payload InvocationStepPayload

	// The unique identifier of the session containing the invocation step.
	//
	// This member is required.
	SessionId *string

	noSmithyDocumentSerde
}

// Payload content, such as text and images, for the invocation step.
//
// The following types satisfy this interface:
//
//	InvocationStepPayloadMemberContentBlocks
type InvocationStepPayload interface {
	isInvocationStepPayload()
}

// The content for the invocation step.
type InvocationStepPayloadMemberContentBlocks struct {
	Value []BedrockSessionContentBlock

	noSmithyDocumentSerde
}

func (*InvocationStepPayloadMemberContentBlocks) isInvocationStepPayload() {}

// Contains details about an invocation step within an invocation in a session.
// For more information about sessions, see [Store and retrieve conversation history and context with Amazon Bedrock sessions].
//
// [Store and retrieve conversation history and context with Amazon Bedrock sessions]: https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html
type InvocationStepSummary struct {

	// A unique identifier for the invocation in UUID format.
	//
	// This member is required.
	InvocationId *string

	// The unique identifier (in UUID format) for the invocation step.
	//
	// This member is required.
	InvocationStepId *string

	// The timestamp for when the invocation step was created.
	//
	// This member is required.
	InvocationStepTime *time.Time

	// The unique identifier for the session associated with the invocation step.
	//
	// This member is required.
	SessionId *string

	noSmithyDocumentSerde
}

// Contains details about an invocation in a session. For more information about
// sessions, see [Store and retrieve conversation history and context with Amazon Bedrock sessions].
//
// [Store and retrieve conversation history and context with Amazon Bedrock sessions]: https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html
type InvocationSummary struct {

	// The timestamp for when the invocation was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// A unique identifier for the invocation in UUID format.
	//
	// This member is required.
	InvocationId *string

	// The unique identifier for the session associated with the invocation.
	//
	// This member is required.
	SessionId *string

	noSmithyDocumentSerde
}

// Details of the knowledge base associated withe inline agent.
type KnowledgeBase struct {

	//  The description of the knowledge base associated with the inline agent.
	//
	// This member is required.
	Description *string

	//  The unique identifier for a knowledge base associated with the inline agent.
	//
	// This member is required.
	KnowledgeBaseId *string

	//  The configurations to apply to the knowledge base during query. For more
	// information, see [Query configurations].
	//
	// [Query configurations]: https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html
	RetrievalConfiguration *KnowledgeBaseRetrievalConfiguration

	noSmithyDocumentSerde
}

// Configurations to apply to a knowledge base attached to the agent during query.
// For more information, see [Knowledge base retrieval configurations].
//
// [Knowledge base retrieval configurations]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html#session-state-kb
type KnowledgeBaseConfiguration struct {

	// The unique identifier for a knowledge base attached to the agent.
	//
	// This member is required.
	KnowledgeBaseId *string

	// The configurations to apply to the knowledge base during query. For more
	// information, see [Query configurations].
	//
	// [Query configurations]: https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html
	//
	// This member is required.
	RetrievalConfiguration *KnowledgeBaseRetrievalConfiguration

	noSmithyDocumentSerde
}

// Contains details about the knowledge base to look up and the query to be made.
type KnowledgeBaseLookupInput struct {

	// The unique identifier of the knowledge base to look up.
	KnowledgeBaseId *string

	// The query made to the knowledge base.
	Text *string

	noSmithyDocumentSerde
}

// Contains details about the results from looking up the knowledge base.
type KnowledgeBaseLookupOutput struct {

	// Contains information about the knowledge base output.
	Metadata *Metadata

	// Contains metadata about the sources cited for the generated response.
	RetrievedReferences []RetrievedReference

	noSmithyDocumentSerde
}

// Contains the query made to the knowledge base.
//
// This data type is used in the following API operations:
//
// [Retrieve request]
//   - – in the retrievalQuery field
//
// [Retrieve request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax
type KnowledgeBaseQuery struct {

	// An image to include in the knowledge base query for multimodal retrieval.
	Image *InputImage

	// The text of the query made to the knowledge base.
	Text *string

	// The type of query being performed.
	Type KnowledgeBaseQueryType

	noSmithyDocumentSerde
}

// Contains configurations for knowledge base query. For more information, see [Query configurations].
//
// This data type is used in the following API operations:
//
// [Retrieve request]
//   - – in the retrievalConfiguration field
//
// [RetrieveAndGenerate request]
//   - – in the retrievalConfiguration field
//
// [RetrieveAndGenerate request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax
// [Retrieve request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax
// [Query configurations]: https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html
type KnowledgeBaseRetrievalConfiguration struct {

	// Contains details about how the results from the vector search should be
	// returned. For more information, see [Query configurations].
	//
	// [Query configurations]: https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html
	//
	// This member is required.
	VectorSearchConfiguration *KnowledgeBaseVectorSearchConfiguration

	noSmithyDocumentSerde
}

// Details about a result from querying the knowledge base.
//
// This data type is used in the following API operations:
//
// [Retrieve response]
//   - – in the retrievalResults field
//
// [Retrieve response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax
type KnowledgeBaseRetrievalResult struct {

	// Contains information about the content of the chunk.
	//
	// This member is required.
	Content *RetrievalResultContent

	// Contains information about the location of the data source.
	Location *RetrievalResultLocation

	// Contains metadata attributes and their values for the file in the data source.
	// For more information, see [Metadata and filtering].
	//
	// [Metadata and filtering]: https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-ds.html#kb-ds-metadata
	Metadata map[string]document.Interface

	// The level of relevance of the result to the query.
	Score *float64

	noSmithyDocumentSerde
}

// Contains details about the resource being queried.
//
// This data type is used in the following API operations:
//
// [Retrieve request]
//   - – in the knowledgeBaseConfiguration field
//
// [RetrieveAndGenerate request]
//   - – in the knowledgeBaseConfiguration field
//
// [RetrieveAndGenerate request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax
// [Retrieve request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax
type KnowledgeBaseRetrieveAndGenerateConfiguration struct {

	// The unique identifier of the knowledge base that is queried.
	//
	// This member is required.
	KnowledgeBaseId *string

	// The ARN of the foundation model or [inference profile] used to generate a response.
	//
	// [inference profile]: https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html
	//
	// This member is required.
	ModelArn *string

	// Contains configurations for response generation based on the knowledge base
	// query results.
	GenerationConfiguration *GenerationConfiguration

	// Settings for how the model processes the prompt prior to retrieval and
	// generation.
	OrchestrationConfiguration *OrchestrationConfiguration

	// Contains configurations for how to retrieve and return the knowledge base query.
	RetrievalConfiguration *KnowledgeBaseRetrievalConfiguration

	noSmithyDocumentSerde
}

// Configurations for how to perform the search query and return results. For more
// information, see [Query configurations].
//
// This data type is used in the following API operations:
//
// [Retrieve request]
//   - – in the vectorSearchConfiguration field
//
// [RetrieveAndGenerate request]
//   - – in the vectorSearchConfiguration field
//
// [RetrieveAndGenerate request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax
// [Retrieve request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax
// [Query configurations]: https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html
type KnowledgeBaseVectorSearchConfiguration struct {

	// Specifies the filters to use on the metadata in the knowledge base data sources
	// before returning results. For more information, see [Query configurations].
	//
	// [Query configurations]: https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html
	Filter RetrievalFilter

	// Settings for implicit filtering.
	ImplicitFilterConfiguration *ImplicitFilterConfiguration

	// The number of source chunks to retrieve.
	NumberOfResults *int32

	// By default, Amazon Bedrock decides a search strategy for you. If you're using
	// an Amazon OpenSearch Serverless vector store that contains a filterable text
	// field, you can specify whether to query the knowledge base with a HYBRID search
	// using both vector embeddings and raw text, or SEMANTIC search using only vector
	// embeddings. For other vector store configurations, only SEMANTIC search is
	// available. For more information, see [Test a knowledge base].
	//
	// [Test a knowledge base]: https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-test.html
	OverrideSearchType SearchType

	// Contains configurations for reranking the retrieved results. For more
	// information, see [Improve the relevance of query responses with a reranker model].
	//
	// [Improve the relevance of query responses with a reranker model]: https://docs.aws.amazon.com/bedrock/latest/userguide/rerank.html
	RerankingConfiguration *VectorSearchRerankingConfiguration

	noSmithyDocumentSerde
}

// Contains sessions summaries.
//
// The following types satisfy this interface:
//
//	MemoryMemberSessionSummary
type Memory interface {
	isMemory()
}

// Contains summary of a session.
type MemoryMemberSessionSummary struct {
	Value MemorySessionSummary

	noSmithyDocumentSerde
}

func (*MemoryMemberSessionSummary) isMemory() {}

// Contains details of a session summary.
type MemorySessionSummary struct {

	// The unique identifier of the memory where the session summary is stored.
	MemoryId *string

	// The time when the memory duration for the session is set to end.
	SessionExpiryTime *time.Time

	// The identifier for this session.
	SessionId *string

	// The start time for this session.
	SessionStartTime *time.Time

	// The summarized text for this session.
	SummaryText *string

	noSmithyDocumentSerde
}

// Details about a message.
type Message struct {

	// The message's content.
	//
	// This member is required.
	Content []ContentBlock

	// The message's role.
	//
	// This member is required.
	Role ConversationRole

	noSmithyDocumentSerde
}

// Provides information about the execution process for different types of
// invocations, such as model invocation, knowledge base invocation, agent
// collaborator invocation, guardrail invocation, and code interpreter Invocation.
type Metadata struct {

	// A unique identifier associated with the downstream invocation. This ID can be
	// used for tracing, debugging, and identifying specific invocations in customer
	// logs or systems.
	ClientRequestId *string

	// In the final response, endTime is the end time of the agent invocation
	// operation.
	EndTime *time.Time

	// The total time it took for the agent to complete execution. This field is only
	// set for the final response.
	OperationTotalTimeMs *int64

	// In the final response, startTime is the start time of the agent invocation
	// operation.
	StartTime *time.Time

	//  The total execution time for the specific invocation being processed (model,
	// knowledge base, guardrail, agent collaborator, or code interpreter). It
	// represents how long the individual invocation took.
	TotalTimeMs *int64

	// Specific to model invocation and contains details about the usage of a
	// foundation model.
	Usage *Usage

	noSmithyDocumentSerde
}

// Details about a metadata attribute.
type MetadataAttributeSchema struct {

	// The attribute's description.
	//
	// This member is required.
	Description *string

	// The attribute's key.
	//
	// This member is required.
	Key *string

	// The attribute's type.
	//
	// This member is required.
	Type AttributeType

	noSmithyDocumentSerde
}

// Contains configurations for the metadata to use in reranking.
type MetadataConfigurationForReranking struct {

	// Specifies whether to consider all metadata when reranking, or only the metadata
	// that you select. If you specify SELECTIVE , include the
	// selectiveModeConfiguration field.
	//
	// This member is required.
	SelectionMode RerankingMetadataSelectionMode

	// Contains configurations for the metadata fields to include or exclude when
	// considering reranking.
	SelectiveModeConfiguration RerankingMetadataSelectiveModeConfiguration

	noSmithyDocumentSerde
}

// The input for the pre-processing step.
//
//   - The type matches the agent step.
//
//   - The text contains the prompt.
//
//   - The inferenceConfiguration , parserMode , and overrideLambda values are set
//     in the [PromptOverrideConfiguration]object that was set when the agent was created or updated.
//
// [PromptOverrideConfiguration]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html
type ModelInvocationInput struct {

	// The identifier of a foundation model.
	FoundationModel *string

	// Specifications about the inference parameters that were provided alongside the
	// prompt. These are specified in the [PromptOverrideConfiguration]object that was set when the agent was
	// created or updated. For more information, see [Inference parameters for foundation models].
	//
	// [Inference parameters for foundation models]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html
	// [PromptOverrideConfiguration]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html
	InferenceConfiguration *InferenceConfiguration

	// The ARN of the Lambda function to use when parsing the raw foundation model
	// output in parts of the agent sequence.
	OverrideLambda *string

	// Specifies whether to override the default parser Lambda function when parsing
	// the raw foundation model output in the part of the agent sequence defined by the
	// promptType .
	ParserMode CreationMode

	// Specifies whether the default prompt template was OVERRIDDEN . If it was, the
	// basePromptTemplate that was set in the [PromptOverrideConfiguration] object when the agent was created or
	// updated is used instead.
	//
	// [PromptOverrideConfiguration]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html
	PromptCreationMode CreationMode

	// The text that prompted the agent at this step.
	Text *string

	// The unique identifier of the trace.
	TraceId *string

	// The step in the agent sequence.
	Type PromptType

	noSmithyDocumentSerde
}

// The performance configuration for a model called with InvokeFlow.
type ModelPerformanceConfiguration struct {

	// The latency configuration for the model.
	PerformanceConfig *PerformanceConfiguration

	noSmithyDocumentSerde
}

// Contains information about an action (operation) called by a node during
// execution.
type NodeActionEvent struct {

	// The name of the node that called the operation.
	//
	// This member is required.
	NodeName *string

	// The name of the operation that the node called.
	//
	// This member is required.
	OperationName *string

	// The ID of the request that the node made to the operation.
	//
	// This member is required.
	RequestId *string

	// The name of the service that the node called.
	//
	// This member is required.
	ServiceName *string

	// The date and time that the operation was called.
	//
	// This member is required.
	Timestamp *time.Time

	// The request payload sent to the downstream service.
	OperationRequest document.Interface

	// The response payload received from the downstream service.
	OperationResponse document.Interface

	noSmithyDocumentSerde
}

// Contains information about an internal trace of a specific node during
// execution.
type NodeDependencyEvent struct {

	// The name of the node that generated the dependency trace.
	//
	// This member is required.
	NodeName *string

	// The date and time that the dependency trace was generated.
	//
	// This member is required.
	Timestamp *time.Time

	// The trace elements containing detailed information about the node execution.
	//
	// This member is required.
	TraceElements NodeTraceElements

	noSmithyDocumentSerde
}

// Contains the content of a flow node's input or output field for a flow
// execution.
//
// Flow executions is in preview release for Amazon Bedrock and is subject to
// change.
//
// The following types satisfy this interface:
//
//	NodeExecutionContentMemberDocument
type NodeExecutionContent interface {
	isNodeExecutionContent()
}

// The document content of the field, which can contain text or structured data.
type NodeExecutionContentMemberDocument struct {
	Value document.Interface

	noSmithyDocumentSerde
}

func (*NodeExecutionContentMemberDocument) isNodeExecutionContent() {}

// Contains information about a failure that occurred at a specific node during a
// flow execution.
//
// Flow executions is in preview release for Amazon Bedrock and is subject to
// change.
type NodeFailureEvent struct {

	// The error code that identifies the type of failure that occurred at the node.
	//
	// This member is required.
	ErrorCode NodeErrorCode

	// A descriptive message that provides details about the node failure.
	//
	// This member is required.
	ErrorMessage *string

	// The name of the node where the failure occurred.
	//
	// This member is required.
	NodeName *string

	// The timestamp when the node failure occurred.
	//
	// This member is required.
	Timestamp *time.Time

	noSmithyDocumentSerde
}

// Contains information about the inputs provided to a specific node during a flow
// execution.
//
// Flow executions is in preview release for Amazon Bedrock and is subject to
// change.
type NodeInputEvent struct {

	// A list of input fields provided to the node.
	//
	// This member is required.
	Fields []NodeInputField

	// The name of the node that received the inputs.
	//
	// This member is required.
	NodeName *string

	// The timestamp when the inputs were provided to the node.
	//
	// This member is required.
	Timestamp *time.Time

	noSmithyDocumentSerde
}

// Represents an item in the execution chain for node input tracking.
type NodeInputExecutionChainItem struct {

	// The name of the node in the execution chain.
	//
	// This member is required.
	NodeName *string

	// The type of execution chain item. Supported values are Iterator and Loop.
	//
	// This member is required.
	Type FlowControlNodeType

	// The index position of this item in the execution chain.
	Index *int32

	noSmithyDocumentSerde
}

// Represents an input field provided to a node during a flow execution.
type NodeInputField struct {

	// The content of the input field, which can contain text or structured data.
	//
	// This member is required.
	Content NodeExecutionContent

	// The name of the input field as defined in the node's input schema.
	//
	// This member is required.
	Name *string

	// The category of the input field.
	Category FlowNodeInputCategory

	// The execution path through nested nodes like iterators and loops.
	ExecutionChain []NodeInputExecutionChainItem

	// The source node that provides input data to this field.
	Source *NodeInputSource

	// The data type of the input field for compatibility validation.
	Type FlowNodeIODataType

	noSmithyDocumentSerde
}

// Represents the source of input data for a node field.
type NodeInputSource struct {

	// The expression used to extract data from the source.
	//
	// This member is required.
	Expression *string

	// The name of the source node that provides the input data.
	//
	// This member is required.
	NodeName *string

	// The name of the output field from the source node.
	//
	// This member is required.
	OutputFieldName *string

	noSmithyDocumentSerde
}

// Contains information about the outputs produced by a specific node during a
// flow execution.
//
// Flow executions is in preview release for Amazon Bedrock and is subject to
// change.
type NodeOutputEvent struct {

	// A list of output fields produced by the node.
	//
	// This member is required.
	Fields []NodeOutputField

	// The name of the node that produced the outputs.
	//
	// This member is required.
	NodeName *string

	// The timestamp when the outputs were produced by the node.
	//
	// This member is required.
	Timestamp *time.Time

	noSmithyDocumentSerde
}

// Represents an output field produced by a node during a flow execution.
//
// Flow executions is in preview release for Amazon Bedrock and is subject to
// change.
type NodeOutputField struct {

	// The content of the output field, which can contain text or structured data.
	//
	// This member is required.
	Content NodeExecutionContent

	// The name of the output field as defined in the node's output schema.
	//
	// This member is required.
	Name *string

	// The next node that receives output data from this field.
	Next []NodeOutputNext

	// The data type of the output field for compatibility validation.
	Type FlowNodeIODataType

	noSmithyDocumentSerde
}

// Represents the next node that receives output data.
type NodeOutputNext struct {

	// The name of the input field in the next node that receives the data.
	//
	// This member is required.
	InputFieldName *string

	// The name of the next node that receives the output data.
	//
	// This member is required.
	NodeName *string

	noSmithyDocumentSerde
}

// Contains trace elements for node execution tracking.
//
// The following types satisfy this interface:
//
//	NodeTraceElementsMemberAgentTraces
type NodeTraceElements interface {
	isNodeTraceElements()
}

// Agent trace information for the node execution.
type NodeTraceElementsMemberAgentTraces struct {
	Value []TracePart

	noSmithyDocumentSerde
}

func (*NodeTraceElementsMemberAgentTraces) isNodeTraceElements() {}

// Contains the result or output of an action group or knowledge base, or the
// response to the user.
type Observation struct {

	// Contains the JSON-formatted string returned by the API invoked by the action
	// group.
	ActionGroupInvocationOutput *ActionGroupInvocationOutput

	// A collaborator's invocation output.
	AgentCollaboratorInvocationOutput *AgentCollaboratorInvocationOutput

	// Contains the JSON-formatted string returned by the API invoked by the code
	// interpreter.
	CodeInterpreterInvocationOutput *CodeInterpreterInvocationOutput

	// Contains details about the response to the user.
	FinalResponse *FinalResponse

	// Contains details about the results from looking up the knowledge base.
	KnowledgeBaseLookupOutput *KnowledgeBaseLookupOutput

	// Contains details about the response to reprompt the input.
	RepromptResponse *RepromptResponse

	// The unique identifier of the trace.
	TraceId *string

	// Specifies what kind of information the agent returns in the observation. The
	// following values are possible.
	//
	//   - ACTION_GROUP – The agent returns the result of an action group.
	//
	//   - KNOWLEDGE_BASE – The agent returns information from a knowledge base.
	//
	//   - FINISH – The agent returns a final response to the user with no follow-up.
	//
	//   - ASK_USER – The agent asks the user a question.
	//
	//   - REPROMPT – The agent prompts the user again for the same information.
	Type Type

	noSmithyDocumentSerde
}

// Contains information about the optimized prompt.
//
// The following types satisfy this interface:
//
//	OptimizedPromptMemberTextPrompt
type OptimizedPrompt interface {
	isOptimizedPrompt()
}

// Contains information about the text in the prompt that was optimized.
type OptimizedPromptMemberTextPrompt struct {
	Value TextPrompt

	noSmithyDocumentSerde
}

func (*OptimizedPromptMemberTextPrompt) isOptimizedPrompt() {}

// An event in which the prompt was optimized.
type OptimizedPromptEvent struct {

	// Contains information about the optimized prompt.
	OptimizedPrompt OptimizedPrompt

	noSmithyDocumentSerde
}

// The stream containing events in the prompt optimization process.
//
// The following types satisfy this interface:
//
//	OptimizedPromptStreamMemberAnalyzePromptEvent
//	OptimizedPromptStreamMemberOptimizedPromptEvent
type OptimizedPromptStream interface {
	isOptimizedPromptStream()
}

// An event in which the prompt was analyzed in preparation for optimization.
type OptimizedPromptStreamMemberAnalyzePromptEvent struct {
	Value AnalyzePromptEvent

	noSmithyDocumentSerde
}

func (*OptimizedPromptStreamMemberAnalyzePromptEvent) isOptimizedPromptStream() {}

// An event in which the prompt was optimized.
type OptimizedPromptStreamMemberOptimizedPromptEvent struct {
	Value OptimizedPromptEvent

	noSmithyDocumentSerde
}

func (*OptimizedPromptStreamMemberOptimizedPromptEvent) isOptimizedPromptStream() {}

// Settings for how the model processes the prompt prior to retrieval and
// generation.
type OrchestrationConfiguration struct {

	//  Additional model parameters and corresponding values not included in the
	// textInferenceConfig structure for a knowledge base. This allows users to provide
	// custom model parameters specific to the language model being used.
	AdditionalModelRequestFields map[string]document.Interface

	//  Configuration settings for inference when using RetrieveAndGenerate to
	// generate responses while using a knowledge base as a source.
	InferenceConfig *InferenceConfig

	// The latency configuration for the model.
	PerformanceConfig *PerformanceConfiguration

	// Contains the template for the prompt that's sent to the model. Orchestration
	// prompts must include the $conversation_history$ and
	// $output_format_instructions$ variables. For more information, see [Use placeholder variables] in the user
	// guide.
	//
	// [Use placeholder variables]: https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html
	PromptTemplate *PromptTemplate

	// To split up the prompt and retrieve multiple sources, set the transformation
	// type to QUERY_DECOMPOSITION .
	QueryTransformationConfiguration *QueryTransformationConfiguration

	noSmithyDocumentSerde
}

// The structure of the executor invoking the actions in custom orchestration.
//
// The following types satisfy this interface:
//
//	OrchestrationExecutorMemberLambda
type OrchestrationExecutor interface {
	isOrchestrationExecutor()
}

// The Amazon Resource Name (ARN) of the Lambda function containing the business
// logic that is carried out upon invoking the action.
type OrchestrationExecutorMemberLambda struct {
	Value string

	noSmithyDocumentSerde
}

func (*OrchestrationExecutorMemberLambda) isOrchestrationExecutor() {}

// The foundation model output from the orchestration step.
type OrchestrationModelInvocationOutput struct {

	// Contains information about the foundation model output from the orchestration
	// step.
	Metadata *Metadata

	// Contains details of the raw response from the foundation model output.
	RawResponse *RawResponse

	// Contains content about the reasoning that the model made during the
	// orchestration step.
	ReasoningContent ReasoningContentBlock

	// The unique identifier of the trace.
	TraceId *string

	noSmithyDocumentSerde
}

// Details about the orchestration step, in which the agent determines the order
// in which actions are executed and which knowledge bases are retrieved.
//
// The following types satisfy this interface:
//
//	OrchestrationTraceMemberInvocationInput
//	OrchestrationTraceMemberModelInvocationInput
//	OrchestrationTraceMemberModelInvocationOutput
//	OrchestrationTraceMemberObservation
//	OrchestrationTraceMemberRationale
type OrchestrationTrace interface {
	isOrchestrationTrace()
}

// Contains information pertaining to the action group or knowledge base that is
// being invoked.
type OrchestrationTraceMemberInvocationInput struct {
	Value InvocationInput

	noSmithyDocumentSerde
}

func (*OrchestrationTraceMemberInvocationInput) isOrchestrationTrace() {}

// The input for the orchestration step.
//
//   - The type is ORCHESTRATION .
//
//   - The text contains the prompt.
//
//   - The inferenceConfiguration , parserMode , and overrideLambda values are set
//     in the [PromptOverrideConfiguration]object that was set when the agent was created or updated.
//
// [PromptOverrideConfiguration]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html
type OrchestrationTraceMemberModelInvocationInput struct {
	Value ModelInvocationInput

	noSmithyDocumentSerde
}

func (*OrchestrationTraceMemberModelInvocationInput) isOrchestrationTrace() {}

// Contains information pertaining to the output from the foundation model that is
// being invoked.
type OrchestrationTraceMemberModelInvocationOutput struct {
	Value OrchestrationModelInvocationOutput

	noSmithyDocumentSerde
}

func (*OrchestrationTraceMemberModelInvocationOutput) isOrchestrationTrace() {}

// Details about the observation (the output of the action group Lambda or
// knowledge base) made by the agent.
type OrchestrationTraceMemberObservation struct {
	Value Observation

	noSmithyDocumentSerde
}

func (*OrchestrationTraceMemberObservation) isOrchestrationTrace() {}

// Details about the reasoning, based on the input, that the agent uses to justify
// carrying out an action group or getting information from a knowledge base.
type OrchestrationTraceMemberRationale struct {
	Value Rationale

	noSmithyDocumentSerde
}

func (*OrchestrationTraceMemberRationale) isOrchestrationTrace() {}

// Contains details of the response from code interpreter.
type OutputFile struct {

	// The byte count of files that contains response from code interpreter.
	Bytes []byte

	// The name of the file containing response from code interpreter.
	Name *string

	// The type of file that contains response from the code interpreter.
	Type *string

	noSmithyDocumentSerde
}

// A parameter for the API request or function.
type Parameter struct {

	// The name of the parameter.
	Name *string

	// The type of the parameter.
	Type *string

	// The value of the parameter.
	Value *string

	noSmithyDocumentSerde
}

// Contains details about a parameter in a function for an action group.
type ParameterDetail struct {

	//  The data type of the parameter.
	//
	// This member is required.
	Type ParameterType

	//  A description of the parameter. Helps the foundation model determine how to
	// elicit the parameters from the user.
	Description *string

	//  Whether the parameter is required for the agent to complete the function for
	// action group invocation.
	Required *bool

	noSmithyDocumentSerde
}

// Contains a part of an agent response and citations for it.
type PayloadPart struct {

	// Contains citations for a part of an agent response.
	Attribution *Attribution

	// A part of the agent response in bytes.
	Bytes []byte

	noSmithyDocumentSerde
}

// Performance settings for a model.
type PerformanceConfiguration struct {

	// To use a latency-optimized version of the model, set to optimized .
	Latency PerformanceConfigLatency

	noSmithyDocumentSerde
}

// The foundation model output from the post-processing step.
type PostProcessingModelInvocationOutput struct {

	//  Contains information about the foundation model output from the
	// post-processing step.
	Metadata *Metadata

	// Details about the response from the Lambda parsing of the output of the
	// post-processing step.
	ParsedResponse *PostProcessingParsedResponse

	//  Details of the raw response from the foundation model output.
	RawResponse *RawResponse

	// Contains content about the reasoning that the model made during the
	// post-processing step.
	ReasoningContent ReasoningContentBlock

	// The unique identifier of the trace.
	TraceId *string

	noSmithyDocumentSerde
}

// Details about the response from the Lambda parsing of the output from the
// post-processing step.
type PostProcessingParsedResponse struct {

	// The text returned by the parser.
	Text *string

	noSmithyDocumentSerde
}

// Details about the post-processing step, in which the agent shapes the response.
//
// The following types satisfy this interface:
//
//	PostProcessingTraceMemberModelInvocationInput
//	PostProcessingTraceMemberModelInvocationOutput
type PostProcessingTrace interface {
	isPostProcessingTrace()
}

// The input for the post-processing step.
//
//   - The type is POST_PROCESSING .
//
//   - The text contains the prompt.
//
//   - The inferenceConfiguration , parserMode , and overrideLambda values are set
//     in the [PromptOverrideConfiguration]object that was set when the agent was created or updated.
//
// [PromptOverrideConfiguration]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html
type PostProcessingTraceMemberModelInvocationInput struct {
	Value ModelInvocationInput

	noSmithyDocumentSerde
}

func (*PostProcessingTraceMemberModelInvocationInput) isPostProcessingTrace() {}

// The foundation model output from the post-processing step.
type PostProcessingTraceMemberModelInvocationOutput struct {
	Value PostProcessingModelInvocationOutput

	noSmithyDocumentSerde
}

func (*PostProcessingTraceMemberModelInvocationOutput) isPostProcessingTrace() {}

// The foundation model output from the pre-processing step.
type PreProcessingModelInvocationOutput struct {

	//  Contains information about the foundation model output from the pre-processing
	// step.
	Metadata *Metadata

	// Details about the response from the Lambda parsing of the output of the
	// pre-processing step.
	ParsedResponse *PreProcessingParsedResponse

	//  Details of the raw response from the foundation model output.
	RawResponse *RawResponse

	// Contains content about the reasoning that the model made during the
	// pre-processing step.
	ReasoningContent ReasoningContentBlock

	// The unique identifier of the trace.
	TraceId *string

	noSmithyDocumentSerde
}

// Details about the response from the Lambda parsing of the output from the
// pre-processing step.
type PreProcessingParsedResponse struct {

	// Whether the user input is valid or not. If false , the agent doesn't proceed to
	// orchestration.
	IsValid *bool

	// The text returned by the parsing of the pre-processing step, explaining the
	// steps that the agent plans to take in orchestration, if the user input is valid.
	Rationale *string

	noSmithyDocumentSerde
}

// Details about the pre-processing step, in which the agent contextualizes and
// categorizes user inputs.
//
// The following types satisfy this interface:
//
//	PreProcessingTraceMemberModelInvocationInput
//	PreProcessingTraceMemberModelInvocationOutput
type PreProcessingTrace interface {
	isPreProcessingTrace()
}

// The input for the pre-processing step.
//
//   - The type is PRE_PROCESSING .
//
//   - The text contains the prompt.
//
//   - The inferenceConfiguration , parserMode , and overrideLambda values are set
//     in the [PromptOverrideConfiguration]object that was set when the agent was created or updated.
//
// [PromptOverrideConfiguration]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html
type PreProcessingTraceMemberModelInvocationInput struct {
	Value ModelInvocationInput

	noSmithyDocumentSerde
}

func (*PreProcessingTraceMemberModelInvocationInput) isPreProcessingTrace() {}

// The foundation model output from the pre-processing step.
type PreProcessingTraceMemberModelInvocationOutput struct {
	Value PreProcessingModelInvocationOutput

	noSmithyDocumentSerde
}

func (*PreProcessingTraceMemberModelInvocationOutput) isPreProcessingTrace() {}

//	Contains configurations to override a prompt template in one part of an agent
//
// sequence. For more information, see [Advanced prompts].
//
// [Advanced prompts]: https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html
type PromptConfiguration struct {

	// If the Converse or ConverseStream operations support the model,
	// additionalModelRequestFields contains additional inference parameters, beyond
	// the base set of inference parameters in the inferenceConfiguration field.
	//
	// For more information, see Inference request parameters and response fields for
	// foundation models in the Amazon Bedrock user guide.
	AdditionalModelRequestFields document.Interface

	// Defines the prompt template with which to replace the default prompt template.
	// You can use placeholder variables in the base prompt template to customize the
	// prompt. For more information, see [Prompt template placeholder variables]. For more information, see [Configure the prompt templates].
	//
	// [Configure the prompt templates]: https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts-configure.html
	// [Prompt template placeholder variables]: https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html
	BasePromptTemplate *string

	//  The foundation model to use.
	FoundationModel *string

	// Contains inference parameters to use when the agent invokes a foundation model
	// in the part of the agent sequence defined by the promptType . For more
	// information, see [Inference parameters for foundation models].
	//
	// [Inference parameters for foundation models]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html
	InferenceConfiguration *InferenceConfiguration

	// Specifies whether to override the default parser Lambda function when parsing
	// the raw foundation model output in the part of the agent sequence defined by the
	// promptType . If you set the field as OVERRIDDEN , the overrideLambda field in
	// the [PromptOverrideConfiguration]must be specified with the ARN of a Lambda function.
	//
	// [PromptOverrideConfiguration]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html
	ParserMode CreationMode

	// Specifies whether to override the default prompt template for this promptType .
	// Set this value to OVERRIDDEN to use the prompt that you provide in the
	// basePromptTemplate . If you leave it as DEFAULT , the agent uses a default
	// prompt template.
	PromptCreationMode CreationMode

	// Specifies whether to allow the inline agent to carry out the step specified in
	// the promptType . If you set this value to DISABLED , the agent skips that step.
	// The default state for each promptType is as follows.
	//
	//   - PRE_PROCESSING – ENABLED
	//
	//   - ORCHESTRATION – ENABLED
	//
	//   - KNOWLEDGE_BASE_RESPONSE_GENERATION – ENABLED
	//
	//   - POST_PROCESSING – DISABLED
	PromptState PromptState

	//  The step in the agent sequence that this prompt configuration applies to.
	PromptType PromptType

	noSmithyDocumentSerde
}

// Specifies parameters that control how the service populates the agent prompt
// for an InvokeAgent or InvokeInlineAgent request. You can control which aspects
// of previous invocations in the same agent session the service uses to populate
// the agent prompt. This gives you more granular control over the contextual
// history that is used to process the current request.
type PromptCreationConfigurations struct {

	// If true , the service removes any content between <thinking> tags from previous
	// conversations in an agent session. The service will only remove content from
	// already processed turns. This helps you remove content which might not be useful
	// for current and subsequent invocations. This can reduce the input token count
	// and potentially save costs. The default value is false .
	ExcludePreviousThinkingSteps bool

	// The number of previous conversations from the ongoing agent session to include
	// in the conversation history of the agent prompt, during the current invocation.
	// This gives you more granular control over the context that the model is made
	// aware of, and helps the model remove older context which is no longer useful
	// during the ongoing agent session.
	PreviousConversationTurnsToInclude *int32

	noSmithyDocumentSerde
}

// Contains configurations to override prompts in different parts of an agent
// sequence. For more information, see [Advanced prompts].
//
// [Advanced prompts]: https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html
type PromptOverrideConfiguration struct {

	// Contains configurations to override a prompt template in one part of an agent
	// sequence. For more information, see [Advanced prompts].
	//
	// [Advanced prompts]: https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html
	//
	// This member is required.
	PromptConfigurations []PromptConfiguration

	// The ARN of the Lambda function to use when parsing the raw foundation model
	// output in parts of the agent sequence. If you specify this field, at least one
	// of the promptConfigurations must contain a parserMode value that is set to
	// OVERRIDDEN . For more information, see [Parser Lambda function in Amazon Bedrock Agents].
	//
	// [Parser Lambda function in Amazon Bedrock Agents]: https://docs.aws.amazon.com/bedrock/latest/userguide/lambda-parser.html
	OverrideLambda *string

	noSmithyDocumentSerde
}

// Contains the template for the prompt that's sent to the model for response
// generation. For more information, see [Knowledge base prompt templates].
//
// This data type is used in the following API operations:
//
// [RetrieveAndGenerate request]
//   - – in the filter field
//
// [RetrieveAndGenerate request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax
// [Knowledge base prompt templates]: https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html#kb-test-config-sysprompt
type PromptTemplate struct {

	// The template for the prompt that's sent to the model for response generation.
	// You can include prompt placeholders, which become replaced before the prompt is
	// sent to the model to provide instructions and context to the model. In addition,
	// you can include XML tags to delineate meaningful sections of the prompt
	// template.
	//
	// For more information, see the following resources:
	//
	// [Knowledge base prompt templates]
	//
	// [Use XML tags with Anthropic Claude models]
	//
	// [Use XML tags with Anthropic Claude models]: https://docs.claude.com/en/docs/build-with-claude/prompt-engineering/use-xml-tags
	// [Knowledge base prompt templates]: https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html#kb-test-config-sysprompt
	TextPromptTemplate *string

	noSmithyDocumentSerde
}

// Contains the parameters in the request body.
type PropertyParameters struct {

	// A list of parameters in the request body.
	Properties []Parameter

	noSmithyDocumentSerde
}

// Contains information about a natural language query to transform into SQL.
type QueryGenerationInput struct {

	// The text of the query.
	//
	// This member is required.
	Text *string

	// The type of the query.
	//
	// This member is required.
	Type InputQueryType

	noSmithyDocumentSerde
}

// To split up the prompt and retrieve multiple sources, set the transformation
// type to QUERY_DECOMPOSITION .
type QueryTransformationConfiguration struct {

	// The type of transformation to apply to the prompt.
	//
	// This member is required.
	Type QueryTransformationType

	noSmithyDocumentSerde
}

// Contains the reasoning, based on the input, that the agent uses to justify
// carrying out an action group or getting information from a knowledge base.
type Rationale struct {

	// The reasoning or thought process of the agent, based on the input.
	Text *string

	// The unique identifier of the trace step.
	TraceId *string

	noSmithyDocumentSerde
}

// Contains the raw output from the foundation model.
type RawResponse struct {

	// The foundation model's raw output content.
	Content *string

	noSmithyDocumentSerde
}

// Contains content regarding the reasoning that the foundation model made with
// respect to the content in the content block. Reasoning refers to a Chain of
// Thought (CoT) that the model generates to enhance the accuracy of its final
// response.
//
// The following types satisfy this interface:
//
//	ReasoningContentBlockMemberReasoningText
//	ReasoningContentBlockMemberRedactedContent
type ReasoningContentBlock interface {
	isReasoningContentBlock()
}

// Contains information about the reasoning that the model used to return the
// content in the content block.
type ReasoningContentBlockMemberReasoningText struct {
	Value ReasoningTextBlock

	noSmithyDocumentSerde
}

func (*ReasoningContentBlockMemberReasoningText) isReasoningContentBlock() {}

// The content in the reasoning that was encrypted by the model provider for trust
// and safety reasons.
type ReasoningContentBlockMemberRedactedContent struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*ReasoningContentBlockMemberRedactedContent) isReasoningContentBlock() {}

// Contains information about the reasoning that the model used to return the
// content in the content block.
type ReasoningTextBlock struct {

	// Text describing the reasoning that the model used to return the content in the
	// content block.
	//
	// This member is required.
	Text *string

	// A hash of all the messages in the conversation to ensure that the content in
	// the reasoning text block isn't tampered with. You must submit the signature in
	// subsequent Converse requests, in addition to the previous messages. If the
	// previous messages are tampered with, the response throws an error.
	Signature *string

	noSmithyDocumentSerde
}

// Contains details about the agent's response to reprompt the input.
type RepromptResponse struct {

	// Specifies what output is prompting the agent to reprompt the input.
	Source Source

	// The text reprompting the input.
	Text *string

	noSmithyDocumentSerde
}

// The parameters in the API request body.
type RequestBody struct {

	// The content in the request body.
	Content map[string][]Parameter

	noSmithyDocumentSerde
}

// Contains information about a document to rerank. Choose the type to define and
// include the field that corresponds to the type.
type RerankDocument struct {

	// The type of document to rerank.
	//
	// This member is required.
	Type RerankDocumentType

	// Contains a JSON document to rerank.
	JsonDocument document.Interface

	// Contains information about a text document to rerank.
	TextDocument *RerankTextDocument

	noSmithyDocumentSerde
}

// Contains configurations for reranking.
type RerankingConfiguration struct {

	// Contains configurations for an Amazon Bedrock reranker.
	//
	// This member is required.
	BedrockRerankingConfiguration *BedrockRerankingConfiguration

	// The type of reranker that the configurations apply to.
	//
	// This member is required.
	Type RerankingConfigurationType

	noSmithyDocumentSerde
}

// Contains configurations for the metadata fields to include or exclude when
// considering reranking. If you include the fieldsToExclude field, the reranker
// ignores all the metadata fields that you specify. If you include the
// fieldsToInclude field, the reranker uses only the metadata fields that you
// specify and ignores all others. You can include only one of these fields.
//
// The following types satisfy this interface:
//
//	RerankingMetadataSelectiveModeConfigurationMemberFieldsToExclude
//	RerankingMetadataSelectiveModeConfigurationMemberFieldsToInclude
type RerankingMetadataSelectiveModeConfiguration interface {
	isRerankingMetadataSelectiveModeConfiguration()
}

// An array of objects, each of which specifies a metadata field to exclude from
// consideration when reranking.
type RerankingMetadataSelectiveModeConfigurationMemberFieldsToExclude struct {
	Value []FieldForReranking

	noSmithyDocumentSerde
}

func (*RerankingMetadataSelectiveModeConfigurationMemberFieldsToExclude) isRerankingMetadataSelectiveModeConfiguration() {
}

// An array of objects, each of which specifies a metadata field to include in
// consideration when reranking. The remaining metadata fields are ignored.
type RerankingMetadataSelectiveModeConfigurationMemberFieldsToInclude struct {
	Value []FieldForReranking

	noSmithyDocumentSerde
}

func (*RerankingMetadataSelectiveModeConfigurationMemberFieldsToInclude) isRerankingMetadataSelectiveModeConfiguration() {
}

// Contains information about a query to submit to the reranker model.
type RerankQuery struct {

	// Contains information about a text query.
	//
	// This member is required.
	TextQuery *RerankTextDocument

	// The type of the query.
	//
	// This member is required.
	Type RerankQueryContentType

	noSmithyDocumentSerde
}

// Contains information about a document that was reranked.
type RerankResult struct {

	// The original index of the document from the input sources array.
	//
	// This member is required.
	Index *int32

	// The relevance score of the document.
	//
	// This member is required.
	RelevanceScore *float32

	// Contains information about the document.
	Document *RerankDocument

	noSmithyDocumentSerde
}

// Contains information about a source for reranking.
type RerankSource struct {

	// Contains an inline definition of a source for reranking.
	//
	// This member is required.
	InlineDocumentSource *RerankDocument

	// The type of the source.
	//
	// This member is required.
	Type RerankSourceType

	noSmithyDocumentSerde
}

// Contains information about a text document to rerank.
type RerankTextDocument struct {

	// The text of the document.
	Text *string

	noSmithyDocumentSerde
}

// The response from invoking the agent and associated citations and trace
// information.
//
// The following types satisfy this interface:
//
//	ResponseStreamMemberChunk
//	ResponseStreamMemberFiles
//	ResponseStreamMemberReturnControl
//	ResponseStreamMemberTrace
type ResponseStream interface {
	isResponseStream()
}

// Contains a part of an agent response and citations for it.
type ResponseStreamMemberChunk struct {
	Value PayloadPart

	noSmithyDocumentSerde
}

func (*ResponseStreamMemberChunk) isResponseStream() {}

// Contains intermediate response for code interpreter if any files have been
// generated.
type ResponseStreamMemberFiles struct {
	Value FilePart

	noSmithyDocumentSerde
}

func (*ResponseStreamMemberFiles) isResponseStream() {}

// Contains the parameters and information that the agent elicited from the
// customer to carry out an action. This information is returned to the system and
// can be used in your own setup for fulfilling the action.
type ResponseStreamMemberReturnControl struct {
	Value ReturnControlPayload

	noSmithyDocumentSerde
}

func (*ResponseStreamMemberReturnControl) isResponseStream() {}

// Contains information about the agent and session, alongside the agent's
// reasoning process and results from calling actions and querying knowledge bases
// and metadata about the trace. You can use the trace to understand how the agent
// arrived at the response it provided the customer. For more information, see [Trace events].
//
// [Trace events]: https://docs.aws.amazon.com/bedrock/latest/userguide/trace-events.html
type ResponseStreamMemberTrace struct {
	Value TracePart

	noSmithyDocumentSerde
}

func (*ResponseStreamMemberTrace) isResponseStream() {}

// Specifies the filters to use on the metadata attributes in the knowledge base
// data sources before returning results. For more information, see [Query configurations]. See the
// examples below to see how to use these filters.
//
// This data type is used in the following API operations:
//
// [Retrieve request]
//   - – in the filter field
//
// [RetrieveAndGenerate request]
//   - – in the filter field
//
// The following types satisfy this interface:
//
//	RetrievalFilterMemberAndAll
//	RetrievalFilterMemberEquals
//	RetrievalFilterMemberGreaterThan
//	RetrievalFilterMemberGreaterThanOrEquals
//	RetrievalFilterMemberIn
//	RetrievalFilterMemberLessThan
//	RetrievalFilterMemberLessThanOrEquals
//	RetrievalFilterMemberListContains
//	RetrievalFilterMemberNotEquals
//	RetrievalFilterMemberNotIn
//	RetrievalFilterMemberOrAll
//	RetrievalFilterMemberStartsWith
//	RetrievalFilterMemberStringContains
//
// [RetrieveAndGenerate request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax
// [Retrieve request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax
// [Query configurations]: https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html
type RetrievalFilter interface {
	isRetrievalFilter()
}

// Knowledge base data sources are returned if their metadata attributes fulfill
// all the filter conditions inside this list.
type RetrievalFilterMemberAndAll struct {
	Value []RetrievalFilter

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberAndAll) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value matches the value in this object.
//
// The following example would return data sources with an animal attribute whose
// value is cat :
//
//	"equals": { "key": "animal", "value": "cat" }
type RetrievalFilterMemberEquals struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberEquals) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value is greater than the value in this
// object.
//
// The following example would return data sources with an year attribute whose
// value is greater than 1989 :
//
//	"greaterThan": { "key": "year", "value": 1989 }
type RetrievalFilterMemberGreaterThan struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberGreaterThan) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value is greater than or equal to the value
// in this object.
//
// The following example would return data sources with an year attribute whose
// value is greater than or equal to 1989 :
//
//	"greaterThanOrEquals": { "key": "year", "value": 1989 }
type RetrievalFilterMemberGreaterThanOrEquals struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberGreaterThanOrEquals) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value is in the list specified in the value
// in this object.
//
// The following example would return data sources with an animal attribute that
// is either cat or dog :
//
//	"in": { "key": "animal", "value": ["cat", "dog"] }
type RetrievalFilterMemberIn struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberIn) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value is less than the value in this
// object.
//
// The following example would return data sources with an year attribute whose
// value is less than to 1989 .
//
//	"lessThan": { "key": "year", "value": 1989 }
type RetrievalFilterMemberLessThan struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberLessThan) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value is less than or equal to the value
// in this object.
//
// The following example would return data sources with an year attribute whose
// value is less than or equal to 1989 .
//
//	"lessThanOrEquals": { "key": "year", "value": 1989 }
type RetrievalFilterMemberLessThanOrEquals struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberLessThanOrEquals) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value is a list that contains the value as
// one of its members.
//
// The following example would return data sources with an animals attribute that
// is a list containing a cat member (for example ["dog", "cat"] ).
//
//	"listContains": { "key": "animals", "value": "cat" }
type RetrievalFilterMemberListContains struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberListContains) isRetrievalFilter() {}

// Knowledge base data sources are returned when:
//
//   - It contains a metadata attribute whose name matches the key and whose value
//     doesn't match the value in this object.
//
//   - The key is not present in the document.
//
// The following example would return data sources that don't contain an animal
// attribute whose value is cat .
//
//	"notEquals": { "key": "animal", "value": "cat" }
type RetrievalFilterMemberNotEquals struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberNotEquals) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value isn't in the list specified in the
// value in this object.
//
// The following example would return data sources whose animal attribute is
// neither cat nor dog .
//
//	"notIn": { "key": "animal", "value": ["cat", "dog"] }
type RetrievalFilterMemberNotIn struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberNotIn) isRetrievalFilter() {}

// Knowledge base data sources are returned if their metadata attributes fulfill
// at least one of the filter conditions inside this list.
type RetrievalFilterMemberOrAll struct {
	Value []RetrievalFilter

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberOrAll) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value starts with the value in this
// object. This filter is currently only supported for Amazon OpenSearch Serverless
// vector stores.
//
// The following example would return data sources with an animal attribute starts
// with ca (for example, cat or camel ).
//
//	"startsWith": { "key": "animal", "value": "ca" }
type RetrievalFilterMemberStartsWith struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberStartsWith) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value is one of the following:
//
//   - A string that contains the value as a substring. The following example would
//     return data sources with an animal attribute that contains the substring at
//     (for example cat ).
//
// "stringContains": { "key": "animal", "value": "at" }
//
//   - A list with a member that contains the value as a substring. The following
//     example would return data sources with an animals attribute that is a list
//     containing a member that contains the substring at (for example ["dog", "cat"]
//     ).
//
// "stringContains": { "key": "animals", "value": "at" }
type RetrievalFilterMemberStringContains struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberStringContains) isRetrievalFilter() {}

// The Confluence data source location.
type RetrievalResultConfluenceLocation struct {

	// The Confluence host URL for the data source location.
	Url *string

	noSmithyDocumentSerde
}

// Contains information about a chunk of text from a data source in the knowledge
// base. If the result is from a structured data source, the cell in the database
// and the type of the value is also identified.
//
// This data type is used in the following API operations:
//
// [Retrieve response]
//   - – in the content field
//
// [RetrieveAndGenerate response]
//   - – in the content field
//
// [InvokeAgent response]
//   - – in the content field
//
// [RetrieveAndGenerate response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax
// [Retrieve response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax
// [InvokeAgent response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax
type RetrievalResultContent struct {

	// Audio segment information when the retrieval result contains audio content.
	Audio *AudioSegment

	// A data URI with base64-encoded content from the data source. The URI is in the
	// following format: returned in the following format:
	// data:image/jpeg;base64,${base64-encoded string} .
	ByteContent *string

	// Specifies information about the rows with the cells to return in retrieval.
	Row []RetrievalResultContentColumn

	// The cited text from the data source.
	Text *string

	// The type of content in the retrieval result.
	Type RetrievalResultContentType

	// Video segment information when the retrieval result contains video content.
	Video *VideoSegment

	noSmithyDocumentSerde
}

// Contains information about a column with a cell to return in retrieval.
type RetrievalResultContentColumn struct {

	// The name of the column.
	ColumnName *string

	// The value in the column.
	ColumnValue *string

	// The data type of the value.
	Type RetrievalResultContentColumnType

	noSmithyDocumentSerde
}

// Contains information about the location of a document in a custom data source.
type RetrievalResultCustomDocumentLocation struct {

	// The ID of the document.
	Id *string

	noSmithyDocumentSerde
}

// The location of a result in Amazon Kendra.
type RetrievalResultKendraDocumentLocation struct {

	// The document's uri.
	Uri *string

	noSmithyDocumentSerde
}

// Contains information about the data source location.
//
// This data type is used in the following API operations:
//
// [Retrieve response]
//   - – in the location field
//
// [RetrieveAndGenerate response]
//   - – in the location field
//
// [InvokeAgent response]
//   - – in the location field
//
// [RetrieveAndGenerate response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax
// [Retrieve response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax
// [InvokeAgent response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax
type RetrievalResultLocation struct {

	// The type of data source location.
	//
	// This member is required.
	Type RetrievalResultLocationType

	// The Confluence data source location.
	ConfluenceLocation *RetrievalResultConfluenceLocation

	// Specifies the location of a document in a custom data source.
	CustomDocumentLocation *RetrievalResultCustomDocumentLocation

	// The location of a document in Amazon Kendra.
	KendraDocumentLocation *RetrievalResultKendraDocumentLocation

	// The S3 data source location.
	S3Location *RetrievalResultS3Location

	// The Salesforce data source location.
	SalesforceLocation *RetrievalResultSalesforceLocation

	// The SharePoint data source location.
	SharePointLocation *RetrievalResultSharePointLocation

	// Specifies information about the SQL query used to retrieve the result.
	SqlLocation *RetrievalResultSqlLocation

	// The web URL/URLs data source location.
	WebLocation *RetrievalResultWebLocation

	noSmithyDocumentSerde
}

// The S3 data source location.
//
// This data type is used in the following API operations:
//
// [Retrieve response]
//   - – in the s3Location field
//
// [RetrieveAndGenerate response]
//   - – in the s3Location field
//
// [InvokeAgent response]
//   - – in the s3Location field
//
// [RetrieveAndGenerate response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax
// [Retrieve response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax
// [InvokeAgent response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax
type RetrievalResultS3Location struct {

	// The S3 URI for the data source location.
	Uri *string

	noSmithyDocumentSerde
}

// The Salesforce data source location.
type RetrievalResultSalesforceLocation struct {

	// The Salesforce host URL for the data source location.
	Url *string

	noSmithyDocumentSerde
}

// The SharePoint data source location.
type RetrievalResultSharePointLocation struct {

	// The SharePoint site URL for the data source location.
	Url *string

	noSmithyDocumentSerde
}

// Contains information about the SQL query used to retrieve the result.
type RetrievalResultSqlLocation struct {

	// The SQL query used to retrieve the result.
	Query *string

	noSmithyDocumentSerde
}

// The web URL/URLs data source location.
type RetrievalResultWebLocation struct {

	// The web URL/URLs for the data source location.
	Url *string

	noSmithyDocumentSerde
}

// Contains details about the resource being queried.
//
// This data type is used in the following API operations:
//
// [RetrieveAndGenerate request]
//   - – in the retrieveAndGenerateConfiguration field
//
// [RetrieveAndGenerate request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax
type RetrieveAndGenerateConfiguration struct {

	// The type of resource that contains your data for retrieving information and
	// generating responses.
	//
	// If you choose to use EXTERNAL_SOURCES , then currently only Anthropic Claude 3
	// Sonnet models for knowledge bases are supported.
	//
	// This member is required.
	Type RetrieveAndGenerateType

	// The configuration for the external source wrapper object in the
	// retrieveAndGenerate function.
	ExternalSourcesConfiguration *ExternalSourcesRetrieveAndGenerateConfiguration

	// Contains details about the knowledge base for retrieving information and
	// generating responses.
	KnowledgeBaseConfiguration *KnowledgeBaseRetrieveAndGenerateConfiguration

	noSmithyDocumentSerde
}

// Contains the query made to the knowledge base.
//
// This data type is used in the following API operations:
//
// [RetrieveAndGenerate request]
//   - – in the input field
//
// [RetrieveAndGenerate request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax
type RetrieveAndGenerateInput struct {

	// The query made to the knowledge base, in characters.
	//
	// This member is required.
	Text *string

	noSmithyDocumentSerde
}

// Contains the response generated from querying the knowledge base.
//
// This data type is used in the following API operations:
//
// [RetrieveAndGenerate response]
//   - – in the output field
//
// [RetrieveAndGenerate response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax
type RetrieveAndGenerateOutput struct {

	// The response generated from querying the knowledge base.
	//
	// This member is required.
	Text *string

	noSmithyDocumentSerde
}

// A retrieve and generate output event.
type RetrieveAndGenerateOutputEvent struct {

	// A text response.
	//
	// This member is required.
	Text *string

	noSmithyDocumentSerde
}

// Contains configuration about the session with the knowledge base.
//
// This data type is used in the following API operations:
//
// [RetrieveAndGenerate request]
//   - – in the sessionConfiguration field
//
// [RetrieveAndGenerate request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax
type RetrieveAndGenerateSessionConfiguration struct {

	// The ARN of the KMS key encrypting the session.
	//
	// This member is required.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// A retrieve and generate stream response output.
//
// The following types satisfy this interface:
//
//	RetrieveAndGenerateStreamResponseOutputMemberCitation
//	RetrieveAndGenerateStreamResponseOutputMemberGuardrail
//	RetrieveAndGenerateStreamResponseOutputMemberOutput
type RetrieveAndGenerateStreamResponseOutput interface {
	isRetrieveAndGenerateStreamResponseOutput()
}

// A citation event.
type RetrieveAndGenerateStreamResponseOutputMemberCitation struct {
	Value CitationEvent

	noSmithyDocumentSerde
}

func (*RetrieveAndGenerateStreamResponseOutputMemberCitation) isRetrieveAndGenerateStreamResponseOutput() {
}

// A guardrail event.
type RetrieveAndGenerateStreamResponseOutputMemberGuardrail struct {
	Value GuardrailEvent

	noSmithyDocumentSerde
}

func (*RetrieveAndGenerateStreamResponseOutputMemberGuardrail) isRetrieveAndGenerateStreamResponseOutput() {
}

// An output event.
type RetrieveAndGenerateStreamResponseOutputMemberOutput struct {
	Value RetrieveAndGenerateOutputEvent

	noSmithyDocumentSerde
}

func (*RetrieveAndGenerateStreamResponseOutputMemberOutput) isRetrieveAndGenerateStreamResponseOutput() {
}

// Contains metadata about a source cited for the generated response.
//
// This data type is used in the following API operations:
//
// [RetrieveAndGenerate response]
//   - – in the retrievedReferences field
//
// [InvokeAgent response]
//   - – in the retrievedReferences field
//
// [RetrieveAndGenerate response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax
// [InvokeAgent response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax
type RetrievedReference struct {

	// Contains the cited text from the data source.
	Content *RetrievalResultContent

	// Contains information about the location of the data source.
	Location *RetrievalResultLocation

	// Contains metadata attributes and their values for the file in the data source.
	// For more information, see [Metadata and filtering].
	//
	// [Metadata and filtering]: https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-ds.html#kb-ds-metadata
	Metadata map[string]document.Interface

	noSmithyDocumentSerde
}

// Contains information to return from the action group that the agent has
// predicted to invoke.
//
// This data type is used in the following API operations:
//
// [InvokeAgent response]
//
// [InvokeAgent response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax
type ReturnControlPayload struct {

	// The identifier of the action group invocation.
	InvocationId *string

	// A list of objects that contain information about the parameters and inputs that
	// need to be sent into the API operation or function, based on what the agent
	// determines from its session with the user.
	InvocationInputs []InvocationInputMember

	noSmithyDocumentSerde
}

// An action invocation result.
type ReturnControlResults struct {

	// The action's invocation ID.
	InvocationId *string

	// The action invocation result.
	ReturnControlInvocationResults []InvocationResultMember

	noSmithyDocumentSerde
}

// Invocation output from a routing classifier model.
type RoutingClassifierModelInvocationOutput struct {

	// The invocation's metadata.
	Metadata *Metadata

	// The invocation's raw response.
	RawResponse *RawResponse

	// The invocation's trace ID.
	TraceId *string

	noSmithyDocumentSerde
}

// A trace for a routing classifier.
//
// The following types satisfy this interface:
//
//	RoutingClassifierTraceMemberInvocationInput
//	RoutingClassifierTraceMemberModelInvocationInput
//	RoutingClassifierTraceMemberModelInvocationOutput
//	RoutingClassifierTraceMemberObservation
type RoutingClassifierTrace interface {
	isRoutingClassifierTrace()
}

// The classifier's invocation input.
type RoutingClassifierTraceMemberInvocationInput struct {
	Value InvocationInput

	noSmithyDocumentSerde
}

func (*RoutingClassifierTraceMemberInvocationInput) isRoutingClassifierTrace() {}

// The classifier's model invocation input.
type RoutingClassifierTraceMemberModelInvocationInput struct {
	Value ModelInvocationInput

	noSmithyDocumentSerde
}

func (*RoutingClassifierTraceMemberModelInvocationInput) isRoutingClassifierTrace() {}

// The classifier's model invocation output.
type RoutingClassifierTraceMemberModelInvocationOutput struct {
	Value RoutingClassifierModelInvocationOutput

	noSmithyDocumentSerde
}

func (*RoutingClassifierTraceMemberModelInvocationOutput) isRoutingClassifierTrace() {}

// The classifier's observation.
type RoutingClassifierTraceMemberObservation struct {
	Value Observation

	noSmithyDocumentSerde
}

func (*RoutingClassifierTraceMemberObservation) isRoutingClassifierTrace() {}

// The identifier information for an Amazon S3 bucket.
type S3Identifier struct {

	//  The name of the S3 bucket.
	S3BucketName *string

	//  The S3 object key for the S3 resource.
	S3ObjectKey *string

	noSmithyDocumentSerde
}

// Information about the Amazon S3 bucket where the image is stored.
type S3Location struct {

	// The path to the Amazon S3 bucket where the image is stored.
	//
	// This member is required.
	Uri *string

	noSmithyDocumentSerde
}

// The unique wrapper object of the document from the S3 location.
type S3ObjectDoc struct {

	// The file location of the S3 wrapper object.
	//
	// This member is required.
	Uri *string

	noSmithyDocumentSerde
}

// Contains details of the s3 object where the source file is located.
type S3ObjectFile struct {

	// The uri of the s3 object.
	//
	// This member is required.
	Uri *string

	noSmithyDocumentSerde
}

// Represents a condition that was satisfied during a condition node evaluation in
// a flow execution.
//
// Flow executions is in preview release for Amazon Bedrock and is subject to
// change.
type SatisfiedCondition struct {

	// The name of the condition that was satisfied.
	//
	// This member is required.
	ConditionName *string

	noSmithyDocumentSerde
}

// Contains parameters that specify various attributes that persist across a
// session or prompt. You can define session state attributes as key-value pairs
// when writing a [Lambda function]for an action group or pass them when making an [InvokeAgent] request. Use
// session state attributes to control and provide conversational context for your
// agent and to help customize your agent's behavior. For more information, see [Control session context].
//
// [InvokeAgent]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html
// [Control session context]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html
// [Lambda function]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-lambda.html
type SessionState struct {

	// The state's conversation history.
	ConversationHistory *ConversationHistory

	// Contains information about the files used by code interpreter.
	Files []InputFile

	// The identifier of the invocation of an action. This value must match the
	// invocationId returned in the InvokeAgent response for the action whose results
	// are provided in the returnControlInvocationResults field. For more information,
	// see [Return control to the agent developer]and [Control session context].
	//
	// [Return control to the agent developer]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html
	// [Control session context]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html
	InvocationId *string

	// An array of configurations, each of which applies to a knowledge base attached
	// to the agent.
	KnowledgeBaseConfigurations []KnowledgeBaseConfiguration

	// Contains attributes that persist across a prompt and the values of those
	// attributes.
	//
	//   - In orchestration prompt template, these attributes replace the
	//   $prompt_session_attributes$ placeholder variable. For more information, see [Prompt template placeholder variables].
	//
	//   - In [multi-agent collaboration], the promptSessionAttributes will only be used by supervisor agent when
	//   $prompt_session_attributes$ is present in prompt template.
	//
	// [multi-agent collaboration]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-multi-agent-collaboration.html
	// [Prompt template placeholder variables]: https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html
	PromptSessionAttributes map[string]string

	// Contains information about the results from the action group invocation. For
	// more information, see [Return control to the agent developer]and [Control session context].
	//
	// If you include this field, the inputText field will be ignored.
	//
	// [Return control to the agent developer]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html
	// [Control session context]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html
	ReturnControlInvocationResults []InvocationResultMember

	// Contains attributes that persist across a session and the values of those
	// attributes. If sessionAttributes are passed to a supervisor agent in [multi-agent collaboration], it will
	// be forwarded to all agent collaborators.
	//
	// [multi-agent collaboration]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-multi-agent-collaboration.html
	SessionAttributes map[string]string

	noSmithyDocumentSerde
}

// Contains details about a session. For more information about sessions, see [Store and retrieve conversation history and context with Amazon Bedrock sessions].
//
// [Store and retrieve conversation history and context with Amazon Bedrock sessions]: https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html
type SessionSummary struct {

	// The timestamp for when the session was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The timestamp for when the session was last modified.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The Amazon Resource Name (ARN) of the session.
	//
	// This member is required.
	SessionArn *string

	// The unique identifier for the session.
	//
	// This member is required.
	SessionId *string

	// The current status of the session.
	//
	// This member is required.
	SessionStatus SessionStatus

	noSmithyDocumentSerde
}

// Contains information about where the text with a citation begins and ends in
// the generated output.
//
// This data type is used in the following API operations:
//
// [RetrieveAndGenerate response]
//   - – in the span field
//
// [InvokeAgent response]
//   - – in the span field
//
// [RetrieveAndGenerate response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax
// [InvokeAgent response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax
type Span struct {

	// Where the text with a citation ends in the generated output.
	End *int32

	// Where the text with a citation starts in the generated output.
	Start *int32

	noSmithyDocumentSerde
}

// Configurations for streaming.
type StreamingConfigurations struct {

	//  The guardrail interval to apply as response is generated. By default, the
	// guardrail interval is set to 50 characters. If a larger interval is specified,
	// the response will be generated in larger chunks with fewer ApplyGuardrail
	// calls. The following examples show the response generated for Hello, I am an
	// agent input string.
	//
	// Example response in chunks: Interval set to 3 characters
	//
	//     'Hel', 'lo, ','I am', ' an', ' Age', 'nt'
	//
	// Each chunk has at least 3 characters except for the last chunk
	//
	// Example response in chunks: Interval set to 20 or more characters
	//
	//     Hello, I am an Agent
	ApplyGuardrailInterval *int32

	//  Specifies whether to enable streaming for the final response. This is set to
	// false by default.
	StreamFinalResponse bool

	noSmithyDocumentSerde
}

// Configuration settings for text generation using a language model via the
// RetrieveAndGenerate operation. Includes parameters like temperature, top-p,
// maximum token count, and stop sequences.
//
// The valid range of maxTokens depends on the accepted values for your chosen
// model's inference parameters. To see the inference parameters for your model,
// see [Inference parameters for foundation models.]
//
// [Inference parameters for foundation models.]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html
type TextInferenceConfig struct {

	// The maximum number of tokens to generate in the output text. Do not use the
	// minimum of 0 or the maximum of 65536. The limit values described here are
	// arbitary values, for actual values consult the limits defined by your specific
	// model.
	MaxTokens *int32

	// A list of sequences of characters that, if generated, will cause the model to
	// stop generating further tokens. Do not use a minimum length of 1 or a maximum
	// length of 1000. The limit values described here are arbitary values, for actual
	// values consult the limits defined by your specific model.
	StopSequences []string

	//  Controls the random-ness of text generated by the language model, influencing
	// how much the model sticks to the most predictable next words versus exploring
	// more surprising options. A lower temperature value (e.g. 0.2 or 0.3) makes model
	// outputs more deterministic or predictable, while a higher temperature (e.g. 0.8
	// or 0.9) makes the outputs more creative or unpredictable.
	Temperature *float32

	//  A probability distribution threshold which controls what the model considers
	// for the set of possible next tokens. The model will only consider the top p% of
	// the probability distribution when generating the next token.
	TopP *float32

	noSmithyDocumentSerde
}

// Contains information about the text prompt to optimize.
type TextPrompt struct {

	// The text in the text prompt to optimize.
	//
	// This member is required.
	Text *string

	noSmithyDocumentSerde
}

// Contains the part of the generated text that contains a citation, alongside
// where it begins and ends.
//
// This data type is used in the following API operations:
//
// [RetrieveAndGenerate response]
//   - – in the textResponsePart field
//
// [InvokeAgent response]
//   - – in the textResponsePart field
//
// [RetrieveAndGenerate response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax
// [InvokeAgent response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax
type TextResponsePart struct {

	// Contains information about where the text with a citation begins and ends in
	// the generated output.
	Span *Span

	// The part of the generated text that contains a citation.
	Text *string

	noSmithyDocumentSerde
}

// Contains configurations for transforming text to SQL.
type TextToSqlConfiguration struct {

	// The type of resource to use in transformation.
	//
	// This member is required.
	Type TextToSqlConfigurationType

	// Specifies configurations for a knowledge base to use in transformation.
	KnowledgeBaseConfiguration *TextToSqlKnowledgeBaseConfiguration

	noSmithyDocumentSerde
}

// Contains configurations for a knowledge base to use in transformation.
type TextToSqlKnowledgeBaseConfiguration struct {

	// The ARN of the knowledge base
	//
	// This member is required.
	KnowledgeBaseArn *string

	noSmithyDocumentSerde
}

// Contains one part of the agent's reasoning process and results from calling API
// actions and querying knowledge bases. You can use the trace to understand how
// the agent arrived at the response it provided the customer. For more
// information, see [Trace enablement].
//
// The following types satisfy this interface:
//
//	TraceMemberCustomOrchestrationTrace
//	TraceMemberFailureTrace
//	TraceMemberGuardrailTrace
//	TraceMemberOrchestrationTrace
//	TraceMemberPostProcessingTrace
//	TraceMemberPreProcessingTrace
//	TraceMemberRoutingClassifierTrace
//
// [Trace enablement]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement
type Trace interface {
	isTrace()
}

//	Details about the custom orchestration step in which the agent determines the
//
// order in which actions are executed.
type TraceMemberCustomOrchestrationTrace struct {
	Value CustomOrchestrationTrace

	noSmithyDocumentSerde
}

func (*TraceMemberCustomOrchestrationTrace) isTrace() {}

// Contains information about the failure of the interaction.
type TraceMemberFailureTrace struct {
	Value FailureTrace

	noSmithyDocumentSerde
}

func (*TraceMemberFailureTrace) isTrace() {}

// The trace details for a trace defined in the Guardrail filter.
type TraceMemberGuardrailTrace struct {
	Value GuardrailTrace

	noSmithyDocumentSerde
}

func (*TraceMemberGuardrailTrace) isTrace() {}

// Details about the orchestration step, in which the agent determines the order
// in which actions are executed and which knowledge bases are retrieved.
type TraceMemberOrchestrationTrace struct {
	Value OrchestrationTrace

	noSmithyDocumentSerde
}

func (*TraceMemberOrchestrationTrace) isTrace() {}

// Details about the post-processing step, in which the agent shapes the response..
type TraceMemberPostProcessingTrace struct {
	Value PostProcessingTrace

	noSmithyDocumentSerde
}

func (*TraceMemberPostProcessingTrace) isTrace() {}

// Details about the pre-processing step, in which the agent contextualizes and
// categorizes user inputs.
type TraceMemberPreProcessingTrace struct {
	Value PreProcessingTrace

	noSmithyDocumentSerde
}

func (*TraceMemberPreProcessingTrace) isTrace() {}

// A routing classifier's trace.
type TraceMemberRoutingClassifierTrace struct {
	Value RoutingClassifierTrace

	noSmithyDocumentSerde
}

func (*TraceMemberRoutingClassifierTrace) isTrace() {}

// Contains trace elements for flow execution tracking.
//
// The following types satisfy this interface:
//
//	TraceElementsMemberAgentTraces
type TraceElements interface {
	isTraceElements()
}

// Agent trace information for the flow execution.
type TraceElementsMemberAgentTraces struct {
	Value []TracePart

	noSmithyDocumentSerde
}

func (*TraceElementsMemberAgentTraces) isTraceElements() {}

// Contains information about the agent and session, alongside the agent's
// reasoning process and results from calling API actions and querying knowledge
// bases and metadata about the trace. You can use the trace to understand how the
// agent arrived at the response it provided the customer. For more information,
// see [Trace enablement].
//
// [Trace enablement]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement
type TracePart struct {

	// The unique identifier of the alias of the agent.
	AgentAliasId *string

	// The unique identifier of the agent.
	AgentId *string

	// The version of the agent.
	AgentVersion *string

	// The part's caller chain.
	CallerChain []Caller

	// The part's collaborator name.
	CollaboratorName *string

	//  The time of the trace.
	EventTime *time.Time

	// The unique identifier of the session with the agent.
	SessionId *string

	// Contains one part of the agent's reasoning process and results from calling API
	// actions and querying knowledge bases. You can use the trace to understand how
	// the agent arrived at the response it provided the customer. For more
	// information, see [Trace enablement].
	//
	// [Trace enablement]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement
	Trace Trace

	noSmithyDocumentSerde
}

// Contains configurations for transforming the natural language query into SQL.
type TransformationConfiguration struct {

	// The mode of the transformation.
	//
	// This member is required.
	Mode QueryTransformationMode

	// Specifies configurations for transforming text to SQL.
	TextToSqlConfiguration *TextToSqlConfiguration

	noSmithyDocumentSerde
}

// Contains information of the usage of the foundation model.
type Usage struct {

	// Contains information about the input tokens from the foundation model usage.
	InputTokens *int32

	// Contains information about the output tokens from the foundation model usage.
	OutputTokens *int32

	noSmithyDocumentSerde
}

// Contains configurations for reranking with an Amazon Bedrock reranker model.
type VectorSearchBedrockRerankingConfiguration struct {

	// Contains configurations for the reranker model.
	//
	// This member is required.
	ModelConfiguration *VectorSearchBedrockRerankingModelConfiguration

	// Contains configurations for the metadata to use in reranking.
	MetadataConfiguration *MetadataConfigurationForReranking

	// The number of results to return after reranking.
	NumberOfRerankedResults *int32

	noSmithyDocumentSerde
}

// Contains configurations for an Amazon Bedrock reranker model.
type VectorSearchBedrockRerankingModelConfiguration struct {

	// The ARN of the reranker model to use.
	//
	// This member is required.
	ModelArn *string

	// A JSON object whose keys are request fields for the model and whose values are
	// values for those fields.
	AdditionalModelRequestFields map[string]document.Interface

	noSmithyDocumentSerde
}

// Contains configurations for reranking the retrieved results.
type VectorSearchRerankingConfiguration struct {

	// The type of reranker model.
	//
	// This member is required.
	Type VectorSearchRerankingConfigurationType

	// Contains configurations for an Amazon Bedrock reranker model.
	BedrockRerankingConfiguration *VectorSearchBedrockRerankingConfiguration

	noSmithyDocumentSerde
}

// Contains information about a video segment retrieved from a knowledge base,
// including its location and summary.
//
// This data type is used in the following API operations:
//
// [Retrieve response]
//   - – in the video field
//
// [Retrieve response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax
type VideoSegment struct {

	// The S3 URI where this specific video segment is stored in the multimodal
	// storage destination.
	//
	// This member is required.
	S3Uri *string

	// A text summary describing the content of the video segment.
	Summary *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isActionGroupExecutor()                         {}
func (*UnknownUnionMember) isAPISchema()                                   {}
func (*UnknownUnionMember) isBedrockSessionContentBlock()                  {}
func (*UnknownUnionMember) isCaller()                                      {}
func (*UnknownUnionMember) isContentBlock()                                {}
func (*UnknownUnionMember) isFlowExecutionContent()                        {}
func (*UnknownUnionMember) isFlowExecutionEvent()                          {}
func (*UnknownUnionMember) isFlowInputContent()                            {}
func (*UnknownUnionMember) isFlowMultiTurnInputContent()                   {}
func (*UnknownUnionMember) isFlowOutputContent()                           {}
func (*UnknownUnionMember) isFlowResponseStream()                          {}
func (*UnknownUnionMember) isFlowTrace()                                   {}
func (*UnknownUnionMember) isFlowTraceNodeInputContent()                   {}
func (*UnknownUnionMember) isFlowTraceNodeOutputContent()                  {}
func (*UnknownUnionMember) isFunctionSchema()                              {}
func (*UnknownUnionMember) isImageInputSource()                            {}
func (*UnknownUnionMember) isImageSource()                                 {}
func (*UnknownUnionMember) isInlineAgentResponseStream()                   {}
func (*UnknownUnionMember) isInputPrompt()                                 {}
func (*UnknownUnionMember) isInvocationInputMember()                       {}
func (*UnknownUnionMember) isInvocationResultMember()                      {}
func (*UnknownUnionMember) isInvocationStepPayload()                       {}
func (*UnknownUnionMember) isMemory()                                      {}
func (*UnknownUnionMember) isNodeExecutionContent()                        {}
func (*UnknownUnionMember) isNodeTraceElements()                           {}
func (*UnknownUnionMember) isOptimizedPrompt()                             {}
func (*UnknownUnionMember) isOptimizedPromptStream()                       {}
func (*UnknownUnionMember) isOrchestrationExecutor()                       {}
func (*UnknownUnionMember) isOrchestrationTrace()                          {}
func (*UnknownUnionMember) isPostProcessingTrace()                         {}
func (*UnknownUnionMember) isPreProcessingTrace()                          {}
func (*UnknownUnionMember) isReasoningContentBlock()                       {}
func (*UnknownUnionMember) isRerankingMetadataSelectiveModeConfiguration() {}
func (*UnknownUnionMember) isResponseStream()                              {}
func (*UnknownUnionMember) isRetrievalFilter()                             {}
func (*UnknownUnionMember) isRetrieveAndGenerateStreamResponseOutput()     {}
func (*UnknownUnionMember) isRoutingClassifierTrace()                      {}
func (*UnknownUnionMember) isTrace()                                       {}
func (*UnknownUnionMember) isTraceElements()                               {}
