// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentruntime

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime/types"
	"github.com/aws/smithy-go/middleware"
	smithysync "github.com/aws/smithy-go/sync"
	"sync"
)

//	Invokes an inline Amazon Bedrock agent using the configurations you provide
//
// with the request.
//
//   - Specify the following fields for security purposes.
//
//   - (Optional) customerEncryptionKeyArn – The Amazon Resource Name (ARN) of a
//     KMS key to encrypt the creation of the agent.
//
//   - (Optional) idleSessionTTLinSeconds – Specify the number of seconds for which
//     the agent should maintain session information. After this time expires, the
//     subsequent InvokeInlineAgent request begins a new session.
//
//   - To override the default prompt behavior for agent orchestration and to use
//     advanced prompts, include a promptOverrideConfiguration object. For more
//     information, see [Advanced prompts].
//
//   - The agent instructions will not be honored if your agent has only one
//     knowledge base, uses default prompts, has no action group, and user input is
//     disabled.
//
// [Advanced prompts]: https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html
func (c *Client) InvokeInlineAgent(ctx context.Context, params *InvokeInlineAgentInput, optFns ...func(*Options)) (*InvokeInlineAgentOutput, error) {
	if params == nil {
		params = &InvokeInlineAgentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "InvokeInlineAgent", params, optFns, c.addOperationInvokeInlineAgentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*InvokeInlineAgentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type InvokeInlineAgentInput struct {

	//  The [model identifier (ID)] of the model to use for orchestration by the inline agent. For example,
	// meta.llama3-1-70b-instruct-v1:0 .
	//
	// [model identifier (ID)]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns
	//
	// This member is required.
	FoundationModel *string

	//  The instructions that tell the inline agent what it should do and how it
	// should interact with users.
	//
	// This member is required.
	Instruction *string

	//  The unique identifier of the session. Use the same value across requests to
	// continue the same conversation.
	//
	// This member is required.
	SessionId *string

	//  A list of action groups with each action group defining the action the inline
	// agent needs to carry out.
	ActionGroups []types.AgentActionGroup

	//  Defines how the inline collaborator agent handles information across multiple
	// collaborator agents to coordinate a final response. The inline collaborator
	// agent can also be the supervisor.
	AgentCollaboration types.AgentCollaboration

	// The name for the agent.
	AgentName *string

	// Model settings for the request.
	BedrockModelConfigurations *types.InlineBedrockModelConfigurations

	//  Settings for an inline agent collaborator called with [InvokeInlineAgent].
	//
	// [InvokeInlineAgent]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeInlineAgent.html
	CollaboratorConfigurations []types.CollaboratorConfiguration

	//  List of collaborator inline agents.
	Collaborators []types.Collaborator

	// Contains details of the custom orchestration configured for the agent.
	CustomOrchestration *types.CustomOrchestration

	//  The Amazon Resource Name (ARN) of the Amazon Web Services KMS key to use to
	// encrypt your inline agent.
	CustomerEncryptionKeyArn *string

	//  Specifies whether to turn on the trace or not to track the agent's reasoning
	// process. For more information, see [Using trace].
	//
	// [Using trace]: https://docs.aws.amazon.com/bedrock/latest/userguide/trace-events.html
	EnableTrace *bool

	//  Specifies whether to end the session with the inline agent or not.
	EndSession *bool

	//  The [guardrails] to assign to the inline agent.
	//
	// [guardrails]: https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails.html
	GuardrailConfiguration *types.GuardrailConfigurationWithArn

	//  The number of seconds for which the inline agent should maintain session
	// information. After this time expires, the subsequent InvokeInlineAgent request
	// begins a new session.
	//
	// A user interaction remains active for the amount of time specified. If no
	// conversation occurs during this time, the session expires and the data provided
	// before the timeout is deleted.
	IdleSessionTTLInSeconds *int32

	//  Parameters that specify the various attributes of a sessions. You can include
	// attributes for the session or prompt or, if you configured an action group to
	// return control, results from invocation of the action group. For more
	// information, see [Control session context].
	//
	// If you include returnControlInvocationResults in the sessionState field, the
	// inputText field will be ignored.
	//
	// [Control session context]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html
	InlineSessionState *types.InlineSessionState

	//  The prompt text to send to the agent.
	//
	// If you include returnControlInvocationResults in the sessionState field, the
	// inputText field will be ignored.
	InputText *string

	//  Contains information of the knowledge bases to associate with.
	KnowledgeBases []types.KnowledgeBase

	// Specifies the type of orchestration strategy for the agent. This is set to
	// DEFAULT orchestration type, by default.
	OrchestrationType types.OrchestrationType

	// Specifies parameters that control how the service populates the agent prompt
	// for an InvokeInlineAgent request. You can control which aspects of previous
	// invocations in the same agent session the service uses to populate the agent
	// prompt. This gives you more granular control over the contextual history that is
	// used to process the current request.
	PromptCreationConfigurations *types.PromptCreationConfigurations

	//  Configurations for advanced prompts used to override the default prompts to
	// enhance the accuracy of the inline agent.
	PromptOverrideConfiguration *types.PromptOverrideConfiguration

	//  Specifies the configurations for streaming.
	//
	// To use agent streaming, you need permissions to perform the
	// bedrock:InvokeModelWithResponseStream action.
	StreamingConfigurations *types.StreamingConfigurations

	noSmithyDocumentSerde
}

type InvokeInlineAgentOutput struct {

	//  The MIME type of the input data in the request. The default value is
	// application/json.
	//
	// This member is required.
	ContentType *string

	//  The unique identifier of the session with the agent.
	//
	// This member is required.
	SessionId *string

	eventStream *InvokeInlineAgentEventStream

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

// GetStream returns the type to interact with the event stream.
func (o *InvokeInlineAgentOutput) GetStream() *InvokeInlineAgentEventStream {
	return o.eventStream
}

func (c *Client) addOperationInvokeInlineAgentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpInvokeInlineAgent{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpInvokeInlineAgent{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "InvokeInlineAgent"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addEventStreamInvokeInlineAgentMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpInvokeInlineAgentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opInvokeInlineAgent(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opInvokeInlineAgent(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "InvokeInlineAgent",
	}
}

// InvokeInlineAgentEventStream provides the event stream handling for the InvokeInlineAgent operation.
//
// For testing and mocking the event stream this type should be initialized via
// the NewInvokeInlineAgentEventStream constructor function. Using the functional options
// to pass in nested mock behavior.
type InvokeInlineAgentEventStream struct {
	// InlineAgentResponseStreamReader is the EventStream reader for the
	// InlineAgentResponseStream events. This value is automatically set by the SDK
	// when the API call is made Use this member when unit testing your code with the
	// SDK to mock out the EventStream Reader.
	//
	// Must not be nil.
	Reader InlineAgentResponseStreamReader

	done      chan struct{}
	closeOnce sync.Once
	err       *smithysync.OnceErr
}

// NewInvokeInlineAgentEventStream initializes an InvokeInlineAgentEventStream.
// This function should only be used for testing and mocking the InvokeInlineAgentEventStream
// stream within your application.
//
// The Reader member must be set before reading events from the stream.
func NewInvokeInlineAgentEventStream(optFns ...func(*InvokeInlineAgentEventStream)) *InvokeInlineAgentEventStream {
	es := &InvokeInlineAgentEventStream{
		done: make(chan struct{}),
		err:  smithysync.NewOnceErr(),
	}
	for _, fn := range optFns {
		fn(es)
	}
	return es
}

// Events returns a channel to read events from.
func (es *InvokeInlineAgentEventStream) Events() <-chan types.InlineAgentResponseStream {
	return es.Reader.Events()
}

// Close closes the stream. This will also cause the stream to be closed.
// Close must be called when done using the stream API. Not calling Close
// may result in resource leaks.
//
// Will close the underlying EventStream writer and reader, and no more events can be
// sent or received.
func (es *InvokeInlineAgentEventStream) Close() error {
	es.closeOnce.Do(es.safeClose)
	return es.Err()
}

func (es *InvokeInlineAgentEventStream) safeClose() {
	close(es.done)

	es.Reader.Close()
}

// Err returns any error that occurred while reading or writing EventStream Events
// from the service API's response. Returns nil if there were no errors.
func (es *InvokeInlineAgentEventStream) Err() error {
	if err := es.err.Err(); err != nil {
		return err
	}

	if err := es.Reader.Err(); err != nil {
		return err
	}

	return nil
}

func (es *InvokeInlineAgentEventStream) waitStreamClose() {
	type errorSet interface {
		ErrorSet() <-chan struct{}
	}

	var outputErrCh <-chan struct{}
	if v, ok := es.Reader.(errorSet); ok {
		outputErrCh = v.ErrorSet()
	}
	var outputClosedCh <-chan struct{}
	if v, ok := es.Reader.(interface{ Closed() <-chan struct{} }); ok {
		outputClosedCh = v.Closed()
	}

	select {
	case <-es.done:
	case <-outputErrCh:
		es.err.SetError(es.Reader.Err())
		es.Close()

	case <-outputClosedCh:
		if err := es.Reader.Err(); err != nil {
			es.err.SetError(es.Reader.Err())
		}
		es.Close()

	}
}
