// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/document"
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains information about an agent runtime. An agent runtime is the execution
// environment for a Amazon Bedrock Agent.
type AgentRuntime struct {

	// The Amazon Resource Name (ARN) of the agent runtime.
	//
	// This member is required.
	AgentRuntimeArn *string

	// The unique identifier of the agent runtime.
	//
	// This member is required.
	AgentRuntimeId *string

	// The name of the agent runtime.
	//
	// This member is required.
	AgentRuntimeName *string

	// The version of the agent runtime.
	//
	// This member is required.
	AgentRuntimeVersion *string

	// The description of the agent runtime.
	//
	// This member is required.
	Description *string

	// The timestamp when the agent runtime was last updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The current status of the agent runtime.
	//
	// This member is required.
	Status AgentRuntimeStatus

	noSmithyDocumentSerde
}

// The artifact of the agent.
//
// The following types satisfy this interface:
//
//	AgentRuntimeArtifactMemberCodeConfiguration
//	AgentRuntimeArtifactMemberContainerConfiguration
type AgentRuntimeArtifact interface {
	isAgentRuntimeArtifact()
}

// The code configuration for the agent runtime artifact, including the source
// code location and execution settings.
type AgentRuntimeArtifactMemberCodeConfiguration struct {
	Value CodeConfiguration

	noSmithyDocumentSerde
}

func (*AgentRuntimeArtifactMemberCodeConfiguration) isAgentRuntimeArtifact() {}

// The container configuration for the agent artifact.
type AgentRuntimeArtifactMemberContainerConfiguration struct {
	Value ContainerConfiguration

	noSmithyDocumentSerde
}

func (*AgentRuntimeArtifactMemberContainerConfiguration) isAgentRuntimeArtifact() {}

// Contains information about an agent runtime endpoint. An endpoint provides a
// way to connect to and interact with an agent runtime.
type AgentRuntimeEndpoint struct {

	// The Amazon Resource Name (ARN) of the agent runtime associated with the
	// endpoint.
	//
	// This member is required.
	AgentRuntimeArn *string

	// The Amazon Resource Name (ARN) of the agent runtime endpoint.
	//
	// This member is required.
	AgentRuntimeEndpointArn *string

	// The timestamp when the agent runtime endpoint was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the agent runtime endpoint.
	//
	// This member is required.
	Id *string

	// The timestamp when the agent runtime endpoint was last updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The name of the agent runtime endpoint.
	//
	// This member is required.
	Name *string

	// The current status of the agent runtime endpoint.
	//
	// This member is required.
	Status AgentRuntimeEndpointStatus

	// The description of the agent runtime endpoint.
	Description *string

	// The live version of the agent runtime endpoint. This is the version that is
	// currently serving requests.
	LiveVersion *string

	// The target version of the agent runtime endpoint. This is the version that the
	// endpoint is being updated to.
	TargetVersion *string

	noSmithyDocumentSerde
}

// The configuration for an Amazon API Gateway target.
type ApiGatewayTargetConfiguration struct {

	// The configuration for defining REST API tool filters and overrides for the
	// gateway target.
	//
	// This member is required.
	ApiGatewayToolConfiguration *ApiGatewayToolConfiguration

	// The ID of the API Gateway REST API.
	//
	// This member is required.
	RestApiId *string

	// The ID of the stage of the REST API to add as a target.
	//
	// This member is required.
	Stage *string

	noSmithyDocumentSerde
}

// The configuration for defining REST API tool filters and overrides for the
// gateway target.
type ApiGatewayToolConfiguration struct {

	// A list of path and method patterns to expose as tools using metadata from the
	// REST API's OpenAPI specification.
	//
	// This member is required.
	ToolFilters []ApiGatewayToolFilter

	// A list of explicit tool definitions with optional custom names and descriptions.
	ToolOverrides []ApiGatewayToolOverride

	noSmithyDocumentSerde
}

// Specifies which operations from an API Gateway REST API are exposed as tools.
// Tool names and descriptions are derived from the operationId and description
// fields in the API's exported OpenAPI specification.
type ApiGatewayToolFilter struct {

	// Resource path to match in the REST API. Supports exact paths (for example, /pets
	// ) or wildcard paths (for example, /pets/* to match all paths under /pets ). Must
	// match existing paths in the REST API.
	//
	// This member is required.
	FilterPath *string

	// The methods to filter for.
	//
	// This member is required.
	Methods []RestApiMethod

	noSmithyDocumentSerde
}

// Settings to override configurations for a tool.
type ApiGatewayToolOverride struct {

	// The HTTP method to expose for the specified path.
	//
	// This member is required.
	Method RestApiMethod

	// The name of tool. Identifies the tool in the Model Context Protocol.
	//
	// This member is required.
	Name *string

	// Resource path in the REST API (e.g., /pets ). Must explicitly match an existing
	// path in the REST API.
	//
	// This member is required.
	Path *string

	// The description of the tool. Provides information about the purpose and usage
	// of the tool. If not provided, uses the description from the API's OpenAPI
	// specification.
	Description *string

	noSmithyDocumentSerde
}

// Contains information about an API key credential provider.
type ApiKeyCredentialProviderItem struct {

	// The timestamp when the API key credential provider was created.
	//
	// This member is required.
	CreatedTime *time.Time

	// The Amazon Resource Name (ARN) of the API key credential provider.
	//
	// This member is required.
	CredentialProviderArn *string

	// The timestamp when the API key credential provider was last updated.
	//
	// This member is required.
	LastUpdatedTime *time.Time

	// The name of the API key credential provider.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Configuration for API schema.
//
// The following types satisfy this interface:
//
//	ApiSchemaConfigurationMemberInlinePayload
//	ApiSchemaConfigurationMemberS3
type ApiSchemaConfiguration interface {
	isApiSchemaConfiguration()
}

// The inline payload containing the API schema definition.
type ApiSchemaConfigurationMemberInlinePayload struct {
	Value string

	noSmithyDocumentSerde
}

func (*ApiSchemaConfigurationMemberInlinePayload) isApiSchemaConfiguration() {}

// The Amazon S3 configuration for a gateway. This structure defines how the
// gateway accesses files in Amazon S3.
type ApiSchemaConfigurationMemberS3 struct {
	Value S3Configuration

	noSmithyDocumentSerde
}

func (*ApiSchemaConfigurationMemberS3) isApiSchemaConfiguration() {}

// Configuration settings for connecting to Atlassian services using OAuth2
// authentication. This includes the client credentials required to authenticate
// with Atlassian's OAuth2 authorization server.
type AtlassianOauth2ProviderConfigInput struct {

	// The client ID for the Atlassian OAuth2 provider. This identifier is assigned by
	// Atlassian when you register your application.
	//
	// This member is required.
	ClientId *string

	// The client secret for the Atlassian OAuth2 provider. This secret is assigned by
	// Atlassian and used along with the client ID to authenticate your application.
	//
	// This member is required.
	ClientSecret *string

	noSmithyDocumentSerde
}

// The configuration details returned for an Atlassian OAuth2 provider, including
// the client ID and OAuth2 discovery information.
type AtlassianOauth2ProviderConfigOutput struct {

	// Contains the discovery information for an OAuth2 provider.
	//
	// This member is required.
	OauthDiscovery Oauth2Discovery

	// The client ID for the Atlassian OAuth2 provider.
	ClientId *string

	noSmithyDocumentSerde
}

// Represents inbound authorization configuration options used to authenticate
// incoming requests.
//
// The following types satisfy this interface:
//
//	AuthorizerConfigurationMemberCustomJWTAuthorizer
type AuthorizerConfiguration interface {
	isAuthorizerConfiguration()
}

// The inbound JWT-based authorization, specifying how incoming requests should be
// authenticated.
type AuthorizerConfigurationMemberCustomJWTAuthorizer struct {
	Value CustomJWTAuthorizerConfiguration

	noSmithyDocumentSerde
}

func (*AuthorizerConfigurationMemberCustomJWTAuthorizer) isAuthorizerConfiguration() {}

// Defines the value or values to match for and the relationship of the match.
type AuthorizingClaimMatchValueType struct {

	// Defines the relationship between the claim field value and the value or values
	// you're matching for.
	//
	// This member is required.
	ClaimMatchOperator ClaimMatchOperatorType

	// The value or values to match for.
	//
	// This member is required.
	ClaimMatchValue ClaimMatchValueType

	noSmithyDocumentSerde
}

//	The configuration for using Amazon Bedrock models in evaluator assessments,
//
// including model selection and inference parameters.
type BedrockEvaluatorModelConfig struct {

	//  The identifier of the Amazon Bedrock model to use for evaluation. Must be a
	// supported foundation model available in your region.
	//
	// This member is required.
	ModelId *string

	//  Additional model-specific request fields to customize model behavior beyond
	// the standard inference configuration.
	AdditionalModelRequestFields document.Interface

	//  The inference configuration parameters that control model behavior during
	// evaluation, including temperature, token limits, and sampling settings.
	InferenceConfig *InferenceConfiguration

	noSmithyDocumentSerde
}

// The network configuration for a browser. This structure defines how the browser
// connects to the network.
type BrowserNetworkConfiguration struct {

	// The network mode for the browser. This field specifies how the browser connects
	// to the network.
	//
	// This member is required.
	NetworkMode BrowserNetworkMode

	// VpcConfig for the Agent.
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// Configuration for enabling browser signing capabilities that allow agents to
// cryptographically identify themselves to websites using HTTP message signatures.
type BrowserSigningConfigInput struct {

	// Specifies whether browser signing is enabled. When enabled, the browser will
	// cryptographically sign HTTP requests to identify itself as an AI agent to bot
	// control vendors.
	//
	// This member is required.
	Enabled bool

	noSmithyDocumentSerde
}

// The current browser signing configuration that shows whether cryptographic
// agent identification is enabled for web bot authentication.
type BrowserSigningConfigOutput struct {

	// Indicates whether browser signing is currently enabled for cryptographic agent
	// identification using HTTP message signatures.
	//
	// This member is required.
	Enabled bool

	noSmithyDocumentSerde
}

// Contains summary information about a browser. A browser enables Amazon Bedrock
// Agent to interact with web content.
type BrowserSummary struct {

	// The Amazon Resource Name (ARN) of the browser.
	//
	// This member is required.
	BrowserArn *string

	// The unique identifier of the browser.
	//
	// This member is required.
	BrowserId *string

	// The timestamp when the browser was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The current status of the browser.
	//
	// This member is required.
	Status BrowserStatus

	// The description of the browser.
	Description *string

	// The timestamp when the browser was last updated.
	LastUpdatedAt *time.Time

	// The name of the browser.
	Name *string

	noSmithyDocumentSerde
}

//	The definition of a categorical rating scale option that provides a named
//
// category with its description for evaluation scoring.
type CategoricalScaleDefinition struct {

	//  The description that explains what this categorical rating represents and when
	// it should be used.
	//
	// This member is required.
	Definition *string

	//  The label or name of this categorical rating option.
	//
	// This member is required.
	Label *string

	noSmithyDocumentSerde
}

// Represents a Cedar policy statement within the AgentCore Policy system. Cedar
// is a policy language designed for authorization that provides human-readable,
// analyzable, and high-performance policy evaluation for controlling agent
// behavior and access decisions.
type CedarPolicy struct {

	// The Cedar policy statement that defines the authorization logic. This statement
	// follows Cedar syntax and specifies principals, actions, resources, and
	// conditions that determine when access should be allowed or denied.
	//
	// This member is required.
	Statement *string

	noSmithyDocumentSerde
}

// The value or values to match for.
//
//   - Include a matchValueString with the EQUALS operator to specify a string that
//     matches the claim field value.
//
//   - Include a matchValueArray to specify an array of string values. You can use
//     the following operators:
//
//   - Use CONTAINS to yield a match if the claim field value is in the array.
//
//   - Use CONTAINS_ANY to yield a match if the claim field value contains any of
//     the strings in the array.
//
// The following types satisfy this interface:
//
//	ClaimMatchValueTypeMemberMatchValueString
//	ClaimMatchValueTypeMemberMatchValueStringList
type ClaimMatchValueType interface {
	isClaimMatchValueType()
}

// The string value to match for.
type ClaimMatchValueTypeMemberMatchValueString struct {
	Value string

	noSmithyDocumentSerde
}

func (*ClaimMatchValueTypeMemberMatchValueString) isClaimMatchValueType() {}

// An array of strings to check for a match.
type ClaimMatchValueTypeMemberMatchValueStringList struct {
	Value []string

	noSmithyDocumentSerde
}

func (*ClaimMatchValueTypeMemberMatchValueStringList) isClaimMatchValueType() {}

//	The configuration for reading agent traces from CloudWatch logs as input for
//
// online evaluation.
type CloudWatchLogsInputConfig struct {

	//  The list of CloudWatch log group names to monitor for agent traces.
	//
	// This member is required.
	LogGroupNames []string

	//  The list of service names to filter traces within the specified log groups.
	// Used to identify relevant agent sessions.
	//
	// This member is required.
	ServiceNames []string

	noSmithyDocumentSerde
}

//	The configuration for writing evaluation results to CloudWatch logs with
//
// embedded metric format (EMF) for monitoring.
type CloudWatchOutputConfig struct {

	//  The name of the CloudWatch log group where evaluation results will be written.
	// The log group will be created if it doesn't exist.
	//
	// This member is required.
	LogGroupName *string

	noSmithyDocumentSerde
}

// The source code configuration that specifies the location and details of the
// code to be executed.
//
// The following types satisfy this interface:
//
//	CodeMemberS3
type Code interface {
	isCode()
}

// The Amazon Amazon S3 object that contains the source code for the agent runtime.
type CodeMemberS3 struct {
	Value S3Location

	noSmithyDocumentSerde
}

func (*CodeMemberS3) isCode() {}

// The configuration for the source code that defines how the agent runtime code
// should be executed, including the code location, runtime environment, and entry
// point.
type CodeConfiguration struct {

	// The source code location and configuration details.
	//
	// This member is required.
	Code Code

	// The entry point for the code execution, specifying the function or method that
	// should be invoked when the code runs.
	//
	// This member is required.
	EntryPoint []string

	// The runtime environment for executing the code (for example, Python 3.9 or
	// Node.js 18).
	//
	// This member is required.
	Runtime AgentManagedRuntimeType

	noSmithyDocumentSerde
}

// The network configuration for a code interpreter. This structure defines how
// the code interpreter connects to the network.
type CodeInterpreterNetworkConfiguration struct {

	// The network mode for the code interpreter. This field specifies how the code
	// interpreter connects to the network.
	//
	// This member is required.
	NetworkMode CodeInterpreterNetworkMode

	// VpcConfig for the Agent.
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// Contains summary information about a code interpreter. A code interpreter
// enables Amazon Bedrock Agent to execute code.
type CodeInterpreterSummary struct {

	// The Amazon Resource Name (ARN) of the code interpreter.
	//
	// This member is required.
	CodeInterpreterArn *string

	// The unique identifier of the code interpreter.
	//
	// This member is required.
	CodeInterpreterId *string

	// The timestamp when the code interpreter was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The current status of the code interpreter.
	//
	// This member is required.
	Status CodeInterpreterStatus

	// The description of the code interpreter.
	Description *string

	// The timestamp when the code interpreter was last updated.
	LastUpdatedAt *time.Time

	// The name of the code interpreter.
	Name *string

	noSmithyDocumentSerde
}

// Contains consolidation configuration information for a memory strategy.
//
// The following types satisfy this interface:
//
//	ConsolidationConfigurationMemberCustomConsolidationConfiguration
type ConsolidationConfiguration interface {
	isConsolidationConfiguration()
}

// The custom consolidation configuration.
type ConsolidationConfigurationMemberCustomConsolidationConfiguration struct {
	Value CustomConsolidationConfiguration

	noSmithyDocumentSerde
}

func (*ConsolidationConfigurationMemberCustomConsolidationConfiguration) isConsolidationConfiguration() {
}

// Representation of a container configuration.
type ContainerConfiguration struct {

	// The ECR URI of the container.
	//
	// This member is required.
	ContainerUri *string

	noSmithyDocumentSerde
}

// Represents content input for policy generation operations. This structure
// encapsulates the natural language descriptions or other content formats that are
// used as input for AI-powered policy generation.
//
// The following types satisfy this interface:
//
//	ContentMemberRawText
type Content interface {
	isContent()
}

// The raw text content containing natural language descriptions of desired policy
// behavior. This text is processed by AI to generate corresponding Cedar policy
// statements that match the described intent.
type ContentMemberRawText struct {
	Value string

	noSmithyDocumentSerde
}

func (*ContentMemberRawText) isContent() {}

// A credential provider for gateway authentication. This structure contains the
// configuration for authenticating with the target endpoint.
//
// The following types satisfy this interface:
//
//	CredentialProviderMemberApiKeyCredentialProvider
//	CredentialProviderMemberOauthCredentialProvider
type CredentialProvider interface {
	isCredentialProvider()
}

// The API key credential provider. This provider uses an API key to authenticate
// with the target endpoint.
type CredentialProviderMemberApiKeyCredentialProvider struct {
	Value GatewayApiKeyCredentialProvider

	noSmithyDocumentSerde
}

func (*CredentialProviderMemberApiKeyCredentialProvider) isCredentialProvider() {}

// The OAuth credential provider. This provider uses OAuth authentication to
// access the target endpoint.
type CredentialProviderMemberOauthCredentialProvider struct {
	Value OAuthCredentialProvider

	noSmithyDocumentSerde
}

func (*CredentialProviderMemberOauthCredentialProvider) isCredentialProvider() {}

// The configuration for a credential provider. This structure defines how the
// gateway authenticates with the target endpoint.
type CredentialProviderConfiguration struct {

	// The type of credential provider. This field specifies which authentication
	// method the gateway uses.
	//
	// This member is required.
	CredentialProviderType CredentialProviderType

	// The credential provider. This field contains the specific configuration for the
	// credential provider type.
	CredentialProvider CredentialProvider

	noSmithyDocumentSerde
}

// Defines the name of a custom claim field and rules for finding matches to
// authenticate its value.
type CustomClaimValidationType struct {

	// Defines the value or values to match for and the relationship of the match.
	//
	// This member is required.
	AuthorizingClaimMatchValue *AuthorizingClaimMatchValueType

	// The name of the custom claim field to check.
	//
	// This member is required.
	InboundTokenClaimName *string

	// The data type of the claim value to check for.
	//
	//   - Use STRING if you want to find an exact match to a string you define.
	//
	//   - Use STRING_ARRAY if you want to fnd a match to at least one value in an
	//   array you define.
	//
	// This member is required.
	InboundTokenClaimValueType InboundTokenClaimValueType

	noSmithyDocumentSerde
}

// Input for custom configuration of a memory strategy.
//
// The following types satisfy this interface:
//
//	CustomConfigurationInputMemberEpisodicOverride
//	CustomConfigurationInputMemberSelfManagedConfiguration
//	CustomConfigurationInputMemberSemanticOverride
//	CustomConfigurationInputMemberSummaryOverride
//	CustomConfigurationInputMemberUserPreferenceOverride
type CustomConfigurationInput interface {
	isCustomConfigurationInput()
}

// The episodic memory strategy override configuration for a custom memory
// strategy.
type CustomConfigurationInputMemberEpisodicOverride struct {
	Value EpisodicOverrideConfigurationInput

	noSmithyDocumentSerde
}

func (*CustomConfigurationInputMemberEpisodicOverride) isCustomConfigurationInput() {}

// The self managed configuration for a custom memory strategy.
type CustomConfigurationInputMemberSelfManagedConfiguration struct {
	Value SelfManagedConfigurationInput

	noSmithyDocumentSerde
}

func (*CustomConfigurationInputMemberSelfManagedConfiguration) isCustomConfigurationInput() {}

// The semantic override configuration for a custom memory strategy.
type CustomConfigurationInputMemberSemanticOverride struct {
	Value SemanticOverrideConfigurationInput

	noSmithyDocumentSerde
}

func (*CustomConfigurationInputMemberSemanticOverride) isCustomConfigurationInput() {}

// The summary override configuration for a custom memory strategy.
type CustomConfigurationInputMemberSummaryOverride struct {
	Value SummaryOverrideConfigurationInput

	noSmithyDocumentSerde
}

func (*CustomConfigurationInputMemberSummaryOverride) isCustomConfigurationInput() {}

// The user preference override configuration for a custom memory strategy.
type CustomConfigurationInputMemberUserPreferenceOverride struct {
	Value UserPreferenceOverrideConfigurationInput

	noSmithyDocumentSerde
}

func (*CustomConfigurationInputMemberUserPreferenceOverride) isCustomConfigurationInput() {}

// Contains custom consolidation configuration information.
//
// The following types satisfy this interface:
//
//	CustomConsolidationConfigurationMemberEpisodicConsolidationOverride
//	CustomConsolidationConfigurationMemberSemanticConsolidationOverride
//	CustomConsolidationConfigurationMemberSummaryConsolidationOverride
//	CustomConsolidationConfigurationMemberUserPreferenceConsolidationOverride
type CustomConsolidationConfiguration interface {
	isCustomConsolidationConfiguration()
}

// The configurations to override the default consolidation step for the episodic
// memory strategy.
type CustomConsolidationConfigurationMemberEpisodicConsolidationOverride struct {
	Value EpisodicConsolidationOverride

	noSmithyDocumentSerde
}

func (*CustomConsolidationConfigurationMemberEpisodicConsolidationOverride) isCustomConsolidationConfiguration() {
}

// The semantic consolidation override configuration.
type CustomConsolidationConfigurationMemberSemanticConsolidationOverride struct {
	Value SemanticConsolidationOverride

	noSmithyDocumentSerde
}

func (*CustomConsolidationConfigurationMemberSemanticConsolidationOverride) isCustomConsolidationConfiguration() {
}

// The summary consolidation override configuration.
type CustomConsolidationConfigurationMemberSummaryConsolidationOverride struct {
	Value SummaryConsolidationOverride

	noSmithyDocumentSerde
}

func (*CustomConsolidationConfigurationMemberSummaryConsolidationOverride) isCustomConsolidationConfiguration() {
}

// The user preference consolidation override configuration.
type CustomConsolidationConfigurationMemberUserPreferenceConsolidationOverride struct {
	Value UserPreferenceConsolidationOverride

	noSmithyDocumentSerde
}

func (*CustomConsolidationConfigurationMemberUserPreferenceConsolidationOverride) isCustomConsolidationConfiguration() {
}

// Input for a custom consolidation configuration.
//
// The following types satisfy this interface:
//
//	CustomConsolidationConfigurationInputMemberEpisodicConsolidationOverride
//	CustomConsolidationConfigurationInputMemberSemanticConsolidationOverride
//	CustomConsolidationConfigurationInputMemberSummaryConsolidationOverride
//	CustomConsolidationConfigurationInputMemberUserPreferenceConsolidationOverride
type CustomConsolidationConfigurationInput interface {
	isCustomConsolidationConfigurationInput()
}

// Configurations to override the consolidation step of the episodic strategy.
type CustomConsolidationConfigurationInputMemberEpisodicConsolidationOverride struct {
	Value EpisodicOverrideConsolidationConfigurationInput

	noSmithyDocumentSerde
}

func (*CustomConsolidationConfigurationInputMemberEpisodicConsolidationOverride) isCustomConsolidationConfigurationInput() {
}

// The semantic consolidation override configuration input.
type CustomConsolidationConfigurationInputMemberSemanticConsolidationOverride struct {
	Value SemanticOverrideConsolidationConfigurationInput

	noSmithyDocumentSerde
}

func (*CustomConsolidationConfigurationInputMemberSemanticConsolidationOverride) isCustomConsolidationConfigurationInput() {
}

// The summary consolidation override configuration input.
type CustomConsolidationConfigurationInputMemberSummaryConsolidationOverride struct {
	Value SummaryOverrideConsolidationConfigurationInput

	noSmithyDocumentSerde
}

func (*CustomConsolidationConfigurationInputMemberSummaryConsolidationOverride) isCustomConsolidationConfigurationInput() {
}

// The user preference consolidation override configuration input.
type CustomConsolidationConfigurationInputMemberUserPreferenceConsolidationOverride struct {
	Value UserPreferenceOverrideConsolidationConfigurationInput

	noSmithyDocumentSerde
}

func (*CustomConsolidationConfigurationInputMemberUserPreferenceConsolidationOverride) isCustomConsolidationConfigurationInput() {
}

// Contains custom extraction configuration information.
//
// The following types satisfy this interface:
//
//	CustomExtractionConfigurationMemberEpisodicExtractionOverride
//	CustomExtractionConfigurationMemberSemanticExtractionOverride
//	CustomExtractionConfigurationMemberUserPreferenceExtractionOverride
type CustomExtractionConfiguration interface {
	isCustomExtractionConfiguration()
}

// The configurations to override the default extraction step for the episodic
// memory strategy.
type CustomExtractionConfigurationMemberEpisodicExtractionOverride struct {
	Value EpisodicExtractionOverride

	noSmithyDocumentSerde
}

func (*CustomExtractionConfigurationMemberEpisodicExtractionOverride) isCustomExtractionConfiguration() {
}

// The semantic extraction override configuration.
type CustomExtractionConfigurationMemberSemanticExtractionOverride struct {
	Value SemanticExtractionOverride

	noSmithyDocumentSerde
}

func (*CustomExtractionConfigurationMemberSemanticExtractionOverride) isCustomExtractionConfiguration() {
}

// The user preference extraction override configuration.
type CustomExtractionConfigurationMemberUserPreferenceExtractionOverride struct {
	Value UserPreferenceExtractionOverride

	noSmithyDocumentSerde
}

func (*CustomExtractionConfigurationMemberUserPreferenceExtractionOverride) isCustomExtractionConfiguration() {
}

// Input for a custom extraction configuration.
//
// The following types satisfy this interface:
//
//	CustomExtractionConfigurationInputMemberEpisodicExtractionOverride
//	CustomExtractionConfigurationInputMemberSemanticExtractionOverride
//	CustomExtractionConfigurationInputMemberUserPreferenceExtractionOverride
type CustomExtractionConfigurationInput interface {
	isCustomExtractionConfigurationInput()
}

// Configurations to override the extraction step of the episodic strategy.
type CustomExtractionConfigurationInputMemberEpisodicExtractionOverride struct {
	Value EpisodicOverrideExtractionConfigurationInput

	noSmithyDocumentSerde
}

func (*CustomExtractionConfigurationInputMemberEpisodicExtractionOverride) isCustomExtractionConfigurationInput() {
}

// The semantic extraction override configuration input.
type CustomExtractionConfigurationInputMemberSemanticExtractionOverride struct {
	Value SemanticOverrideExtractionConfigurationInput

	noSmithyDocumentSerde
}

func (*CustomExtractionConfigurationInputMemberSemanticExtractionOverride) isCustomExtractionConfigurationInput() {
}

// The user preference extraction override configuration input.
type CustomExtractionConfigurationInputMemberUserPreferenceExtractionOverride struct {
	Value UserPreferenceOverrideExtractionConfigurationInput

	noSmithyDocumentSerde
}

func (*CustomExtractionConfigurationInputMemberUserPreferenceExtractionOverride) isCustomExtractionConfigurationInput() {
}

// Configuration for inbound JWT-based authorization, specifying how incoming
// requests should be authenticated.
type CustomJWTAuthorizerConfiguration struct {

	// This URL is used to fetch OpenID Connect configuration or authorization server
	// metadata for validating incoming tokens.
	//
	// This member is required.
	DiscoveryUrl *string

	// Represents individual audience values that are validated in the incoming JWT
	// token validation process.
	AllowedAudience []string

	// Represents individual client IDs that are validated in the incoming JWT token
	// validation process.
	AllowedClients []string

	// An array of scopes that are allowed to access the token.
	AllowedScopes []string

	// An array of objects that define a custom claim validation name, value, and
	// operation
	CustomClaims []CustomClaimValidationType

	noSmithyDocumentSerde
}

// Input for creating a custom memory strategy.
type CustomMemoryStrategyInput struct {

	// The name of the custom memory strategy.
	//
	// This member is required.
	Name *string

	// The configuration for the custom memory strategy.
	Configuration CustomConfigurationInput

	// The description of the custom memory strategy.
	Description *string

	// The namespaces associated with the custom memory strategy.
	Namespaces []string

	noSmithyDocumentSerde
}

// Input configuration for a custom OAuth2 provider.
type CustomOauth2ProviderConfigInput struct {

	// The client ID for the custom OAuth2 provider.
	//
	// This member is required.
	ClientId *string

	// The client secret for the custom OAuth2 provider.
	//
	// This member is required.
	ClientSecret *string

	// The OAuth2 discovery information for the custom provider.
	//
	// This member is required.
	OauthDiscovery Oauth2Discovery

	noSmithyDocumentSerde
}

// Output configuration for a custom OAuth2 provider.
type CustomOauth2ProviderConfigOutput struct {

	// The OAuth2 discovery information for the custom provider.
	//
	// This member is required.
	OauthDiscovery Oauth2Discovery

	// The client ID for the custom OAuth2 provider.
	ClientId *string

	noSmithyDocumentSerde
}

// Contains configurations for a custom reflection strategy.
//
// The following types satisfy this interface:
//
//	CustomReflectionConfigurationMemberEpisodicReflectionOverride
type CustomReflectionConfiguration interface {
	isCustomReflectionConfiguration()
}

// The configuration for a reflection strategy to override the default one.
type CustomReflectionConfigurationMemberEpisodicReflectionOverride struct {
	Value EpisodicReflectionOverride

	noSmithyDocumentSerde
}

func (*CustomReflectionConfigurationMemberEpisodicReflectionOverride) isCustomReflectionConfiguration() {
}

// Input for a custom reflection configuration.
//
// The following types satisfy this interface:
//
//	CustomReflectionConfigurationInputMemberEpisodicReflectionOverride
type CustomReflectionConfigurationInput interface {
	isCustomReflectionConfigurationInput()
}

// The reflection override configuration input.
type CustomReflectionConfigurationInputMemberEpisodicReflectionOverride struct {
	Value EpisodicOverrideReflectionConfigurationInput

	noSmithyDocumentSerde
}

func (*CustomReflectionConfigurationInputMemberEpisodicReflectionOverride) isCustomReflectionConfigurationInput() {
}

//	The configuration that specifies where to read agent traces for online
//
// evaluation.
//
// The following types satisfy this interface:
//
//	DataSourceConfigMemberCloudWatchLogs
type DataSourceConfig interface {
	isDataSourceConfig()
}

// The CloudWatch logs configuration for reading agent traces from log groups.
type DataSourceConfigMemberCloudWatchLogs struct {
	Value CloudWatchLogsInputConfig

	noSmithyDocumentSerde
}

func (*DataSourceConfigMemberCloudWatchLogs) isDataSourceConfig() {}

// Input for deleting a memory strategy.
type DeleteMemoryStrategyInput struct {

	// The unique identifier of the memory strategy to delete.
	//
	// This member is required.
	MemoryStrategyId *string

	noSmithyDocumentSerde
}

// Contains configurations to override the default consolidation step for the
// episodic memory strategy.
type EpisodicConsolidationOverride struct {

	// The text appended to the prompt for the consolidation step of the episodic
	// memory strategy.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID used for the consolidation step of the episodic memory strategy.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// Contains configurations to override the default extraction step for the
// episodic memory strategy.
type EpisodicExtractionOverride struct {

	// The text appended to the prompt for the extraction step of the episodic memory
	// strategy.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID used for the extraction step of the episodic memory strategy.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// Input for creating an episodic memory strategy.
type EpisodicMemoryStrategyInput struct {

	// The name of the episodic memory strategy.
	//
	// This member is required.
	Name *string

	// The description of the episodic memory strategy.
	Description *string

	// The namespaces for which to create episodes.
	Namespaces []string

	// The configuration for the reflections created with the episodic memory strategy.
	ReflectionConfiguration *EpisodicReflectionConfigurationInput

	noSmithyDocumentSerde
}

// Input for the configuration to override the episodic memory strategy.
type EpisodicOverrideConfigurationInput struct {

	// Contains configurations for overriding the consolidation step of the episodic
	// memory strategy.
	Consolidation *EpisodicOverrideConsolidationConfigurationInput

	// Contains configurations for overriding the extraction step of the episodic
	// memory strategy.
	Extraction *EpisodicOverrideExtractionConfigurationInput

	// Contains configurations for overriding the reflection step of the episodic
	// memory strategy.
	Reflection *EpisodicOverrideReflectionConfigurationInput

	noSmithyDocumentSerde
}

// Configurations for overriding the consolidation step of the episodic memory
// strategy.
type EpisodicOverrideConsolidationConfigurationInput struct {

	// The text to append to the prompt for the consolidation step of the episodic
	// memory strategy.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for the consolidation step of the episodic memory strategy.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// Configurations for overriding the extraction step of the episodic memory
// strategy.
type EpisodicOverrideExtractionConfigurationInput struct {

	// The text to append to the prompt for the extraction step of the episodic memory
	// strategy.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for the extraction step of the episodic memory strategy.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// Configurations for overriding the reflection step of the episodic memory
// strategy.
type EpisodicOverrideReflectionConfigurationInput struct {

	// The text to append to the prompt for reflection step of the episodic memory
	// strategy.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for the reflection step of the episodic memory strategy.
	//
	// This member is required.
	ModelId *string

	// The namespaces to use for episodic reflection. Can be less nested than the
	// episodic namespaces.
	Namespaces []string

	noSmithyDocumentSerde
}

// The configuration for the reflections created with the episodic memory strategy.
type EpisodicReflectionConfiguration struct {

	// The namespaces for which to create reflections. Can be less nested than the
	// episodic namespaces.
	//
	// This member is required.
	Namespaces []string

	noSmithyDocumentSerde
}

// An episodic reflection configuration input.
type EpisodicReflectionConfigurationInput struct {

	// The namespaces over which to create reflections. Can be less nested than
	// episode namespaces.
	//
	// This member is required.
	Namespaces []string

	noSmithyDocumentSerde
}

// Contains configurations to override the default reflection step for the
// episodic memory strategy.
type EpisodicReflectionOverride struct {

	// The text appended to the prompt for the reflection step of the episodic memory
	// strategy.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID used for the reflection step of the episodic memory strategy.
	//
	// This member is required.
	ModelId *string

	// The namespaces over which reflections were created. Can be less nested than the
	// episodic namespaces.
	Namespaces []string

	noSmithyDocumentSerde
}

//	The configuration that defines how an evaluator assesses agent performance,
//
// including the evaluation method and parameters.
//
// The following types satisfy this interface:
//
//	EvaluatorConfigMemberLlmAsAJudge
type EvaluatorConfig interface {
	isEvaluatorConfig()
}

//	The LLM-as-a-Judge configuration that uses a language model to evaluate agent
//
// performance based on custom instructions and rating scales.
type EvaluatorConfigMemberLlmAsAJudge struct {
	Value LlmAsAJudgeEvaluatorConfig

	noSmithyDocumentSerde
}

func (*EvaluatorConfigMemberLlmAsAJudge) isEvaluatorConfig() {}

//	The model configuration that specifies which foundation model to use for
//
// evaluation and how to configure it.
//
// The following types satisfy this interface:
//
//	EvaluatorModelConfigMemberBedrockEvaluatorModelConfig
type EvaluatorModelConfig interface {
	isEvaluatorModelConfig()
}

// The Amazon Bedrock model configuration for evaluation.
type EvaluatorModelConfigMemberBedrockEvaluatorModelConfig struct {
	Value BedrockEvaluatorModelConfig

	noSmithyDocumentSerde
}

func (*EvaluatorModelConfigMemberBedrockEvaluatorModelConfig) isEvaluatorModelConfig() {}

//	The reference to an evaluator used in online evaluation configurations,
//
// containing the evaluator identifier.
//
// The following types satisfy this interface:
//
//	EvaluatorReferenceMemberEvaluatorId
type EvaluatorReference interface {
	isEvaluatorReference()
}

//	The unique identifier of the evaluator. Can reference builtin evaluators
//
// (e.g., Builtin.Helpfulness) or custom evaluators.
type EvaluatorReferenceMemberEvaluatorId struct {
	Value string

	noSmithyDocumentSerde
}

func (*EvaluatorReferenceMemberEvaluatorId) isEvaluatorReference() {}

//	The summary information about an evaluator, including basic metadata and
//
// status information.
type EvaluatorSummary struct {

	//  The timestamp when the evaluator was created.
	//
	// This member is required.
	CreatedAt *time.Time

	//  The Amazon Resource Name (ARN) of the evaluator.
	//
	// This member is required.
	EvaluatorArn *string

	//  The unique identifier of the evaluator.
	//
	// This member is required.
	EvaluatorId *string

	//  The name of the evaluator.
	//
	// This member is required.
	EvaluatorName *string

	//  The type of evaluator, indicating whether it is a built-in evaluator provided
	// by the service or a custom evaluator created by the user.
	//
	// This member is required.
	EvaluatorType EvaluatorType

	//  The current status of the evaluator.
	//
	// This member is required.
	Status EvaluatorStatus

	//  The timestamp when the evaluator was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	//  The description of the evaluator.
	Description *string

	//  The evaluation level ( TOOL_CALL , TRACE , or SESSION ) that determines the
	// scope of evaluation.
	Level EvaluatorLevel

	//  Whether the evaluator is locked for modification due to being referenced by
	// active online evaluation configurations.
	LockedForModification *bool

	noSmithyDocumentSerde
}

// Contains extraction configuration information for a memory strategy.
//
// The following types satisfy this interface:
//
//	ExtractionConfigurationMemberCustomExtractionConfiguration
type ExtractionConfiguration interface {
	isExtractionConfiguration()
}

// The custom extraction configuration.
type ExtractionConfigurationMemberCustomExtractionConfiguration struct {
	Value CustomExtractionConfiguration

	noSmithyDocumentSerde
}

func (*ExtractionConfigurationMemberCustomExtractionConfiguration) isExtractionConfiguration() {}

//	The filter that applies conditions to agent traces during online evaluation to
//
// determine which traces should be evaluated.
type Filter struct {

	//  The key or field name to filter on within the agent trace data.
	//
	// This member is required.
	Key *string

	//  The comparison operator to use for filtering.
	//
	// This member is required.
	Operator FilterOperator

	//  The value to compare against using the specified operator.
	//
	// This member is required.
	Value FilterValue

	noSmithyDocumentSerde
}

//	The value used in filter comparisons, supporting different data types for
//
// flexible filtering criteria.
//
// The following types satisfy this interface:
//
//	FilterValueMemberBooleanValue
//	FilterValueMemberDoubleValue
//	FilterValueMemberStringValue
type FilterValue interface {
	isFilterValue()
}

// The boolean value for true/false filtering conditions.
type FilterValueMemberBooleanValue struct {
	Value bool

	noSmithyDocumentSerde
}

func (*FilterValueMemberBooleanValue) isFilterValue() {}

// The numeric value for numerical filtering and comparisons.
type FilterValueMemberDoubleValue struct {
	Value float64

	noSmithyDocumentSerde
}

func (*FilterValueMemberDoubleValue) isFilterValue() {}

// The string value for text-based filtering.
type FilterValueMemberStringValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*FilterValueMemberStringValue) isFilterValue() {}

// Represents a finding or issue discovered during policy generation or
// validation. Findings provide insights about potential problems, recommendations,
// or validation results from policy analysis operations. Finding types include:
// VALID (policy is ready to use), INVALID (policy has validation errors that must
// be fixed), NOT_TRANSLATABLE (input couldn't be converted to policy), ALLOW_ALL
// (policy would allow all actions, potential security risk), ALLOW_NONE (policy
// would allow no actions, unusable), DENY_ALL (policy would deny all actions, may
// be too restrictive), and DENY_NONE (policy would deny no actions, ineffective).
// Review all findings before creating policies from generated assets to ensure
// they match your security requirements.
type Finding struct {

	// A human-readable description of the finding. This provides detailed information
	// about the issue, recommendation, or validation result to help users understand
	// and address the finding.
	Description *string

	// The type or category of the finding. This classifies the finding as an error,
	// warning, recommendation, or informational message to help users understand the
	// severity and nature of the issue.
	Type FindingType

	noSmithyDocumentSerde
}

// An API key credential provider for gateway authentication. This structure
// contains the configuration for authenticating with the target endpoint using an
// API key.
type GatewayApiKeyCredentialProvider struct {

	// The Amazon Resource Name (ARN) of the API key credential provider. This ARN
	// identifies the provider in Amazon Web Services.
	//
	// This member is required.
	ProviderArn *string

	// The location of the API key credential. This field specifies where in the
	// request the API key should be placed.
	CredentialLocation ApiKeyCredentialLocation

	// The name of the credential parameter for the API key. This parameter name is
	// used when sending the API key to the target endpoint.
	CredentialParameterName *string

	// The prefix for the API key credential. This prefix is added to the API key when
	// sending it to the target endpoint.
	CredentialPrefix *string

	noSmithyDocumentSerde
}

// The configuration for an interceptor on a gateway. This structure defines
// settings for an interceptor that will be invoked during the invocation of the
// gateway.
type GatewayInterceptorConfiguration struct {

	// The supported points of interception. This field specifies which points during
	// the gateway invocation to invoke the interceptor
	//
	// This member is required.
	InterceptionPoints []GatewayInterceptionPoint

	// The infrastructure settings of an interceptor configuration. This structure
	// defines how the interceptor can be invoked.
	//
	// This member is required.
	Interceptor InterceptorConfiguration

	// The configuration for the input of the interceptor. This field specifies how
	// the input to the interceptor is constructed
	InputConfiguration *InterceptorInputConfiguration

	noSmithyDocumentSerde
}

// The configuration for a policy engine associated with a gateway. A policy
// engine is a collection of policies that evaluates and authorizes agent tool
// calls. When associated with a gateway, the policy engine intercepts all agent
// requests and determines whether to allow or deny each action based on the
// defined policies.
type GatewayPolicyEngineConfiguration struct {

	// The ARN of the policy engine. The policy engine contains Cedar policies that
	// define fine-grained authorization rules specifying who can perform what actions
	// on which resources as agents interact through the gateway.
	//
	// This member is required.
	Arn *string

	// The enforcement mode for the policy engine. Valid values include:
	//
	//   - LOG_ONLY - The policy engine evaluates each action against your policies and
	//   adds traces on whether tool calls would be allowed or denied, but does not
	//   enforce the decision. Use this mode to test and validate policies before
	//   enabling enforcement.
	//
	//   - ENFORCE - The policy engine evaluates actions against your policies and
	//   enforces decisions by allowing or denying agent operations. Test and validate
	//   policies in LOG_ONLY mode before enabling enforcement to avoid unintended
	//   denials or adversely affecting production traffic.
	//
	// This member is required.
	Mode GatewayPolicyEngineMode

	noSmithyDocumentSerde
}

// The configuration for a gateway protocol. This structure defines how the
// gateway communicates with external services.
//
// The following types satisfy this interface:
//
//	GatewayProtocolConfigurationMemberMcp
type GatewayProtocolConfiguration interface {
	isGatewayProtocolConfiguration()
}

// The configuration for the Model Context Protocol (MCP). This protocol enables
// communication between Amazon Bedrock Agent and external tools.
type GatewayProtocolConfigurationMemberMcp struct {
	Value MCPGatewayConfiguration

	noSmithyDocumentSerde
}

func (*GatewayProtocolConfigurationMemberMcp) isGatewayProtocolConfiguration() {}

// Contains summary information about a gateway.
type GatewaySummary struct {

	// The type of authorizer used by the gateway.
	//
	// This member is required.
	AuthorizerType AuthorizerType

	// The timestamp when the gateway was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the gateway.
	//
	// This member is required.
	GatewayId *string

	// The name of the gateway.
	//
	// This member is required.
	Name *string

	// The protocol type used by the gateway.
	//
	// This member is required.
	ProtocolType GatewayProtocolType

	// The current status of the gateway.
	//
	// This member is required.
	Status GatewayStatus

	// The timestamp when the gateway was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the gateway.
	Description *string

	noSmithyDocumentSerde
}

// The gateway target.
type GatewayTarget struct {

	// The date and time at which the target was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The provider configurations.
	//
	// This member is required.
	CredentialProviderConfigurations []CredentialProviderConfiguration

	// The Amazon Resource Name (ARN) of the gateway target.
	//
	// This member is required.
	GatewayArn *string

	// The name of the gateway target.
	//
	// This member is required.
	Name *string

	// The status of the gateway target.
	//
	// This member is required.
	Status TargetStatus

	// The configuration for a gateway target. This structure defines how the gateway
	// connects to and interacts with the target endpoint.
	//
	// This member is required.
	TargetConfiguration TargetConfiguration

	// The target ID.
	//
	// This member is required.
	TargetId *string

	// The date and time at which the target was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description for the gateway target.
	Description *string

	// The last synchronization time.
	LastSynchronizedAt *time.Time

	// The status reasons for the target status.
	StatusReasons []string

	noSmithyDocumentSerde
}

// Input configuration for a GitHub OAuth2 provider.
type GithubOauth2ProviderConfigInput struct {

	// The client ID for the GitHub OAuth2 provider.
	//
	// This member is required.
	ClientId *string

	// The client secret for the GitHub OAuth2 provider.
	//
	// This member is required.
	ClientSecret *string

	noSmithyDocumentSerde
}

// Output configuration for a GitHub OAuth2 provider.
type GithubOauth2ProviderConfigOutput struct {

	// The OAuth2 discovery information for the GitHub provider.
	//
	// This member is required.
	OauthDiscovery Oauth2Discovery

	// The client ID for the GitHub OAuth2 provider.
	ClientId *string

	noSmithyDocumentSerde
}

// Input configuration for a Google OAuth2 provider.
type GoogleOauth2ProviderConfigInput struct {

	// The client ID for the Google OAuth2 provider.
	//
	// This member is required.
	ClientId *string

	// The client secret for the Google OAuth2 provider.
	//
	// This member is required.
	ClientSecret *string

	noSmithyDocumentSerde
}

// Output configuration for a Google OAuth2 provider.
type GoogleOauth2ProviderConfigOutput struct {

	// The OAuth2 discovery information for the Google provider.
	//
	// This member is required.
	OauthDiscovery Oauth2Discovery

	// The client ID for the Google OAuth2 provider.
	ClientId *string

	noSmithyDocumentSerde
}

// Configuration settings for connecting to a supported OAuth2 provider. This
// includes client credentials and OAuth2 discovery information for providers that
// have built-in support.
type IncludedOauth2ProviderConfigInput struct {

	// The client ID for the supported OAuth2 provider. This identifier is assigned by
	// the OAuth2 provider when you register your application.
	//
	// This member is required.
	ClientId *string

	// The client secret for the supported OAuth2 provider. This secret is assigned by
	// the OAuth2 provider and used along with the client ID to authenticate your
	// application.
	//
	// This member is required.
	ClientSecret *string

	// OAuth2 authorization endpoint for your isolated OAuth2 application tenant. This
	// is where users are redirected to authenticate and authorize access to their
	// resources.
	AuthorizationEndpoint *string

	// Token issuer of your isolated OAuth2 application tenant. This URL identifies
	// the authorization server that issues tokens for this provider.
	Issuer *string

	// OAuth2 token endpoint for your isolated OAuth2 application tenant. This is
	// where authorization codes are exchanged for access tokens.
	TokenEndpoint *string

	noSmithyDocumentSerde
}

// The configuration details returned for a supported OAuth2 provider, including
// client credentials and OAuth2 discovery information.
type IncludedOauth2ProviderConfigOutput struct {

	// Contains the discovery information for an OAuth2 provider.
	//
	// This member is required.
	OauthDiscovery Oauth2Discovery

	// The client ID for the supported OAuth2 provider.
	ClientId *string

	noSmithyDocumentSerde
}

//	The configuration parameters that control how the foundation model behaves
//
// during evaluation, including response generation settings.
type InferenceConfiguration struct {

	//  The maximum number of tokens to generate in the model response during
	// evaluation.
	MaxTokens *int32

	//  The list of sequences that will cause the model to stop generating tokens when
	// encountered.
	StopSequences []string

	//  The temperature value that controls randomness in the model's responses. Lower
	// values produce more deterministic outputs.
	Temperature *float32

	//  The top-p sampling parameter that controls the diversity of the model's
	// responses by limiting the cumulative probability of token choices.
	TopP *float32

	noSmithyDocumentSerde
}

// The interceptor configuration.
//
// The following types satisfy this interface:
//
//	InterceptorConfigurationMemberLambda
type InterceptorConfiguration interface {
	isInterceptorConfiguration()
}

// The details of the lambda function used for the interceptor.
type InterceptorConfigurationMemberLambda struct {
	Value LambdaInterceptorConfiguration

	noSmithyDocumentSerde
}

func (*InterceptorConfigurationMemberLambda) isInterceptorConfiguration() {}

// The input configuration of the interceptor.
type InterceptorInputConfiguration struct {

	// Indicates whether to pass request headers as input into the interceptor. When
	// set to true, request headers will be passed.
	//
	// This member is required.
	PassRequestHeaders *bool

	noSmithyDocumentSerde
}

// The configuration to invoke a self-managed memory processing pipeline with.
type InvocationConfiguration struct {

	// The S3 bucket name for event payload delivery.
	//
	// This member is required.
	PayloadDeliveryBucketName *string

	// The ARN of the SNS topic for job notifications.
	//
	// This member is required.
	TopicArn *string

	noSmithyDocumentSerde
}

// The configuration to invoke a self-managed memory processing pipeline with.
type InvocationConfigurationInput struct {

	// The S3 bucket name for event payload delivery.
	//
	// This member is required.
	PayloadDeliveryBucketName *string

	// The ARN of the SNS topic for job notifications.
	//
	// This member is required.
	TopicArn *string

	noSmithyDocumentSerde
}

// Contains the KMS configuration for a resource.
type KmsConfiguration struct {

	// The type of KMS key (CustomerManagedKey or ServiceManagedKey).
	//
	// This member is required.
	KeyType KeyType

	// The Amazon Resource Name (ARN) of the KMS key.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// The lambda configuration for the interceptor
type LambdaInterceptorConfiguration struct {

	// The arn of the lambda function to be invoked for the interceptor.
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

// LifecycleConfiguration lets you manage the lifecycle of runtime sessions and
// resources in AgentCore Runtime. This configuration helps optimize resource
// utilization by automatically cleaning up idle sessions and preventing
// long-running instances from consuming resources indefinitely.
type LifecycleConfiguration struct {

	// Timeout in seconds for idle runtime sessions. When a session remains idle for
	// this duration, it will be automatically terminated. Default: 900 seconds (15
	// minutes).
	IdleRuntimeSessionTimeout *int32

	// Maximum lifetime for the instance in seconds. Once reached, instances will be
	// automatically terminated and replaced. Default: 28800 seconds (8 hours).
	MaxLifetime *int32

	noSmithyDocumentSerde
}

// Configuration settings for connecting to LinkedIn services using OAuth2
// authentication. This includes the client credentials required to authenticate
// with LinkedIn's OAuth2 authorization server.
type LinkedinOauth2ProviderConfigInput struct {

	// The client ID for the LinkedIn OAuth2 provider. This identifier is assigned by
	// LinkedIn when you register your application.
	//
	// This member is required.
	ClientId *string

	// The client secret for the LinkedIn OAuth2 provider. This secret is assigned by
	// LinkedIn and used along with the client ID to authenticate your application.
	//
	// This member is required.
	ClientSecret *string

	noSmithyDocumentSerde
}

// The configuration details returned for a LinkedIn OAuth2 provider, including
// the client ID and OAuth2 discovery information.
type LinkedinOauth2ProviderConfigOutput struct {

	// Contains the discovery information for an OAuth2 provider.
	//
	// This member is required.
	OauthDiscovery Oauth2Discovery

	// The client ID for the LinkedIn OAuth2 provider.
	ClientId *string

	noSmithyDocumentSerde
}

//	The configuration for LLM-as-a-Judge evaluation that uses a language model to
//
// assess agent performance based on custom instructions and rating scales.
type LlmAsAJudgeEvaluatorConfig struct {

	//  The evaluation instructions that guide the language model in assessing agent
	// performance, including criteria and evaluation guidelines.
	//
	// This member is required.
	Instructions *string

	//  The model configuration that specifies which foundation model to use and how
	// to configure it for evaluation.
	//
	// This member is required.
	ModelConfig EvaluatorModelConfig

	//  The rating scale that defines how the evaluator should score agent
	// performance, either numerical or categorical.
	//
	// This member is required.
	RatingScale RatingScale

	noSmithyDocumentSerde
}

// The configuration for a Model Context Protocol (MCP) gateway. This structure
// defines how the gateway implements the MCP protocol.
type MCPGatewayConfiguration struct {

	// The instructions for using the Model Context Protocol gateway. These
	// instructions provide guidance on how to interact with the gateway.
	Instructions *string

	// The search type for the Model Context Protocol gateway. This field specifies
	// how the gateway handles search operations.
	SearchType SearchType

	// The supported versions of the Model Context Protocol. This field specifies
	// which versions of the protocol the gateway can use.
	SupportedVersions []string

	noSmithyDocumentSerde
}

// The Lambda configuration for a Model Context Protocol target. This structure
// defines how the gateway uses a Lambda function to communicate with the target.
type McpLambdaTargetConfiguration struct {

	// The Amazon Resource Name (ARN) of the Lambda function. This function is invoked
	// by the gateway to communicate with the target.
	//
	// This member is required.
	LambdaArn *string

	// The tool schema for the Lambda function. This schema defines the structure of
	// the tools that the Lambda function provides.
	//
	// This member is required.
	ToolSchema ToolSchema

	noSmithyDocumentSerde
}

// The target configuration for the MCP server.
type McpServerTargetConfiguration struct {

	// The endpoint for the MCP server target configuration.
	//
	// This member is required.
	Endpoint *string

	noSmithyDocumentSerde
}

// The Model Context Protocol (MCP) configuration for a target. This structure
// defines how the gateway uses MCP to communicate with the target.
//
// The following types satisfy this interface:
//
//	McpTargetConfigurationMemberApiGateway
//	McpTargetConfigurationMemberLambda
//	McpTargetConfigurationMemberMcpServer
//	McpTargetConfigurationMemberOpenApiSchema
//	McpTargetConfigurationMemberSmithyModel
type McpTargetConfiguration interface {
	isMcpTargetConfiguration()
}

// The configuration for an Amazon API Gateway target.
type McpTargetConfigurationMemberApiGateway struct {
	Value ApiGatewayTargetConfiguration

	noSmithyDocumentSerde
}

func (*McpTargetConfigurationMemberApiGateway) isMcpTargetConfiguration() {}

// The Lambda configuration for the Model Context Protocol target. This
// configuration defines how the gateway uses a Lambda function to communicate with
// the target.
type McpTargetConfigurationMemberLambda struct {
	Value McpLambdaTargetConfiguration

	noSmithyDocumentSerde
}

func (*McpTargetConfigurationMemberLambda) isMcpTargetConfiguration() {}

// The MCP server specified as the gateway target.
type McpTargetConfigurationMemberMcpServer struct {
	Value McpServerTargetConfiguration

	noSmithyDocumentSerde
}

func (*McpTargetConfigurationMemberMcpServer) isMcpTargetConfiguration() {}

// The OpenAPI schema for the Model Context Protocol target. This schema defines
// the API structure of the target.
type McpTargetConfigurationMemberOpenApiSchema struct {
	Value ApiSchemaConfiguration

	noSmithyDocumentSerde
}

func (*McpTargetConfigurationMemberOpenApiSchema) isMcpTargetConfiguration() {}

// The Smithy model for the Model Context Protocol target. This model defines the
// API structure of the target using the Smithy specification.
type McpTargetConfigurationMemberSmithyModel struct {
	Value ApiSchemaConfiguration

	noSmithyDocumentSerde
}

func (*McpTargetConfigurationMemberSmithyModel) isMcpTargetConfiguration() {}

// Contains information about a memory resource.
type Memory struct {

	// The Amazon Resource Name (ARN) of the memory.
	//
	// This member is required.
	Arn *string

	// The timestamp when the memory was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The number of days after which memory events will expire.
	//
	// This member is required.
	EventExpiryDuration *int32

	// The unique identifier of the memory.
	//
	// This member is required.
	Id *string

	// The name of the memory.
	//
	// This member is required.
	Name *string

	// The current status of the memory.
	//
	// This member is required.
	Status MemoryStatus

	// The timestamp when the memory was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the memory.
	Description *string

	// The ARN of the KMS key used to encrypt the memory.
	EncryptionKeyArn *string

	// The reason for failure if the memory is in a failed state.
	FailureReason *string

	// The ARN of the IAM role that provides permissions for the memory.
	MemoryExecutionRoleArn *string

	// The list of memory strategies associated with this memory.
	Strategies []MemoryStrategy

	noSmithyDocumentSerde
}

// Contains information about a memory strategy.
type MemoryStrategy struct {

	// The name of the memory strategy.
	//
	// This member is required.
	Name *string

	// The namespaces associated with the memory strategy.
	//
	// This member is required.
	Namespaces []string

	// The unique identifier of the memory strategy.
	//
	// This member is required.
	StrategyId *string

	// The type of the memory strategy.
	//
	// This member is required.
	Type MemoryStrategyType

	// The configuration of the memory strategy.
	Configuration *StrategyConfiguration

	// The timestamp when the memory strategy was created.
	CreatedAt *time.Time

	// The description of the memory strategy.
	Description *string

	// The current status of the memory strategy.
	Status MemoryStrategyStatus

	// The timestamp when the memory strategy was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Contains input information for creating a memory strategy.
//
// The following types satisfy this interface:
//
//	MemoryStrategyInputMemberCustomMemoryStrategy
//	MemoryStrategyInputMemberEpisodicMemoryStrategy
//	MemoryStrategyInputMemberSemanticMemoryStrategy
//	MemoryStrategyInputMemberSummaryMemoryStrategy
//	MemoryStrategyInputMemberUserPreferenceMemoryStrategy
type MemoryStrategyInput interface {
	isMemoryStrategyInput()
}

// Input for creating a custom memory strategy.
type MemoryStrategyInputMemberCustomMemoryStrategy struct {
	Value CustomMemoryStrategyInput

	noSmithyDocumentSerde
}

func (*MemoryStrategyInputMemberCustomMemoryStrategy) isMemoryStrategyInput() {}

// Input for creating an episodic memory strategy
type MemoryStrategyInputMemberEpisodicMemoryStrategy struct {
	Value EpisodicMemoryStrategyInput

	noSmithyDocumentSerde
}

func (*MemoryStrategyInputMemberEpisodicMemoryStrategy) isMemoryStrategyInput() {}

// Input for creating a semantic memory strategy.
type MemoryStrategyInputMemberSemanticMemoryStrategy struct {
	Value SemanticMemoryStrategyInput

	noSmithyDocumentSerde
}

func (*MemoryStrategyInputMemberSemanticMemoryStrategy) isMemoryStrategyInput() {}

// Input for creating a summary memory strategy.
type MemoryStrategyInputMemberSummaryMemoryStrategy struct {
	Value SummaryMemoryStrategyInput

	noSmithyDocumentSerde
}

func (*MemoryStrategyInputMemberSummaryMemoryStrategy) isMemoryStrategyInput() {}

// Input for creating a user preference memory strategy.
type MemoryStrategyInputMemberUserPreferenceMemoryStrategy struct {
	Value UserPreferenceMemoryStrategyInput

	noSmithyDocumentSerde
}

func (*MemoryStrategyInputMemberUserPreferenceMemoryStrategy) isMemoryStrategyInput() {}

// Contains summary information about a memory resource.
type MemorySummary struct {

	// The timestamp when the memory was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The timestamp when the memory was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The Amazon Resource Name (ARN) of the memory.
	Arn *string

	// The unique identifier of the memory.
	Id *string

	// The current status of the memory.
	Status MemoryStatus

	noSmithyDocumentSerde
}

// The trigger configuration based on a message.
type MessageBasedTrigger struct {

	// The number of messages that trigger memory processing.
	MessageCount *int32

	noSmithyDocumentSerde
}

// The trigger configuration based on a message.
type MessageBasedTriggerInput struct {

	// The number of messages that trigger memory processing.
	MessageCount *int32

	noSmithyDocumentSerde
}

// Input configuration for a Microsoft OAuth2 provider.
type MicrosoftOauth2ProviderConfigInput struct {

	// The client ID for the Microsoft OAuth2 provider.
	//
	// This member is required.
	ClientId *string

	// The client secret for the Microsoft OAuth2 provider.
	//
	// This member is required.
	ClientSecret *string

	// The Microsoft Entra ID (formerly Azure AD) tenant ID for your organization.
	// This identifies the specific tenant within Microsoft's identity platform where
	// your application is registered.
	TenantId *string

	noSmithyDocumentSerde
}

// Output configuration for a Microsoft OAuth2 provider.
type MicrosoftOauth2ProviderConfigOutput struct {

	// The OAuth2 discovery information for the Microsoft provider.
	//
	// This member is required.
	OauthDiscovery Oauth2Discovery

	// The client ID for the Microsoft OAuth2 provider.
	ClientId *string

	noSmithyDocumentSerde
}

// Contains information for modifying a consolidation configuration.
//
// The following types satisfy this interface:
//
//	ModifyConsolidationConfigurationMemberCustomConsolidationConfiguration
type ModifyConsolidationConfiguration interface {
	isModifyConsolidationConfiguration()
}

// The updated custom consolidation configuration.
type ModifyConsolidationConfigurationMemberCustomConsolidationConfiguration struct {
	Value CustomConsolidationConfigurationInput

	noSmithyDocumentSerde
}

func (*ModifyConsolidationConfigurationMemberCustomConsolidationConfiguration) isModifyConsolidationConfiguration() {
}

// Contains information for modifying an extraction configuration.
//
// The following types satisfy this interface:
//
//	ModifyExtractionConfigurationMemberCustomExtractionConfiguration
type ModifyExtractionConfiguration interface {
	isModifyExtractionConfiguration()
}

// The updated custom extraction configuration.
type ModifyExtractionConfigurationMemberCustomExtractionConfiguration struct {
	Value CustomExtractionConfigurationInput

	noSmithyDocumentSerde
}

func (*ModifyExtractionConfigurationMemberCustomExtractionConfiguration) isModifyExtractionConfiguration() {
}

// The configuration for updating invocation settings.
type ModifyInvocationConfigurationInput struct {

	// The updated S3 bucket name for event payload delivery.
	PayloadDeliveryBucketName *string

	// The updated ARN of the SNS topic for job notifications.
	TopicArn *string

	noSmithyDocumentSerde
}

// Contains information for modifying memory strategies.
type ModifyMemoryStrategies struct {

	// The list of memory strategies to add.
	AddMemoryStrategies []MemoryStrategyInput

	// The list of memory strategies to delete.
	DeleteMemoryStrategies []DeleteMemoryStrategyInput

	// The list of memory strategies to modify.
	ModifyMemoryStrategies []ModifyMemoryStrategyInput

	noSmithyDocumentSerde
}

// Input for modifying a memory strategy.
type ModifyMemoryStrategyInput struct {

	// The unique identifier of the memory strategy to modify.
	//
	// This member is required.
	MemoryStrategyId *string

	// The updated configuration for the memory strategy.
	Configuration *ModifyStrategyConfiguration

	// The updated description of the memory strategy.
	Description *string

	// The updated namespaces for the memory strategy.
	Namespaces []string

	noSmithyDocumentSerde
}

// Contains information for modifying a reflection configuration.
//
// The following types satisfy this interface:
//
//	ModifyReflectionConfigurationMemberCustomReflectionConfiguration
//	ModifyReflectionConfigurationMemberEpisodicReflectionConfiguration
type ModifyReflectionConfiguration interface {
	isModifyReflectionConfiguration()
}

// The updated custom reflection configuration.
type ModifyReflectionConfigurationMemberCustomReflectionConfiguration struct {
	Value CustomReflectionConfigurationInput

	noSmithyDocumentSerde
}

func (*ModifyReflectionConfigurationMemberCustomReflectionConfiguration) isModifyReflectionConfiguration() {
}

// The updated episodic reflection configuration.
type ModifyReflectionConfigurationMemberEpisodicReflectionConfiguration struct {
	Value EpisodicReflectionConfigurationInput

	noSmithyDocumentSerde
}

func (*ModifyReflectionConfigurationMemberEpisodicReflectionConfiguration) isModifyReflectionConfiguration() {
}

// The configuration for updating the self-managed memory strategy.
type ModifySelfManagedConfiguration struct {

	// The updated number of historical messages to include in processing context.
	HistoricalContextWindowSize *int32

	// The updated configuration to invoke self-managed memory processing pipeline.
	InvocationConfiguration *ModifyInvocationConfigurationInput

	// The updated list of conditions that trigger memory processing.
	TriggerConditions []TriggerConditionInput

	noSmithyDocumentSerde
}

// Contains information for modifying a strategy configuration.
type ModifyStrategyConfiguration struct {

	// The updated consolidation configuration.
	Consolidation ModifyConsolidationConfiguration

	// The updated extraction configuration.
	Extraction ModifyExtractionConfiguration

	// The updated reflection configuration.
	Reflection ModifyReflectionConfiguration

	// The updated self-managed configuration.
	SelfManagedConfiguration *ModifySelfManagedConfiguration

	noSmithyDocumentSerde
}

// SecurityConfig for the Agent.
type NetworkConfiguration struct {

	// The network mode for the AgentCore Runtime.
	//
	// This member is required.
	NetworkMode NetworkMode

	// The network mode configuration for the AgentCore Runtime.
	NetworkModeConfig *VpcConfig

	noSmithyDocumentSerde
}

//	The definition of a numerical rating scale option that provides a numeric
//
// value with its description for evaluation scoring.
type NumericalScaleDefinition struct {

	//  The description that explains what this numerical rating represents and when
	// it should be used.
	//
	// This member is required.
	Definition *string

	//  The label or name that describes this numerical rating option.
	//
	// This member is required.
	Label *string

	//  The numerical value for this rating scale option.
	//
	// This member is required.
	Value *float64

	noSmithyDocumentSerde
}

// Contains the authorization server metadata for an OAuth2 provider.
type Oauth2AuthorizationServerMetadata struct {

	// The authorization endpoint URL for the OAuth2 authorization server.
	//
	// This member is required.
	AuthorizationEndpoint *string

	// The issuer URL for the OAuth2 authorization server.
	//
	// This member is required.
	Issuer *string

	// The token endpoint URL for the OAuth2 authorization server.
	//
	// This member is required.
	TokenEndpoint *string

	// The supported response types for the OAuth2 authorization server.
	ResponseTypes []string

	// The authentication methods supported by the token endpoint. This specifies how
	// clients can authenticate when requesting tokens from the authorization server.
	TokenEndpointAuthMethods []string

	noSmithyDocumentSerde
}

// Contains information about an OAuth2 credential provider.
type Oauth2CredentialProviderItem struct {

	// The timestamp when the OAuth2 credential provider was created.
	//
	// This member is required.
	CreatedTime *time.Time

	// The Amazon Resource Name (ARN) of the OAuth2 credential provider.
	//
	// This member is required.
	CredentialProviderArn *string

	// The vendor of the OAuth2 credential provider.
	//
	// This member is required.
	CredentialProviderVendor CredentialProviderVendorType

	// The timestamp when the OAuth2 credential provider was last updated.
	//
	// This member is required.
	LastUpdatedTime *time.Time

	// The name of the OAuth2 credential provider.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Contains the discovery information for an OAuth2 provider.
//
// The following types satisfy this interface:
//
//	Oauth2DiscoveryMemberAuthorizationServerMetadata
//	Oauth2DiscoveryMemberDiscoveryUrl
type Oauth2Discovery interface {
	isOauth2Discovery()
}

// The authorization server metadata for the OAuth2 provider.
type Oauth2DiscoveryMemberAuthorizationServerMetadata struct {
	Value Oauth2AuthorizationServerMetadata

	noSmithyDocumentSerde
}

func (*Oauth2DiscoveryMemberAuthorizationServerMetadata) isOauth2Discovery() {}

// The discovery URL for the OAuth2 provider.
type Oauth2DiscoveryMemberDiscoveryUrl struct {
	Value string

	noSmithyDocumentSerde
}

func (*Oauth2DiscoveryMemberDiscoveryUrl) isOauth2Discovery() {}

// Contains the input configuration for an OAuth2 provider.
//
// The following types satisfy this interface:
//
//	Oauth2ProviderConfigInputMemberAtlassianOauth2ProviderConfig
//	Oauth2ProviderConfigInputMemberCustomOauth2ProviderConfig
//	Oauth2ProviderConfigInputMemberGithubOauth2ProviderConfig
//	Oauth2ProviderConfigInputMemberGoogleOauth2ProviderConfig
//	Oauth2ProviderConfigInputMemberIncludedOauth2ProviderConfig
//	Oauth2ProviderConfigInputMemberLinkedinOauth2ProviderConfig
//	Oauth2ProviderConfigInputMemberMicrosoftOauth2ProviderConfig
//	Oauth2ProviderConfigInputMemberSalesforceOauth2ProviderConfig
//	Oauth2ProviderConfigInputMemberSlackOauth2ProviderConfig
type Oauth2ProviderConfigInput interface {
	isOauth2ProviderConfigInput()
}

// Configuration settings for Atlassian OAuth2 provider integration.
type Oauth2ProviderConfigInputMemberAtlassianOauth2ProviderConfig struct {
	Value AtlassianOauth2ProviderConfigInput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigInputMemberAtlassianOauth2ProviderConfig) isOauth2ProviderConfigInput() {}

// The configuration for a custom OAuth2 provider.
type Oauth2ProviderConfigInputMemberCustomOauth2ProviderConfig struct {
	Value CustomOauth2ProviderConfigInput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigInputMemberCustomOauth2ProviderConfig) isOauth2ProviderConfigInput() {}

// The configuration for a GitHub OAuth2 provider.
type Oauth2ProviderConfigInputMemberGithubOauth2ProviderConfig struct {
	Value GithubOauth2ProviderConfigInput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigInputMemberGithubOauth2ProviderConfig) isOauth2ProviderConfigInput() {}

// The configuration for a Google OAuth2 provider.
type Oauth2ProviderConfigInputMemberGoogleOauth2ProviderConfig struct {
	Value GoogleOauth2ProviderConfigInput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigInputMemberGoogleOauth2ProviderConfig) isOauth2ProviderConfigInput() {}

// The configuration for a non-custom OAuth2 provider. This includes settings for
// supported OAuth2 providers that have built-in integration support.
type Oauth2ProviderConfigInputMemberIncludedOauth2ProviderConfig struct {
	Value IncludedOauth2ProviderConfigInput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigInputMemberIncludedOauth2ProviderConfig) isOauth2ProviderConfigInput() {}

// Configuration settings for LinkedIn OAuth2 provider integration.
type Oauth2ProviderConfigInputMemberLinkedinOauth2ProviderConfig struct {
	Value LinkedinOauth2ProviderConfigInput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigInputMemberLinkedinOauth2ProviderConfig) isOauth2ProviderConfigInput() {}

// The configuration for a Microsoft OAuth2 provider.
type Oauth2ProviderConfigInputMemberMicrosoftOauth2ProviderConfig struct {
	Value MicrosoftOauth2ProviderConfigInput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigInputMemberMicrosoftOauth2ProviderConfig) isOauth2ProviderConfigInput() {}

// The configuration for a Salesforce OAuth2 provider.
type Oauth2ProviderConfigInputMemberSalesforceOauth2ProviderConfig struct {
	Value SalesforceOauth2ProviderConfigInput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigInputMemberSalesforceOauth2ProviderConfig) isOauth2ProviderConfigInput() {}

// The configuration for a Slack OAuth2 provider.
type Oauth2ProviderConfigInputMemberSlackOauth2ProviderConfig struct {
	Value SlackOauth2ProviderConfigInput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigInputMemberSlackOauth2ProviderConfig) isOauth2ProviderConfigInput() {}

// Contains the output configuration for an OAuth2 provider.
//
// The following types satisfy this interface:
//
//	Oauth2ProviderConfigOutputMemberAtlassianOauth2ProviderConfig
//	Oauth2ProviderConfigOutputMemberCustomOauth2ProviderConfig
//	Oauth2ProviderConfigOutputMemberGithubOauth2ProviderConfig
//	Oauth2ProviderConfigOutputMemberGoogleOauth2ProviderConfig
//	Oauth2ProviderConfigOutputMemberIncludedOauth2ProviderConfig
//	Oauth2ProviderConfigOutputMemberLinkedinOauth2ProviderConfig
//	Oauth2ProviderConfigOutputMemberMicrosoftOauth2ProviderConfig
//	Oauth2ProviderConfigOutputMemberSalesforceOauth2ProviderConfig
//	Oauth2ProviderConfigOutputMemberSlackOauth2ProviderConfig
type Oauth2ProviderConfigOutput interface {
	isOauth2ProviderConfigOutput()
}

// The configuration details for the Atlassian OAuth2 provider.
type Oauth2ProviderConfigOutputMemberAtlassianOauth2ProviderConfig struct {
	Value AtlassianOauth2ProviderConfigOutput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigOutputMemberAtlassianOauth2ProviderConfig) isOauth2ProviderConfigOutput() {
}

// The output configuration for a custom OAuth2 provider.
type Oauth2ProviderConfigOutputMemberCustomOauth2ProviderConfig struct {
	Value CustomOauth2ProviderConfigOutput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigOutputMemberCustomOauth2ProviderConfig) isOauth2ProviderConfigOutput() {}

// The output configuration for a GitHub OAuth2 provider.
type Oauth2ProviderConfigOutputMemberGithubOauth2ProviderConfig struct {
	Value GithubOauth2ProviderConfigOutput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigOutputMemberGithubOauth2ProviderConfig) isOauth2ProviderConfigOutput() {}

// The output configuration for a Google OAuth2 provider.
type Oauth2ProviderConfigOutputMemberGoogleOauth2ProviderConfig struct {
	Value GoogleOauth2ProviderConfigOutput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigOutputMemberGoogleOauth2ProviderConfig) isOauth2ProviderConfigOutput() {}

// The configuration for a non-custom OAuth2 provider. This includes the
// configuration details for supported OAuth2 providers that have built-in
// integration support.
type Oauth2ProviderConfigOutputMemberIncludedOauth2ProviderConfig struct {
	Value IncludedOauth2ProviderConfigOutput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigOutputMemberIncludedOauth2ProviderConfig) isOauth2ProviderConfigOutput() {}

// The configuration details for the LinkedIn OAuth2 provider.
type Oauth2ProviderConfigOutputMemberLinkedinOauth2ProviderConfig struct {
	Value LinkedinOauth2ProviderConfigOutput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigOutputMemberLinkedinOauth2ProviderConfig) isOauth2ProviderConfigOutput() {}

// The output configuration for a Microsoft OAuth2 provider.
type Oauth2ProviderConfigOutputMemberMicrosoftOauth2ProviderConfig struct {
	Value MicrosoftOauth2ProviderConfigOutput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigOutputMemberMicrosoftOauth2ProviderConfig) isOauth2ProviderConfigOutput() {
}

// The output configuration for a Salesforce OAuth2 provider.
type Oauth2ProviderConfigOutputMemberSalesforceOauth2ProviderConfig struct {
	Value SalesforceOauth2ProviderConfigOutput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigOutputMemberSalesforceOauth2ProviderConfig) isOauth2ProviderConfigOutput() {
}

// The output configuration for a Slack OAuth2 provider.
type Oauth2ProviderConfigOutputMemberSlackOauth2ProviderConfig struct {
	Value SlackOauth2ProviderConfigOutput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigOutputMemberSlackOauth2ProviderConfig) isOauth2ProviderConfigOutput() {}

// An OAuth credential provider for gateway authentication. This structure
// contains the configuration for authenticating with the target endpoint using
// OAuth.
type OAuthCredentialProvider struct {

	// The Amazon Resource Name (ARN) of the OAuth credential provider. This ARN
	// identifies the provider in Amazon Web Services.
	//
	// This member is required.
	ProviderArn *string

	// The OAuth scopes for the credential provider. These scopes define the level of
	// access requested from the OAuth provider.
	//
	// This member is required.
	Scopes []string

	// The custom parameters for the OAuth credential provider. These parameters
	// provide additional configuration for the OAuth authentication process.
	CustomParameters map[string]string

	// The URL where the end user's browser is redirected after obtaining the
	// authorization code. Generally points to the customer's application.
	DefaultReturnUrl *string

	// Specifies the kind of credentials to use for authorization:
	//
	//   - CLIENT_CREDENTIALS - Authorization with a client ID and secret.
	//
	//   - AUTHORIZATION_CODE - Authorization with a token that is specific to an
	//   individual end user.
	GrantType OAuthGrantType

	noSmithyDocumentSerde
}

//	The summary information about an online evaluation configuration, including
//
// basic metadata and execution status.
type OnlineEvaluationConfigSummary struct {

	//  The timestamp when the online evaluation configuration was created.
	//
	// This member is required.
	CreatedAt *time.Time

	//  The execution status indicating whether the online evaluation is currently
	// running.
	//
	// This member is required.
	ExecutionStatus OnlineEvaluationExecutionStatus

	//  The Amazon Resource Name (ARN) of the online evaluation configuration.
	//
	// This member is required.
	OnlineEvaluationConfigArn *string

	//  The unique identifier of the online evaluation configuration.
	//
	// This member is required.
	OnlineEvaluationConfigId *string

	//  The name of the online evaluation configuration.
	//
	// This member is required.
	OnlineEvaluationConfigName *string

	//  The status of the online evaluation configuration.
	//
	// This member is required.
	Status OnlineEvaluationConfigStatus

	//  The timestamp when the online evaluation configuration was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	//  The description of the online evaluation configuration.
	Description *string

	//  The reason for failure if the online evaluation configuration execution
	// failed.
	FailureReason *string

	noSmithyDocumentSerde
}

//	The configuration that specifies where evaluation results should be written
//
// for monitoring and analysis.
type OutputConfig struct {

	//  The CloudWatch configuration for writing evaluation results to CloudWatch logs
	// with embedded metric format.
	//
	// This member is required.
	CloudWatchConfig *CloudWatchOutputConfig

	noSmithyDocumentSerde
}

// Represents a complete policy resource within the AgentCore Policy system.
// Policies are ARN-able resources that contain Cedar policy statements and
// associated metadata for controlling agent behavior and access decisions. Each
// policy belongs to a policy engine and defines fine-grained authorization rules
// that are evaluated in real-time as agents interact with tools through Gateway.
// Policies use the Cedar policy language to specify who (principals based on OAuth
// claims like username, role, or scope) can perform what actions (tool calls) on
// which resources (Gateways), with optional conditions for attribute-based access
// control. Multiple policies can apply to a single request, with Cedar's
// forbid-wins semantics ensuring that security restrictions are never accidentally
// overridden.
type Policy struct {

	// The timestamp when the policy was originally created. This is automatically set
	// by the service and used for auditing and lifecycle management.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Cedar policy statement that defines the access control rules. This contains
	// the actual policy logic used for agent behavior control and access decisions.
	//
	// This member is required.
	Definition PolicyDefinition

	// The customer-assigned immutable name for the policy. This human-readable
	// identifier must be unique within the account and cannot exceed 48 characters.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) of the policy. This globally unique identifier
	// can be used for cross-service references and IAM policy statements.
	//
	// This member is required.
	PolicyArn *string

	// The identifier of the policy engine that manages this policy. This establishes
	// the policy engine context for policy evaluation and management.
	//
	// This member is required.
	PolicyEngineId *string

	// The unique identifier for the policy. This system-generated identifier consists
	// of the user name plus a 10-character generated suffix and serves as the primary
	// key for policy operations.
	//
	// This member is required.
	PolicyId *string

	// The current status of the policy.
	//
	// This member is required.
	Status PolicyStatus

	// Additional information about the policy status. This provides details about any
	// failures or the current state of the policy lifecycle.
	//
	// This member is required.
	StatusReasons []string

	// The timestamp when the policy was last modified. This tracks the most recent
	// changes to the policy configuration or metadata.
	//
	// This member is required.
	UpdatedAt *time.Time

	// A human-readable description of the policy's purpose and functionality. Limited
	// to 4,096 characters, this helps administrators understand and manage the policy.
	Description *string

	noSmithyDocumentSerde
}

// Represents the definition structure for policies within the AgentCore Policy
// system. This structure encapsulates different policy formats and languages that
// can be used to define access control rules.
//
// The following types satisfy this interface:
//
//	PolicyDefinitionMemberCedar
type PolicyDefinition interface {
	isPolicyDefinition()
}

// The Cedar policy definition within the policy definition structure. This
// contains the Cedar policy statement that defines the authorization logic using
// Cedar's human-readable, analyzable policy language. Cedar policies specify
// principals (who can access), actions (what operations are allowed), resources
// (what can be accessed), and optional conditions for fine-grained control. Cedar
// provides a formal policy language designed for authorization with deterministic
// evaluation, making policies testable, reviewable, and auditable. All Cedar
// policies follow a default-deny model where actions are denied unless explicitly
// permitted, and forbid policies always override permit policies.
type PolicyDefinitionMemberCedar struct {
	Value CedarPolicy

	noSmithyDocumentSerde
}

func (*PolicyDefinitionMemberCedar) isPolicyDefinition() {}

// Represents a policy engine resource within the AgentCore Policy system. Policy
// engines serve as containers for grouping related policies and provide the
// execution context for policy evaluation and management. Each policy engine can
// be associated with one Gateway (one engine per Gateway), where it intercepts all
// agent tool calls and evaluates them against the contained policies before
// allowing tools to execute. The policy engine maintains the Cedar schema
// generated from the Gateway's tool manifest, ensuring that policies are validated
// against the actual tools and parameters available. Policy engines support two
// enforcement modes that can be configured when associating with a Gateway:
// log-only mode for testing (evaluates decisions without blocking) and enforce
// mode for production (actively allows or denies based on policy evaluation).
type PolicyEngine struct {

	// The timestamp when the policy engine was originally created. This is
	// automatically set by the service and used for auditing and lifecycle management.
	//
	// This member is required.
	CreatedAt *time.Time

	// The customer-assigned immutable name for the policy engine. This human-readable
	// identifier must be unique within the account and cannot exceed 48 characters.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) of the policy engine. This globally unique
	// identifier can be used for cross-service references and IAM policy statements.
	//
	// This member is required.
	PolicyEngineArn *string

	// The unique identifier for the policy engine. This system-generated identifier
	// consists of the user name plus a 10-character generated suffix and serves as the
	// primary key for policy engine operations.
	//
	// This member is required.
	PolicyEngineId *string

	// The current status of the policy engine.
	//
	// This member is required.
	Status PolicyEngineStatus

	// Additional information about the policy engine status. This provides details
	// about any failures or the current state of the policy engine lifecycle.
	//
	// This member is required.
	StatusReasons []string

	// The timestamp when the policy engine was last modified. This tracks the most
	// recent changes to the policy engine configuration or metadata.
	//
	// This member is required.
	UpdatedAt *time.Time

	// A human-readable description of the policy engine's purpose and scope. Limited
	// to 4,096 characters, this helps administrators understand the policy engine's
	// role in the overall governance strategy.
	Description *string

	noSmithyDocumentSerde
}

// Represents a policy generation request within the AgentCore Policy system.
// Tracks the AI-powered conversion of natural language descriptions into Cedar
// policy statements, enabling users to author policies by describing authorization
// requirements in plain English. The generation process analyzes the natural
// language input along with the Gateway's tool context and Cedar schema to produce
// one or more validated policy options. Each generation request tracks the status
// of the conversion process and maintains findings about the generated policies,
// including validation results and potential issues. Generated policy assets
// remain available for one week after successful generation, allowing time to
// review and create policies from the generated options.
type PolicyGeneration struct {

	// The timestamp when this policy generation request was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The customer-assigned name for this policy generation request.
	//
	// This member is required.
	Name *string

	// The identifier of the policy engine associated with this generation request.
	//
	// This member is required.
	PolicyEngineId *string

	// The ARN of this policy generation request.
	//
	// This member is required.
	PolicyGenerationArn *string

	// The unique identifier for this policy generation request.
	//
	// This member is required.
	PolicyGenerationId *string

	// The resource information associated with this policy generation.
	//
	// This member is required.
	Resource Resource

	// The current status of this policy generation request.
	//
	// This member is required.
	Status PolicyGenerationStatus

	// Additional information about the generation status.
	//
	// This member is required.
	StatusReasons []string

	// The timestamp when this policy generation was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Findings and insights from this policy generation process.
	Findings *string

	noSmithyDocumentSerde
}

// Represents a generated policy asset from the AI-powered policy generation
// process within the AgentCore Policy system. Each asset contains a Cedar policy
// statement generated from natural language input, along with associated metadata
// and analysis findings to help users evaluate and select the most appropriate
// policy option.
type PolicyGenerationAsset struct {

	// Analysis findings and insights related to this specific generated policy asset.
	// These findings may include validation results, potential issues, or
	// recommendations for improvement to help users evaluate the quality and
	// appropriateness of the generated policy.
	//
	// This member is required.
	Findings []Finding

	// The unique identifier for this generated policy asset within the policy
	// generation request. This ID can be used to reference specific generated policy
	// options when creating actual policies from the generation results.
	//
	// This member is required.
	PolicyGenerationAssetId *string

	// The portion of the original natural language input that this generated policy
	// asset addresses. This helps users understand which part of their policy
	// description was translated into this specific Cedar policy statement, enabling
	// better policy selection and refinement. When a single natural language input
	// describes multiple authorization requirements, the generation process creates
	// separate policy assets for each requirement, with each asset's rawTextFragment
	// showing which requirement it addresses. Use this mapping to verify that all
	// parts of your natural language input were correctly translated into Cedar
	// policies.
	//
	// This member is required.
	RawTextFragment *string

	// Represents the definition structure for policies within the AgentCore Policy
	// system. This structure encapsulates different policy formats and languages that
	// can be used to define access control rules.
	Definition PolicyDefinition

	noSmithyDocumentSerde
}

// The protocol configuration for an agent runtime. This structure defines how the
// agent runtime communicates with clients.
type ProtocolConfiguration struct {

	// The server protocol for the agent runtime. This field specifies which protocol
	// the agent runtime uses to communicate with clients.
	//
	// This member is required.
	ServerProtocol ServerProtocol

	noSmithyDocumentSerde
}

//	The rating scale that defines how evaluators should score agent performance,
//
// supporting both numerical and categorical scales.
//
// The following types satisfy this interface:
//
//	RatingScaleMemberCategorical
//	RatingScaleMemberNumerical
type RatingScale interface {
	isRatingScale()
}

//	The categorical rating scale with named categories and definitions for
//
// qualitative evaluation.
type RatingScaleMemberCategorical struct {
	Value []CategoricalScaleDefinition

	noSmithyDocumentSerde
}

func (*RatingScaleMemberCategorical) isRatingScale() {}

//	The numerical rating scale with defined score values and descriptions for
//
// quantitative evaluation.
type RatingScaleMemberNumerical struct {
	Value []NumericalScaleDefinition

	noSmithyDocumentSerde
}

func (*RatingScaleMemberNumerical) isRatingScale() {}

// The recording configuration for a browser. This structure defines how browser
// sessions are recorded.
type RecordingConfig struct {

	// Indicates whether recording is enabled for the browser. When set to true,
	// browser sessions are recorded.
	Enabled bool

	// The Amazon S3 location where browser recordings are stored. This location
	// contains the recorded browser sessions.
	S3Location *S3Location

	noSmithyDocumentSerde
}

// Contains reflection configuration information for a memory strategy.
//
// The following types satisfy this interface:
//
//	ReflectionConfigurationMemberCustomReflectionConfiguration
//	ReflectionConfigurationMemberEpisodicReflectionConfiguration
type ReflectionConfiguration interface {
	isReflectionConfiguration()
}

// The configuration for a custom reflection strategy.
type ReflectionConfigurationMemberCustomReflectionConfiguration struct {
	Value CustomReflectionConfiguration

	noSmithyDocumentSerde
}

func (*ReflectionConfigurationMemberCustomReflectionConfiguration) isReflectionConfiguration() {}

// The configuration for the episodic reflection strategy.
type ReflectionConfigurationMemberEpisodicReflectionConfiguration struct {
	Value EpisodicReflectionConfiguration

	noSmithyDocumentSerde
}

func (*ReflectionConfigurationMemberEpisodicReflectionConfiguration) isReflectionConfiguration() {}

// Configuration for HTTP request headers that will be passed through to the
// runtime.
//
// The following types satisfy this interface:
//
//	RequestHeaderConfigurationMemberRequestHeaderAllowlist
type RequestHeaderConfiguration interface {
	isRequestHeaderConfiguration()
}

// A list of HTTP request headers that are allowed to be passed through to the
// runtime.
type RequestHeaderConfigurationMemberRequestHeaderAllowlist struct {
	Value []string

	noSmithyDocumentSerde
}

func (*RequestHeaderConfigurationMemberRequestHeaderAllowlist) isRequestHeaderConfiguration() {}

// Represents a resource within the AgentCore Policy system. Resources are the
// targets of policy evaluation. Currently, only AgentCore Gateways are supported
// as resources for policy enforcement.
//
// The following types satisfy this interface:
//
//	ResourceMemberArn
type Resource interface {
	isResource()
}

// The Amazon Resource Name (ARN) of the resource. This globally unique identifier
// specifies the exact resource that policies will be evaluated against for access
// control decisions.
type ResourceMemberArn struct {
	Value string

	noSmithyDocumentSerde
}

func (*ResourceMemberArn) isResource() {}

//	The evaluation rule that defines sampling configuration, filtering criteria,
//
// and session detection settings for online evaluation.
type Rule struct {

	//  The sampling configuration that determines what percentage of agent traces to
	// evaluate.
	//
	// This member is required.
	SamplingConfig *SamplingConfig

	//  The list of filters that determine which agent traces should be included in
	// the evaluation based on trace properties.
	Filters []Filter

	//  The session configuration that defines timeout settings for detecting when
	// agent sessions are complete and ready for evaluation.
	SessionConfig *SessionConfig

	noSmithyDocumentSerde
}

// The Amazon S3 configuration for a gateway. This structure defines how the
// gateway accesses files in Amazon S3.
type S3Configuration struct {

	// The account ID of the Amazon S3 bucket owner. This ID is used for cross-account
	// access to the bucket.
	BucketOwnerAccountId *string

	// The URI of the Amazon S3 object. This URI specifies the location of the object
	// in Amazon S3.
	Uri *string

	noSmithyDocumentSerde
}

// The Amazon S3 location for storing data. This structure defines where in Amazon
// S3 data is stored.
type S3Location struct {

	// The name of the Amazon S3 bucket. This bucket contains the stored data.
	//
	// This member is required.
	Bucket *string

	// The prefix for objects in the Amazon S3 bucket. This prefix is added to the
	// object keys to organize the data.
	//
	// This member is required.
	Prefix *string

	// The version ID of the Amazon Amazon S3 object. If not specified, the latest
	// version of the object is used.
	VersionId *string

	noSmithyDocumentSerde
}

// Input configuration for a Salesforce OAuth2 provider.
type SalesforceOauth2ProviderConfigInput struct {

	// The client ID for the Salesforce OAuth2 provider.
	//
	// This member is required.
	ClientId *string

	// The client secret for the Salesforce OAuth2 provider.
	//
	// This member is required.
	ClientSecret *string

	noSmithyDocumentSerde
}

// Output configuration for a Salesforce OAuth2 provider.
type SalesforceOauth2ProviderConfigOutput struct {

	// The OAuth2 discovery information for the Salesforce provider.
	//
	// This member is required.
	OauthDiscovery Oauth2Discovery

	// The client ID for the Salesforce OAuth2 provider.
	ClientId *string

	noSmithyDocumentSerde
}

//	The configuration that controls what percentage of agent traces are sampled
//
// for evaluation to manage evaluation volume and costs.
type SamplingConfig struct {

	//  The percentage of agent traces to sample for evaluation, ranging from 0.01% to
	// 100%.
	//
	// This member is required.
	SamplingPercentage *float64

	noSmithyDocumentSerde
}

// A schema definition for a gateway target. This structure defines the structure
// of the API that the target exposes.
type SchemaDefinition struct {

	// The type of the schema definition. This field specifies the data type of the
	// schema.
	//
	// This member is required.
	Type SchemaType

	// The description of the schema definition. This description provides information
	// about the purpose and usage of the schema.
	Description *string

	// The items in the schema definition. This field is used for array types to
	// define the structure of the array elements.
	Items *SchemaDefinition

	// The properties of the schema definition. These properties define the fields in
	// the schema.
	Properties map[string]SchemaDefinition

	// The required fields in the schema definition. These fields must be provided
	// when using the schema.
	Required []string

	noSmithyDocumentSerde
}

// Contains information about a secret in AWS Secrets Manager.
type Secret struct {

	// The Amazon Resource Name (ARN) of the secret in AWS Secrets Manager.
	//
	// This member is required.
	SecretArn *string

	noSmithyDocumentSerde
}

// A configuration for a self-managed memory strategy.
type SelfManagedConfiguration struct {

	// The number of historical messages to include in processing context.
	//
	// This member is required.
	HistoricalContextWindowSize *int32

	// The configuration to use when invoking memory processing.
	//
	// This member is required.
	InvocationConfiguration *InvocationConfiguration

	// A list of conditions that trigger memory processing.
	//
	// This member is required.
	TriggerConditions []TriggerCondition

	noSmithyDocumentSerde
}

// Input configuration for a self-managed memory strategy.
type SelfManagedConfigurationInput struct {

	// Configuration to invoke a self-managed memory processing pipeline with.
	//
	// This member is required.
	InvocationConfiguration *InvocationConfigurationInput

	// Number of historical messages to include in processing context.
	HistoricalContextWindowSize *int32

	// A list of conditions that trigger memory processing.
	TriggerConditions []TriggerConditionInput

	noSmithyDocumentSerde
}

// Contains semantic consolidation override configuration.
type SemanticConsolidationOverride struct {

	// The text to append to the prompt for semantic consolidation.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for semantic consolidation.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// Contains semantic extraction override configuration.
type SemanticExtractionOverride struct {

	// The text to append to the prompt for semantic extraction.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for semantic extraction.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// Input for creating a semantic memory strategy.
type SemanticMemoryStrategyInput struct {

	// The name of the semantic memory strategy.
	//
	// This member is required.
	Name *string

	// The description of the semantic memory strategy.
	Description *string

	// The namespaces associated with the semantic memory strategy.
	Namespaces []string

	noSmithyDocumentSerde
}

// Input for semantic override configuration in a memory strategy.
type SemanticOverrideConfigurationInput struct {

	// The consolidation configuration for a semantic override.
	Consolidation *SemanticOverrideConsolidationConfigurationInput

	// The extraction configuration for a semantic override.
	Extraction *SemanticOverrideExtractionConfigurationInput

	noSmithyDocumentSerde
}

// Input for semantic override consolidation configuration in a memory strategy.
type SemanticOverrideConsolidationConfigurationInput struct {

	// The text to append to the prompt for semantic consolidation.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for semantic consolidation.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// Input for semantic override extraction configuration in a memory strategy.
type SemanticOverrideExtractionConfigurationInput struct {

	// The text to append to the prompt for semantic extraction.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for semantic extraction.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

//	The configuration that defines how agent sessions are detected and when they
//
// are considered complete for evaluation.
type SessionConfig struct {

	//  The number of minutes of inactivity after which an agent session is considered
	// complete and ready for evaluation. Default is 15 minutes.
	//
	// This member is required.
	SessionTimeoutMinutes *int32

	noSmithyDocumentSerde
}

// Input configuration for a Slack OAuth2 provider.
type SlackOauth2ProviderConfigInput struct {

	// The client ID for the Slack OAuth2 provider.
	//
	// This member is required.
	ClientId *string

	// The client secret for the Slack OAuth2 provider.
	//
	// This member is required.
	ClientSecret *string

	noSmithyDocumentSerde
}

// Output configuration for a Slack OAuth2 provider.
type SlackOauth2ProviderConfigOutput struct {

	// The OAuth2 discovery information for the Slack provider.
	//
	// This member is required.
	OauthDiscovery Oauth2Discovery

	// The client ID for the Slack OAuth2 provider.
	ClientId *string

	noSmithyDocumentSerde
}

// Contains configuration information for a memory strategy.
type StrategyConfiguration struct {

	// The consolidation configuration for the memory strategy.
	Consolidation ConsolidationConfiguration

	// The extraction configuration for the memory strategy.
	Extraction ExtractionConfiguration

	// The reflection configuration for the memory strategy.
	Reflection ReflectionConfiguration

	// Self-managed configuration settings.
	SelfManagedConfiguration *SelfManagedConfiguration

	// The type of override for the strategy configuration.
	Type OverrideType

	noSmithyDocumentSerde
}

// Contains summary consolidation override configuration.
type SummaryConsolidationOverride struct {

	// The text to append to the prompt for summary consolidation.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for summary consolidation.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// Input for creating a summary memory strategy.
type SummaryMemoryStrategyInput struct {

	// The name of the summary memory strategy.
	//
	// This member is required.
	Name *string

	// The description of the summary memory strategy.
	Description *string

	// The namespaces associated with the summary memory strategy.
	Namespaces []string

	noSmithyDocumentSerde
}

// Input for summary override configuration in a memory strategy.
type SummaryOverrideConfigurationInput struct {

	// The consolidation configuration for a summary override.
	Consolidation *SummaryOverrideConsolidationConfigurationInput

	noSmithyDocumentSerde
}

// Input for summary override consolidation configuration in a memory strategy.
type SummaryOverrideConsolidationConfigurationInput struct {

	// The text to append to the prompt for summary consolidation.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for summary consolidation.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// The configuration for a gateway target. This structure defines how the gateway
// connects to and interacts with the target endpoint.
//
// The following types satisfy this interface:
//
//	TargetConfigurationMemberMcp
type TargetConfiguration interface {
	isTargetConfiguration()
}

// The Model Context Protocol (MCP) configuration for the target. This
// configuration defines how the gateway uses MCP to communicate with the target.
type TargetConfigurationMemberMcp struct {
	Value McpTargetConfiguration

	noSmithyDocumentSerde
}

func (*TargetConfigurationMemberMcp) isTargetConfiguration() {}

// Contains summary information about a gateway target. A target represents an
// endpoint that the gateway can connect to.
type TargetSummary struct {

	// The timestamp when the target was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The name of the target.
	//
	// This member is required.
	Name *string

	// The current status of the target.
	//
	// This member is required.
	Status TargetStatus

	// The unique identifier of the target.
	//
	// This member is required.
	TargetId *string

	// The timestamp when the target was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the target.
	Description *string

	noSmithyDocumentSerde
}

// Trigger configuration based on time.
type TimeBasedTrigger struct {

	// Idle session timeout (seconds) that triggers memory processing.
	IdleSessionTimeout *int32

	noSmithyDocumentSerde
}

// Trigger configuration based on time.
type TimeBasedTriggerInput struct {

	// Idle session timeout (seconds) that triggers memory processing.
	IdleSessionTimeout *int32

	noSmithyDocumentSerde
}

// Trigger configuration based on tokens.
type TokenBasedTrigger struct {

	// Number of tokens that trigger memory processing.
	TokenCount *int32

	noSmithyDocumentSerde
}

// Trigger configuration based on tokens.
type TokenBasedTriggerInput struct {

	// Number of tokens that trigger memory processing.
	TokenCount *int32

	noSmithyDocumentSerde
}

// A tool definition for a gateway target. This structure defines a tool that the
// target exposes through the Model Context Protocol.
type ToolDefinition struct {

	// The description of the tool. This description provides information about the
	// purpose and usage of the tool.
	//
	// This member is required.
	Description *string

	// The input schema for the tool. This schema defines the structure of the input
	// that the tool accepts.
	//
	// This member is required.
	InputSchema *SchemaDefinition

	// The name of the tool. This name identifies the tool in the Model Context
	// Protocol.
	//
	// This member is required.
	Name *string

	// The output schema for the tool. This schema defines the structure of the output
	// that the tool produces.
	OutputSchema *SchemaDefinition

	noSmithyDocumentSerde
}

// A tool schema for a gateway target. This structure defines the schema for a
// tool that the target exposes through the Model Context Protocol.
//
// The following types satisfy this interface:
//
//	ToolSchemaMemberInlinePayload
//	ToolSchemaMemberS3
type ToolSchema interface {
	isToolSchema()
}

// The inline payload of the tool schema. This payload contains the schema
// definition directly in the request.
type ToolSchemaMemberInlinePayload struct {
	Value []ToolDefinition

	noSmithyDocumentSerde
}

func (*ToolSchemaMemberInlinePayload) isToolSchema() {}

// The Amazon S3 location of the tool schema. This location contains the schema
// definition file.
type ToolSchemaMemberS3 struct {
	Value S3Configuration

	noSmithyDocumentSerde
}

func (*ToolSchemaMemberS3) isToolSchema() {}

// Condition that triggers memory processing.
//
// The following types satisfy this interface:
//
//	TriggerConditionMemberMessageBasedTrigger
//	TriggerConditionMemberTimeBasedTrigger
//	TriggerConditionMemberTokenBasedTrigger
type TriggerCondition interface {
	isTriggerCondition()
}

// Message based trigger configuration.
type TriggerConditionMemberMessageBasedTrigger struct {
	Value MessageBasedTrigger

	noSmithyDocumentSerde
}

func (*TriggerConditionMemberMessageBasedTrigger) isTriggerCondition() {}

// Time based trigger configuration.
type TriggerConditionMemberTimeBasedTrigger struct {
	Value TimeBasedTrigger

	noSmithyDocumentSerde
}

func (*TriggerConditionMemberTimeBasedTrigger) isTriggerCondition() {}

// Token based trigger configuration.
type TriggerConditionMemberTokenBasedTrigger struct {
	Value TokenBasedTrigger

	noSmithyDocumentSerde
}

func (*TriggerConditionMemberTokenBasedTrigger) isTriggerCondition() {}

// Condition that triggers memory processing.
//
// The following types satisfy this interface:
//
//	TriggerConditionInputMemberMessageBasedTrigger
//	TriggerConditionInputMemberTimeBasedTrigger
//	TriggerConditionInputMemberTokenBasedTrigger
type TriggerConditionInput interface {
	isTriggerConditionInput()
}

// Message based trigger configuration.
type TriggerConditionInputMemberMessageBasedTrigger struct {
	Value MessageBasedTriggerInput

	noSmithyDocumentSerde
}

func (*TriggerConditionInputMemberMessageBasedTrigger) isTriggerConditionInput() {}

// Time based trigger configuration.
type TriggerConditionInputMemberTimeBasedTrigger struct {
	Value TimeBasedTriggerInput

	noSmithyDocumentSerde
}

func (*TriggerConditionInputMemberTimeBasedTrigger) isTriggerConditionInput() {}

// Token based trigger configuration.
type TriggerConditionInputMemberTokenBasedTrigger struct {
	Value TokenBasedTriggerInput

	noSmithyDocumentSerde
}

func (*TriggerConditionInputMemberTokenBasedTrigger) isTriggerConditionInput() {}

// Contains user preference consolidation override configuration.
type UserPreferenceConsolidationOverride struct {

	// The text to append to the prompt for user preference consolidation.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for user preference consolidation.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// Contains user preference extraction override configuration.
type UserPreferenceExtractionOverride struct {

	// The text to append to the prompt for user preference extraction.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for user preference extraction.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// Input for creating a user preference memory strategy.
type UserPreferenceMemoryStrategyInput struct {

	// The name of the user preference memory strategy.
	//
	// This member is required.
	Name *string

	// The description of the user preference memory strategy.
	Description *string

	// The namespaces associated with the user preference memory strategy.
	Namespaces []string

	noSmithyDocumentSerde
}

// Input for user preference override configuration in a memory strategy.
type UserPreferenceOverrideConfigurationInput struct {

	// The consolidation configuration for a user preference override.
	Consolidation *UserPreferenceOverrideConsolidationConfigurationInput

	// The extraction configuration for a user preference override.
	Extraction *UserPreferenceOverrideExtractionConfigurationInput

	noSmithyDocumentSerde
}

// Input for user preference override consolidation configuration in a memory
// strategy.
type UserPreferenceOverrideConsolidationConfigurationInput struct {

	// The text to append to the prompt for user preference consolidation.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for user preference consolidation.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// Input for user preference override extraction configuration in a memory
// strategy.
type UserPreferenceOverrideExtractionConfigurationInput struct {

	// The text to append to the prompt for user preference extraction.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for user preference extraction.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// Stores information about a field passed inside a request that resulted in an
// exception.
type ValidationExceptionField struct {

	// A message describing why this field failed validation.
	//
	// This member is required.
	Message *string

	// The name of the field.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// VpcConfig for the Agent.
type VpcConfig struct {

	// The security groups associated with the VPC configuration.
	//
	// This member is required.
	SecurityGroups []string

	// The subnets associated with the VPC configuration.
	//
	// This member is required.
	Subnets []string

	noSmithyDocumentSerde
}

// The information about the workload identity.
type WorkloadIdentityDetails struct {

	// The ARN associated with the workload identity.
	//
	// This member is required.
	WorkloadIdentityArn *string

	noSmithyDocumentSerde
}

// Contains information about a workload identity.
type WorkloadIdentityType struct {

	// The name of the workload identity.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) of the workload identity.
	//
	// This member is required.
	WorkloadIdentityArn *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAgentRuntimeArtifact()                  {}
func (*UnknownUnionMember) isApiSchemaConfiguration()                {}
func (*UnknownUnionMember) isAuthorizerConfiguration()               {}
func (*UnknownUnionMember) isClaimMatchValueType()                   {}
func (*UnknownUnionMember) isCode()                                  {}
func (*UnknownUnionMember) isConsolidationConfiguration()            {}
func (*UnknownUnionMember) isContent()                               {}
func (*UnknownUnionMember) isCredentialProvider()                    {}
func (*UnknownUnionMember) isCustomConfigurationInput()              {}
func (*UnknownUnionMember) isCustomConsolidationConfiguration()      {}
func (*UnknownUnionMember) isCustomConsolidationConfigurationInput() {}
func (*UnknownUnionMember) isCustomExtractionConfiguration()         {}
func (*UnknownUnionMember) isCustomExtractionConfigurationInput()    {}
func (*UnknownUnionMember) isCustomReflectionConfiguration()         {}
func (*UnknownUnionMember) isCustomReflectionConfigurationInput()    {}
func (*UnknownUnionMember) isDataSourceConfig()                      {}
func (*UnknownUnionMember) isEvaluatorConfig()                       {}
func (*UnknownUnionMember) isEvaluatorModelConfig()                  {}
func (*UnknownUnionMember) isEvaluatorReference()                    {}
func (*UnknownUnionMember) isExtractionConfiguration()               {}
func (*UnknownUnionMember) isFilterValue()                           {}
func (*UnknownUnionMember) isGatewayProtocolConfiguration()          {}
func (*UnknownUnionMember) isInterceptorConfiguration()              {}
func (*UnknownUnionMember) isMcpTargetConfiguration()                {}
func (*UnknownUnionMember) isMemoryStrategyInput()                   {}
func (*UnknownUnionMember) isModifyConsolidationConfiguration()      {}
func (*UnknownUnionMember) isModifyExtractionConfiguration()         {}
func (*UnknownUnionMember) isModifyReflectionConfiguration()         {}
func (*UnknownUnionMember) isOauth2Discovery()                       {}
func (*UnknownUnionMember) isOauth2ProviderConfigInput()             {}
func (*UnknownUnionMember) isOauth2ProviderConfigOutput()            {}
func (*UnknownUnionMember) isPolicyDefinition()                      {}
func (*UnknownUnionMember) isRatingScale()                           {}
func (*UnknownUnionMember) isReflectionConfiguration()               {}
func (*UnknownUnionMember) isRequestHeaderConfiguration()            {}
func (*UnknownUnionMember) isResource()                              {}
func (*UnknownUnionMember) isTargetConfiguration()                   {}
func (*UnknownUnionMember) isToolSchema()                            {}
func (*UnknownUnionMember) isTriggerCondition()                      {}
func (*UnknownUnionMember) isTriggerConditionInput()                 {}
