// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates an existing policy engine within the AgentCore Policy system. This
// operation allows modification of the policy engine description while maintaining
// its identity. This is an asynchronous operation. Use the GetPolicyEngine
// operation to poll the status field to track completion.
func (c *Client) UpdatePolicyEngine(ctx context.Context, params *UpdatePolicyEngineInput, optFns ...func(*Options)) (*UpdatePolicyEngineOutput, error) {
	if params == nil {
		params = &UpdatePolicyEngineInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdatePolicyEngine", params, optFns, c.addOperationUpdatePolicyEngineMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdatePolicyEngineOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdatePolicyEngineInput struct {

	// The unique identifier of the policy engine to be updated.
	//
	// This member is required.
	PolicyEngineId *string

	// The new description for the policy engine.
	Description *string

	noSmithyDocumentSerde
}

type UpdatePolicyEngineOutput struct {

	// The original creation timestamp of the policy engine.
	//
	// This member is required.
	CreatedAt *time.Time

	// The name of the updated policy engine.
	//
	// This member is required.
	Name *string

	// The ARN of the updated policy engine.
	//
	// This member is required.
	PolicyEngineArn *string

	// The unique identifier of the updated policy engine.
	//
	// This member is required.
	PolicyEngineId *string

	// The current status of the updated policy engine.
	//
	// This member is required.
	Status types.PolicyEngineStatus

	// Additional information about the update status.
	//
	// This member is required.
	StatusReasons []string

	// The timestamp when the policy engine was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The updated description of the policy engine.
	Description *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdatePolicyEngineMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdatePolicyEngine{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdatePolicyEngine{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdatePolicyEngine"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdatePolicyEngineValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdatePolicyEngine(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdatePolicyEngine(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdatePolicyEngine",
	}
}
