// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	Updates an online evaluation configuration's settings, including rules, data
//
// sources, evaluators, and execution status. Changes take effect immediately for
// ongoing evaluations.
func (c *Client) UpdateOnlineEvaluationConfig(ctx context.Context, params *UpdateOnlineEvaluationConfigInput, optFns ...func(*Options)) (*UpdateOnlineEvaluationConfigOutput, error) {
	if params == nil {
		params = &UpdateOnlineEvaluationConfigInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateOnlineEvaluationConfig", params, optFns, c.addOperationUpdateOnlineEvaluationConfigMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateOnlineEvaluationConfigOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateOnlineEvaluationConfigInput struct {

	//  The unique identifier of the online evaluation configuration to update.
	//
	// This member is required.
	OnlineEvaluationConfigId *string

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than one time. If you don't specify this field, a value is randomly
	// generated for you. If this token matches a previous request, the service ignores
	// the request, but doesn't return an error. For more information, see [Ensuring idempotency].
	//
	// [Ensuring idempotency]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
	ClientToken *string

	//  The updated data source configuration specifying CloudWatch log groups and
	// service names to monitor.
	DataSourceConfig types.DataSourceConfig

	//  The updated description of the online evaluation configuration.
	Description *string

	//  The updated Amazon Resource Name (ARN) of the IAM role used for evaluation
	// execution.
	EvaluationExecutionRoleArn *string

	//  The updated list of evaluators to apply during online evaluation.
	Evaluators []types.EvaluatorReference

	//  The updated execution status to enable or disable the online evaluation.
	ExecutionStatus types.OnlineEvaluationExecutionStatus

	//  The updated evaluation rule containing sampling configuration, filters, and
	// session settings.
	Rule *types.Rule

	noSmithyDocumentSerde
}

type UpdateOnlineEvaluationConfigOutput struct {

	//  The execution status indicating whether the online evaluation is currently
	// running.
	//
	// This member is required.
	ExecutionStatus types.OnlineEvaluationExecutionStatus

	//  The Amazon Resource Name (ARN) of the updated online evaluation configuration.
	//
	// This member is required.
	OnlineEvaluationConfigArn *string

	//  The unique identifier of the updated online evaluation configuration.
	//
	// This member is required.
	OnlineEvaluationConfigId *string

	//  The status of the online evaluation configuration.
	//
	// This member is required.
	Status types.OnlineEvaluationConfigStatus

	//  The timestamp when the online evaluation configuration was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	//  The reason for failure if the online evaluation configuration update or
	// execution failed.
	FailureReason *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateOnlineEvaluationConfigMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateOnlineEvaluationConfig{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateOnlineEvaluationConfig{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateOnlineEvaluationConfig"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opUpdateOnlineEvaluationConfigMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateOnlineEvaluationConfigValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateOnlineEvaluationConfig(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpUpdateOnlineEvaluationConfig struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpUpdateOnlineEvaluationConfig) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpUpdateOnlineEvaluationConfig) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*UpdateOnlineEvaluationConfigInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *UpdateOnlineEvaluationConfigInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opUpdateOnlineEvaluationConfigMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpUpdateOnlineEvaluationConfig{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opUpdateOnlineEvaluationConfig(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateOnlineEvaluationConfig",
	}
}
