// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Lists all online evaluation configurations in the account, providing summary
//
// information about each configuration's status and settings.
func (c *Client) ListOnlineEvaluationConfigs(ctx context.Context, params *ListOnlineEvaluationConfigsInput, optFns ...func(*Options)) (*ListOnlineEvaluationConfigsOutput, error) {
	if params == nil {
		params = &ListOnlineEvaluationConfigsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListOnlineEvaluationConfigs", params, optFns, c.addOperationListOnlineEvaluationConfigsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListOnlineEvaluationConfigsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListOnlineEvaluationConfigsInput struct {

	//  The maximum number of online evaluation configurations to return in a single
	// response.
	MaxResults *int32

	//  The pagination token from a previous request to retrieve the next page of
	// results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListOnlineEvaluationConfigsOutput struct {

	//  The list of online evaluation configuration summaries containing basic
	// information about each configuration.
	//
	// This member is required.
	OnlineEvaluationConfigs []types.OnlineEvaluationConfigSummary

	//  The pagination token to use in a subsequent request to retrieve the next page
	// of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListOnlineEvaluationConfigsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListOnlineEvaluationConfigs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListOnlineEvaluationConfigs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListOnlineEvaluationConfigs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListOnlineEvaluationConfigs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListOnlineEvaluationConfigsPaginatorOptions is the paginator options for
// ListOnlineEvaluationConfigs
type ListOnlineEvaluationConfigsPaginatorOptions struct {
	//  The maximum number of online evaluation configurations to return in a single
	// response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListOnlineEvaluationConfigsPaginator is a paginator for
// ListOnlineEvaluationConfigs
type ListOnlineEvaluationConfigsPaginator struct {
	options   ListOnlineEvaluationConfigsPaginatorOptions
	client    ListOnlineEvaluationConfigsAPIClient
	params    *ListOnlineEvaluationConfigsInput
	nextToken *string
	firstPage bool
}

// NewListOnlineEvaluationConfigsPaginator returns a new
// ListOnlineEvaluationConfigsPaginator
func NewListOnlineEvaluationConfigsPaginator(client ListOnlineEvaluationConfigsAPIClient, params *ListOnlineEvaluationConfigsInput, optFns ...func(*ListOnlineEvaluationConfigsPaginatorOptions)) *ListOnlineEvaluationConfigsPaginator {
	if params == nil {
		params = &ListOnlineEvaluationConfigsInput{}
	}

	options := ListOnlineEvaluationConfigsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListOnlineEvaluationConfigsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListOnlineEvaluationConfigsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListOnlineEvaluationConfigs page.
func (p *ListOnlineEvaluationConfigsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListOnlineEvaluationConfigsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListOnlineEvaluationConfigs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListOnlineEvaluationConfigsAPIClient is a client that implements the
// ListOnlineEvaluationConfigs operation.
type ListOnlineEvaluationConfigsAPIClient interface {
	ListOnlineEvaluationConfigs(context.Context, *ListOnlineEvaluationConfigsInput, ...func(*Options)) (*ListOnlineEvaluationConfigsOutput, error)
}

var _ ListOnlineEvaluationConfigsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListOnlineEvaluationConfigs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListOnlineEvaluationConfigs",
	}
}
