// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all OAuth2 credential providers in your account.
func (c *Client) ListOauth2CredentialProviders(ctx context.Context, params *ListOauth2CredentialProvidersInput, optFns ...func(*Options)) (*ListOauth2CredentialProvidersOutput, error) {
	if params == nil {
		params = &ListOauth2CredentialProvidersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListOauth2CredentialProviders", params, optFns, c.addOperationListOauth2CredentialProvidersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListOauth2CredentialProvidersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListOauth2CredentialProvidersInput struct {

	// Maximum number of results to return.
	MaxResults *int32

	// Pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

type ListOauth2CredentialProvidersOutput struct {

	// The list of OAuth2 credential providers.
	//
	// This member is required.
	CredentialProviders []types.Oauth2CredentialProviderItem

	// Pagination token for the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListOauth2CredentialProvidersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListOauth2CredentialProviders{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListOauth2CredentialProviders{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListOauth2CredentialProviders"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListOauth2CredentialProviders(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListOauth2CredentialProvidersPaginatorOptions is the paginator options for
// ListOauth2CredentialProviders
type ListOauth2CredentialProvidersPaginatorOptions struct {
	// Maximum number of results to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListOauth2CredentialProvidersPaginator is a paginator for
// ListOauth2CredentialProviders
type ListOauth2CredentialProvidersPaginator struct {
	options   ListOauth2CredentialProvidersPaginatorOptions
	client    ListOauth2CredentialProvidersAPIClient
	params    *ListOauth2CredentialProvidersInput
	nextToken *string
	firstPage bool
}

// NewListOauth2CredentialProvidersPaginator returns a new
// ListOauth2CredentialProvidersPaginator
func NewListOauth2CredentialProvidersPaginator(client ListOauth2CredentialProvidersAPIClient, params *ListOauth2CredentialProvidersInput, optFns ...func(*ListOauth2CredentialProvidersPaginatorOptions)) *ListOauth2CredentialProvidersPaginator {
	if params == nil {
		params = &ListOauth2CredentialProvidersInput{}
	}

	options := ListOauth2CredentialProvidersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListOauth2CredentialProvidersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListOauth2CredentialProvidersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListOauth2CredentialProviders page.
func (p *ListOauth2CredentialProvidersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListOauth2CredentialProvidersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListOauth2CredentialProviders(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListOauth2CredentialProvidersAPIClient is a client that implements the
// ListOauth2CredentialProviders operation.
type ListOauth2CredentialProvidersAPIClient interface {
	ListOauth2CredentialProviders(context.Context, *ListOauth2CredentialProvidersInput, ...func(*Options)) (*ListOauth2CredentialProvidersOutput, error)
}

var _ ListOauth2CredentialProvidersAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListOauth2CredentialProviders(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListOauth2CredentialProviders",
	}
}
