// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	smithywaiter "github.com/aws/smithy-go/waiter"
	"time"
)

// Retrieves information about a policy generation request within the AgentCore
// Policy system. Policy generation converts natural language descriptions into
// Cedar policy statements using AI-powered translation, enabling non-technical
// users to create policies.
func (c *Client) GetPolicyGeneration(ctx context.Context, params *GetPolicyGenerationInput, optFns ...func(*Options)) (*GetPolicyGenerationOutput, error) {
	if params == nil {
		params = &GetPolicyGenerationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetPolicyGeneration", params, optFns, c.addOperationGetPolicyGenerationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetPolicyGenerationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetPolicyGenerationInput struct {

	// The identifier of the policy engine associated with the policy generation
	// request. This provides the context for the generation operation and schema
	// validation.
	//
	// This member is required.
	PolicyEngineId *string

	// The unique identifier of the policy generation request to be retrieved. This
	// must be a valid generation ID from a previous [StartPolicyGeneration]call.
	//
	// [StartPolicyGeneration]: https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/API_StartPolicyGeneration.html
	//
	// This member is required.
	PolicyGenerationId *string

	noSmithyDocumentSerde
}

type GetPolicyGenerationOutput struct {

	// The timestamp when the policy generation request was created. This is used for
	// tracking and auditing generation operations and their lifecycle.
	//
	// This member is required.
	CreatedAt *time.Time

	// The customer-assigned name for the policy generation request. This helps
	// identify and track generation operations across multiple requests.
	//
	// This member is required.
	Name *string

	// The identifier of the policy engine associated with this policy generation.
	// This confirms the policy engine context for the generation operation.
	//
	// This member is required.
	PolicyEngineId *string

	// The Amazon Resource Name (ARN) of the policy generation. This globally unique
	// identifier can be used for tracking, auditing, and cross-service references.
	//
	// This member is required.
	PolicyGenerationArn *string

	// The unique identifier of the policy generation request. This matches the
	// generation ID provided in the request and serves as the tracking identifier.
	//
	// This member is required.
	PolicyGenerationId *string

	// The resource information associated with the policy generation. This provides
	// context about the target resources for which the policies are being generated.
	//
	// This member is required.
	Resource types.Resource

	// The current status of the policy generation. This indicates whether the
	// generation is in progress, completed successfully, or failed during processing.
	//
	// This member is required.
	Status types.PolicyGenerationStatus

	// Additional information about the generation status. This provides details about
	// any failures, warnings, or the current state of the generation process.
	//
	// This member is required.
	StatusReasons []string

	// The timestamp when the policy generation was last updated. This tracks the
	// progress of the generation process and any status changes.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The findings and results from the policy generation process. This includes any
	// issues, recommendations, validation results, or insights from the generated
	// policies.
	Findings *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetPolicyGenerationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetPolicyGeneration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetPolicyGeneration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetPolicyGeneration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetPolicyGenerationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetPolicyGeneration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// PolicyGenerationCompletedWaiterOptions are waiter options for
// PolicyGenerationCompletedWaiter
type PolicyGenerationCompletedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// PolicyGenerationCompletedWaiter will use default minimum delay of 2 seconds.
	// Note that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, PolicyGenerationCompletedWaiter will use default max delay of 120
	// seconds. Note that MaxDelay must resolve to value greater than or equal to the
	// MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetPolicyGenerationInput, *GetPolicyGenerationOutput, error) (bool, error)
}

// PolicyGenerationCompletedWaiter defines the waiters for
// PolicyGenerationCompleted
type PolicyGenerationCompletedWaiter struct {
	client GetPolicyGenerationAPIClient

	options PolicyGenerationCompletedWaiterOptions
}

// NewPolicyGenerationCompletedWaiter constructs a PolicyGenerationCompletedWaiter.
func NewPolicyGenerationCompletedWaiter(client GetPolicyGenerationAPIClient, optFns ...func(*PolicyGenerationCompletedWaiterOptions)) *PolicyGenerationCompletedWaiter {
	options := PolicyGenerationCompletedWaiterOptions{}
	options.MinDelay = 2 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = policyGenerationCompletedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &PolicyGenerationCompletedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for PolicyGenerationCompleted waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *PolicyGenerationCompletedWaiter) Wait(ctx context.Context, params *GetPolicyGenerationInput, maxWaitDur time.Duration, optFns ...func(*PolicyGenerationCompletedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for PolicyGenerationCompleted waiter
// and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *PolicyGenerationCompletedWaiter) WaitForOutput(ctx context.Context, params *GetPolicyGenerationInput, maxWaitDur time.Duration, optFns ...func(*PolicyGenerationCompletedWaiterOptions)) (*GetPolicyGenerationOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetPolicyGeneration(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for PolicyGenerationCompleted waiter")
}

func policyGenerationCompletedStateRetryable(ctx context.Context, input *GetPolicyGenerationInput, output *GetPolicyGenerationOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.Status
		expectedValue := "GENERATED"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "GENERATING"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return true, nil
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "GENERATE_FAILED"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "DELETE_FAILED"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// GetPolicyGenerationAPIClient is a client that implements the
// GetPolicyGeneration operation.
type GetPolicyGenerationAPIClient interface {
	GetPolicyGeneration(context.Context, *GetPolicyGenerationInput, ...func(*Options)) (*GetPolicyGenerationOutput, error)
}

var _ GetPolicyGenerationAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetPolicyGeneration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetPolicyGeneration",
	}
}
