// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Deletes an existing policy from the AgentCore Policy system. Once deleted, the
// policy can no longer be used for agent behavior control and all references to it
// become invalid. This is an asynchronous operation. Use the GetPolicy operation
// to poll the status field to track completion.
func (c *Client) DeletePolicy(ctx context.Context, params *DeletePolicyInput, optFns ...func(*Options)) (*DeletePolicyOutput, error) {
	if params == nil {
		params = &DeletePolicyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeletePolicy", params, optFns, c.addOperationDeletePolicyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeletePolicyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeletePolicyInput struct {

	// The identifier of the policy engine that manages the policy to be deleted. This
	// ensures the policy is deleted from the correct policy engine context.
	//
	// This member is required.
	PolicyEngineId *string

	// The unique identifier of the policy to be deleted. This must be a valid policy
	// ID that exists within the specified policy engine.
	//
	// This member is required.
	PolicyId *string

	noSmithyDocumentSerde
}

type DeletePolicyOutput struct {

	// The timestamp when the deleted policy was originally created.
	//
	// This member is required.
	CreatedAt *time.Time

	// Represents the definition structure for policies within the AgentCore Policy
	// system. This structure encapsulates different policy formats and languages that
	// can be used to define access control rules.
	//
	// This member is required.
	Definition types.PolicyDefinition

	// The customer-assigned name of the deleted policy. This confirms which policy
	// was successfully removed from the system and matches the name that was
	// originally assigned during policy creation.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) of the deleted policy. This globally unique
	// identifier confirms which policy resource was successfully removed.
	//
	// This member is required.
	PolicyArn *string

	// The identifier of the policy engine from which the policy was deleted. This
	// confirms the policy engine context for the deletion operation.
	//
	// This member is required.
	PolicyEngineId *string

	// The unique identifier of the policy being deleted. This confirms which policy
	// the deletion operation targets.
	//
	// This member is required.
	PolicyId *string

	// The status of the policy deletion operation. This provides information about
	// any issues that occurred during the deletion process.
	//
	// This member is required.
	Status types.PolicyStatus

	// Additional information about the deletion status. This provides details about
	// the deletion process or any issues that may have occurred.
	//
	// This member is required.
	StatusReasons []string

	// The timestamp when the deleted policy was last modified before deletion. This
	// tracks the final state of the policy before it was removed from the system.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The human-readable description of the deleted policy.
	Description *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeletePolicyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDeletePolicy{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDeletePolicy{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DeletePolicy"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDeletePolicyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeletePolicy(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeletePolicy(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DeletePolicy",
	}
}
