// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	Creates an online evaluation configuration for continuous monitoring of agent
//
// performance. Online evaluation automatically samples live traffic from
// CloudWatch logs at specified rates and applies evaluators to assess agent
// quality in production.
func (c *Client) CreateOnlineEvaluationConfig(ctx context.Context, params *CreateOnlineEvaluationConfigInput, optFns ...func(*Options)) (*CreateOnlineEvaluationConfigOutput, error) {
	if params == nil {
		params = &CreateOnlineEvaluationConfigInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateOnlineEvaluationConfig", params, optFns, c.addOperationCreateOnlineEvaluationConfigMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateOnlineEvaluationConfigOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateOnlineEvaluationConfigInput struct {

	//  The data source configuration that specifies CloudWatch log groups and service
	// names to monitor for agent traces.
	//
	// This member is required.
	DataSourceConfig types.DataSourceConfig

	//  Whether to enable the online evaluation configuration immediately upon
	// creation. If true, evaluation begins automatically.
	//
	// This member is required.
	EnableOnCreate *bool

	//  The Amazon Resource Name (ARN) of the IAM role that grants permissions to read
	// from CloudWatch logs, write evaluation results, and invoke Amazon Bedrock models
	// for evaluation.
	//
	// This member is required.
	EvaluationExecutionRoleArn *string

	//  The list of evaluators to apply during online evaluation. Can include both
	// built-in evaluators and custom evaluators created with CreateEvaluator .
	//
	// This member is required.
	Evaluators []types.EvaluatorReference

	//  The name of the online evaluation configuration. Must be unique within your
	// account.
	//
	// This member is required.
	OnlineEvaluationConfigName *string

	//  The evaluation rule that defines sampling configuration, filters, and session
	// detection settings for the online evaluation.
	//
	// This member is required.
	Rule *types.Rule

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than one time. If you don't specify this field, a value is randomly
	// generated for you. If this token matches a previous request, the service ignores
	// the request, but doesn't return an error. For more information, see [Ensuring idempotency].
	//
	// [Ensuring idempotency]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
	ClientToken *string

	//  The description of the online evaluation configuration that explains its
	// monitoring purpose and scope.
	Description *string

	noSmithyDocumentSerde
}

type CreateOnlineEvaluationConfigOutput struct {

	//  The timestamp when the online evaluation configuration was created.
	//
	// This member is required.
	CreatedAt *time.Time

	//  The execution status indicating whether the online evaluation is currently
	// running.
	//
	// This member is required.
	ExecutionStatus types.OnlineEvaluationExecutionStatus

	//  The Amazon Resource Name (ARN) of the created online evaluation configuration.
	//
	// This member is required.
	OnlineEvaluationConfigArn *string

	//  The unique identifier of the created online evaluation configuration.
	//
	// This member is required.
	OnlineEvaluationConfigId *string

	//  The status of the online evaluation configuration.
	//
	// This member is required.
	Status types.OnlineEvaluationConfigStatus

	//  The reason for failure if the online evaluation configuration creation or
	// execution failed.
	FailureReason *string

	//  The configuration that specifies where evaluation results should be written
	// for monitoring and analysis.
	OutputConfig *types.OutputConfig

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateOnlineEvaluationConfigMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateOnlineEvaluationConfig{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateOnlineEvaluationConfig{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateOnlineEvaluationConfig"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateOnlineEvaluationConfigMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateOnlineEvaluationConfigValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateOnlineEvaluationConfig(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateOnlineEvaluationConfig struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateOnlineEvaluationConfig) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateOnlineEvaluationConfig) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateOnlineEvaluationConfigInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateOnlineEvaluationConfigInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateOnlineEvaluationConfigMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateOnlineEvaluationConfig{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateOnlineEvaluationConfig(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateOnlineEvaluationConfig",
	}
}
