// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	Creates a custom evaluator for agent quality assessment. Custom evaluators use
//
// LLM-as-a-Judge configurations with user-defined prompts, rating scales, and
// model settings to evaluate agent performance at tool call, trace, or session
// levels.
func (c *Client) CreateEvaluator(ctx context.Context, params *CreateEvaluatorInput, optFns ...func(*Options)) (*CreateEvaluatorOutput, error) {
	if params == nil {
		params = &CreateEvaluatorInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateEvaluator", params, optFns, c.addOperationCreateEvaluatorMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateEvaluatorOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateEvaluatorInput struct {

	//  The configuration for the evaluator, including LLM-as-a-Judge settings with
	// instructions, rating scale, and model configuration.
	//
	// This member is required.
	EvaluatorConfig types.EvaluatorConfig

	//  The name of the evaluator. Must be unique within your account.
	//
	// This member is required.
	EvaluatorName *string

	//  The evaluation level that determines the scope of evaluation. Valid values are
	// TOOL_CALL for individual tool invocations, TRACE for single request-response
	// interactions, or SESSION for entire conversation sessions.
	//
	// This member is required.
	Level types.EvaluatorLevel

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than one time. If you don't specify this field, a value is randomly
	// generated for you. If this token matches a previous request, the service ignores
	// the request, but doesn't return an error. For more information, see [Ensuring idempotency].
	//
	// [Ensuring idempotency]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
	ClientToken *string

	//  The description of the evaluator that explains its purpose and evaluation
	// criteria.
	Description *string

	noSmithyDocumentSerde
}

type CreateEvaluatorOutput struct {

	//  The timestamp when the evaluator was created.
	//
	// This member is required.
	CreatedAt *time.Time

	//  The Amazon Resource Name (ARN) of the created evaluator.
	//
	// This member is required.
	EvaluatorArn *string

	//  The unique identifier of the created evaluator.
	//
	// This member is required.
	EvaluatorId *string

	//  The status of the evaluator creation operation.
	//
	// This member is required.
	Status types.EvaluatorStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateEvaluatorMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateEvaluator{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateEvaluator{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateEvaluator"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateEvaluatorMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateEvaluatorValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateEvaluator(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateEvaluator struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateEvaluator) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateEvaluator) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateEvaluatorInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateEvaluatorInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateEvaluatorMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateEvaluator{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateEvaluator(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateEvaluator",
	}
}
