// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcore

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates and initializes a code interpreter session in Amazon Bedrock. The
// session enables agents to execute code as part of their response generation,
// supporting programming languages such as Python for data analysis,
// visualization, and computation tasks.
//
// To create a session, you must specify a code interpreter identifier and a name.
// The session remains active until it times out or you explicitly stop it using
// the StopCodeInterpreterSession operation.
//
// The following operations are related to StartCodeInterpreterSession :
//
// [InvokeCodeInterpreter]
//
// [GetCodeInterpreterSession]
//
// [StopCodeInterpreterSession]
//
// [InvokeCodeInterpreter]: https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_InvokeCodeInterpreter.html
// [StopCodeInterpreterSession]: https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_StopCodeInterpreterSession.html
// [GetCodeInterpreterSession]: https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_GetCodeInterpreterSession.html
func (c *Client) StartCodeInterpreterSession(ctx context.Context, params *StartCodeInterpreterSessionInput, optFns ...func(*Options)) (*StartCodeInterpreterSessionOutput, error) {
	if params == nil {
		params = &StartCodeInterpreterSessionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartCodeInterpreterSession", params, optFns, c.addOperationStartCodeInterpreterSessionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartCodeInterpreterSessionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartCodeInterpreterSessionInput struct {

	// The unique identifier of the code interpreter to use for this session. This
	// identifier specifies which code interpreter environment to initialize for the
	// session.
	//
	// This member is required.
	CodeInterpreterIdentifier *string

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. This parameter helps prevent
	// the creation of duplicate sessions if there are temporary network issues.
	ClientToken *string

	// The name of the code interpreter session. This name helps you identify and
	// manage the session. The name does not need to be unique.
	Name *string

	// The time in seconds after which the session automatically terminates if there
	// is no activity. The default value is 900 seconds (15 minutes). The minimum
	// allowed value is 60 seconds, and the maximum allowed value is 28800 seconds (8
	// hours).
	SessionTimeoutSeconds *int32

	// The trace identifier for request tracking.
	TraceId *string

	// The parent trace information for distributed tracing.
	TraceParent *string

	noSmithyDocumentSerde
}

type StartCodeInterpreterSessionOutput struct {

	// The identifier of the code interpreter.
	//
	// This member is required.
	CodeInterpreterIdentifier *string

	// The time at which the code interpreter session was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the created code interpreter session.
	//
	// This member is required.
	SessionId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartCodeInterpreterSessionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartCodeInterpreterSession{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartCodeInterpreterSession{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartCodeInterpreterSession"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartCodeInterpreterSessionMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartCodeInterpreterSessionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartCodeInterpreterSession(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStartCodeInterpreterSession struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartCodeInterpreterSession) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartCodeInterpreterSession) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartCodeInterpreterSessionInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartCodeInterpreterSessionInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartCodeInterpreterSessionMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartCodeInterpreterSession{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartCodeInterpreterSession(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartCodeInterpreterSession",
	}
}
