// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcore

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcore/types"
	"github.com/aws/smithy-go/middleware"
	smithysync "github.com/aws/smithy-go/sync"
	"sync"
)

// Executes code within an active code interpreter session in Amazon Bedrock. This
// operation processes the provided code, runs it in a secure environment, and
// returns the execution results including output, errors, and generated
// visualizations.
//
// To execute code, you must specify the code interpreter identifier, session ID,
// and the code to run in the arguments parameter. The operation returns a stream
// containing the execution results, which can include text output, error messages,
// and data visualizations.
//
// This operation is subject to request rate limiting based on your account's
// service quotas.
//
// The following operations are related to InvokeCodeInterpreter :
//
// [StartCodeInterpreterSession]
//
// [GetCodeInterpreterSession]
//
// [StartCodeInterpreterSession]: https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_StartCodeInterpreterSession.html
// [GetCodeInterpreterSession]: https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_GetCodeInterpreterSession.html
func (c *Client) InvokeCodeInterpreter(ctx context.Context, params *InvokeCodeInterpreterInput, optFns ...func(*Options)) (*InvokeCodeInterpreterOutput, error) {
	if params == nil {
		params = &InvokeCodeInterpreterInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "InvokeCodeInterpreter", params, optFns, c.addOperationInvokeCodeInterpreterMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*InvokeCodeInterpreterOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type InvokeCodeInterpreterInput struct {

	// The unique identifier of the code interpreter associated with the session. This
	// must match the identifier used when creating the session with
	// StartCodeInterpreterSession .
	//
	// This member is required.
	CodeInterpreterIdentifier *string

	// The name of the code interpreter to invoke.
	//
	// This member is required.
	Name types.ToolName

	// The arguments for the code interpreter. This includes the code to execute and
	// any additional parameters such as the programming language, whether to clear the
	// execution context, and other execution options. The structure of this parameter
	// depends on the specific code interpreter being used.
	Arguments *types.ToolArguments

	// The unique identifier of the code interpreter session to use. This must be an
	// active session created with StartCodeInterpreterSession . If the session has
	// expired or been stopped, the request will fail.
	SessionId *string

	// The trace identifier for request tracking.
	TraceId *string

	// The parent trace information for distributed tracing.
	TraceParent *string

	noSmithyDocumentSerde
}

type InvokeCodeInterpreterOutput struct {

	// The identifier of the code interpreter session.
	SessionId *string

	eventStream *InvokeCodeInterpreterEventStream

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

// GetStream returns the type to interact with the event stream.
func (o *InvokeCodeInterpreterOutput) GetStream() *InvokeCodeInterpreterEventStream {
	return o.eventStream
}

func (c *Client) addOperationInvokeCodeInterpreterMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpInvokeCodeInterpreter{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpInvokeCodeInterpreter{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "InvokeCodeInterpreter"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addEventStreamInvokeCodeInterpreterMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpInvokeCodeInterpreterValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opInvokeCodeInterpreter(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opInvokeCodeInterpreter(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "InvokeCodeInterpreter",
	}
}

// InvokeCodeInterpreterEventStream provides the event stream handling for the InvokeCodeInterpreter operation.
//
// For testing and mocking the event stream this type should be initialized via
// the NewInvokeCodeInterpreterEventStream constructor function. Using the functional options
// to pass in nested mock behavior.
type InvokeCodeInterpreterEventStream struct {
	// CodeInterpreterStreamOutputReader is the EventStream reader for the
	// CodeInterpreterStreamOutput events. This value is automatically set by the SDK
	// when the API call is made Use this member when unit testing your code with the
	// SDK to mock out the EventStream Reader.
	//
	// Must not be nil.
	Reader CodeInterpreterStreamOutputReader

	done      chan struct{}
	closeOnce sync.Once
	err       *smithysync.OnceErr
}

// NewInvokeCodeInterpreterEventStream initializes an InvokeCodeInterpreterEventStream.
// This function should only be used for testing and mocking the InvokeCodeInterpreterEventStream
// stream within your application.
//
// The Reader member must be set before reading events from the stream.
func NewInvokeCodeInterpreterEventStream(optFns ...func(*InvokeCodeInterpreterEventStream)) *InvokeCodeInterpreterEventStream {
	es := &InvokeCodeInterpreterEventStream{
		done: make(chan struct{}),
		err:  smithysync.NewOnceErr(),
	}
	for _, fn := range optFns {
		fn(es)
	}
	return es
}

// Events returns a channel to read events from.
func (es *InvokeCodeInterpreterEventStream) Events() <-chan types.CodeInterpreterStreamOutput {
	return es.Reader.Events()
}

// Close closes the stream. This will also cause the stream to be closed.
// Close must be called when done using the stream API. Not calling Close
// may result in resource leaks.
//
// Will close the underlying EventStream writer and reader, and no more events can be
// sent or received.
func (es *InvokeCodeInterpreterEventStream) Close() error {
	es.closeOnce.Do(es.safeClose)
	return es.Err()
}

func (es *InvokeCodeInterpreterEventStream) safeClose() {
	close(es.done)

	es.Reader.Close()
}

// Err returns any error that occurred while reading or writing EventStream Events
// from the service API's response. Returns nil if there were no errors.
func (es *InvokeCodeInterpreterEventStream) Err() error {
	if err := es.err.Err(); err != nil {
		return err
	}

	if err := es.Reader.Err(); err != nil {
		return err
	}

	return nil
}

func (es *InvokeCodeInterpreterEventStream) waitStreamClose() {
	type errorSet interface {
		ErrorSet() <-chan struct{}
	}

	var outputErrCh <-chan struct{}
	if v, ok := es.Reader.(errorSet); ok {
		outputErrCh = v.ErrorSet()
	}
	var outputClosedCh <-chan struct{}
	if v, ok := es.Reader.(interface{ Closed() <-chan struct{} }); ok {
		outputClosedCh = v.Closed()
	}

	select {
	case <-es.done:
	case <-outputErrCh:
		es.err.SetError(es.Reader.Err())
		es.Close()

	case <-outputClosedCh:
		if err := es.Reader.Err(); err != nil {
			es.err.SetError(es.Reader.Err())
		}
		es.Close()

	}
}
