// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcore

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcore/document"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the A2A agent card associated with an AgentCore Runtime agent.
func (c *Client) GetAgentCard(ctx context.Context, params *GetAgentCardInput, optFns ...func(*Options)) (*GetAgentCardOutput, error) {
	if params == nil {
		params = &GetAgentCardInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAgentCard", params, optFns, c.addOperationGetAgentCardMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAgentCardOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAgentCardInput struct {

	// The ARN of the AgentCore Runtime agent for which you want to get the A2A agent
	// card.
	//
	// This member is required.
	AgentRuntimeArn *string

	// Optional qualifier to specify an agent alias, such as prod code> or dev . If you
	// don't provide a value, the DEFAULT alias is used.
	Qualifier *string

	// The session ID that the AgentCore Runtime agent is using.
	RuntimeSessionId *string

	noSmithyDocumentSerde
}

type GetAgentCardOutput struct {

	// An agent card document that contains metadata and capabilities for an AgentCore
	// Runtime agent.
	//
	// This member is required.
	AgentCard document.Interface

	// The ID of the session associated with the AgentCore Runtime agent.
	RuntimeSessionId *string

	// The status code of the request.
	StatusCode *int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAgentCardMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetAgentCard{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetAgentCard{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAgentCard"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opGetAgentCardMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpGetAgentCardValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAgentCard(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpGetAgentCard struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpGetAgentCard) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpGetAgentCard) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*GetAgentCardInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *GetAgentCardInput ")
	}

	if input.RuntimeSessionId == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.RuntimeSessionId = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opGetAgentCardMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpGetAgentCard{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opGetAgentCard(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAgentCard",
	}
}
