// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcore

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcore/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Performs on-demand evaluation of agent traces using a specified evaluator.
//
// This synchronous API accepts traces in OpenTelemetry format and returns
// immediate scoring results with detailed explanations.
func (c *Client) Evaluate(ctx context.Context, params *EvaluateInput, optFns ...func(*Options)) (*EvaluateOutput, error) {
	if params == nil {
		params = &EvaluateInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "Evaluate", params, optFns, c.addOperationEvaluateMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*EvaluateOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type EvaluateInput struct {

	//  The input data containing agent session spans to be evaluated. Includes a list
	// of spans in OpenTelemetry format from supported frameworks like Strands
	// (AgentCore Runtime) or LangGraph with OpenInference instrumentation.
	//
	// This member is required.
	EvaluationInput types.EvaluationInput

	//  The unique identifier of the evaluator to use for scoring. Can be a built-in
	// evaluator (e.g., Builtin.Helpfulness , Builtin.Correctness ) or a custom
	// evaluator ARN created through the control plane API.
	//
	// This member is required.
	EvaluatorId *string

	//  The specific trace or span IDs to evaluate within the provided input. Allows
	// targeting evaluation at different levels: individual tool calls, single
	// request-response interactions (traces), or entire conversation sessions.
	EvaluationTarget types.EvaluationTarget

	noSmithyDocumentSerde
}

type EvaluateOutput struct {

	//  The detailed evaluation results containing scores, explanations, and metadata.
	// Includes the evaluator information, numerical or categorical ratings based on
	// the evaluator's rating scale, and token usage statistics for the evaluation
	// process.
	//
	// This member is required.
	EvaluationResults []types.EvaluationResultContent

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationEvaluateMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpEvaluate{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpEvaluate{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "Evaluate"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpEvaluateValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opEvaluate(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opEvaluate(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "Evaluate",
	}
}
