// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates an existing Automated Reasoning policy with new rules, variables, or
// configuration. This creates a new version of the policy while preserving the
// previous version.
func (c *Client) UpdateAutomatedReasoningPolicy(ctx context.Context, params *UpdateAutomatedReasoningPolicyInput, optFns ...func(*Options)) (*UpdateAutomatedReasoningPolicyOutput, error) {
	if params == nil {
		params = &UpdateAutomatedReasoningPolicyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateAutomatedReasoningPolicy", params, optFns, c.addOperationUpdateAutomatedReasoningPolicyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateAutomatedReasoningPolicyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateAutomatedReasoningPolicyInput struct {

	// The Amazon Resource Name (ARN) of the Automated Reasoning policy to update.
	// This must be the ARN of a draft policy.
	//
	// This member is required.
	PolicyArn *string

	// The updated policy definition containing the formal logic rules, variables, and
	// types.
	//
	// This member is required.
	PolicyDefinition *types.AutomatedReasoningPolicyDefinition

	// The updated description for the Automated Reasoning policy.
	Description *string

	// The updated name for the Automated Reasoning policy.
	Name *string

	noSmithyDocumentSerde
}

type UpdateAutomatedReasoningPolicyOutput struct {

	// The hash of the updated policy definition.
	//
	// This member is required.
	DefinitionHash *string

	// The updated name of the policy.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) of the updated policy.
	//
	// This member is required.
	PolicyArn *string

	// The timestamp when the policy was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateAutomatedReasoningPolicyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateAutomatedReasoningPolicy{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateAutomatedReasoningPolicy{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateAutomatedReasoningPolicy"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateAutomatedReasoningPolicyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateAutomatedReasoningPolicy(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateAutomatedReasoningPolicy(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateAutomatedReasoningPolicy",
	}
}
