// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of inference profiles that you can use. For more information,
// see [Increase throughput and resilience with cross-region inference in Amazon Bedrock]. in the Amazon Bedrock User Guide.
//
// [Increase throughput and resilience with cross-region inference in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html
func (c *Client) ListInferenceProfiles(ctx context.Context, params *ListInferenceProfilesInput, optFns ...func(*Options)) (*ListInferenceProfilesOutput, error) {
	if params == nil {
		params = &ListInferenceProfilesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListInferenceProfiles", params, optFns, c.addOperationListInferenceProfilesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListInferenceProfilesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListInferenceProfilesInput struct {

	// The maximum number of results to return in the response. If the total number of
	// results is greater than this value, use the token returned in the response in
	// the nextToken field when making another request to return the next batch of
	// results.
	MaxResults *int32

	// If the total number of results is greater than the maxResults value provided in
	// the request, enter the token returned in the nextToken field in the response in
	// this field to return the next batch of results.
	NextToken *string

	// Filters for inference profiles that match the type you specify.
	//
	//   - SYSTEM_DEFINED – The inference profile is defined by Amazon Bedrock. You can
	//   route inference requests across regions with these inference profiles.
	//
	//   - APPLICATION – The inference profile was created by a user. This type of
	//   inference profile can track metrics and costs when invoking the model in it. The
	//   inference profile may route requests to one or multiple regions.
	TypeEquals types.InferenceProfileType

	noSmithyDocumentSerde
}

type ListInferenceProfilesOutput struct {

	// A list of information about each inference profile that you can use.
	InferenceProfileSummaries []types.InferenceProfileSummary

	// If the total number of results is greater than the maxResults value provided in
	// the request, use this token when making another request in the nextToken field
	// to return the next batch of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListInferenceProfilesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListInferenceProfiles{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListInferenceProfiles{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListInferenceProfiles"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListInferenceProfiles(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListInferenceProfilesPaginatorOptions is the paginator options for
// ListInferenceProfiles
type ListInferenceProfilesPaginatorOptions struct {
	// The maximum number of results to return in the response. If the total number of
	// results is greater than this value, use the token returned in the response in
	// the nextToken field when making another request to return the next batch of
	// results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListInferenceProfilesPaginator is a paginator for ListInferenceProfiles
type ListInferenceProfilesPaginator struct {
	options   ListInferenceProfilesPaginatorOptions
	client    ListInferenceProfilesAPIClient
	params    *ListInferenceProfilesInput
	nextToken *string
	firstPage bool
}

// NewListInferenceProfilesPaginator returns a new ListInferenceProfilesPaginator
func NewListInferenceProfilesPaginator(client ListInferenceProfilesAPIClient, params *ListInferenceProfilesInput, optFns ...func(*ListInferenceProfilesPaginatorOptions)) *ListInferenceProfilesPaginator {
	if params == nil {
		params = &ListInferenceProfilesInput{}
	}

	options := ListInferenceProfilesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListInferenceProfilesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListInferenceProfilesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListInferenceProfiles page.
func (p *ListInferenceProfilesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListInferenceProfilesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListInferenceProfiles(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListInferenceProfilesAPIClient is a client that implements the
// ListInferenceProfiles operation.
type ListInferenceProfilesAPIClient interface {
	ListInferenceProfiles(context.Context, *ListInferenceProfilesInput, ...func(*Options)) (*ListInferenceProfilesOutput, error)
}

var _ ListInferenceProfilesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListInferenceProfiles(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListInferenceProfiles",
	}
}
