// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists tests for an Automated Reasoning policy. We recommend using pagination to
// ensure that the operation returns quickly and successfully.
func (c *Client) ListAutomatedReasoningPolicyTestCases(ctx context.Context, params *ListAutomatedReasoningPolicyTestCasesInput, optFns ...func(*Options)) (*ListAutomatedReasoningPolicyTestCasesOutput, error) {
	if params == nil {
		params = &ListAutomatedReasoningPolicyTestCasesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAutomatedReasoningPolicyTestCases", params, optFns, c.addOperationListAutomatedReasoningPolicyTestCasesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAutomatedReasoningPolicyTestCasesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAutomatedReasoningPolicyTestCasesInput struct {

	// The Amazon Resource Name (ARN) of the Automated Reasoning policy for which to
	// list tests.
	//
	// This member is required.
	PolicyArn *string

	// The maximum number of tests to return in a single call.
	MaxResults *int32

	// The pagination token from a previous request to retrieve the next page of
	// results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAutomatedReasoningPolicyTestCasesOutput struct {

	// A list of tests for the specified policy.
	//
	// This member is required.
	TestCases []types.AutomatedReasoningPolicyTestCase

	// The pagination token to use in a subsequent request to retrieve the next page
	// of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAutomatedReasoningPolicyTestCasesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAutomatedReasoningPolicyTestCases{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAutomatedReasoningPolicyTestCases{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAutomatedReasoningPolicyTestCases"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAutomatedReasoningPolicyTestCasesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAutomatedReasoningPolicyTestCases(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAutomatedReasoningPolicyTestCasesPaginatorOptions is the paginator options
// for ListAutomatedReasoningPolicyTestCases
type ListAutomatedReasoningPolicyTestCasesPaginatorOptions struct {
	// The maximum number of tests to return in a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAutomatedReasoningPolicyTestCasesPaginator is a paginator for
// ListAutomatedReasoningPolicyTestCases
type ListAutomatedReasoningPolicyTestCasesPaginator struct {
	options   ListAutomatedReasoningPolicyTestCasesPaginatorOptions
	client    ListAutomatedReasoningPolicyTestCasesAPIClient
	params    *ListAutomatedReasoningPolicyTestCasesInput
	nextToken *string
	firstPage bool
}

// NewListAutomatedReasoningPolicyTestCasesPaginator returns a new
// ListAutomatedReasoningPolicyTestCasesPaginator
func NewListAutomatedReasoningPolicyTestCasesPaginator(client ListAutomatedReasoningPolicyTestCasesAPIClient, params *ListAutomatedReasoningPolicyTestCasesInput, optFns ...func(*ListAutomatedReasoningPolicyTestCasesPaginatorOptions)) *ListAutomatedReasoningPolicyTestCasesPaginator {
	if params == nil {
		params = &ListAutomatedReasoningPolicyTestCasesInput{}
	}

	options := ListAutomatedReasoningPolicyTestCasesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAutomatedReasoningPolicyTestCasesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAutomatedReasoningPolicyTestCasesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAutomatedReasoningPolicyTestCases page.
func (p *ListAutomatedReasoningPolicyTestCasesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAutomatedReasoningPolicyTestCasesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAutomatedReasoningPolicyTestCases(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAutomatedReasoningPolicyTestCasesAPIClient is a client that implements the
// ListAutomatedReasoningPolicyTestCases operation.
type ListAutomatedReasoningPolicyTestCasesAPIClient interface {
	ListAutomatedReasoningPolicyTestCases(context.Context, *ListAutomatedReasoningPolicyTestCasesInput, ...func(*Options)) (*ListAutomatedReasoningPolicyTestCasesOutput, error)
}

var _ ListAutomatedReasoningPolicyTestCasesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAutomatedReasoningPolicyTestCases(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAutomatedReasoningPolicyTestCases",
	}
}
