// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all build workflows for an Automated Reasoning policy, showing the
// history of policy creation and modification attempts.
func (c *Client) ListAutomatedReasoningPolicyBuildWorkflows(ctx context.Context, params *ListAutomatedReasoningPolicyBuildWorkflowsInput, optFns ...func(*Options)) (*ListAutomatedReasoningPolicyBuildWorkflowsOutput, error) {
	if params == nil {
		params = &ListAutomatedReasoningPolicyBuildWorkflowsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAutomatedReasoningPolicyBuildWorkflows", params, optFns, c.addOperationListAutomatedReasoningPolicyBuildWorkflowsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAutomatedReasoningPolicyBuildWorkflowsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAutomatedReasoningPolicyBuildWorkflowsInput struct {

	// The Amazon Resource Name (ARN) of the Automated Reasoning policy whose build
	// workflows you want to list.
	//
	// This member is required.
	PolicyArn *string

	// The maximum number of build workflows to return in a single response. Valid
	// range is 1-100.
	MaxResults *int32

	// A pagination token from a previous request to continue listing build workflows
	// from where the previous request left off.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAutomatedReasoningPolicyBuildWorkflowsOutput struct {

	// A list of build workflow summaries, each containing key information about a
	// build workflow including its status and timestamps.
	//
	// This member is required.
	AutomatedReasoningPolicyBuildWorkflowSummaries []types.AutomatedReasoningPolicyBuildWorkflowSummary

	// A pagination token to use in subsequent requests to retrieve additional build
	// workflows.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAutomatedReasoningPolicyBuildWorkflowsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAutomatedReasoningPolicyBuildWorkflows{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAutomatedReasoningPolicyBuildWorkflows{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAutomatedReasoningPolicyBuildWorkflows"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAutomatedReasoningPolicyBuildWorkflowsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAutomatedReasoningPolicyBuildWorkflows(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAutomatedReasoningPolicyBuildWorkflowsPaginatorOptions is the paginator
// options for ListAutomatedReasoningPolicyBuildWorkflows
type ListAutomatedReasoningPolicyBuildWorkflowsPaginatorOptions struct {
	// The maximum number of build workflows to return in a single response. Valid
	// range is 1-100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAutomatedReasoningPolicyBuildWorkflowsPaginator is a paginator for
// ListAutomatedReasoningPolicyBuildWorkflows
type ListAutomatedReasoningPolicyBuildWorkflowsPaginator struct {
	options   ListAutomatedReasoningPolicyBuildWorkflowsPaginatorOptions
	client    ListAutomatedReasoningPolicyBuildWorkflowsAPIClient
	params    *ListAutomatedReasoningPolicyBuildWorkflowsInput
	nextToken *string
	firstPage bool
}

// NewListAutomatedReasoningPolicyBuildWorkflowsPaginator returns a new
// ListAutomatedReasoningPolicyBuildWorkflowsPaginator
func NewListAutomatedReasoningPolicyBuildWorkflowsPaginator(client ListAutomatedReasoningPolicyBuildWorkflowsAPIClient, params *ListAutomatedReasoningPolicyBuildWorkflowsInput, optFns ...func(*ListAutomatedReasoningPolicyBuildWorkflowsPaginatorOptions)) *ListAutomatedReasoningPolicyBuildWorkflowsPaginator {
	if params == nil {
		params = &ListAutomatedReasoningPolicyBuildWorkflowsInput{}
	}

	options := ListAutomatedReasoningPolicyBuildWorkflowsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAutomatedReasoningPolicyBuildWorkflowsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAutomatedReasoningPolicyBuildWorkflowsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAutomatedReasoningPolicyBuildWorkflows page.
func (p *ListAutomatedReasoningPolicyBuildWorkflowsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAutomatedReasoningPolicyBuildWorkflowsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAutomatedReasoningPolicyBuildWorkflows(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAutomatedReasoningPolicyBuildWorkflowsAPIClient is a client that implements
// the ListAutomatedReasoningPolicyBuildWorkflows operation.
type ListAutomatedReasoningPolicyBuildWorkflowsAPIClient interface {
	ListAutomatedReasoningPolicyBuildWorkflows(context.Context, *ListAutomatedReasoningPolicyBuildWorkflowsInput, ...func(*Options)) (*ListAutomatedReasoningPolicyBuildWorkflowsOutput, error)
}

var _ ListAutomatedReasoningPolicyBuildWorkflowsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAutomatedReasoningPolicyBuildWorkflows(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAutomatedReasoningPolicyBuildWorkflows",
	}
}
