// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates an Automated Reasoning policy for Amazon Bedrock Guardrails. Automated
// Reasoning policies use mathematical techniques to detect hallucinations, suggest
// corrections, and highlight unstated assumptions in the responses of your GenAI
// application.
//
// To create a policy, you upload a source document that describes the rules that
// you're encoding. Automated Reasoning extracts important concepts from the source
// document that will become variables in the policy and infers policy rules.
func (c *Client) CreateAutomatedReasoningPolicy(ctx context.Context, params *CreateAutomatedReasoningPolicyInput, optFns ...func(*Options)) (*CreateAutomatedReasoningPolicyOutput, error) {
	if params == nil {
		params = &CreateAutomatedReasoningPolicyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateAutomatedReasoningPolicy", params, optFns, c.addOperationCreateAutomatedReasoningPolicyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateAutomatedReasoningPolicyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateAutomatedReasoningPolicyInput struct {

	// A unique name for the Automated Reasoning policy. The name must be between 1
	// and 63 characters and can contain letters, numbers, hyphens, and underscores.
	//
	// This member is required.
	Name *string

	// A unique, case-sensitive identifier to ensure that the operation completes no
	// more than once. If this token matches a previous request, Amazon Bedrock ignores
	// the request but doesn't return an error.
	ClientRequestToken *string

	// A description of the Automated Reasoning policy. Use this to provide context
	// about the policy's purpose and the types of validations it performs.
	Description *string

	// The identifier of the KMS key to use for encrypting the automated reasoning
	// policy and its associated artifacts. If you don't specify a KMS key, Amazon
	// Bedrock uses an KMS managed key for encryption. For enhanced security and
	// control, you can specify a customer managed KMS key.
	KmsKeyId *string

	// The policy definition that contains the formal logic rules, variables, and
	// custom variable types used to validate foundation model responses in your
	// application.
	PolicyDefinition *types.AutomatedReasoningPolicyDefinition

	// A list of tags to associate with the Automated Reasoning policy. Tags help you
	// organize and manage your policies.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateAutomatedReasoningPolicyOutput struct {

	// The timestamp when the policy was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The name of the Automated Reasoning policy.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) of the Automated Reasoning policy that you
	// created.
	//
	// This member is required.
	PolicyArn *string

	// The timestamp when the policy was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The version number of the newly created Automated Reasoning policy. The initial
	// version is always DRAFT.
	//
	// This member is required.
	Version *string

	// The hash of the policy definition. This is used as a concurrency token for
	// creating policy versions that you can use in your application.
	DefinitionHash *string

	// The description of the Automated Reasoning policy.
	Description *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateAutomatedReasoningPolicyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateAutomatedReasoningPolicy{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateAutomatedReasoningPolicy{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateAutomatedReasoningPolicy"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateAutomatedReasoningPolicyMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateAutomatedReasoningPolicyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateAutomatedReasoningPolicy(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateAutomatedReasoningPolicy struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateAutomatedReasoningPolicy) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateAutomatedReasoningPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateAutomatedReasoningPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateAutomatedReasoningPolicyInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateAutomatedReasoningPolicyMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateAutomatedReasoningPolicy{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateAutomatedReasoningPolicy(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateAutomatedReasoningPolicy",
	}
}
