// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Represents an action to add a Reserved Instance to a bill scenario.
type AddReservedInstanceAction struct {

	//  The number of instances to add for this Reserved Instance offering.
	InstanceCount *int32

	//  The ID of the Reserved Instance offering to add. For more information, see [DescribeReservedInstancesOfferings].
	//
	// [DescribeReservedInstancesOfferings]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeReservedInstancesOfferings.html
	ReservedInstancesOfferingId *string

	noSmithyDocumentSerde
}

// Represents an action to add a Savings Plan to a bill scenario.
type AddSavingsPlanAction struct {

	//  The hourly commitment, in the same currency of the savingsPlanOfferingId . This
	// is a value between 0.001 and 1 million. You cannot specify more than five digits
	// after the decimal point.
	Commitment *float64

	//  The ID of the Savings Plan offering to add. For more information, see [DescribeSavingsPlansOfferings].
	//
	// [DescribeSavingsPlansOfferings]: https://docs.aws.amazon.com/savingsplans/latest/APIReference/API_DescribeSavingsPlansOfferings.html
	SavingsPlanOfferingId *string

	noSmithyDocumentSerde
}

//	Represents an entry object in the batch operation to create bill scenario
//
// commitment modifications.
type BatchCreateBillScenarioCommitmentModificationEntry struct {

	//  The specific commitment action to be taken (e.g., adding a Reserved Instance
	// or Savings Plan).
	//
	// This member is required.
	CommitmentAction BillScenarioCommitmentModificationAction

	//  A unique identifier for this entry in the batch operation. This can be any
	// valid string. This key is useful to identify errors associated with any
	// commitment entry as any error is returned with this key.
	//
	// This member is required.
	Key *string

	//  The Amazon Web Services account ID to which this commitment will be applied
	// to.
	//
	// This member is required.
	UsageAccountId *string

	//  An optional group identifier for the commitment modification.
	Group *string

	noSmithyDocumentSerde
}

//	Represents an error that occurred during a batch create operation for bill
//
// scenario commitment modifications.
type BatchCreateBillScenarioCommitmentModificationError struct {

	//  The error code associated with the failed operation.
	ErrorCode BatchCreateBillScenarioCommitmentModificationErrorCode

	//  A descriptive message for the error that occurred.
	ErrorMessage *string

	//  The key of the entry that caused the error.
	Key *string

	noSmithyDocumentSerde
}

//	Represents a successfully created item in a batch operation for bill scenario
//
// commitment modifications.
type BatchCreateBillScenarioCommitmentModificationItem struct {

	//  The specific commitment action that was taken.
	CommitmentAction BillScenarioCommitmentModificationAction

	//  The group identifier for the created commitment modification.
	Group *string

	//  The unique identifier assigned to the created commitment modification.
	Id *string

	//  The key of the successfully created entry. This can be any valid string. This
	// key is useful to identify errors associated with any commitment entry as any
	// error is returned with this key.
	Key *string

	//  The Amazon Web Services account ID associated with the created commitment
	// modification.
	UsageAccountId *string

	noSmithyDocumentSerde
}

//	Represents an entry in a batch operation to create bill scenario usage
//
// modifications.
type BatchCreateBillScenarioUsageModificationEntry struct {

	//  A unique identifier for this entry in the batch operation. This can be any
	// valid string. This key is useful to identify errors associated with any usage
	// entry as any error is returned with this key.
	//
	// This member is required.
	Key *string

	//  The specific operation associated with this usage modification. Describes the
	// specific Amazon Web Services operation that this usage line models. For example,
	// RunInstances indicates the operation of an Amazon EC2 instance.
	//
	// This member is required.
	Operation *string

	//  The Amazon Web Services service code for this usage modification. This
	// identifies the specific Amazon Web Services service to the customer as a unique
	// short abbreviation. For example, AmazonEC2 and AWSKMS .
	//
	// This member is required.
	ServiceCode *string

	//  The Amazon Web Services account ID to which this usage will be applied to.
	//
	// This member is required.
	UsageAccountId *string

	//  Describes the usage details of the usage line item.
	//
	// This member is required.
	UsageType *string

	//  The amount of usage you want to create for the service use you are modeling.
	Amounts []UsageAmount

	//  The Availability Zone that this usage line uses.
	AvailabilityZone *string

	//  An optional group identifier for the usage modification.
	Group *string

	//  Historical usage data associated with this modification, if available.
	HistoricalUsage *HistoricalUsageEntity

	noSmithyDocumentSerde
}

//	Represents an error that occurred during a batch create operation for bill
//
// scenario usage modifications.
type BatchCreateBillScenarioUsageModificationError struct {

	//  The error code associated with the failed operation.
	ErrorCode BatchCreateBillScenarioUsageModificationErrorCode

	//  A descriptive message for the error that occurred.
	ErrorMessage *string

	//  The key of the entry that caused the error.
	Key *string

	noSmithyDocumentSerde
}

//	Represents a successfully created item in a batch operation for bill scenario
//
// usage modifications.
type BatchCreateBillScenarioUsageModificationItem struct {

	//  The specific operation associated with this usage modification.
	//
	// This member is required.
	Operation *string

	//  The Amazon Web Services service code for this usage modification.
	//
	// This member is required.
	ServiceCode *string

	//  The type of usage that was modified.
	//
	// This member is required.
	UsageType *string

	//  The availability zone associated with this usage modification, if applicable.
	AvailabilityZone *string

	//  The group identifier for the created usage modification.
	Group *string

	//  Historical usage data associated with this modification, if available.
	HistoricalUsage *HistoricalUsageEntity

	//  The unique identifier assigned to the created usage modification.
	Id *string

	//  The key of the successfully created entry.
	Key *string

	//  The location associated with this usage modification.
	Location *string

	//  The modified usage quantities.
	Quantities []UsageQuantity

	//  The Amazon Web Services account ID associated with the created usage
	// modification.
	UsageAccountId *string

	noSmithyDocumentSerde
}

// Represents an entry in a batch operation to create workload estimate usage.
type BatchCreateWorkloadEstimateUsageEntry struct {

	//  The estimated usage amount.
	//
	// This member is required.
	Amount *float64

	//  A unique identifier for this entry in the batch operation.
	//
	// This member is required.
	Key *string

	//  The specific operation associated with this usage estimate.
	//
	// This member is required.
	Operation *string

	//  The Amazon Web Services service code for this usage estimate.
	//
	// This member is required.
	ServiceCode *string

	//  The Amazon Web Services account ID associated with this usage estimate.
	//
	// This member is required.
	UsageAccountId *string

	//  The type of usage being estimated.
	//
	// This member is required.
	UsageType *string

	//  An optional group identifier for the usage estimate.
	Group *string

	//  Historical usage data associated with this estimate, if available.
	HistoricalUsage *HistoricalUsageEntity

	noSmithyDocumentSerde
}

//	Represents an error that occurred during a batch create operation for workload
//
// estimate usage.
type BatchCreateWorkloadEstimateUsageError struct {

	//  The error code associated with the failed operation.
	ErrorCode BatchCreateWorkloadEstimateUsageCode

	//  A descriptive message for the error that occurred.
	ErrorMessage *string

	//  The key of the entry that caused the error.
	Key *string

	noSmithyDocumentSerde
}

//	Represents a successfully created item in a batch operation for workload
//
// estimate usage.
type BatchCreateWorkloadEstimateUsageItem struct {

	//  The specific operation associated with this usage estimate.
	//
	// This member is required.
	Operation *string

	//  The Amazon Web Services service code for this usage estimate.
	//
	// This member is required.
	ServiceCode *string

	//  The type of usage that was estimated.
	//
	// This member is required.
	UsageType *string

	//  The estimated cost associated with this usage.
	Cost *float64

	//  The currency of the estimated cost.
	Currency CurrencyCode

	//  The group identifier for the created usage estimate.
	Group *string

	//  Historical usage data associated with this estimate, if available.
	HistoricalUsage *HistoricalUsageEntity

	//  The unique identifier assigned to the created usage estimate.
	Id *string

	//  The key of the successfully created entry.
	Key *string

	//  The location associated with this usage estimate.
	Location *string

	//  The estimated usage quantity.
	Quantity *WorkloadEstimateUsageQuantity

	//  The current status of the created usage estimate.
	Status WorkloadEstimateCostStatus

	//  The Amazon Web Services account ID associated with the created usage estimate.
	UsageAccountId *string

	noSmithyDocumentSerde
}

//	Represents an error that occurred when deleting a commitment in a Bill
//
// Scenario.
type BatchDeleteBillScenarioCommitmentModificationError struct {

	//  The code associated with the error.
	ErrorCode BatchDeleteBillScenarioCommitmentModificationErrorCode

	//  The message that describes the error.
	ErrorMessage *string

	//  The ID of the error.
	Id *string

	noSmithyDocumentSerde
}

// Represents an error that occurred when deleting usage in a Bill Scenario.
type BatchDeleteBillScenarioUsageModificationError struct {

	//  The code associated with the error.
	ErrorCode BatchDeleteBillScenarioUsageModificationErrorCode

	//  The message that describes the error.
	ErrorMessage *string

	//  The ID of the error.
	Id *string

	noSmithyDocumentSerde
}

// Represents an error that occurred when deleting usage in a workload estimate.
type BatchDeleteWorkloadEstimateUsageError struct {

	//  The code associated with the error.
	ErrorCode WorkloadEstimateUpdateUsageErrorCode

	//  The message that describes the error.
	ErrorMessage *string

	//  The ID of the error.
	Id *string

	noSmithyDocumentSerde
}

//	Represents an entry in a batch operation to update bill scenario commitment
//
// modifications.
type BatchUpdateBillScenarioCommitmentModificationEntry struct {

	//  The unique identifier of the commitment modification to update.
	//
	// This member is required.
	Id *string

	//  The updated group identifier for the commitment modification.
	Group *string

	noSmithyDocumentSerde
}

//	Represents an error that occurred when updating a commitment in a Bill
//
// Scenario.
type BatchUpdateBillScenarioCommitmentModificationError struct {

	//  The code associated with the error.
	ErrorCode BatchUpdateBillScenarioCommitmentModificationErrorCode

	//  The message that describes the error.
	ErrorMessage *string

	//  The ID of the error.
	Id *string

	noSmithyDocumentSerde
}

//	Represents an entry in a batch operation to update bill scenario usage
//
// modifications.
type BatchUpdateBillScenarioUsageModificationEntry struct {

	//  The unique identifier of the usage modification to update.
	//
	// This member is required.
	Id *string

	//  The updated usage amounts for the modification.
	Amounts []UsageAmount

	//  The updated group identifier for the usage modification.
	Group *string

	noSmithyDocumentSerde
}

// Represents an error that occurred when updating usage in a Bill Scenario.
type BatchUpdateBillScenarioUsageModificationError struct {

	//  The code associated with the error.
	ErrorCode BatchUpdateBillScenarioUsageModificationErrorCode

	//  The message that describes the error.
	ErrorMessage *string

	//  The ID of the error.
	Id *string

	noSmithyDocumentSerde
}

// Represents an entry in a batch operation to update workload estimate usage.
type BatchUpdateWorkloadEstimateUsageEntry struct {

	//  The unique identifier of the usage estimate to update.
	//
	// This member is required.
	Id *string

	//  The updated estimated usage amount.
	Amount *float64

	//  The updated group identifier for the usage estimate.
	Group *string

	noSmithyDocumentSerde
}

// Represents an error that occurred when updating usage in a workload estimate.
type BatchUpdateWorkloadEstimateUsageError struct {

	//  The code associated with the error.
	ErrorCode WorkloadEstimateUpdateUsageErrorCode

	//  The message that describes the error.
	ErrorMessage *string

	//  The ID of the error.
	Id *string

	noSmithyDocumentSerde
}

// Provides a summary of commitment-related information for a bill estimate.
type BillEstimateCommitmentSummary struct {

	//  The unique identifier of the commitment.
	Id *string

	//  The monthly payment amount for this commitment, if applicable.
	MonthlyPayment *CostAmount

	//  The identifier of the specific offering associated with this commitment.
	OfferingId *string

	//  The payment option chosen for this commitment (e.g., All Upfront, Partial
	// Upfront, No Upfront).
	PaymentOption *string

	//  The type of purchase agreement (e.g., Reserved Instance, Savings Plan).
	PurchaseAgreementType PurchaseAgreementType

	//  The Amazon Web Services region associated with this commitment.
	Region *string

	//  The length of the commitment term.
	TermLength *string

	//  The upfront payment amount for this commitment, if applicable.
	UpfrontPayment *CostAmount

	//  The Amazon Web Services account ID associated with this commitment.
	UsageAccountId *string

	noSmithyDocumentSerde
}

// Provides a summary of cost-related information for a bill estimate.
type BillEstimateCostSummary struct {

	//  A breakdown of cost differences by Amazon Web Services service.
	ServiceCostDifferences map[string]CostDifference

	//  The total difference in cost between the estimated and historical costs.
	TotalCostDifference *CostDifference

	noSmithyDocumentSerde
}

// Summarizes an input commitment modification for a bill estimate.
type BillEstimateInputCommitmentModificationSummary struct {

	//  The specific commitment action taken in this modification.
	CommitmentAction BillScenarioCommitmentModificationAction

	//  The group identifier for the commitment modification.
	Group *string

	//  The unique identifier of the commitment modification.
	Id *string

	//  The Amazon Web Services account ID associated with this commitment
	// modification.
	UsageAccountId *string

	noSmithyDocumentSerde
}

// Summarizes an input usage modification for a bill estimate.
type BillEstimateInputUsageModificationSummary struct {

	//  The specific operation associated with this usage modification.
	//
	// This member is required.
	Operation *string

	//  The Amazon Web Services service code for this usage modification.
	//
	// This member is required.
	ServiceCode *string

	//  The type of usage being modified.
	//
	// This member is required.
	UsageType *string

	//  The availability zone associated with this usage modification, if applicable.
	AvailabilityZone *string

	//  The group identifier for the usage modification.
	Group *string

	//  Historical usage data associated with this modification, if available.
	HistoricalUsage *HistoricalUsageEntity

	//  The unique identifier of the usage modification.
	Id *string

	//  The location associated with this usage modification.
	Location *string

	//  The modified usage quantities.
	Quantities []UsageQuantity

	//  The Amazon Web Services account ID associated with this usage modification.
	UsageAccountId *string

	noSmithyDocumentSerde
}

// Provides a summary of a line item in a bill estimate.
type BillEstimateLineItemSummary struct {

	//  The specific operation associated with this line item.
	//
	// This member is required.
	Operation *string

	//  The Amazon Web Services service code associated with this line item.
	//
	// This member is required.
	ServiceCode *string

	//  The type of usage for this line item.
	//
	// This member is required.
	UsageType *string

	//  The availability zone associated with this line item, if applicable.
	AvailabilityZone *string

	//  The estimated cost for this line item.
	EstimatedCost *CostAmount

	//  The estimated usage quantity for this line item.
	EstimatedUsageQuantity *UsageQuantityResult

	//  The historical cost for this line item.
	HistoricalCost *CostAmount

	//  The historical usage quantity for this line item.
	HistoricalUsageQuantity *UsageQuantityResult

	//  The unique identifier of this line item.
	Id *string

	//  The line item identifier from the original bill.
	LineItemId *string

	//  The type of this line item (e.g., Usage, Tax, Credit).
	LineItemType *string

	//  The location associated with this line item.
	Location *string

	//  The Amazon Web Services account ID of the payer for this line item.
	PayerAccountId *string

	//  The Amazon Resource Names (ARNs) of any Savings Plans applied to this line
	// item.
	SavingsPlanArns []string

	//  The Amazon Web Services account ID associated with the usage for this line
	// item.
	UsageAccountId *string

	noSmithyDocumentSerde
}

// Provides a summary of a bill estimate.
type BillEstimateSummary struct {

	//  The unique identifier of the bill estimate.
	//
	// This member is required.
	Id *string

	//  The time period covered by the bill estimate.
	BillInterval *BillInterval

	//  The timestamp when the bill estimate was created.
	CreatedAt *time.Time

	//  The timestamp when the bill estimate will expire.
	ExpiresAt *time.Time

	//  The name of the bill estimate.
	Name *string

	//  The current status of the bill estimate.
	Status BillEstimateStatus

	noSmithyDocumentSerde
}

// Represents a time interval for a bill or estimate.
type BillInterval struct {

	//  The end date and time of the interval.
	End *time.Time

	//  The start date and time of the interval.
	Start *time.Time

	noSmithyDocumentSerde
}

//	Represents an action to modify commitments in a bill scenario.
//
// The following types satisfy this interface:
//
//	BillScenarioCommitmentModificationActionMemberAddReservedInstanceAction
//	BillScenarioCommitmentModificationActionMemberAddSavingsPlanAction
//	BillScenarioCommitmentModificationActionMemberNegateReservedInstanceAction
//	BillScenarioCommitmentModificationActionMemberNegateSavingsPlanAction
type BillScenarioCommitmentModificationAction interface {
	isBillScenarioCommitmentModificationAction()
}

// Action to add a Reserved Instance to the scenario.
type BillScenarioCommitmentModificationActionMemberAddReservedInstanceAction struct {
	Value AddReservedInstanceAction

	noSmithyDocumentSerde
}

func (*BillScenarioCommitmentModificationActionMemberAddReservedInstanceAction) isBillScenarioCommitmentModificationAction() {
}

// Action to add a Savings Plan to the scenario.
type BillScenarioCommitmentModificationActionMemberAddSavingsPlanAction struct {
	Value AddSavingsPlanAction

	noSmithyDocumentSerde
}

func (*BillScenarioCommitmentModificationActionMemberAddSavingsPlanAction) isBillScenarioCommitmentModificationAction() {
}

// Action to remove a Reserved Instance from the scenario.
type BillScenarioCommitmentModificationActionMemberNegateReservedInstanceAction struct {
	Value NegateReservedInstanceAction

	noSmithyDocumentSerde
}

func (*BillScenarioCommitmentModificationActionMemberNegateReservedInstanceAction) isBillScenarioCommitmentModificationAction() {
}

// Action to remove a Savings Plan from the scenario.
type BillScenarioCommitmentModificationActionMemberNegateSavingsPlanAction struct {
	Value NegateSavingsPlanAction

	noSmithyDocumentSerde
}

func (*BillScenarioCommitmentModificationActionMemberNegateSavingsPlanAction) isBillScenarioCommitmentModificationAction() {
}

// Represents a commitment modification item in a bill scenario.
type BillScenarioCommitmentModificationItem struct {

	//  The specific commitment action taken in this modification.
	CommitmentAction BillScenarioCommitmentModificationAction

	//  The group identifier for the commitment modification.
	Group *string

	//  The unique identifier of the commitment modification.
	Id *string

	//  The Amazon Web Services account ID associated with this commitment
	// modification.
	UsageAccountId *string

	noSmithyDocumentSerde
}

// Provides a summary of a bill scenario.
type BillScenarioSummary struct {

	//  The unique identifier of the bill scenario.
	//
	// This member is required.
	Id *string

	//  The time period covered by the bill scenario.
	BillInterval *BillInterval

	// The arn of the cost category used in the reserved and prioritized group sharing.
	CostCategoryGroupSharingPreferenceArn *string

	//  The timestamp when the bill scenario was created.
	CreatedAt *time.Time

	//  The timestamp when the bill scenario will expire.
	ExpiresAt *time.Time

	//  An error message if the bill scenario creation or processing failed.
	FailureMessage *string

	// The setting for the reserved instance and savings plan group sharing used in
	// this estimate.
	GroupSharingPreference GroupSharingPreferenceEnum

	//  The name of the bill scenario.
	Name *string

	//  The current status of the bill scenario.
	Status BillScenarioStatus

	noSmithyDocumentSerde
}

// Represents a usage modification item in a bill scenario.
type BillScenarioUsageModificationItem struct {

	//  The specific operation associated with this usage modification.
	//
	// This member is required.
	Operation *string

	//  The Amazon Web Services service code for this usage modification.
	//
	// This member is required.
	ServiceCode *string

	//  The type of usage being modified.
	//
	// This member is required.
	UsageType *string

	//  The availability zone associated with this usage modification, if applicable.
	AvailabilityZone *string

	//  The group identifier for the usage modification.
	Group *string

	//  Historical usage data associated with this modification, if available.
	HistoricalUsage *HistoricalUsageEntity

	//  The unique identifier of the usage modification.
	Id *string

	//  The location associated with this usage modification.
	Location *string

	//  The modified usage quantities.
	Quantities []UsageQuantity

	//  The Amazon Web Services account ID associated with this usage modification.
	UsageAccountId *string

	noSmithyDocumentSerde
}

// Represents a monetary amount with associated currency.
type CostAmount struct {

	//  The numeric value of the cost.
	Amount *float64

	//  The currency code for the cost amount.
	Currency CurrencyCode

	noSmithyDocumentSerde
}

// Represents the difference between historical and estimated costs.
type CostDifference struct {

	//  The estimated cost amount.
	EstimatedCost *CostAmount

	//  The historical cost amount.
	HistoricalCost *CostAmount

	noSmithyDocumentSerde
}

// Represents a complex filtering expression for cost and usage data.
type Expression struct {

	//  A list of expressions to be combined with AND logic.
	And []Expression

	//  Filters based on cost categories.
	CostCategories *ExpressionFilter

	//  Filters based on dimensions (e.g., service, operation).
	Dimensions *ExpressionFilter

	//  An expression to be negated.
	Not *Expression

	//  A list of expressions to be combined with OR logic.
	Or []Expression

	//  Filters based on resource tags.
	Tags *ExpressionFilter

	noSmithyDocumentSerde
}

// Represents a filter used within an expression.
type ExpressionFilter struct {

	//  The key or attribute to filter on.
	Key *string

	//  The match options for the filter (e.g., equals, contains).
	MatchOptions []string

	//  The values to match against.
	Values []string

	noSmithyDocumentSerde
}

// Represents a time-based filter.
type FilterTimestamp struct {

	//  Include results after this timestamp.
	AfterTimestamp *time.Time

	//  Include results before this timestamp.
	BeforeTimestamp *time.Time

	noSmithyDocumentSerde
}

// Represents historical usage data for a specific entity.
type HistoricalUsageEntity struct {

	//  The time interval for the historical usage data.
	//
	// This member is required.
	BillInterval *BillInterval

	//  An optional filter expression to apply to the historical usage data.
	//
	// This member is required.
	FilterExpression *Expression

	//  The specific operation associated with the usage.
	//
	// This member is required.
	Operation *string

	//  The Amazon Web Services service code associated with the usage.
	//
	// This member is required.
	ServiceCode *string

	//  The Amazon Web Services account ID associated with the usage.
	//
	// This member is required.
	UsageAccountId *string

	//  The type of usage.
	//
	// This member is required.
	UsageType *string

	//  The location associated with the usage.
	Location *string

	noSmithyDocumentSerde
}

// Represents a filter for listing bill estimate line items.
type ListBillEstimateLineItemsFilter struct {

	//  The name of the filter attribute.
	//
	// This member is required.
	Name ListBillEstimateLineItemsFilterName

	//  The values to filter by.
	//
	// This member is required.
	Values []string

	//  The match option for the filter (e.g., equals, contains).
	MatchOption MatchOption

	noSmithyDocumentSerde
}

// Represents a filter for listing bill estimates.
type ListBillEstimatesFilter struct {

	//  The name of the filter attribute.
	//
	// This member is required.
	Name ListBillEstimatesFilterName

	//  The values to filter by.
	//
	// This member is required.
	Values []string

	//  The match option for the filter (e.g., equals, contains).
	MatchOption MatchOption

	noSmithyDocumentSerde
}

// Represents a filter for listing bill scenarios.
type ListBillScenariosFilter struct {

	//  The name of the filter attribute.
	//
	// This member is required.
	Name ListBillScenariosFilterName

	//  The values to filter by.
	//
	// This member is required.
	Values []string

	//  The match option for the filter (e.g., equals, contains).
	MatchOption MatchOption

	noSmithyDocumentSerde
}

// Represents a filter for listing usage data.
type ListUsageFilter struct {

	//  The name of the filter attribute.
	//
	// This member is required.
	Name ListUsageFilterName

	//  The values to filter by.
	//
	// This member is required.
	Values []string

	//  The match option for the filter (e.g., equals, contains).
	MatchOption MatchOption

	noSmithyDocumentSerde
}

// Represents a filter for listing workload estimates.
type ListWorkloadEstimatesFilter struct {

	//  The name of the filter attribute.
	//
	// This member is required.
	Name ListWorkloadEstimatesFilterName

	//  The values to filter by.
	//
	// This member is required.
	Values []string

	//  The match option for the filter (e.g., equals, contains).
	MatchOption MatchOption

	noSmithyDocumentSerde
}

//	Represents an action to remove a Reserved Instance from a bill scenario.
//
// This is the ID of an existing Reserved Instance in your account.
type NegateReservedInstanceAction struct {

	//  The ID of the Reserved Instance to remove.
	ReservedInstancesId *string

	noSmithyDocumentSerde
}

//	Represents an action to remove a Savings Plan from a bill scenario.
//
// This is the ID of an existing Savings Plan in your account.
type NegateSavingsPlanAction struct {

	//  The ID of the Savings Plan to remove.
	SavingsPlanId *string

	noSmithyDocumentSerde
}

// Represents a usage amount for a specific time period.
type UsageAmount struct {

	//  The usage amount for the period.
	//
	// This member is required.
	Amount *float64

	//  The start hour of the usage period.
	//
	// This member is required.
	StartHour *time.Time

	noSmithyDocumentSerde
}

// Represents a usage quantity with associated unit and time period.
type UsageQuantity struct {

	//  The numeric value of the usage quantity.
	Amount *float64

	//  The start hour of the usage period.
	StartHour *time.Time

	//  The unit of measurement for the usage quantity.
	Unit *string

	noSmithyDocumentSerde
}

// Represents the result of a usage quantity calculation.
type UsageQuantityResult struct {

	//  The numeric value of the usage quantity result.
	Amount *float64

	//  The unit of measurement for the usage quantity result.
	Unit *string

	noSmithyDocumentSerde
}

// Represents a field that failed validation in a request.
type ValidationExceptionField struct {

	//  The error message describing why the field failed validation.
	//
	// This member is required.
	Message *string

	//  The name of the field that failed validation.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Provides a summary of a workload estimate.
type WorkloadEstimateSummary struct {

	//  The unique identifier of the workload estimate.
	//
	// This member is required.
	Id *string

	//  The currency of the estimated cost.
	CostCurrency CurrencyCode

	//  The timestamp when the workload estimate was created.
	CreatedAt *time.Time

	//  The timestamp when the workload estimate will expire.
	ExpiresAt *time.Time

	//  An error message if the workload estimate creation or processing failed.
	FailureMessage *string

	//  The name of the workload estimate.
	Name *string

	//  The timestamp of the pricing rates used for the estimate.
	RateTimestamp *time.Time

	//  The type of pricing rates used for the estimate.
	RateType WorkloadEstimateRateType

	//  The current status of the workload estimate.
	Status WorkloadEstimateStatus

	//  The total estimated cost for the workload.
	TotalCost *float64

	noSmithyDocumentSerde
}

// Represents a usage item in a workload estimate.
type WorkloadEstimateUsageItem struct {

	//  The specific operation associated with this usage item.
	//
	// This member is required.
	Operation *string

	//  The Amazon Web Services service code associated with this usage item.
	//
	// This member is required.
	ServiceCode *string

	//  The type of usage for this item.
	//
	// This member is required.
	UsageType *string

	//  The estimated cost for this usage item.
	Cost *float64

	//  The currency of the estimated cost.
	Currency CurrencyCode

	//  The group identifier for this usage item.
	Group *string

	//  Historical usage data associated with this item, if available.
	HistoricalUsage *HistoricalUsageEntity

	//  The unique identifier of this usage item.
	Id *string

	//  The location associated with this usage item.
	Location *string

	//  The estimated usage quantity for this item.
	Quantity *WorkloadEstimateUsageQuantity

	//  The current status of this usage item.
	Status WorkloadEstimateCostStatus

	//  The Amazon Web Services account ID associated with this usage item.
	UsageAccountId *string

	noSmithyDocumentSerde
}

// Represents a usage quantity for a workload estimate.
type WorkloadEstimateUsageQuantity struct {

	//  The numeric value of the usage quantity.
	Amount *float64

	//  The unit of measurement for the usage quantity.
	Unit *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isBillScenarioCommitmentModificationAction() {}
