// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmpricingcalculator

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all workload estimates for the account.
func (c *Client) ListWorkloadEstimates(ctx context.Context, params *ListWorkloadEstimatesInput, optFns ...func(*Options)) (*ListWorkloadEstimatesOutput, error) {
	if params == nil {
		params = &ListWorkloadEstimatesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListWorkloadEstimates", params, optFns, c.addOperationListWorkloadEstimatesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListWorkloadEstimatesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListWorkloadEstimatesInput struct {

	//  Filter workload estimates based on the creation date.
	CreatedAtFilter *types.FilterTimestamp

	//  Filter workload estimates based on the expiration date.
	ExpiresAtFilter *types.FilterTimestamp

	//  Filters to apply to the list of workload estimates.
	Filters []types.ListWorkloadEstimatesFilter

	//  The maximum number of results to return per page.
	MaxResults *int32

	//  A token to retrieve the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListWorkloadEstimatesOutput struct {

	//  The list of workload estimates for the account.
	Items []types.WorkloadEstimateSummary

	//  A token to retrieve the next page of results, if any.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListWorkloadEstimatesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListWorkloadEstimates{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListWorkloadEstimates{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListWorkloadEstimates"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListWorkloadEstimatesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListWorkloadEstimates(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListWorkloadEstimatesPaginatorOptions is the paginator options for
// ListWorkloadEstimates
type ListWorkloadEstimatesPaginatorOptions struct {
	//  The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListWorkloadEstimatesPaginator is a paginator for ListWorkloadEstimates
type ListWorkloadEstimatesPaginator struct {
	options   ListWorkloadEstimatesPaginatorOptions
	client    ListWorkloadEstimatesAPIClient
	params    *ListWorkloadEstimatesInput
	nextToken *string
	firstPage bool
}

// NewListWorkloadEstimatesPaginator returns a new ListWorkloadEstimatesPaginator
func NewListWorkloadEstimatesPaginator(client ListWorkloadEstimatesAPIClient, params *ListWorkloadEstimatesInput, optFns ...func(*ListWorkloadEstimatesPaginatorOptions)) *ListWorkloadEstimatesPaginator {
	if params == nil {
		params = &ListWorkloadEstimatesInput{}
	}

	options := ListWorkloadEstimatesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListWorkloadEstimatesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListWorkloadEstimatesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListWorkloadEstimates page.
func (p *ListWorkloadEstimatesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListWorkloadEstimatesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListWorkloadEstimates(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListWorkloadEstimatesAPIClient is a client that implements the
// ListWorkloadEstimates operation.
type ListWorkloadEstimatesAPIClient interface {
	ListWorkloadEstimates(context.Context, *ListWorkloadEstimatesInput, ...func(*Options)) (*ListWorkloadEstimatesOutput, error)
}

var _ ListWorkloadEstimatesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListWorkloadEstimates(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListWorkloadEstimates",
	}
}
