// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmpricingcalculator

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves details of a specific bill scenario.
func (c *Client) GetBillScenario(ctx context.Context, params *GetBillScenarioInput, optFns ...func(*Options)) (*GetBillScenarioOutput, error) {
	if params == nil {
		params = &GetBillScenarioInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetBillScenario", params, optFns, c.addOperationGetBillScenarioMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetBillScenarioOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetBillScenarioInput struct {

	//  The unique identifier of the bill scenario to retrieve.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

type GetBillScenarioOutput struct {

	//  The unique identifier of the retrieved bill scenario.
	//
	// This member is required.
	Id *string

	//  The time period covered by the bill scenario.
	BillInterval *types.BillInterval

	// The arn of the cost category used in the reserved and prioritized group sharing.
	CostCategoryGroupSharingPreferenceArn *string

	//  The timestamp when the bill scenario was created.
	CreatedAt *time.Time

	//  The timestamp when the bill scenario will expire.
	ExpiresAt *time.Time

	//  An error message if the bill scenario retrieval failed.
	FailureMessage *string

	// The setting for the reserved instance and savings plan group sharing used in
	// this estimate.
	GroupSharingPreference types.GroupSharingPreferenceEnum

	//  The name of the retrieved bill scenario.
	Name *string

	//  The current status of the bill scenario.
	Status types.BillScenarioStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetBillScenarioMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetBillScenario{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetBillScenario{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetBillScenario"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetBillScenarioValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetBillScenario(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetBillScenario(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetBillScenario",
	}
}
