// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmpricingcalculator

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Update a newly added or existing usage lines. You can update the usage amounts
//
// and usage group based on a usage ID and a Workload estimate ID.
//
// The BatchUpdateWorkloadEstimateUsage operation doesn't have its own IAM
// permission. To authorize this operation for Amazon Web Services principals,
// include the permission bcm-pricing-calculator:UpdateWorkloadEstimateUsage in
// your policies.
func (c *Client) BatchUpdateWorkloadEstimateUsage(ctx context.Context, params *BatchUpdateWorkloadEstimateUsageInput, optFns ...func(*Options)) (*BatchUpdateWorkloadEstimateUsageOutput, error) {
	if params == nil {
		params = &BatchUpdateWorkloadEstimateUsageInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchUpdateWorkloadEstimateUsage", params, optFns, c.addOperationBatchUpdateWorkloadEstimateUsageMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchUpdateWorkloadEstimateUsageOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchUpdateWorkloadEstimateUsageInput struct {

	//  List of usage line amounts and usage group that you want to update in a
	// Workload estimate identified by the usage ID.
	//
	// This member is required.
	Usage []types.BatchUpdateWorkloadEstimateUsageEntry

	//  The ID of the Workload estimate for which you want to modify the usage lines.
	//
	// This member is required.
	WorkloadEstimateId *string

	noSmithyDocumentSerde
}

type BatchUpdateWorkloadEstimateUsageOutput struct {

	//  Returns the list of error reasons and usage line item IDs that could not be
	// updated for the Workload estimate.
	Errors []types.BatchUpdateWorkloadEstimateUsageError

	//  Returns the list of successful usage line items that were updated for a
	// Workload estimate.
	Items []types.WorkloadEstimateUsageItem

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchUpdateWorkloadEstimateUsageMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpBatchUpdateWorkloadEstimateUsage{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpBatchUpdateWorkloadEstimateUsage{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchUpdateWorkloadEstimateUsage"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpBatchUpdateWorkloadEstimateUsageValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchUpdateWorkloadEstimateUsage(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opBatchUpdateWorkloadEstimateUsage(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchUpdateWorkloadEstimateUsage",
	}
}
