// Code generated by smithy-go-codegen DO NOT EDIT.

package backupsearch

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/backupsearch/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// This operation retrieves the metadata of an export job.
//
// An export job is an operation that transmits the results of a search job to a
// specified S3 bucket in a .csv file.
//
// An export job allows you to retain results of a search beyond the search job's
// scheduled retention of 7 days.
func (c *Client) GetSearchResultExportJob(ctx context.Context, params *GetSearchResultExportJobInput, optFns ...func(*Options)) (*GetSearchResultExportJobOutput, error) {
	if params == nil {
		params = &GetSearchResultExportJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetSearchResultExportJob", params, optFns, c.addOperationGetSearchResultExportJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetSearchResultExportJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetSearchResultExportJobInput struct {

	// This is the unique string that identifies a specific export job.
	//
	// Required for this operation.
	//
	// This member is required.
	ExportJobIdentifier *string

	noSmithyDocumentSerde
}

type GetSearchResultExportJobOutput struct {

	// This is the unique string that identifies the specified export job.
	//
	// This member is required.
	ExportJobIdentifier *string

	// The date and time that an export job completed, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationTime is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CompletionTime *time.Time

	// The date and time that an export job was created, in Unix format and
	// Coordinated Universal Time (UTC). The value of CreationTime is accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 2018 12:11:30.087 AM.
	CreationTime *time.Time

	// The unique Amazon Resource Name (ARN) that uniquely identifies the export job.
	ExportJobArn *string

	// The export specification consists of the destination S3 bucket to which the
	// search results were exported, along with the destination prefix.
	ExportSpecification types.ExportSpecification

	// The unique string that identifies the Amazon Resource Name (ARN) of the
	// specified search job.
	SearchJobArn *string

	// This is the current status of the export job.
	Status types.ExportJobStatus

	// A status message is a string that is returned for search job with a status of
	// FAILED , along with steps to remedy and retry the operation.
	StatusMessage *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetSearchResultExportJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetSearchResultExportJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetSearchResultExportJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetSearchResultExportJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetSearchResultExportJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetSearchResultExportJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetSearchResultExportJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetSearchResultExportJob",
	}
}
