// Code generated by smithy-go-codegen DO NOT EDIT.

package backup

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/backup/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns a list of existing scan jobs for an authenticated account for the last
// 30 days.
func (c *Client) ListScanJobs(ctx context.Context, params *ListScanJobsInput, optFns ...func(*Options)) (*ListScanJobsOutput, error) {
	if params == nil {
		params = &ListScanJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListScanJobs", params, optFns, c.addOperationListScanJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListScanJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListScanJobsInput struct {

	// The account ID to list the jobs from. Returns only backup jobs associated with
	// the specified account ID.
	//
	// If used from an Amazon Web Services Organizations management account, passing *
	// returns all jobs across the organization.
	//
	// Pattern: ^[0-9]{12}$
	ByAccountId *string

	// Returns only scan jobs that will be stored in the specified backup vault.
	// Backup vaults are identified by names that are unique to the account used to
	// create them and the Amazon Web Services Region where they are created.
	//
	// Pattern: ^[a-zA-Z0-9\-\_\.]{2,50}$
	ByBackupVaultName *string

	// Returns only scan jobs completed after a date expressed in Unix format and
	// Coordinated Universal Time (UTC).
	ByCompleteAfter *time.Time

	// Returns only backup jobs completed before a date expressed in Unix format and
	// Coordinated Universal Time (UTC).
	ByCompleteBefore *time.Time

	// Returns only the scan jobs for the specified malware scanner. Currently only
	// supports GUARDDUTY .
	ByMalwareScanner types.MalwareScanner

	// Returns only the scan jobs that are ran against the specified recovery point.
	ByRecoveryPointArn *string

	// Returns only scan jobs that match the specified resource Amazon Resource Name
	// (ARN).
	ByResourceArn *string

	// Returns restore testing selections by the specified restore testing plan name.
	//
	//   - EBS for Amazon Elastic Block Store
	//
	//   - EC2 for Amazon Elastic Compute Cloud
	//
	//   - S3 for Amazon Simple Storage Service (Amazon S3)
	//
	// Pattern: ^[a-zA-Z0-9\-\_\.]{1,50}$
	ByResourceType types.ScanResourceType

	// Returns only the scan jobs for the specified scan results:
	//
	//   - THREATS_FOUND
	//
	//   - NO_THREATS_FOUND
	ByScanResultStatus types.ScanResultStatus

	// Returns only the scan jobs for the specified scanning job state.
	ByState types.ScanState

	// The maximum number of items to be returned.
	//
	// Valid Range: Minimum value of 1. Maximum value of 1000.
	MaxResults *int32

	// The next item following a partial list of returned items. For example, if a
	// request is made to return MaxResults number of items, NextToken allows you to
	// return more items in your list starting at the location pointed to by the next
	// token.
	NextToken *string

	noSmithyDocumentSerde
}

type ListScanJobsOutput struct {

	// An array of structures containing metadata about your scan jobs returned in
	// JSON format.
	//
	// This member is required.
	ScanJobs []types.ScanJob

	// The next item following a partial list of returned items. For example, if a
	// request is made to return MaxResults number of items, NextToken allows you to
	// return more items in your list starting at the location pointed to by the next
	// token.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListScanJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListScanJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListScanJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListScanJobs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListScanJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListScanJobsPaginatorOptions is the paginator options for ListScanJobs
type ListScanJobsPaginatorOptions struct {
	// The maximum number of items to be returned.
	//
	// Valid Range: Minimum value of 1. Maximum value of 1000.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListScanJobsPaginator is a paginator for ListScanJobs
type ListScanJobsPaginator struct {
	options   ListScanJobsPaginatorOptions
	client    ListScanJobsAPIClient
	params    *ListScanJobsInput
	nextToken *string
	firstPage bool
}

// NewListScanJobsPaginator returns a new ListScanJobsPaginator
func NewListScanJobsPaginator(client ListScanJobsAPIClient, params *ListScanJobsInput, optFns ...func(*ListScanJobsPaginatorOptions)) *ListScanJobsPaginator {
	if params == nil {
		params = &ListScanJobsInput{}
	}

	options := ListScanJobsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListScanJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListScanJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListScanJobs page.
func (p *ListScanJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListScanJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListScanJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListScanJobsAPIClient is a client that implements the ListScanJobs operation.
type ListScanJobsAPIClient interface {
	ListScanJobs(context.Context, *ListScanJobsInput, ...func(*Options)) (*ListScanJobsOutput, error)
}

var _ ListScanJobsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListScanJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListScanJobs",
	}
}
