// Code generated by smithy-go-codegen DO NOT EDIT.

package backup

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/backup/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a restore access backup vault that provides temporary access to
// recovery points in a logically air-gapped backup vault, subject to MPA approval.
func (c *Client) CreateRestoreAccessBackupVault(ctx context.Context, params *CreateRestoreAccessBackupVaultInput, optFns ...func(*Options)) (*CreateRestoreAccessBackupVaultOutput, error) {
	if params == nil {
		params = &CreateRestoreAccessBackupVaultInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateRestoreAccessBackupVault", params, optFns, c.addOperationCreateRestoreAccessBackupVaultMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateRestoreAccessBackupVaultOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateRestoreAccessBackupVaultInput struct {

	// The ARN of the source backup vault containing the recovery points to which
	// temporary access is requested.
	//
	// This member is required.
	SourceBackupVaultArn *string

	// The name of the backup vault to associate with an MPA approval team.
	BackupVaultName *string

	// Optional tags to assign to the restore access backup vault.
	BackupVaultTags map[string]string

	// A unique string that identifies the request and allows failed requests to be
	// retried without the risk of executing the operation twice.
	CreatorRequestId *string

	// A comment explaining the reason for requesting restore access to the backup
	// vault.
	RequesterComment *string

	noSmithyDocumentSerde
}

type CreateRestoreAccessBackupVaultOutput struct {

	// >The date and time when the restore access backup vault was created, in Unix
	// format and Coordinated Universal Time
	CreationDate *time.Time

	// The ARN that uniquely identifies the created restore access backup vault.
	RestoreAccessBackupVaultArn *string

	// The name of the created restore access backup vault.
	RestoreAccessBackupVaultName *string

	// The current state of the restore access backup vault.
	VaultState types.VaultState

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateRestoreAccessBackupVaultMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateRestoreAccessBackupVault{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateRestoreAccessBackupVault{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateRestoreAccessBackupVault"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateRestoreAccessBackupVaultMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateRestoreAccessBackupVaultValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateRestoreAccessBackupVault(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateRestoreAccessBackupVault struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateRestoreAccessBackupVault) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateRestoreAccessBackupVault) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateRestoreAccessBackupVaultInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateRestoreAccessBackupVaultInput ")
	}

	if input.CreatorRequestId == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.CreatorRequestId = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateRestoreAccessBackupVaultMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateRestoreAccessBackupVault{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateRestoreAccessBackupVault(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateRestoreAccessBackupVault",
	}
}
