// Code generated by smithy-go-codegen DO NOT EDIT.

package auditmanager

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Validates the integrity of an assessment report in Audit Manager.
func (c *Client) ValidateAssessmentReportIntegrity(ctx context.Context, params *ValidateAssessmentReportIntegrityInput, optFns ...func(*Options)) (*ValidateAssessmentReportIntegrityOutput, error) {
	if params == nil {
		params = &ValidateAssessmentReportIntegrityInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ValidateAssessmentReportIntegrity", params, optFns, c.addOperationValidateAssessmentReportIntegrityMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ValidateAssessmentReportIntegrityOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ValidateAssessmentReportIntegrityInput struct {

	//  The relative path of the Amazon S3 bucket that the assessment report is stored
	// in.
	//
	// This member is required.
	S3RelativePath *string

	noSmithyDocumentSerde
}

type ValidateAssessmentReportIntegrityOutput struct {

	//  The signature algorithm that's used to code sign the assessment report file.
	SignatureAlgorithm *string

	//  The date and time signature that specifies when the assessment report was
	// created.
	SignatureDateTime *string

	//  The unique identifier for the validation signature key.
	SignatureKeyId *string

	//  Specifies whether the signature key is valid.
	SignatureValid *bool

	//  Represents any errors that occurred when validating the assessment report.
	ValidationErrors []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationValidateAssessmentReportIntegrityMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpValidateAssessmentReportIntegrity{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpValidateAssessmentReportIntegrity{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ValidateAssessmentReportIntegrity"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpValidateAssessmentReportIntegrityValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opValidateAssessmentReportIntegrity(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opValidateAssessmentReportIntegrity(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ValidateAssessmentReportIntegrity",
	}
}
