// Code generated by smithy-go-codegen DO NOT EDIT.

package appstream

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/appstream/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates custom branding that customizes the appearance of the streaming
// application catalog page.
func (c *Client) UpdateThemeForStack(ctx context.Context, params *UpdateThemeForStackInput, optFns ...func(*Options)) (*UpdateThemeForStackOutput, error) {
	if params == nil {
		params = &UpdateThemeForStackInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateThemeForStack", params, optFns, c.addOperationUpdateThemeForStackMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateThemeForStackOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateThemeForStackInput struct {

	// The name of the stack for the theme.
	//
	// This member is required.
	StackName *string

	// The attributes to delete.
	AttributesToDelete []types.ThemeAttribute

	// The S3 location of the favicon. The favicon enables users to recognize their
	// application streaming site in a browser full of tabs or bookmarks. It is
	// displayed at the top of the browser tab for the application streaming site
	// during users' streaming sessions.
	FaviconS3Location *types.S3Location

	// The links that are displayed in the footer of the streaming application catalog
	// page. These links are helpful resources for users, such as the organization's IT
	// support and product marketing sites.
	FooterLinks []types.ThemeFooterLink

	// The organization logo that appears on the streaming application catalog page.
	OrganizationLogoS3Location *types.S3Location

	// Specifies whether custom branding should be applied to catalog page or not.
	State types.ThemeState

	// The color theme that is applied to website links, text, and buttons. These
	// colors are also applied as accents in the background for the streaming
	// application catalog page.
	ThemeStyling types.ThemeStyling

	// The title that is displayed at the top of the browser tab during users'
	// application streaming sessions.
	TitleText *string

	noSmithyDocumentSerde
}

type UpdateThemeForStackOutput struct {

	//  The theme object that contains the metadata of the custom branding.
	Theme *types.Theme

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateThemeForStackMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateThemeForStack{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateThemeForStack{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateThemeForStack"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateThemeForStackValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateThemeForStack(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateThemeForStack(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateThemeForStack",
	}
}
