// Code generated by smithy-go-codegen DO NOT EDIT.

package appstream

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/appstream/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a task to export a WorkSpaces Applications image to an EC2 AMI. This
// allows you to use your customized WorkSpaces Applications images with other AWS
// services or for backup purposes.
func (c *Client) CreateExportImageTask(ctx context.Context, params *CreateExportImageTaskInput, optFns ...func(*Options)) (*CreateExportImageTaskOutput, error) {
	if params == nil {
		params = &CreateExportImageTaskInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateExportImageTask", params, optFns, c.addOperationCreateExportImageTaskMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateExportImageTaskOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateExportImageTaskInput struct {

	// The name for the exported EC2 AMI. This is a required field that must be unique
	// within your account and region.
	//
	// This member is required.
	AmiName *string

	// The ARN of the IAM role that allows WorkSpaces Applications to create the AMI.
	// The role must have permissions to copy images, describe images, and create tags,
	// with a trust relationship allowing appstream.amazonaws.com to assume the role.
	//
	// This member is required.
	IamRoleArn *string

	// The name of the WorkSpaces Applications image to export. The image must be in
	// an available state and owned by your account.
	//
	// This member is required.
	ImageName *string

	// An optional description for the exported AMI. This description will be applied
	// to the resulting EC2 AMI.
	AmiDescription *string

	// The tags to apply to the exported AMI. These tags help you organize and manage
	// your EC2 AMIs.
	TagSpecifications map[string]string

	noSmithyDocumentSerde
}

type CreateExportImageTaskOutput struct {

	// Information about the export image task that was created, including the task ID
	// and initial state.
	ExportImageTask *types.ExportImageTask

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateExportImageTaskMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateExportImageTask{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateExportImageTask{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateExportImageTask"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateExportImageTaskValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateExportImageTask(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateExportImageTask(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateExportImageTask",
	}
}
