// Code generated by smithy-go-codegen DO NOT EDIT.

package appstream

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Associates license included application(s) with an existing image builder
// instance.
func (c *Client) AssociateSoftwareToImageBuilder(ctx context.Context, params *AssociateSoftwareToImageBuilderInput, optFns ...func(*Options)) (*AssociateSoftwareToImageBuilderOutput, error) {
	if params == nil {
		params = &AssociateSoftwareToImageBuilderInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AssociateSoftwareToImageBuilder", params, optFns, c.addOperationAssociateSoftwareToImageBuilderMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AssociateSoftwareToImageBuilderOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AssociateSoftwareToImageBuilderInput struct {

	// The name of the target image builder instance.
	//
	// This member is required.
	ImageBuilderName *string

	// The list of license included applications to associate with the image builder.
	//
	// Possible values include the following:
	//
	//   - Microsoft_Office_2021_LTSC_Professional_Plus_32Bit
	//
	//   - Microsoft_Office_2021_LTSC_Professional_Plus_64Bit
	//
	//   - Microsoft_Office_2024_LTSC_Professional_Plus_32Bit
	//
	//   - Microsoft_Office_2024_LTSC_Professional_Plus_64Bit
	//
	//   - Microsoft_Visio_2021_LTSC_Professional_32Bit
	//
	//   - Microsoft_Visio_2021_LTSC_Professional_64Bit
	//
	//   - Microsoft_Visio_2024_LTSC_Professional_32Bit
	//
	//   - Microsoft_Visio_2024_LTSC_Professional_64Bit
	//
	//   - Microsoft_Project_2021_Professional_32Bit
	//
	//   - Microsoft_Project_2021_Professional_64Bit
	//
	//   - Microsoft_Project_2024_Professional_32Bit
	//
	//   - Microsoft_Project_2024_Professional_64Bit
	//
	//   - Microsoft_Office_2021_LTSC_Standard_32Bit
	//
	//   - Microsoft_Office_2021_LTSC_Standard_64Bit
	//
	//   - Microsoft_Office_2024_LTSC_Standard_32Bit
	//
	//   - Microsoft_Office_2024_LTSC_Standard_64Bit
	//
	//   - Microsoft_Visio_2021_LTSC_Standard_32Bit
	//
	//   - Microsoft_Visio_2021_LTSC_Standard_64Bit
	//
	//   - Microsoft_Visio_2024_LTSC_Standard_32Bit
	//
	//   - Microsoft_Visio_2024_LTSC_Standard_64Bit
	//
	//   - Microsoft_Project_2021_Standard_32Bit
	//
	//   - Microsoft_Project_2021_Standard_64Bit
	//
	//   - Microsoft_Project_2024_Standard_32Bit
	//
	//   - Microsoft_Project_2024_Standard_64Bit
	//
	// This member is required.
	SoftwareNames []string

	noSmithyDocumentSerde
}

type AssociateSoftwareToImageBuilderOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAssociateSoftwareToImageBuilderMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpAssociateSoftwareToImageBuilder{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpAssociateSoftwareToImageBuilder{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "AssociateSoftwareToImageBuilder"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpAssociateSoftwareToImageBuilderValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAssociateSoftwareToImageBuilder(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opAssociateSoftwareToImageBuilder(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "AssociateSoftwareToImageBuilder",
	}
}
