// Code generated by smithy-go-codegen DO NOT EDIT.

package applicationsignals

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/applicationsignals/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns information about the last deployment and other change states of
// services. This API provides visibility into recent changes that may have
// affected service performance, helping with troubleshooting and change
// correlation.
func (c *Client) ListServiceStates(ctx context.Context, params *ListServiceStatesInput, optFns ...func(*Options)) (*ListServiceStatesOutput, error) {
	if params == nil {
		params = &ListServiceStatesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListServiceStates", params, optFns, c.addOperationListServiceStatesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListServiceStatesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListServiceStatesInput struct {

	// The end of the time period to retrieve service state information for. When used
	// in a raw HTTP Query API, it is formatted as epoch time in seconds. For example,
	// 1698778057 .
	//
	// This member is required.
	EndTime *time.Time

	// The start of the time period to retrieve service state information for. When
	// used in a raw HTTP Query API, it is formatted as epoch time in seconds. For
	// example, 1698778057 .
	//
	// This member is required.
	StartTime *time.Time

	// A list of attribute filters to narrow down the services. You can filter by
	// platform, environment, or other service attributes.
	AttributeFilters []types.AttributeFilter

	// The Amazon Web Services account ID to filter service states by. Use this to
	// limit results to services from a specific account.
	AwsAccountId *string

	// If you are using this operation in a monitoring account, specify true to
	// include service states from source accounts in the returned data.
	IncludeLinkedAccounts bool

	// The maximum number of service states to return in one operation. If you omit
	// this parameter, the default of 20 is used.
	MaxResults *int32

	// Include this value, if it was returned by the previous operation, to get the
	// next set of service states.
	NextToken *string

	noSmithyDocumentSerde
}

type ListServiceStatesOutput struct {

	// The end of the time period that the returned information applies to. When used
	// in a raw HTTP Query API, it is formatted as epoch time in seconds. For example,
	// 1698778057 .
	//
	// This member is required.
	EndTime *time.Time

	// An array of structures, where each structure contains information about the
	// state of one service, including its latest change events such as deployments.
	//
	// This member is required.
	ServiceStates []types.ServiceState

	// The start of the time period that the returned information applies to. When
	// used in a raw HTTP Query API, it is formatted as epoch time in seconds. For
	// example, 1698778057 .
	//
	// This member is required.
	StartTime *time.Time

	// Include this value in your next use of this API to get the next set of service
	// states.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListServiceStatesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListServiceStates{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListServiceStates{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListServiceStates"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListServiceStatesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListServiceStates(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListServiceStatesPaginatorOptions is the paginator options for ListServiceStates
type ListServiceStatesPaginatorOptions struct {
	// The maximum number of service states to return in one operation. If you omit
	// this parameter, the default of 20 is used.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListServiceStatesPaginator is a paginator for ListServiceStates
type ListServiceStatesPaginator struct {
	options   ListServiceStatesPaginatorOptions
	client    ListServiceStatesAPIClient
	params    *ListServiceStatesInput
	nextToken *string
	firstPage bool
}

// NewListServiceStatesPaginator returns a new ListServiceStatesPaginator
func NewListServiceStatesPaginator(client ListServiceStatesAPIClient, params *ListServiceStatesInput, optFns ...func(*ListServiceStatesPaginatorOptions)) *ListServiceStatesPaginator {
	if params == nil {
		params = &ListServiceStatesInput{}
	}

	options := ListServiceStatesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListServiceStatesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListServiceStatesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListServiceStates page.
func (p *ListServiceStatesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListServiceStatesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListServiceStates(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListServiceStatesAPIClient is a client that implements the ListServiceStates
// operation.
type ListServiceStatesAPIClient interface {
	ListServiceStates(context.Context, *ListServiceStatesInput, ...func(*Options)) (*ListServiceStatesOutput, error)
}

var _ ListServiceStatesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListServiceStates(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListServiceStates",
	}
}
