// Code generated by smithy-go-codegen DO NOT EDIT.

package applicationsignals

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/applicationsignals/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns a list of change events for a specific entity, such as deployments,
// configuration changes, or other state-changing activities. This operation helps
// track the history of changes that may have affected service performance.
func (c *Client) ListEntityEvents(ctx context.Context, params *ListEntityEventsInput, optFns ...func(*Options)) (*ListEntityEventsOutput, error) {
	if params == nil {
		params = &ListEntityEventsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListEntityEvents", params, optFns, c.addOperationListEntityEventsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListEntityEventsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListEntityEventsInput struct {

	// The end of the time period to retrieve change events for. When used in a raw
	// HTTP Query API, it is formatted as epoch time in seconds. For example:
	// 1698778057
	//
	// This member is required.
	EndTime *time.Time

	// The entity for which to retrieve change events. This specifies the service,
	// resource, or other entity whose event history you want to examine.
	//
	// This is a string-to-string map. It can include the following fields.
	//
	//   - Type designates the type of object this is.
	//
	//   - ResourceType specifies the type of the resource. This field is used only
	//   when the value of the Type field is Resource or AWS::Resource .
	//
	//   - Name specifies the name of the object. This is used only if the value of the
	//   Type field is Service , RemoteService , or AWS::Service .
	//
	//   - Identifier identifies the resource objects of this resource. This is used
	//   only if the value of the Type field is Resource or AWS::Resource .
	//
	//   - Environment specifies the location where this object is hosted, or what it
	//   belongs to.
	//
	//   - AwsAccountId specifies the account where this object is in.
	//
	// Below is an example of a service.
	//
	//     { "Type": "Service", "Name": "visits-service", "Environment": "petclinic-test" }
	//
	// Below is an example of a resource.
	//
	//     { "Type": "AWS::Resource", "ResourceType": "AWS::DynamoDB::Table",
	//     "Identifier": "Customers" }
	//
	// This member is required.
	Entity map[string]string

	// The start of the time period to retrieve change events for. When used in a raw
	// HTTP Query API, it is formatted as epoch time in seconds. For example:
	// 1698778057
	//
	// This member is required.
	StartTime *time.Time

	// The maximum number of change events to return in one operation. If you omit
	// this parameter, the default of 50 is used.
	MaxResults *int32

	// Include this value, if it was returned by the previous operation, to get the
	// next set of change events.
	NextToken *string

	noSmithyDocumentSerde
}

type ListEntityEventsOutput struct {

	// An array of structures, where each structure contains information about one
	// change event that occurred for the specified entity during the requested time
	// period.
	//
	// This member is required.
	ChangeEvents []types.ChangeEvent

	// The end of the time period that the returned change events apply to. When used
	// in a raw HTTP Query API, it is formatted as epoch time in seconds. For example:
	// 1698778057
	//
	// This member is required.
	EndTime *time.Time

	// The start of the time period that the returned change events apply to. When
	// used in a raw HTTP Query API, it is formatted as epoch time in seconds. For
	// example: 1698778057
	//
	// This member is required.
	StartTime *time.Time

	// Include this value in your next use of this API to get the next set of change
	// events.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListEntityEventsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListEntityEvents{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListEntityEvents{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListEntityEvents"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListEntityEventsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListEntityEvents(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListEntityEventsPaginatorOptions is the paginator options for ListEntityEvents
type ListEntityEventsPaginatorOptions struct {
	// The maximum number of change events to return in one operation. If you omit
	// this parameter, the default of 50 is used.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListEntityEventsPaginator is a paginator for ListEntityEvents
type ListEntityEventsPaginator struct {
	options   ListEntityEventsPaginatorOptions
	client    ListEntityEventsAPIClient
	params    *ListEntityEventsInput
	nextToken *string
	firstPage bool
}

// NewListEntityEventsPaginator returns a new ListEntityEventsPaginator
func NewListEntityEventsPaginator(client ListEntityEventsAPIClient, params *ListEntityEventsInput, optFns ...func(*ListEntityEventsPaginatorOptions)) *ListEntityEventsPaginator {
	if params == nil {
		params = &ListEntityEventsInput{}
	}

	options := ListEntityEventsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListEntityEventsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListEntityEventsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListEntityEvents page.
func (p *ListEntityEventsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListEntityEventsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListEntityEvents(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListEntityEventsAPIClient is a client that implements the ListEntityEvents
// operation.
type ListEntityEventsAPIClient interface {
	ListEntityEvents(context.Context, *ListEntityEventsInput, ...func(*Options)) (*ListEntityEventsOutput, error)
}

var _ ListEntityEventsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListEntityEvents(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListEntityEvents",
	}
}
