// Code generated by smithy-go-codegen DO NOT EDIT.

package applicationsignals

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/applicationsignals/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns a list of audit findings that provide automated analysis of service
// behavior and root cause analysis. These findings help identify the most
// significant observations about your services, including performance issues,
// anomalies, and potential problems. The findings are generated using heuristic
// algorithms based on established troubleshooting patterns.
func (c *Client) ListAuditFindings(ctx context.Context, params *ListAuditFindingsInput, optFns ...func(*Options)) (*ListAuditFindingsOutput, error) {
	if params == nil {
		params = &ListAuditFindingsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAuditFindings", params, optFns, c.addOperationListAuditFindingsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAuditFindingsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAuditFindingsInput struct {

	// A list of audit targets to filter the findings by. You can specify services,
	// SLOs, or service operations to limit the audit findings to specific entities.
	//
	// This member is required.
	AuditTargets []types.AuditTarget

	// The end of the time period to retrieve audit findings for. When used in a raw
	// HTTP Query API, it is formatted as epoch time in seconds. For example,
	// 1698778057
	//
	// This member is required.
	EndTime *time.Time

	// The start of the time period to retrieve audit findings for. When used in a raw
	// HTTP Query API, it is formatted as epoch time in seconds. For example,
	// 1698778057
	//
	// This member is required.
	StartTime *time.Time

	// A list of auditor names to filter the findings by. Only findings generated by
	// the specified auditors will be returned.
	//
	// The following auditors are available for configuration:
	//
	//   - slo - SloAuditor: Identifies SLO violations and detects breached thresholds
	//   during the Assessment phase.
	//
	//   - operation_metric - OperationMetricAuditor: Detects anomalies in service
	//   operation metrics from Application Signals RED metrics during the Assessment
	//   phase
	//
	// Anomaly detection is not supported for sparse metrics (those missing more than
	//   80% of datapoints within the given time period).
	//
	//   - service_quota - ServiceQuotaAuditor: Monitors resource utilization against
	//   service quotas during the Assessment phase
	//
	//   - trace - TraceAuditor: Performs deep-dive analysis of distributed traces,
	//   correlating traces with breached SLOs or abnormal RED metrics during the
	//   Analysis phase
	//
	//   - dependency_metric - CriticalPathAuditor: Analyzes service dependency impacts
	//   and maps dependency relationships from Application Signals RED metrics during
	//   the Analysis phase
	//
	//   - top_contributor - TopContributorAuditor: Identifies infrastructure-level
	//   contributors to issues by analyzing EMF logs of Application Signals RED metrics
	//   during the Analysis phase
	//
	//   - log - LogAuditor: Extracts insights from application logs, categorizing
	//   error types and ranking severity by frequency during the Analysis phase
	//
	// InitAuditor and Summarizer auditors are not configurable as they are
	// automatically triggered during the audit process.
	Auditors []string

	// The level of details of the audit findings. Supported values: BRIEF , DETAILED .
	DetailLevel types.DetailLevel

	// The maximum number of audit findings to return in one operation. If you omit
	// this parameter, the default of 10 is used.
	MaxResults *int32

	// Include this value, if it was returned by the previous operation, to get the
	// next set of audit findings.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAuditFindingsOutput struct {

	// An array of structures, where each structure contains information about one
	// audit finding, including the auditor results, severity, and associated metric
	// and dependency graphs.
	//
	// This member is required.
	AuditFindings []types.AuditFinding

	// The end of the time period that the returned audit findings apply to. When used
	// in a raw HTTP Query API, it is formatted as epoch time in seconds. For example,
	// 1698778057
	EndTime *time.Time

	// Include this value in your next use of this API to get the next set of audit
	// findings.
	NextToken *string

	// The start of the time period that the returned audit findings apply to. When
	// used in a raw HTTP Query API, it is formatted as epoch time in seconds. For
	// example, 1698778057
	StartTime *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAuditFindingsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAuditFindings{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAuditFindings{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAuditFindings"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAuditFindingsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAuditFindings(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opListAuditFindings(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAuditFindings",
	}
}
