// Code generated by smithy-go-codegen DO NOT EDIT.

package applicationsignals

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/applicationsignals/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a service level objective (SLO), which can help you ensure that your
// critical business operations are meeting customer expectations. Use SLOs to set
// and track specific target levels for the reliability and availability of your
// applications and services. SLOs use service level indicators (SLIs) to calculate
// whether the application is performing at the level that you want.
//
// Create an SLO to set a target for a service or operation’s availability or
// latency. CloudWatch measures this target frequently you can find whether it has
// been breached.
//
// The target performance quality that is defined for an SLO is the attainment
// goal.
//
// You can set SLO targets for your applications that are discovered by
// Application Signals, using critical metrics such as latency and availability.
// You can also set SLOs against any CloudWatch metric or math expression that
// produces a time series.
//
// You can't create an SLO for a service operation that was discovered by
// Application Signals until after that operation has reported standard metrics to
// Application Signals.
//
// When you create an SLO, you specify whether it is a period-based SLO or a
// request-based SLO. Each type of SLO has a different way of evaluating your
// application's performance against its attainment goal.
//
//   - A period-based SLO uses defined periods of time within a specified total
//     time interval. For each period of time, Application Signals determines whether
//     the application met its goal. The attainment rate is calculated as the number
//     of good periods/number of total periods .
//
// For example, for a period-based SLO, meeting an attainment goal of 99.9% means
//
//	that within your interval, your application must meet its performance goal
//	during at least 99.9% of the time periods.
//
//	- A request-based SLO doesn't use pre-defined periods of time. Instead, the
//	SLO measures number of good requests/number of total requests during the
//	interval. At any time, you can find the ratio of good requests to total requests
//	for the interval up to the time stamp that you specify, and measure that ratio
//	against the goal set in your SLO.
//
// After you have created an SLO, you can retrieve error budget reports for it. An
// error budget is the amount of time or amount of requests that your application
// can be non-compliant with the SLO's goal, and still have your application meet
// the goal.
//
//   - For a period-based SLO, the error budget starts at a number defined by the
//     highest number of periods that can fail to meet the threshold, while still
//     meeting the overall goal. The remaining error budget decreases with every failed
//     period that is recorded. The error budget within one interval can never
//     increase.
//
// For example, an SLO with a threshold that 99.95% of requests must be completed
//
//	under 2000ms every month translates to an error budget of 21.9 minutes of
//	downtime per month.
//
//	- For a request-based SLO, the remaining error budget is dynamic and can
//	increase or decrease, depending on the ratio of good requests to total requests.
//
// For more information about SLOs, see [Service level objectives (SLOs)].
//
// When you perform a CreateServiceLevelObjective operation, Application Signals
// creates the AWSServiceRoleForCloudWatchApplicationSignals service-linked role,
// if it doesn't already exist in your account. This service- linked role has the
// following permissions:
//
//   - xray:GetServiceGraph
//
//   - logs:StartQuery
//
//   - logs:GetQueryResults
//
//   - cloudwatch:GetMetricData
//
//   - cloudwatch:ListMetrics
//
//   - tag:GetResources
//
//   - autoscaling:DescribeAutoScalingGroups
//
// [Service level objectives (SLOs)]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-ServiceLevelObjectives.html
func (c *Client) CreateServiceLevelObjective(ctx context.Context, params *CreateServiceLevelObjectiveInput, optFns ...func(*Options)) (*CreateServiceLevelObjectiveOutput, error) {
	if params == nil {
		params = &CreateServiceLevelObjectiveInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateServiceLevelObjective", params, optFns, c.addOperationCreateServiceLevelObjectiveMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateServiceLevelObjectiveOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateServiceLevelObjectiveInput struct {

	// A name for this SLO.
	//
	// This member is required.
	Name *string

	// Use this array to create burn rates for this SLO. Each burn rate is a metric
	// that indicates how fast the service is consuming the error budget, relative to
	// the attainment goal of the SLO.
	BurnRateConfigurations []types.BurnRateConfiguration

	// An optional description for this SLO.
	Description *string

	// This structure contains the attributes that determine the goal of the SLO.
	Goal *types.Goal

	// If this SLO is a request-based SLO, this structure defines the information
	// about what performance metric this SLO will monitor.
	//
	// You can't specify both RequestBasedSliConfig and SliConfig in the same
	// operation.
	RequestBasedSliConfig *types.RequestBasedServiceLevelIndicatorConfig

	// If this SLO is a period-based SLO, this structure defines the information about
	// what performance metric this SLO will monitor.
	//
	// You can't specify both RequestBasedSliConfig and SliConfig in the same
	// operation.
	SliConfig *types.ServiceLevelIndicatorConfig

	// A list of key-value pairs to associate with the SLO. You can associate as many
	// as 50 tags with an SLO. To be able to associate tags with the SLO when you
	// create the SLO, you must have the cloudwatch:TagResource permission.
	//
	// Tags can help you organize and categorize your resources. You can also use them
	// to scope user permissions by granting a user permission to access or change only
	// resources with certain tag values.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateServiceLevelObjectiveOutput struct {

	// A structure that contains information about the SLO that you just created.
	//
	// This member is required.
	Slo *types.ServiceLevelObjective

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateServiceLevelObjectiveMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateServiceLevelObjective{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateServiceLevelObjective{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateServiceLevelObjective"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateServiceLevelObjectiveValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateServiceLevelObjective(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateServiceLevelObjective(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateServiceLevelObjective",
	}
}
