// Code generated by smithy-go-codegen DO NOT EDIT.

package amp

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/amp/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// When you call PutAnomalyDetector , the operation creates a new anomaly detector
// if one doesn't exist, or updates an existing one. Each call to this operation
// triggers a complete retraining of the detector, which includes querying the
// minimum required samples and backfilling the detector with historical data. This
// process occurs regardless of whether you're making a minor change like updating
// the evaluation interval or making more substantial modifications. The operation
// serves as the single method for creating, updating, and retraining anomaly
// detectors.
func (c *Client) PutAnomalyDetector(ctx context.Context, params *PutAnomalyDetectorInput, optFns ...func(*Options)) (*PutAnomalyDetectorOutput, error) {
	if params == nil {
		params = &PutAnomalyDetectorInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutAnomalyDetector", params, optFns, c.addOperationPutAnomalyDetectorMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutAnomalyDetectorOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutAnomalyDetectorInput struct {

	// The identifier of the anomaly detector to update.
	//
	// This member is required.
	AnomalyDetectorId *string

	// The algorithm configuration for the anomaly detector.
	//
	// This member is required.
	Configuration types.AnomalyDetectorConfiguration

	// The identifier of the workspace containing the anomaly detector to update.
	//
	// This member is required.
	WorkspaceId *string

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string

	// The frequency, in seconds, at which the anomaly detector evaluates metrics.
	EvaluationIntervalInSeconds *int32

	// The Amazon Managed Service for Prometheus metric labels to associate with the
	// anomaly detector.
	Labels map[string]string

	// Specifies the action to take when data is missing during evaluation.
	MissingDataAction types.AnomalyDetectorMissingDataAction

	noSmithyDocumentSerde
}

type PutAnomalyDetectorOutput struct {

	// The unique identifier of the updated anomaly detector.
	//
	// This member is required.
	AnomalyDetectorId *string

	// The Amazon Resource Name (ARN) of the updated anomaly detector.
	//
	// This member is required.
	Arn *string

	// The status information of the updated anomaly detector.
	//
	// This member is required.
	Status *types.AnomalyDetectorStatus

	// The tags applied to the updated anomaly detector.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutAnomalyDetectorMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpPutAnomalyDetector{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpPutAnomalyDetector{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutAnomalyDetector"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opPutAnomalyDetectorMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpPutAnomalyDetectorValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutAnomalyDetector(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpPutAnomalyDetector struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpPutAnomalyDetector) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpPutAnomalyDetector) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*PutAnomalyDetectorInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *PutAnomalyDetectorInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opPutAnomalyDetectorMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpPutAnomalyDetector{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opPutAnomalyDetector(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutAnomalyDetector",
	}
}
