// Code generated by smithy-go-codegen DO NOT EDIT.

package aiops

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/aiops/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns the ARN and name of each investigation group in the account.
func (c *Client) ListInvestigationGroups(ctx context.Context, params *ListInvestigationGroupsInput, optFns ...func(*Options)) (*ListInvestigationGroupsOutput, error) {
	if params == nil {
		params = &ListInvestigationGroupsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListInvestigationGroups", params, optFns, c.addOperationListInvestigationGroupsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListInvestigationGroupsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListInvestigationGroupsInput struct {

	// The maximum number of results to return in one operation. If you omit this
	// parameter, the default of 50 is used.
	MaxResults *int32

	// Include this value, if it was returned by the previous operation, to get the
	// next set of service operations.
	NextToken *string

	noSmithyDocumentSerde
}

type ListInvestigationGroupsOutput struct {

	// An array of structures, where each structure contains the information about one
	// investigation group in the account.
	InvestigationGroups []types.ListInvestigationGroupsModel

	// Include this value in your next use of this operation to get the next set of
	// service operations.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListInvestigationGroupsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListInvestigationGroups{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListInvestigationGroups{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListInvestigationGroups"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListInvestigationGroups(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListInvestigationGroupsPaginatorOptions is the paginator options for
// ListInvestigationGroups
type ListInvestigationGroupsPaginatorOptions struct {
	// The maximum number of results to return in one operation. If you omit this
	// parameter, the default of 50 is used.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListInvestigationGroupsPaginator is a paginator for ListInvestigationGroups
type ListInvestigationGroupsPaginator struct {
	options   ListInvestigationGroupsPaginatorOptions
	client    ListInvestigationGroupsAPIClient
	params    *ListInvestigationGroupsInput
	nextToken *string
	firstPage bool
}

// NewListInvestigationGroupsPaginator returns a new
// ListInvestigationGroupsPaginator
func NewListInvestigationGroupsPaginator(client ListInvestigationGroupsAPIClient, params *ListInvestigationGroupsInput, optFns ...func(*ListInvestigationGroupsPaginatorOptions)) *ListInvestigationGroupsPaginator {
	if params == nil {
		params = &ListInvestigationGroupsInput{}
	}

	options := ListInvestigationGroupsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListInvestigationGroupsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListInvestigationGroupsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListInvestigationGroups page.
func (p *ListInvestigationGroupsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListInvestigationGroupsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListInvestigationGroups(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListInvestigationGroupsAPIClient is a client that implements the
// ListInvestigationGroups operation.
type ListInvestigationGroupsAPIClient interface {
	ListInvestigationGroups(context.Context, *ListInvestigationGroupsInput, ...func(*Options)) (*ListInvestigationGroupsOutput, error)
}

var _ ListInvestigationGroupsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListInvestigationGroups(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListInvestigationGroups",
	}
}
