// Code generated by smithy-go-codegen DO NOT EDIT.

package account

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/account/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Accepts the request that originated from StartPrimaryEmailUpdate to update the primary email address
// (also known as the root user email address) for the specified account.
func (c *Client) AcceptPrimaryEmailUpdate(ctx context.Context, params *AcceptPrimaryEmailUpdateInput, optFns ...func(*Options)) (*AcceptPrimaryEmailUpdateOutput, error) {
	if params == nil {
		params = &AcceptPrimaryEmailUpdateInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AcceptPrimaryEmailUpdate", params, optFns, c.addOperationAcceptPrimaryEmailUpdateMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AcceptPrimaryEmailUpdateOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AcceptPrimaryEmailUpdateInput struct {

	// Specifies the 12-digit account ID number of the Amazon Web Services account
	// that you want to access or modify with this operation. To use this parameter,
	// the caller must be an identity in the [organization's management account]or a delegated administrator account. The
	// specified account ID must be a member account in the same organization. The
	// organization must have [all features enabled], and the organization must have [trusted access] enabled for the
	// Account Management service, and optionally a [delegated admin]account assigned.
	//
	// This operation can only be called from the management account or the delegated
	// administrator account of an organization for a member account.
	//
	// The management account can't specify its own AccountId .
	//
	// [organization's management account]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account
	// [all features enabled]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html
	// [delegated admin]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#delegated-admin
	// [trusted access]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html
	//
	// This member is required.
	AccountId *string

	// The OTP code sent to the PrimaryEmail specified on the StartPrimaryEmailUpdate
	// API call.
	//
	// This member is required.
	Otp *string

	// The new primary email address for use with the specified account. This must
	// match the PrimaryEmail from the StartPrimaryEmailUpdate API call.
	//
	// This member is required.
	PrimaryEmail *string

	noSmithyDocumentSerde
}

type AcceptPrimaryEmailUpdateOutput struct {

	// Retrieves the status of the accepted primary email update request.
	Status types.PrimaryEmailUpdateStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAcceptPrimaryEmailUpdateMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpAcceptPrimaryEmailUpdate{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpAcceptPrimaryEmailUpdate{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "AcceptPrimaryEmailUpdate"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpAcceptPrimaryEmailUpdateValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAcceptPrimaryEmailUpdate(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opAcceptPrimaryEmailUpdate(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "AcceptPrimaryEmailUpdate",
	}
}
