// Code generated by smithy-go-codegen DO NOT EDIT.

package accessanalyzer

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/accessanalyzer/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of archive rules created for the specified analyzer.
func (c *Client) ListArchiveRules(ctx context.Context, params *ListArchiveRulesInput, optFns ...func(*Options)) (*ListArchiveRulesOutput, error) {
	if params == nil {
		params = &ListArchiveRulesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListArchiveRules", params, optFns, c.addOperationListArchiveRulesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListArchiveRulesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Retrieves a list of archive rules created for the specified analyzer.
type ListArchiveRulesInput struct {

	// The name of the analyzer to retrieve rules from.
	//
	// This member is required.
	AnalyzerName *string

	// The maximum number of results to return in the request.
	MaxResults *int32

	// A token used for pagination of results returned.
	NextToken *string

	noSmithyDocumentSerde
}

// The response to the request.
type ListArchiveRulesOutput struct {

	// A list of archive rules created for the specified analyzer.
	//
	// This member is required.
	ArchiveRules []types.ArchiveRuleSummary

	// A token used for pagination of results returned.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListArchiveRulesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListArchiveRules{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListArchiveRules{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListArchiveRules"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListArchiveRulesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListArchiveRules(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListArchiveRulesPaginatorOptions is the paginator options for ListArchiveRules
type ListArchiveRulesPaginatorOptions struct {
	// The maximum number of results to return in the request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListArchiveRulesPaginator is a paginator for ListArchiveRules
type ListArchiveRulesPaginator struct {
	options   ListArchiveRulesPaginatorOptions
	client    ListArchiveRulesAPIClient
	params    *ListArchiveRulesInput
	nextToken *string
	firstPage bool
}

// NewListArchiveRulesPaginator returns a new ListArchiveRulesPaginator
func NewListArchiveRulesPaginator(client ListArchiveRulesAPIClient, params *ListArchiveRulesInput, optFns ...func(*ListArchiveRulesPaginatorOptions)) *ListArchiveRulesPaginator {
	if params == nil {
		params = &ListArchiveRulesInput{}
	}

	options := ListArchiveRulesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListArchiveRulesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListArchiveRulesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListArchiveRules page.
func (p *ListArchiveRulesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListArchiveRulesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListArchiveRules(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListArchiveRulesAPIClient is a client that implements the ListArchiveRules
// operation.
type ListArchiveRulesAPIClient interface {
	ListArchiveRules(context.Context, *ListArchiveRulesInput, ...func(*Options)) (*ListArchiveRulesOutput, error)
}

var _ ListArchiveRulesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListArchiveRules(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListArchiveRules",
	}
}
