// Code generated by smithy-go-codegen DO NOT EDIT.

package jsonrpc

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/internal/protocoltest/jsonrpc/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

func (c *Client) KitchenSinkOperation(ctx context.Context, params *KitchenSinkOperationInput, optFns ...func(*Options)) (*KitchenSinkOperationOutput, error) {
	if params == nil {
		params = &KitchenSinkOperationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "KitchenSinkOperation", params, optFns, c.addOperationKitchenSinkOperationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*KitchenSinkOperationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type KitchenSinkOperationInput struct {
	Blob []byte

	Boolean *bool

	Double *float64

	EmptyStruct *types.EmptyStruct

	Float *float32

	HttpdateTimestamp *time.Time

	Integer *int32

	Iso8601Timestamp *time.Time

	// This value conforms to the media type: application/json
	JsonValue *string

	ListOfLists [][]string

	ListOfMapsOfStrings []map[string]string

	ListOfStrings []string

	ListOfStructs []types.SimpleStruct

	Long *int64

	MapOfListsOfStrings map[string][]string

	MapOfMaps map[string]map[string]string

	MapOfStrings map[string]string

	MapOfStructs map[string]types.SimpleStruct

	RecursiveList []types.KitchenSink

	RecursiveMap map[string]types.KitchenSink

	RecursiveStruct *types.KitchenSink

	SimpleStruct *types.SimpleStruct

	String_ *string

	StructWithJsonName *types.StructWithJsonName

	Timestamp *time.Time

	UnixTimestamp *time.Time

	noSmithyDocumentSerde
}

type KitchenSinkOperationOutput struct {
	Blob []byte

	Boolean *bool

	Double *float64

	EmptyStruct *types.EmptyStruct

	Float *float32

	HttpdateTimestamp *time.Time

	Integer *int32

	Iso8601Timestamp *time.Time

	// This value conforms to the media type: application/json
	JsonValue *string

	ListOfLists [][]string

	ListOfMapsOfStrings []map[string]string

	ListOfStrings []string

	ListOfStructs []types.SimpleStruct

	Long *int64

	MapOfListsOfStrings map[string][]string

	MapOfMaps map[string]map[string]string

	MapOfStrings map[string]string

	MapOfStructs map[string]types.SimpleStruct

	RecursiveList []types.KitchenSink

	RecursiveMap map[string]types.KitchenSink

	RecursiveStruct *types.KitchenSink

	SimpleStruct *types.SimpleStruct

	String_ *string

	StructWithJsonName *types.StructWithJsonName

	Timestamp *time.Time

	UnixTimestamp *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationKitchenSinkOperationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpKitchenSinkOperation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpKitchenSinkOperation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "KitchenSinkOperation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opKitchenSinkOperation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opKitchenSinkOperation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "KitchenSinkOperation",
	}
}
